// Header file for the FileOptions class
// Created 11 September 1996
// Revised 21 May 1998

#if !defined(__FILEOPTS_H__)
#define __FILEOPTS_H__

#include "bbsinfo.h"
#include "execute.h"
#include "utility.h"
#include "crc.h"
#include "amustr.h"
#include "dates.h"
#include "config.h"
#include "macros.h"
#include "tgfdb.h"

#define ZIPTXT_CTL   "ZIPTEXT.CTL"  /* Extensions to compress       */
#define NOADOPT_CTL  "NOADOPT.CTL"  /* Files not to be adopted      */
#define NOREARC_CTL  "NOREARC.CTL"  /* Files not to be rearced      */
#define TRASH_CTL    "TRASH.CTL"    /* Files to be removed from arcs*/
#define ADD_CTL      "ADD.CTL"      /* Files to be added to arcs    */
#define LOCKED_CTL   "LOCKED.CTL"   /* Files Old should skip        */
#define COMMENT_TXT  "COMMENT.TXT"  /* File comment                 */
#define REPLACE_CTL  "REPLACE.CTL"  /* File containing list of uploaders to replace */
#define TMPDIR       "TMPDIR.AMU"   /* Temporary directory          */

#define READ_MODE    0          /* Open area for read operations    */
#define WRITE_MODE   1          /* Open area for write operations   */
#define NO_BACKUP    0          /* Don't backup file area           */
#define DO_BACKUP    1          /* Backup file area after opening   */
#define NO_RESTORE   0          /* Don't restore file area          */
#define DO_RESTORE   1          /* Restore file area after opening  */
#define BACKSPACE    8          /* Backspace key - ASCII #8         */
#define ALLNEW_BEGIN 0          /* Initialize the allnew files      */
#define ALLNEW_FILL  1          /* Fill the allnew with area data   */
#define ALLNEW_END   2          /* Close & compress file lists      */

#define AMU_DELETED    1        /* Entry should not be written back */
#define AMU_COMMENT    2        /* Entry is a comment line          */
#define AMU_HEADER     4        /* Entry is an AMU header line      */
#define AMU_LOCKED     8        /* Entry should never be deleted    */

    struct sortarray
    {

#if defined (__AMU16__)
       char name[13];
#endif
#if defined (__AMU32__)
       char name[13];
#endif
#if defined (__AMU2__)
       char name[256];
#endif
#if defined (__AMU95__)
       char name[256];
#endif
	unsigned long key;
        struct filearray *thisrec;
    };

struct info
{
    double files,
	   bytes,
           dls;
};

class FileOptions
{
/************************* Private data *******************************/
    private:
    struct fbaseinfo infovar;
    class AMU_Headers *AMU_Headers_ptr;
    class Tgfdb *TGDesc;
    class Execute Execute_obj;
    class Utility Utility_obj;
    class Amustr Amustr_obj;
    class Crc Crc_obj;
    class Dates Today_Date;
    FILE *filesbbsfile, *hdrfile, *idxfile, *txtfile;
    int Area, update_area;
    char LOGSTR[185], *Header;
    struct concord_hdr concordhdrvar;
    struct ra_fileshdr rahdrvar;
    struct ra_filesidx raidxvar;
    struct lora_filesdat loradatavar;
    struct lora_filesidx loraidxvar;
    struct EZY_FileHdrRecord ezyhdrvar;
    struct tg_hdr tghdrvar;
    struct tg_etxt tgtxtvar;
    struct tg310_hdr tg310hdrvar;

    struct filearea fileareavar;
    struct filearray *toprec, *currec, *prevrec, *tmprec, *endrec;
    struct sortarray *sortvar, *sortptr;

/******************** End private data *********************************/

/********************* Private functions *******************************/
    private:
    char *unpackname(char *str);/* Unpack a Concord filename    */
    void packname(char *s);     /* Pack a Concord filename      */
    void analyze_area(struct fbaseinfo *i);    /* Gather file area info        */
    void write_desc(FILE *outfile, int offset, int add_dl);
    char *find_filepath(char *fn);  /* Returns path from FA_NNN.CTL file */

    void killorphans(void);     /* Kill orphaned entries        */
    void adopt(void);           /* Adopt missing files          */
    void pack(void);            /* Pack the RA/Concord filebase */
    char *get_gif(char *fn);    /* Get GIF information          */
    int get_diz(int decompress, char *filename);/* Get a FILE_ID.DIZ desc       */
    void fixheaders(void);      /* Change #255 to #8            */
    void addhdr(void);          /* Add headers                  */
    void process_archives(void);/* Process archives             */
    void check_nested(int scan, int rearc);/* Rearchive nested archives    */
    void import_file(FILE *outfile, char *source); /* Import a text file */
    void counters(void);        /* Update download counters     */
    void sort(void);            /* Sort file listings           */
    void old(void);             /* Move/Kill old files          */
    void import(void);          /* Import FILES.BBS to FDB      */
    void export(void);          /* Export FDB to FILES.BBS      */
    void move_nodesc(void);     /* Move files with no desc      */
    void compress_text(void);   /* Compress text/ascii files    */
    void shorten_fnames(char *fn); // shorten long filenames
    long get_area_number(char *area);

/************************* End private functions ***********************/

/********************** Public functions *******************************/
    public:
    FileOptions(void);
    int merge_LoraFDB(void);    /* Merge the temp files back to FILEBASE.DAT */
    int split_LoraFDB(void);    /* Split FILEBASE.DAT into temp files        */
    struct filearray *get_toprec(void) { return(toprec); }
    void okfile(int argc, char *argv[]);
    int open_area(int mode, int backup, int restore);        /* Open file area               */
    int read_area(void);        /* Read file area into array    */
    void write_area(void);      /* Write array back to disk     */
    void close_area(void);      /* Close file area              */
    void deallocate_area(void); /* De-allocate array            */
    void set_area(int x);       /* Set current area number */
    void append_link(struct filearray *newlink); /* Append an array */
    void filelists(int mode);   /* Create file lists            */
    int process_area(int area, struct filearea *areainfo, int argc, char *argv[]);
    void get_info(int area, struct info *i); /* Get info about area #'area' */
/************************** End public functions ***********************/

};

#endif
/* EOF - FILEOPTS.H */
