// Member functions for class FileOptions, Y2K
// Created 24 September 1995
// Revised 21 May 1998

#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <share.h>
#include <stdlib.h>
#include <dos.h>
#include <malloc.h>
#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <conio.h>
#include <direct.h>
#include "extern.h"
#include "fileopts.h"
#include "config.h"
#include "screen.h"
#include "macros.h"
#include "logs.h"
#include "tgfdb.h"

#if defined(__AMU32__)
#include <graph.h>
#endif

static int sort_function(const void *a, const void *b);
static int Sort_Type;


/* External objecs */
extern int kill_counterdata;
extern class Screen Screen_obj;
extern class Config Config_obj;

/**********************************************************************/

/* Constructor */
FileOptions::FileOptions(void)
{
    AMU_Headers_ptr = NULL;
    filesbbsfile = hdrfile = idxfile = txtfile = NULL;
    toprec = currec = prevrec = tmprec = endrec = NULL;
    sortvar = sortptr = NULL;
}

/* Append a linked list to the end of the file array */
void FileOptions::append_link(struct filearray *newlink)
{
    if(toprec)
    {
        currec = endrec;
        endrec -> nextrec = newlink;
        currec = newlink;
        currec -> prevrec = endrec;
    }
    else
    {
        toprec = currec = endrec = newlink;
    }
    while(currec -> nextrec)
    {
        currec = currec -> nextrec;
    }
    endrec = currec;
}

/************************************************************************/
/* Set 'Area' to x, and read the new file record */
void FileOptions::set_area(int x)
{
    Area = x;
    Config_obj.read_record(FILEAREA_RECORD, x);
    memcpy(&fileareavar, &Config_obj.fileareavar, FILEAREA_SIZE);
}


/**********************************************************************/
/* Open the current file area.  Return TRUE if successful, FALSE if not */
int FileOptions::open_area(int mode, int backup, int restore)
{
    char filename[MAX_FILESPEC], bmode[4], tmode[4], tmpfilename[MAX_FILESPEC];
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    int status = TRUE, FDB_Area, stem;

    hdrfile = idxfile = txtfile = filesbbsfile = NULL;
    FDB_Area = Area;
    if(Config_obj.amu_cfgvar.BBStype == RA250)
    {
        FDB_Area = fileareavar.areanum;
    }

    switch(mode)
    {
        case READ_MODE : strcpy(bmode, "rb");
                         strcpy(tmode, "rt");
                         break;
        case WRITE_MODE: strcpy(bmode, "w+b");
                         strcpy(tmode, "w+t");
                         break;
    }

    switch(fileareavar.listtype)
    {
           /* For the Lora FDB, we're only opening the AMU temporary
              versions of the FDB, so we don't need to worry about
              creating the FDB if it doesn't exist or making
              backups, or restoring the FDB.  That will be taken care
              of by the routine which initially splits the FILEBASE.DAT
              into these temp files. The routine is split_LoraFDB() and
              merge_LoraFDB() */

        case LORA_FDB    : sprintf(filename, "%s$$$%d.FDB",
                                   Config_obj.amu_cfgvar.FDBpath, FDB_Area);
                           hdrfile = _fsopen(filename, bmode, SH_DENYNO);
                           if(!hdrfile)
                           {
                               status = FALSE;
                               sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                       filename, strerror(errno));
                               Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               exit(1);
                           }
                           break;

        case RA_FDB      : sprintf(filename, "%sHDR\\FDB%d.HDR",
                                   Config_obj.amu_cfgvar.FDBpath, FDB_Area);
                           sprintf(tmpfilename, "%sHDR\\FDB%d.BAK",
                                   Config_obj.amu_cfgvar.FDBpath, FDB_Area);
                           if(backup)
                           {
                               Utility_obj.copyfile(filename, tmpfilename);
                           }
                           if(restore)
                           {
                               Utility_obj.copyfile(tmpfilename, filename);
                           }

                           hdrfile = _fsopen(filename, bmode, SH_DENYNO);

                           /* See if this should be created */
                           if(!hdrfile && Config_obj.amu_cfgvar.create_if_notexist)
                           {
                               hdrfile = _fsopen(filename, "w+b", SH_DENYNO);
                               if(hdrfile)
                               {
                                   sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }

                           if(!hdrfile)
                           {
                               status = FALSE;
                               sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                       filename, strerror(errno));
                               Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                           }
                           else
                           {
                               sprintf(filename, "%sIDX\\FDB%d.IDX",
                                       Config_obj.amu_cfgvar.FDBpath, FDB_Area);
                               sprintf(tmpfilename, "%sIDX\\FDB%d.BAK",
                                       Config_obj.amu_cfgvar.FDBpath, FDB_Area);
                               if(backup)
                               {
                                   Utility_obj.copyfile(filename, tmpfilename);
                               }
                               if(restore)
                               {
                                   Utility_obj.copyfile(tmpfilename, filename);
                               }
                               idxfile = _fsopen(filename, bmode, SH_DENYNO);

                               /* See if this should be created */
                               if(!idxfile && Config_obj.amu_cfgvar.create_if_notexist)
                               {
                                   idxfile = _fsopen(filename, "w+b", SH_DENYNO);
                                   if(idxfile)
                                   {
                                       sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                                   }
                               }

                               if(!idxfile)
                               {
                                   status = FALSE;
                                   fclose(hdrfile);
                                   sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                           filename, strerror(errno));
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                               else
                               {
                                   sprintf(filename, "%sTXT\\FDB%d.TXT",
                                           Config_obj.amu_cfgvar.FDBpath, FDB_Area);
                                   sprintf(tmpfilename, "%sTXT\\FDB%d.BAK",
                                           Config_obj.amu_cfgvar.FDBpath, FDB_Area);
                                   if(backup)
                                   {
                                       Utility_obj.copyfile(filename, tmpfilename);
                                   }
                                   if(restore)
                                   {
                                       Utility_obj.copyfile(tmpfilename, filename);
                                   }
                                   txtfile = _fsopen(filename, bmode, SH_DENYNO);

                                   /* See if this should be created */
                                   if(!txtfile && Config_obj.amu_cfgvar.create_if_notexist)
                                   {
                                       txtfile = _fsopen(filename, "w+b", SH_DENYNO);
                                       if(txtfile)
                                       {
                                           sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                           Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                                       }
                                   }

                                   if(!txtfile)
                                   {
                                       status = FALSE;
                                       fclose(hdrfile);
                                       fclose(idxfile);
                                       sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                               filename, strerror(errno));
                                       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                                   }
                               }
                           }
                           break;

              /*   FileName:     <fbasepath>\AREA<(<area>-1)/100+1>\FLH<area>.BBS */
        case EZY_FDB     : stem = (FDB_Area - 1) / 100 + 1;

                           sprintf(filename, "%sAREA%d\\FLH%05d.BBS",
                                   Config_obj.amu_cfgvar.FDBpath, stem, FDB_Area);
                           sprintf(tmpfilename, "%sAREA%d\\FLH%05d.BAK",
                                   Config_obj.amu_cfgvar.FDBpath, stem, FDB_Area);
                           if(backup)
                           {
                               Utility_obj.copyfile(filename, tmpfilename);
                           }
                           if(restore)
                           {
                               Utility_obj.copyfile(tmpfilename, filename);
                           }

                           hdrfile = _fsopen(filename, bmode, SH_DENYNO);

                           /* See if this should be created */
                           if(!hdrfile && Config_obj.amu_cfgvar.create_if_notexist)
                           {
                               hdrfile = _fsopen(filename, "w+b", SH_DENYNO);
                               if(hdrfile)
                               {
                                   sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }

                           if(!hdrfile)
                           {
                               status = FALSE;
                               sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                       filename, strerror(errno));
                               Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                           }
                           else
                           {
                               sprintf(filename, "%sAREA%d\\FLT%05d.BBS",
                                       Config_obj.amu_cfgvar.FDBpath, stem, FDB_Area);
                               sprintf(tmpfilename, "%sAREA%d\\FLT%05d.BBS",
                                       Config_obj.amu_cfgvar.FDBpath, stem, FDB_Area);
                               if(backup)
                               {
                                   Utility_obj.copyfile(filename, tmpfilename);
                               }
                               if(restore)
                               {
                                   Utility_obj.copyfile(tmpfilename, filename);
                               }
                               txtfile = _fsopen(filename, bmode, SH_DENYNO);

                               /* See if this should be created */
                               if(!txtfile && Config_obj.amu_cfgvar.create_if_notexist)
                               {
                                   txtfile = _fsopen(filename, "w+b", SH_DENYNO);
                                   if(txtfile)
                                   {
                                       sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                                   }
                               }

                               if(!txtfile)
                               {
                                   status = FALSE;
                                   fclose(hdrfile);
                                   sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                           filename, strerror(errno));
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }
                           break;


        case CONCORD_FDB : sprintf(filename, "%s%s.HDR", Config_obj.amu_cfgvar.FDBpath,
                                   fileareavar.listpath);
                           sprintf(tmpfilename, "%s%s.HBA",
                                   Config_obj.amu_cfgvar.FDBpath, fileareavar.listpath);
                           if(backup)
                           {
                               Utility_obj.copyfile(filename, tmpfilename);
                           }
                           if(restore)
                           {
                               Utility_obj.copyfile(tmpfilename, filename);
                           }
                           hdrfile = _fsopen(filename, bmode, SH_DENYNO);

                           /* See if this should be created */
                           if(!hdrfile && Config_obj.amu_cfgvar.create_if_notexist)
                           {
                               hdrfile = _fsopen(filename, "w+b", SH_DENYNO);
                               if(hdrfile)
                               {
                                   sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }

                           if(!hdrfile)
                           {
                               status = FALSE;
                               sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                       filename, strerror(errno));
                               Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                           }
                           else
                           {
                               sprintf(filename, "%s%s.TXT",
                                       Config_obj.amu_cfgvar.FDBpath, fileareavar.listpath);
                               sprintf(tmpfilename, "%s%s.TBA",
                                       Config_obj.amu_cfgvar.FDBpath, fileareavar.listpath);
                               if(backup)
                               {
                                   Utility_obj.copyfile(filename, tmpfilename);
                               }
                               if(restore)
                               {
                                   Utility_obj.copyfile(tmpfilename, filename);
                               }
                               txtfile = _fsopen(filename, bmode, SH_DENYNO);

                               /* See if this should be created */
                               if(!txtfile && Config_obj.amu_cfgvar.create_if_notexist)
                               {
                                   txtfile = _fsopen(filename, "w+b", SH_DENYNO);
                                   if(txtfile)
                                   {
                                       sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                                   }
                               }

                               if(!txtfile)
                               {
                                   status = FALSE;
                                   fclose(hdrfile);
                                   sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                           filename, strerror(errno));
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }
                           break;

        case TG_FDB      : sprintf(filename, "%s.FB", fileareavar.listpath);
                           sprintf(tmpfilename, "%s.HBA", fileareavar.listpath);
                           if(backup)
                           {
                               Utility_obj.copyfile(filename, tmpfilename);
                           }
                           if(restore)
                           {
                               Utility_obj.copyfile(tmpfilename, filename);
                           }
                           hdrfile = _fsopen(filename, bmode, SH_DENYNO);

                           /* See if this should be created */
                           if(!hdrfile && Config_obj.amu_cfgvar.create_if_notexist)
                           {
                               hdrfile = _fsopen(filename, "w+b", SH_DENYNO);
                               if(hdrfile)
                               {
                                   sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }

                           if(!hdrfile)
                           {
                               status = FALSE;
                               sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                       filename, strerror(errno));
                               Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                           }
                           else
                           {
                               sprintf(filename, "%s.FBE", fileareavar.listpath);
                               sprintf(tmpfilename, "%s.TBA", fileareavar.listpath);
                               if(backup)
                               {
                                   Utility_obj.copyfile(filename, tmpfilename);
                               }
                               if(restore)
                               {
                                   Utility_obj.copyfile(tmpfilename, filename);
                               }
                               txtfile = _fsopen(filename, bmode, SH_DENYNO);

                               /* See if this should be created */
                               if(!txtfile && Config_obj.amu_cfgvar.create_if_notexist)
                               {
                                   txtfile = _fsopen(filename, "w+b", SH_DENYNO);
                                   if(txtfile)
                                   {
                                       sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
                                       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				   }
			       }

			       if(!txtfile)
			       {
				   status = FALSE;
				   fclose(hdrfile);
				   sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
					   filename, strerror(errno));
				   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
			       }
			   }
			   break;

	case TG310_FDB   : sprintf(filename, "%s.FA", fileareavar.listpath);
			   sprintf(tmpfilename, "%s.BFA", fileareavar.listpath);
			   if(backup)
			   {
			       Utility_obj.copyfile(filename, tmpfilename);
			   }
			   if(restore)
			   {
			       Utility_obj.copyfile(tmpfilename, filename);
			   }
			   hdrfile = _fsopen(filename, bmode, SH_DENYNO);

			   /* See if this should be created */
			   if(!hdrfile && Config_obj.amu_cfgvar.create_if_notexist)
			   {
			       hdrfile = _fsopen(filename, "w+b", SH_DENYNO);
			       if(hdrfile)
			       {
				   sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
				   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
			       }
			   }

			   if(!hdrfile)
			   {
			       status = FALSE;
			       sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
				       filename, strerror(errno));
			       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
			   }
			   else
			   {
			       sprintf(filename, "%s.FAD", fileareavar.listpath);
			       sprintf(tmpfilename, "%s.BFD", fileareavar.listpath);
			       if(backup)
			       {
				   Utility_obj.copyfile(filename, tmpfilename);
			       }
			       if(restore)
			       {
				   Utility_obj.copyfile(tmpfilename, filename);
			       }
			       txtfile = _fsopen(filename, bmode, SH_DENYNO);

			       /* See if this should be created */
			       if(!txtfile && Config_obj.amu_cfgvar.create_if_notexist)
			       {
				   txtfile = _fsopen(filename, "w+b", SH_DENYNO);
				   if(txtfile)
				   {
				       sprintf(LOGSTR, "[OPEN_AREA] Note - Creating '%s' for area #%d", filename, Area);
				       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				   }
			       }

			       if(!txtfile)
			       {
				   status = FALSE;
				   fclose(hdrfile);
				   sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
					   filename, strerror(errno));
				   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
			       }
			   }
			   break;


	case FILESBBS    : if(fileareavar.listpath[0] == NULL)
			   {
			       sprintf(fileareavar.listpath, "%sFILES.BBS", fileareavar.filepath);
			   }
                           sprintf(filename, "%s", fileareavar.listpath);

                           _splitpath(filename, drive, dir, fname, ext);
                           if(fileareavar.attrib.cdrom)
                           {
                               sprintf(tmpfilename, "%s%sFILESBAK.%d", drive, dir, Area);
                           }
                           else
                           {
                              /* For HD areas, get rid of the old FILESBAK.nnn first,
                                 then set up the filename for the FILES.BAK */
                               sprintf(tmpfilename, "%s%sFILESBAK.%d", drive, dir, Area);
                               remove(tmpfilename);
                               sprintf(tmpfilename, "%sFILES.BAK", fileareavar.filepath);
                           }

                           filesbbsfile = _fsopen(filename, tmode, SH_DENYNO);
                           if(!filesbbsfile)
                           {
                               if(access(filename, 0) == 0 &&
                                  access(filename, 2) != 0)
                               {
                                   return(FALSE);
                               }

                               sprintf(filename, "%sFILES.BBS", fileareavar.filepath);
                               filesbbsfile = _fsopen(filename, tmode, SH_DENYNO);

                               /* See if we should create the file listing */
                               if(!filesbbsfile && Config_obj.amu_cfgvar.create_if_notexist)
                               {
                                   sprintf(filename, "%s", fileareavar.listpath);
                                   if(Config_obj.amu_cfgvar.BBStype == RA1)
                                   {
                                       sprintf(filename, "%sFILES.BBS", fileareavar.filepath);
                                   }
                                   filesbbsfile = _fsopen(filename, "w+t", SH_DENYNO);
                                   if(filesbbsfile)
                                   {
				       sprintf(LOGSTR, "[OPEN_AREA] Note - creating '%s' for area #%d", filename, Area);
                                       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                                   }
                               }

                             /* See if we have write access */
                               if(access(filename, 0) == 0 &&
                                  access(filename, 2) != 0)
                               {
                                   return(FALSE);
                               }

                               if(!filesbbsfile)
                               {
                                   status = FALSE;
                                   sprintf(LOGSTR, "? [OPEN_AREA] Error opening '%s' - (%s)",
                                           filename, strerror(errno));
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }
                           if(filesbbsfile && backup)
                           {
                              /* If not on CD, remove all current backups in this area */
                              if(!fileareavar.attrib.cdrom)
                              {
                                  sprintf(LOGSTR, "%sFILESBAK.*", fileareavar.filepath);
                                  Utility_obj.remove_all(LOGSTR);
                              }
                              Utility_obj.copyfile(filename, tmpfilename);
                           }
                           if(filesbbsfile && restore)
                           {
                              Utility_obj.copyfile(tmpfilename, filename);
                           }
                           break;

        default          : status = FALSE;
                           sprintf(LOGSTR,
                                   "? Unknown storage type for area #%d", Area);
                           Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
			   break;
    }
    return(status);
}

/**********************************************************************/
/* Attempt to read the current area into memory.  Return 0 if successful,
   1 if not enough memory, or 2 if there is a problem reading from disk */
int FileOptions::read_area(void)
{
    int status = 0, x, done, z, is_an_ext_desc, space_used;
    char *tmpdesc, *ptr, *ptr2, str[1026], str2[MAX_FILESPEC], tmpstr[500];
    char tmpfn[MAX_FILESPEC], *ptr3;
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    struct find_t fileinfo;
    long offset;
    unsigned short tmpdate, tmpmonth, tmpday, tmpyear;

    tmpdesc = (char *)calloc(MAX_DESC_SIZE, 1);
    toprec = currec = prevrec = endrec = NULL;
    switch(fileareavar.listtype)
    {
        case RA_FDB      : fread(&rahdrvar, sizeof(rahdrvar), 1, hdrfile);
                           fread(&raidxvar, sizeof(raidxvar), 1, idxfile);
#if defined(__AMU16__)
                           if(coreleft() < sizeof(struct filearray) + 1024)
                           {
                               free(tmpdesc);
                               deallocate_area();
                               return(1);
                           }
#endif
                           while(!feof(hdrfile) && status == 0)
                           {
                               memset(tmpdesc, NULL, MAX_DESC_SIZE);
                               currec = (struct filearray *)calloc(1, sizeof(struct filearray));
                               if(!currec)
                               {
                                   free(tmpdesc);
                                   status = 1;
                                   deallocate_area();
                                   return(status);
                               }
                               else
                               {
                                   memset(currec, NULL, sizeof(struct filearray));
                                   if(!toprec)
                                   {
                                       toprec = currec;
				   }
                                   currec -> prevrec = prevrec;
                                   currec -> nextrec = NULL;
                                   if(prevrec)
                                   {
                                       prevrec -> nextrec = currec;
                                   }
                                   prevrec = currec;
                                   Amustr_obj.pascaltoc(currec -> filename,
                                                        rahdrvar.name, rahdrvar.l1);
                                   Amustr_obj.pascaltoc(currec -> uploader,
                                                        rahdrvar.uploader, rahdrvar.l2);
                                   Amustr_obj.pascaltoc(currec -> password,
                                                        rahdrvar.password, rahdrvar.l3);
                                   currec -> bbsattrib = rahdrvar.attrib;
                                   currec -> size = rahdrvar.size;
                                   currec -> longdescptr = rahdrvar.longdescptr;
                                   currec -> timesdl = rahdrvar.timesdl;
                                   currec -> cost = rahdrvar.cost;
				   currec -> uploadtimedate.createDate(rahdrvar.uploaddate, rahdrvar.uploadtime);
				   currec -> timedate.createDate(rahdrvar.filedate, rahdrvar.filetime);
				   currec -> lastdl.createDate(rahdrvar.lastdldate, rahdrvar.lastdltime);
				   for(x = 0; x < 5; x++)
                                   {
                                       currec -> keywordcrc[x] = raidxvar.keywordcrc[x];
                                       Amustr_obj.pascaltoc(currec -> keyword[x],
                                                            rahdrvar.keyword[x].desc,
                                                            rahdrvar.keyword[x].l1);
                                   }

                            /* if this is not a blank entry, read it */
                                   if(currec -> longdescptr != -1)
                                   {
                                       fseek(txtfile, currec -> longdescptr, SEEK_SET);
                                       fread(tmpdesc, MAX_DESC_SIZE-1, 1, txtfile);
                                       x = strlen(tmpdesc);
                                       currec -> description = (char *)calloc(1, x+5);
                                       if(!currec -> description)
                                       {
                                           free(tmpdesc);
                                           deallocate_area();
                                           status = 1;
                                           return(status);
                                       }
                                       else
                                       {
                                           strcpy(currec -> description, tmpdesc);
                                       }
                                   }
                                   else
                                   {
                          /* Otherwise insert a blank description */
                                       strcpy(tmpdesc, "\r\n");
                                       currec -> description = (char *)calloc(1, strlen(tmpdesc)+2);
                                       if(!currec -> description)
                                       {
                                           free(tmpdesc);
                                           deallocate_area();
                                           status = 1;
                                           return(status);
                                       }
                                       else
                                       {
                                           strcpy(currec -> description, tmpdesc);
                                       }
                                   }

                                   /* Set up the Attributes */
                                   if(Utility_obj.bitset(rahdrvar.attrib, RA_LOCKED))
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                           AMU_LOCKED);
                                   }
                                   ptr = currec -> description;
                                   if(strchr(ptr, BACKSPACE))
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_HEADER);
                                   }
                                   if(currec -> filename[0] == NULL)
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_COMMENT);
                                   }
                               }
                               fread(&rahdrvar, sizeof(rahdrvar), 1, hdrfile);
                               fread(&raidxvar, sizeof(raidxvar), 1, idxfile);
                           }
                           endrec = currec;
                           break;

	case TG_FDB      : fread(&tghdrvar, sizeof(tghdrvar), 1, hdrfile);
#if defined(__AMU16__)
                           if(coreleft() < sizeof(struct filearray) + 1024)
                           {
                               free(tmpdesc);
                               deallocate_area();
                               return(1);
                           }
#endif
                           while(!feof(hdrfile) && status == 0)
                           {
                               memset(tmpdesc, NULL, MAX_DESC_SIZE);
                               currec = (struct filearray *)calloc(1, sizeof(struct filearray));
                               if(!currec)
                               {
                                   free(tmpdesc);
                                   status = 1;
                                   deallocate_area();
                                   return(status);
                               }
                               else
			       {
                                   memset(currec, NULL, sizeof(struct filearray));
                                   if(!toprec)
                                   {
                                       toprec = currec;
                                   }
                                   currec -> prevrec = prevrec;
                                   currec -> nextrec = NULL;
                                   if(prevrec)
                                   {
                                       prevrec -> nextrec = currec;
                                   }
                                   prevrec = currec;
                                   Amustr_obj.pascaltoc(currec -> filename,
                                                        tghdrvar.filename, tghdrvar.l1);

                                   _splitpath(currec -> filename, drive, dir, fname, ext);
                                   Amustr_obj.trimend(fname);
                                   Amustr_obj.trimend(ext);
                                   sprintf(currec -> filename, "%s%s", fname, ext);

				   Amustr_obj.pascaltoc(currec -> uploader,
							tghdrvar.uploader, tghdrvar.l3);
				   currec -> passwordcrc = tghdrvar.passwordCRC;
				   currec -> bbsattrib = tghdrvar.filestatus;
				   currec -> size = tghdrvar.size;
				   currec -> timesdl = tghdrvar.downloads;
				   currec -> cost = tghdrvar.filepoints;
				   currec -> uploadtimedate.createDate(tghdrvar.uldate);
				   currec -> lastdl.createDate(tghdrvar.dldate);
				   currec -> timedate.createDate(tghdrvar.filedate);

                                  /* Now read in the description */
                                   Amustr_obj.pascaltoc(tmpstr, tghdrvar.description, tghdrvar.l2);
				   strcat(tmpdesc, tmpstr);
				   strcat(tmpdesc, "\n");
				   if(tghdrvar.extended != -1)
				   {
				      /* This has extended descriptions, so
					 copy the one from the header then
					 loop through the .FBE file for
					 the rest of them */
				      offset = tghdrvar.extended * sizeof(tgtxtvar);
				      do
				      {
					  fseek(txtfile, offset, SEEK_SET);
					  fread(&tgtxtvar, sizeof(tgtxtvar), 1, txtfile);
					  for(x = 0; x < 5; x++)
					  {
					      if(tgtxtvar.extdesc[x][0] == 0)
					      {
						  break;
					      }
					      Amustr_obj.pascaltoc(tmpstr, &tgtxtvar.extdesc[x][1], tgtxtvar.extdesc[x][0]);
					      strcat(tmpdesc, tmpstr);
					      strcat(tmpdesc, "\n");
					  }
					  offset = tgtxtvar.nextlink * sizeof(tgtxtvar);
				      }while(offset > 0);
				   }

				   x = strlen(tmpdesc) + 5;
                                   currec -> description = (char *)calloc(1, x);
                                   if(!currec -> description)
                                   {
                                       free(tmpdesc);
                                       deallocate_area();
                                       status = 1;
                                       return(status);
                                   }
                                   else
				   {
                                       strcpy(currec -> description, tmpdesc);
                                   }

                                   ptr = currec -> description;
                                   if(strchr(ptr, BACKSPACE))
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_HEADER);
                                   }
                                   if(currec -> filename[0] == NULL)
				   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_COMMENT);
                                   }
                               }
                               fread(&tghdrvar, sizeof(tghdrvar), 1, hdrfile);
                           }
			   endrec = currec;
			   break;

	case TG310_FDB   : fread(&tg310hdrvar, sizeof(tg310hdrvar), 1, hdrfile);
#if defined(__AMU16__)
                           if(coreleft() < sizeof(struct filearray) + 1024)
                           {
                               free(tmpdesc);
                               deallocate_area();
                               return(1);
                           }
#endif
			   while(!feof(hdrfile) && status == 0)
                           {
			       memset(tmpdesc, NULL, MAX_DESC_SIZE);
			       currec = (struct filearray *)calloc(1, sizeof(struct filearray));
			       if(!currec)
			       {
				   free(tmpdesc);
				   status = 1;
				   deallocate_area();
				   return(status);
			       }
			       else
			       {
                                   memset(currec, NULL, sizeof(struct filearray));
                                   if(!toprec)
                                   {
                                       toprec = currec;
                                   }
                                   currec -> prevrec = prevrec;
                                   currec -> nextrec = NULL;
                                   if(prevrec)
                                   {
                                       prevrec -> nextrec = currec;
                                   }
				   prevrec = currec;

				   Amustr_obj.pascaltoc(currec -> filename,
							tg310hdrvar.filename, tg310hdrvar.l1);
				   _splitpath(currec -> filename, drive, dir, fname, ext);
				   Amustr_obj.trimend(fname);
				   Amustr_obj.trimend(ext);
				   sprintf(currec -> filename, "%s%s", fname, ext);

				   Amustr_obj.pascaltoc(currec -> uploader,
							tg310hdrvar.uploader, tg310hdrvar.l2);
				   currec -> passwordcrc = tg310hdrvar.passwordCRC;
				   currec -> bbsattrib = tg310hdrvar.filestatus;
				   currec -> size = tg310hdrvar.size;
				   currec -> timesdl = tg310hdrvar.downloads;
				   currec -> cost = tg310hdrvar.filepoints;
				   currec -> uploadtimedate.createDate(tg310hdrvar.uldate);
				   currec -> lastdl.createDate(tg310hdrvar.dldate);
				   currec -> timedate.createDate(tg310hdrvar.filedate);

				  /* Now read in the description */
				   offset = tg310hdrvar.descofs + 13;
				   fseek(txtfile, offset, SEEK_SET);
				   x = tg310hdrvar.desclength + 1;
				   currec -> description = (char *)calloc(1, x);
				   if(!currec -> description)
				   {
				       free(tmpdesc);
				       deallocate_area();
				       status = 1;
				       return(status);
				   }
				   else
				   {
				       fread(currec -> description, 1, tg310hdrvar.desclength, txtfile);
				   }

				   ptr = currec -> description;
				   if(strchr(ptr, BACKSPACE))
				   {
				       Utility_obj.setbit(&currec -> attribute,
							  AMU_HEADER);
				   }
				   if(currec -> filename[0] == NULL)
				   {
				       Utility_obj.setbit(&currec -> attribute,
							  AMU_COMMENT);
				   }
			       }
			       fread(&tg310hdrvar, sizeof(tg310hdrvar), 1, hdrfile);
			   }
			   endrec = currec;
			   break;



	case EZY_FDB     : fread(&ezyhdrvar, sizeof(ezyhdrvar), 1, hdrfile);
#if defined(__AMU16__)
			   if(coreleft() < sizeof(struct filearray) + 1024)
			   {
			       free(tmpdesc);
			       deallocate_area();
                               return(1);
			   }
#endif
                           while(!feof(hdrfile) && status == 0)
                           {
                               memset(tmpdesc, NULL, MAX_DESC_SIZE);
                               currec = (struct filearray *)calloc(1, sizeof(struct filearray));
                               if(!currec)
                               {
                                   free(tmpdesc);
                                   status = 1;
                                   deallocate_area();
                                   return(status);
                               }
                               else
                               {
                                   memset(currec, NULL, sizeof(struct filearray));
                                   if(!toprec)
                                   {
                                       toprec = currec;
                                   }
                                   currec -> prevrec = prevrec;
                                   currec -> nextrec = NULL;
                                   if(prevrec)
                                   {
                                       prevrec -> nextrec = currec;
                                   }
                                   prevrec = currec;
                                   Amustr_obj.pascaltoc(currec -> filename,
                                                        ezyhdrvar.FileName, ezyhdrvar.l1);
                                   Amustr_obj.pascaltoc(currec -> uploader,
                                                        ezyhdrvar.Uploader, ezyhdrvar.l2);
                                   currec -> bbsattrib = ezyhdrvar.Attribute;
                                   currec -> size = ezyhdrvar.FSize;
                                   currec -> longdescptr = ezyhdrvar.FltStart;
				   currec -> timesdl = ezyhdrvar.Downloads;
				   currec -> uploadtimedate.createDate(ezyhdrvar.ArrivalDate, 0);
				   currec -> timedate.createDate(ezyhdrvar.FDate, 0);
				   currec -> lastdl.createDate(ezyhdrvar.DownloadDate, 0);

                            /* if this is not a blank entry, read it */
				   if(currec -> longdescptr != -1)
                                   {
                                       fseek(txtfile, currec -> longdescptr, SEEK_SET);
                                       memset(tmpdesc, NULL, MAX_DESC_SIZE);
                                       fread(tmpdesc, ezyhdrvar.FltLength, 1, txtfile);
                                       x = strlen(tmpdesc);
                                       currec -> description = (char *)calloc(1, x+5);
                                       if(!currec -> description)
                                       {
                                           free(tmpdesc);
                                           deallocate_area();
                                           status = 1;
                                           return(status);
                                       }
                                       else
                                       {
                                           strcpy(currec -> description, tmpdesc);
                                       }
                                   }
                                   else
                                   {
                          /* Otherwise insert a blank description */
                                       strcpy(tmpdesc, "\r");
                                       currec -> description = (char *)calloc(1, strlen(tmpdesc)+2);
                                       if(!currec -> description)
                                       {
                                           free(tmpdesc);
                                           deallocate_area();
                                           status = 1;
                                           return(status);
                                       }
                                       else
                                       {
                                           strcpy(currec -> description, tmpdesc);
                                       }
                                   }

                                   /* Set up the Attributes */
                                   if(Utility_obj.bitset(ezyhdrvar.Attribute, BIT1))
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                           AMU_LOCKED);
                                   }
                                   ptr = currec -> description;
                                   if(strchr(ptr, BACKSPACE))
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_HEADER);
                                   }
                                   if(currec -> filename[0] == NULL)
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_COMMENT);
                                   }
                               }
                               fread(&ezyhdrvar, sizeof(ezyhdrvar), 1, hdrfile);
                           }
                           endrec = currec;
                           break;


        case LORA_FDB    : fread(&loradatavar, sizeof(loradatavar), 1, hdrfile);
#if defined(__AMU16__)
                           if(coreleft() < sizeof(struct filearray) + 1024)
                           {
                               free(tmpdesc);
                               deallocate_area();
                               return(1);
                           }
#endif
                           while(!feof(hdrfile) && status == 0)
                           {
                               memset(tmpdesc, NULL, MAX_DESC_SIZE);
                               currec = (struct filearray *)calloc(1, sizeof(struct filearray));
                               if(!currec)
                               {
                                   free(tmpdesc);
                                   status = 1;
                                   deallocate_area();
                                   return(status);
                               }
                               else
                               {
                                   memset(currec, NULL, sizeof(struct filearray));
                                   if(!toprec)
                                   {
                                       toprec = currec;
                                   }
                                   currec -> prevrec = prevrec;
                                   currec -> nextrec = NULL;
                                   if(prevrec)
                                   {
                                       prevrec -> nextrec = currec;
                                   }
                                   prevrec = currec;

                                   strcpy(currec -> filename, loradatavar.Name);
                                   currec -> bbsattrib = loradatavar.Flags;
                                   currec -> size = loradatavar.Size;
                                   currec -> timesdl = loradatavar.DlTimes;
                                   currec -> cost = loradatavar.Cost;
                                   currec -> passwordcrc = loradatavar.Password;
                                   currec -> level = loradatavar.Level;
                                   currec -> accessflags = loradatavar.AccessFlags;
                                   currec -> denyflags = loradatavar.DenyFlags;
				   strcpy(currec -> keyword[0], loradatavar.Keyword);
				   currec -> uploadtimedate.createDate(loradatavar.UploadDate);
				   currec -> timedate.createDate(loradatavar.FileDate);

                                   /* Read the description & uploader */
                                   if(loradatavar.Description > 0)
                                   {
                                       fread(tmpdesc, loradatavar.Description, 1, hdrfile);
                                       x = strlen(tmpdesc);
                                       currec -> description = (char *)calloc(1, x+5);
                                       if(!currec -> description)
                                       {
                                           free(tmpdesc);
                                           deallocate_area();
                                           status = 1;
                                           return(status);
                                       }
                                       else
                                       {
                                           strcpy(currec -> description, tmpdesc);
                                       }
                                   }
                                   else
                                   {
                                        /* Otherwise insert a blank description */
                                       strcpy(tmpdesc, "\n");
                                       currec -> description = (char *)calloc(1, strlen(tmpdesc)+2);
                                       if(!currec -> description)
                                       {
                                           free(tmpdesc);
                                           deallocate_area();
                                           status = 1;
                                           return(status);
                                       }
                                       else
                                       {
                                           strcpy(currec -> description, tmpdesc);
                                       }
                                   }
                                   if(loradatavar.Uploader > 0)
                                   {
                                       fread(currec -> uploader, loradatavar.Uploader, 1, hdrfile);
                                   }


                                   /* Set up the Attributes */
                                   ptr = currec -> description;
                                   if(strchr(ptr, BACKSPACE))
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_HEADER);
                                   }
                                   if(currec -> filename[0] == NULL)
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_COMMENT);
                                   }
                               }
                               fread(&loradatavar, sizeof(loradatavar), 1, hdrfile);
                           }
                           endrec = currec;
                           break;

        case CONCORD_FDB : fread(&concordhdrvar, sizeof(concordhdrvar), 1, hdrfile);
#if defined(__AMU16__)
                           if(coreleft() < sizeof(struct filearray) + 1024)
                           {
                               free(tmpdesc);
                               deallocate_area();
                               return(1);
                           }
#endif
                           while(!feof(hdrfile))
                           {
                               memset(tmpdesc, NULL, MAX_DESC_SIZE);
                               currec = (struct filearray *)malloc(sizeof(struct filearray));
                               if(!currec)
                               {
                                   free(tmpdesc);
                                   status = 1;
                                   deallocate_area();
                                   return(status);
                               }
                               else
                               {
                                   memset(currec, NULL, sizeof(struct filearray));
                                   if(!toprec)
                                   {
                                       toprec = currec;
                                   }
                                   currec -> prevrec = prevrec;
                                   currec -> nextrec = NULL;
                                   if(prevrec)
                                   {
                                       prevrec -> nextrec = currec;
                                   }
                                   prevrec = currec;
                                   memset(tmpdesc, NULL, MAX_DESC_SIZE);
                                   fseek(txtfile, concordhdrvar.descptr, SEEK_SET);
                                   fread(tmpdesc, concordhdrvar.descreclen, 1, txtfile);
                                   currec -> description = (char *)calloc(1, concordhdrvar.descreclen+5);
                                   if(!currec -> description)
                                   {
                                       free(tmpdesc);
                                       deallocate_area();
                                       status = 1;
                                       return(status);
                                   }
                                   strcpy(currec -> description, tmpdesc);
                                   fread(currec -> uploader, concordhdrvar.uploaderlen, 1, txtfile);
				   fread(&tmpdate, 2, 1, txtfile);
				   fread(&currec -> cost, 2, 1, txtfile);
				   strcpy(currec -> filename, unpackname(concordhdrvar.name));
				   currec -> bbsattrib = concordhdrvar.attrib;
				   currec -> size = concordhdrvar.size;
				   currec -> longdescptr = concordhdrvar.descptr;
				   currec -> timesdl = concordhdrvar.downloads;
				   currec -> uploadtimedate.createDate(concordhdrvar.uploaddate, concordhdrvar.uploadtime);
				   currec -> timedate.createDate(concordhdrvar.uploaddate, concordhdrvar.uploadtime);
				   currec -> lastdl.createDate(tmpdate, 0);
                                   ptr = currec -> description;
                                   if(strchr(ptr, BACKSPACE))
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_HEADER);
                                   }
                                   if(currec -> filename[0] == NULL)
                                   {
                                       Utility_obj.setbit(&currec -> attribute,
                                                          AMU_COMMENT);
                                   }
                               }
                               fread(&concordhdrvar, sizeof(concordhdrvar), 1, hdrfile);
                           }
                           endrec = currec;
                           break;


        case FILESBBS    : fgets(str, sizeof(str)-2, filesbbsfile);
#if defined(__AMU16__)
                           if(coreleft() < sizeof(struct filearray) + 1024)
                           {
                               free(tmpdesc);
                               deallocate_area();
                               return(1);
                           }
#endif
                           while(!feof(filesbbsfile) && !ferror(filesbbsfile))
			   {
			       space_used = FALSE;
			       memset(tmpdesc, NULL, MAX_DESC_SIZE);
			       currec = (struct filearray *)calloc(1, sizeof(struct filearray));
			       if(!currec)
			       {
				   status = 1;
				   free(tmpdesc);
				   deallocate_area();
				   return(status);
			       }
			       else
			       {
				   if(!toprec)
				   {
				       toprec = currec;
				   }
				   currec -> prevrec = prevrec;
				   currec -> nextrec = NULL;
				   if(prevrec)
                                   {
                                       prevrec -> nextrec = currec;
                                   }
                                   prevrec = currec;

                                   /* Start to parse the first string read */
                                   if(str[0] == ' '  || strchr(str, BACKSPACE)
                                      || str[0] == '\n')
				   {
				       if(strchr(str, BACKSPACE))
				       {
					   Utility_obj.setbit(&currec -> attribute,
							      AMU_HEADER);
				       }
				       else
				       {
					   Utility_obj.setbit(&currec -> attribute,
							      AMU_COMMENT);
				       }
				       currec -> description = (char *)calloc(1, strlen(str)+5);
				       if(!currec -> description)
				       {
					   free(tmpdesc);
					   deallocate_area();
					   return(1);
				       }
				       else
				       {
					   strcpy(currec -> description, str);
				       }
				       fgets(str, sizeof(str)-2, filesbbsfile);
				   }
				   else
				   {
				       currec -> size = -1; // Initialize to -1

#if defined (__AMU2__) || defined(__AMU95)
				       sscanf(str, "%s", currec -> filename);
#else
				       sscanf(str, "%12s", currec -> filename);
#endif

				       ptr = strchr(str, ' ');
				       if(!ptr)
				       {
					   ptr = strchr(str, '\n');
					   if(!ptr)
					   {
					       ptr = strchr(str, 0);
					   }
				       }
				       Amustr_obj.trimlead(ptr);

				       /* If this is a CD, check the format */
				       if(fileareavar.attrib.cdrom)
				       {
					   /* fn size date desc */
					   if(fileareavar.cdformat == CD_1)
					   {
					       ptr2 = str2;
					       while(*ptr && !isspace(*ptr))
					       {
						   *ptr2 = *ptr;
						   ptr2++;
						   ptr++;
					       }
					       *ptr2 = NULL;
					       currec -> size = Amustr_obj.pack_value(str2);
					       Amustr_obj.trimlead(ptr);

					       str2[2] = NULL;
					       str2[0] = *ptr;
					       ptr++;
					       str2[1] = *ptr;
					       ptr++;
                                               ptr++;
					       tmpmonth = atoi(str2);

					       str2[0] = *ptr;
					       ptr++;
					       str2[1] = *ptr;
					       ptr++;
					       ptr++;
					       tmpday = atoi(str2);

					       str2[0] = *ptr;
					       ptr++;
					       str2[1] = *ptr;
					       ptr++;
					       tmpyear = atoi(str2);

					       currec -> timedate.createDate(tmpyear, tmpmonth, tmpday, 0, 0, 0);
					       Amustr_obj.trimlead(ptr);
					   }

					   /* fn size desc */
					   if(fileareavar.cdformat == CD_2)
					   {
					       while(*ptr && !isspace(*ptr))
					       {
						   ptr++;
					       }
					       Amustr_obj.trimlead(ptr);
					   }

					   /* fn date desc */
					   if(fileareavar.cdformat == CD_5)
					   {
					       while(*ptr && !isspace(*ptr))
					       {
						   ptr++;
					       }
					       Amustr_obj.trimlead(ptr);
					   }

					   /* fn date size desc */
					   if(fileareavar.cdformat == CD_4)
					   {
					       str2[2] = NULL;
					       str2[0] = *ptr;
					       ptr++;
					       str2[1] = *ptr;
					       ptr++;
					       ptr++;
					       tmpmonth = atoi(str2);

					       str2[0] = *ptr;
					       ptr++;
					       str2[1] = *ptr;
					       ptr++;
					       ptr++;
					       tmpday = atoi(str2);

					       str2[0] = *ptr;
					       ptr++;
					       str2[1] = *ptr;
					       ptr++;
					       tmpyear = atoi(str2);

					       currec -> timedate.createDate(tmpyear, tmpmonth, tmpday, 0, 0, 0);
					       Amustr_obj.trimlead(ptr);
					       ptr2 = str2;
					       while(*ptr && !isspace(*ptr))
					       {
						   *ptr2 = *ptr;
						   ptr2++;
						   ptr++;
					       }
					       *ptr2 = NULL;
					       currec -> size = Amustr_obj.pack_value(str2);
					       Amustr_obj.trimlead(ptr);
					   }
				       }

				      /* If the size is still -1, go to disk */
				       if(currec -> size == -1)
				       {
					   sprintf(str2, "%s%s", find_filepath(currec -> filename), currec -> filename);
					   x = _dos_findfirst(str2, _A_ARCH, &fileinfo);
					   if(x == 0)
					   {
					       currec -> size = fileinfo.size;
							 currec -> timedate.createDate((unsigned short)fileinfo.wr_date, (unsigned short)fileinfo.wr_time);
					   }
					   else
					   {
					       currec -> size = 0;
					   }
				       }

				       /* Check for a download counter */
				       if(Config_obj.amu_cfgvar.counter_width > 0
					  && *ptr == Config_obj.amu_cfgvar.left_bracket)
				       {
                                           ptr++;
                                           ptr2 = str2;
                                           while(*ptr && *ptr != Config_obj.amu_cfgvar.right_bracket)
                                           {
                                               if(*ptr == ' ')
                                               {
                                                   *ptr = '0';
                                               }
                                               *ptr2 = *ptr;
                                               ptr2++;
                                               ptr++;
                                           }
                                           *ptr2 = NULL;
                                           currec -> timesdl = atoi(str2);
                                           ptr += 2;
//                                           Amustr_obj.trimlead(ptr);
                                       }

        /* Now, get the description.  Start out allocating enough room for
           just the first line we've been working on.  Then check for
           extended description lines and use realloc() to adjust the
           size if necessary */
                                       x = strlen(ptr);
                                       currec -> description = (char *)calloc(1, x+5);
                                       if(!currec -> description)
                                       {
                                           free(tmpdesc);
                                           deallocate_area();
                                           return(1);
                                       }
                                       strcpy(currec -> description, ptr);

                                       /* Now, check for extended lines */
                                       done = FALSE;
                                       do
                                       {
                                           fgets(str, sizeof(str)-2, filesbbsfile);
                                           if(feof(filesbbsfile))
                                           {
                                               break;
                                           }

                                                 /* Find the first non-space */
                                           ptr3 = str;
                                           while(*ptr3)
                                           {
                                               if(*ptr3 != ' ')
                                               {
                                                   break;
                                               }
                                               ptr3++;
                                           }

                                           /* See if this is an extended
                                              description in column 1
                                              You cannot have a space as the
                                              ext desc character in column 1 */
                                           if(!isspace(str[0]))
                                           {
                                               if(*ptr3 && strchr(Config_obj.amu_cfgvar.ext_desc_char, *ptr3))
                                               {
                                                   tmpstr[0] = NULL;
                                                   sscanf(str, "%s", tmpstr);
/*
                                                   _splitpath(tmpstr, drive, dir, fname, ext);
                                                   if(fname[0] && ext[1])
                                                   {
                                                       done = TRUE;
                                                   }
*/
                                                   sprintf(tmpfn, "%s%s", find_filepath(tmpstr), tmpstr);
                                                   if(access(tmpfn, 0) == 0)
                                                   {
                                                       done = TRUE;
                                                   }
                                               }
                                               else
                                               {
                                                   done = TRUE;
                                               }
                                           }

                                           if(!done)
                                           {
                                               done = TRUE;
                                               is_an_ext_desc = FALSE;

                                               /* If there is a space as
                                                  an ext desc char, check
                                                  it first */
                                               if(strchr(Config_obj.amu_cfgvar.ext_desc_char, ' '))
                                               {
                                                   z = Config_obj.amu_cfgvar.ext_offset-1;
                                                   if(str[z] == ' ')
                                                   {
                                                       is_an_ext_desc = TRUE;
//                                                     Amustr_obj.trimlead(str);
                                                       ptr2 = str;
                                                       space_used = TRUE;
                                                   }
                                               }

                                             /* Otherwise continue on and
                                                check for others */
                                               if(is_an_ext_desc == FALSE)
                                               {
//                                                 Amustr_obj.trimlead(str);
                                                   ptr = Config_obj.amu_cfgvar.ext_desc_char;
                                                   while(*ptr)
                                                   {
                                                       if(*ptr == ' ')
                                                       {
                                                           ptr++;
                                                           continue;
                                                       }

                                                       if(*ptr3 && *ptr3 == *ptr)
                                                       {
                                                           is_an_ext_desc = TRUE;
                                                           ptr2 = str;
//                                                         ptr2++;
                                                           break;
                                                       }
                                                       else
                                                       {
                                                           ptr++;
                                                       }
                                                   }
                                               }

                                           /* if it is an extended description,
                                               handle it */
                                               if(is_an_ext_desc == TRUE)
                                               {
                                                   done = FALSE;
                                                   currec -> description = (char *)realloc(currec -> description,
                                                         strlen(currec -> description) + strlen(str) + 3);
                                                   if(currec -> description)
                                                   {
//                                                     Amustr_obj.trimlead(ptr2);
                                                       if(*ptr3)
                                                       {
                                                           if(space_used == FALSE)
                                                           {
                                                               Amustr_obj.trimlead(ptr2);
                                                               ptr2++;
                                                           }
//                                                         *ptr3 = ' ';
//                                                         ptr2 = ptr3;
                                                       }
//                                                     strrev(ptr2);
//                                                     x = strlen(ptr2);
//                                                     *(ptr2+ (x - Config_obj.amu_cfgvar.ext_offset)) = NULL;
//                                                     strrev(ptr2);

                                                       strcat(currec -> description, ptr2);
                                                   }
                                                   else
                                                   {
                                                       free(tmpdesc);
                                                       deallocate_area();
                                                       return(1);
                                                   }
                                               }
                                           }
                                       }while(!done);
                                   }
                               }
                           }
                           endrec = currec;
                           break;

        default          : break;
    }
    free(tmpdesc);
    currec = toprec;
    while(currec)
    {
	strupr(currec -> filename);
	currec = currec -> nextrec;
    }
    return(status);
}

/**********************************************************************/
/* Write the area back to disk */
void FileOptions::write_area(void)
{
    int done, x, i, j, space_used, index, num_tgblocks, blocks_written;
    long desc_offset;
    char *ptr, *ptr2, tmpstr[1026], tmpstr2[MAX_FILESPEC], *tmpdesc;
    char *buffer;
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    FILE *replacefile;
    unsigned short tmpdate, tmptime;

    // See if the REPLACE.CTL file exists with a list of uploader names
    // AMU should replace
    buffer = NULL;
    sprintf(tmpstr, "%s%s", Config_obj.amu_cfgvar.AMUpath, REPLACE_CTL);
    replacefile = fopen(tmpstr, "rt");
    if(replacefile != NULL)
    {
	x = filelength(fileno(replacefile));
	buffer = (char *) calloc(1, x+1);
	fread(buffer, x, 1, replacefile);
	fclose(replacefile);
	strupr(buffer);
    }

    currec = toprec;
    while(currec && buffer)
    {
       // First check to see if we need to change the uploaders
	strcpy(tmpstr, currec -> uploader);
	strupr(tmpstr);
	if(Config_obj.amu_cfgvar.replace_ul && (strstr(buffer, tmpstr) ||
	   currec -> uploader[0] == NULL))
	{
	    if(Config_obj.amu_cfgvar.alias_system)
	    {
		strcpy(currec -> uploader, Config_obj.amu_cfgvar.sysopalias);
	    }
	    else
	    {
		strcpy(currec -> uploader, Config_obj.amu_cfgvar.sysop);
	    }
	}

#if defined(__AMU2__) || defined(__AMU95__)
	if(fileareavar.listtype != FILESBBS || Config_obj.amu_cfgvar.shorten_fnames)
	{
	    shorten_fnames(currec -> filename);
	}

      // All filebase systems only have room for 12 characters
	if(fileareavar.listtype != FILESBBS)
	{
	    currec -> filename[12] = NULL;
	}
#endif

	currec = currec -> nextrec;
    }
    if(buffer != NULL)
    {
        free(buffer);
    }

    currec = toprec;
    desc_offset = 0;
    tmpdesc = (char *)calloc(MAX_DESC_SIZE, 1);
    switch(fileareavar.listtype)
    {
	case RA_FDB      : while(currec)
			   {
			       memset(&rahdrvar, NULL, sizeof(rahdrvar));
			       memset(&raidxvar, NULL, sizeof(raidxvar));

			       if(!Utility_obj.bitset(currec -> attribute, AMU_HEADER))
			       {

			       rahdrvar.l1 = raidxvar.l1 = (unsigned char) strlen(currec -> filename);
			       Amustr_obj.ctopascal(currec -> filename,
						    rahdrvar.name);
			       Amustr_obj.ctopascal(currec -> filename,
						    raidxvar.name);
			       rahdrvar.size = currec -> size;
			       rahdrvar.CRC32 = 0;

			       rahdrvar.l2 = (unsigned char) strlen(currec -> uploader);
			       Amustr_obj.ctopascal(currec -> uploader,
						    rahdrvar.uploader);
			       rahdrvar.l3 = (unsigned char) strlen(currec -> password);
			       Amustr_obj.ctopascal(currec -> password,
						    rahdrvar.password);
			       currec -> uploadtimedate.getPackedDateTime(&rahdrvar.uploaddate, &rahdrvar.uploadtime);
			       raidxvar.uploaddate = rahdrvar.uploaddate;
			       raidxvar.uploadtime = rahdrvar.uploadtime;

			       currec -> lastdl.getPackedDateTime(&rahdrvar.lastdldate, &rahdrvar.lastdltime);
			       currec -> timedate.getPackedDateTime(&rahdrvar.filedate, &rahdrvar.filetime);
			       rahdrvar.timesdl = currec -> timesdl;
			       rahdrvar.attrib = (unsigned char) currec -> bbsattrib;
			       rahdrvar.l3 = (unsigned char) strlen(currec -> password);
			       Amustr_obj.ctopascal(currec -> password,
						    rahdrvar.password);
			       for(x = 0; x < 5; x++)
			       {
				   rahdrvar.keyword[x].l1 = (unsigned char) strlen(currec -> keyword[x]);
				   Amustr_obj.ctopascal(currec -> keyword[x],
							rahdrvar.keyword[x].desc);
				   raidxvar.keywordcrc[x] = currec -> keywordcrc[x];
			       }
			       rahdrvar.cost = currec -> cost;

			       }


			       rahdrvar.longdescptr = desc_offset;
			       raidxvar.longdescptr = desc_offset;

			       /* Only write it back if not marked for deletion */
			       if(!Utility_obj.bitset(currec -> attribute, AMU_DELETED))
			       {
				   desc_offset += fprintf(txtfile, "%s%c",
							  currec -> description, NULL);
				   ptr = strchr(currec -> description, NULL);

			     /* Make sure the description ends with a \r\n */
				   if(ptr && currec -> filename[0])
				   {
				       tmpstr[2] = NULL;
				       ptr--;
				       tmpstr[1] = *ptr;
				       ptr--;
				       tmpstr[0] = *ptr;
				       if(!strstr(tmpstr, "\r\n"))
				       {
					   desc_offset += 2;
					   fseek(txtfile, ftell(txtfile) - 1, SEEK_SET);
					   fprintf(txtfile, "\r\n%c", NULL);
				       }

				   }
				   fwrite(&rahdrvar, sizeof(rahdrvar), 1, hdrfile);
				   fwrite(&raidxvar, sizeof(raidxvar), 1, idxfile);
			       }
			       currec = currec -> nextrec;
			   }
                           break;

	case TG_FDB      : desc_offset = 0;
			   while(currec)
			   {
			       memset(&tghdrvar, NULL, sizeof(tghdrvar));

			       if(!Utility_obj.bitset(currec -> attribute, AMU_HEADER))
			       {

			       _splitpath(currec -> filename, drive, dir, fname, ext);

			       Amustr_obj.pad(fname, 8);
			       Amustr_obj.pad(ext, 4);
			       sprintf(currec -> filename, "%s%s", fname, ext);

			       tghdrvar.l1 = (unsigned char) strlen(currec -> filename);
			       Amustr_obj.ctopascal(currec -> filename,
						    tghdrvar.filename);
			       tghdrvar.size = currec -> size;
			       tghdrvar.passwordCRC = currec -> passwordcrc;
			       tghdrvar.l3 = (unsigned char) strlen(currec -> uploader);
			       Amustr_obj.ctopascal(currec -> uploader,
						    tghdrvar.uploader);
			       tghdrvar.filedate = currec -> timedate.getSecondsSince1970();

			       // The upload and download fields are only supposed to contain
			       // the date, not the time.
			       currec -> uploadtimedate.getPackedDateTime(&tmpdate, &tmptime);
			       currec -> uploadtimedate.createDate(tmpdate, 0);
			       tghdrvar.uldate = currec -> uploadtimedate.getSecondsSince1970();
			       currec -> lastdl.getPackedDateTime(&tmpdate, &tmptime);
			       currec -> lastdl.createDate(tmpdate, 0);
			       tghdrvar.dldate = currec -> lastdl.getSecondsSince1970();

			       tghdrvar.downloads = currec -> timesdl;
			       tghdrvar.filestatus = (unsigned char) currec -> bbsattrib;
			       tghdrvar.filepoints = currec -> cost;
			       }

			       tghdrvar.extended = -1;

			       /* Only write it back if not marked for deletion */
			       if(!Utility_obj.bitset(currec -> attribute, AMU_DELETED))
			       {
				   TGDesc = new Tgfdb(currec -> description);
				   num_tgblocks = TGDesc -> get_num_blocks();
				   blocks_written = 0;
				   index = 1;

				   // If the description is empty...
				   if(num_tgblocks == 0)
				   {
				       tghdrvar.l2 = 0;
				       memset(tghdrvar.description, NULL, sizeof(tghdrvar.description));
				   }
				   else
				   {
				       // Otherwise copy the first block
				       strcpy(tmpstr, TGDesc -> get_tg_block(index));
				       tghdrvar.l2 = (char) strlen(tmpstr);
				       Amustr_obj.ctopascal(tmpstr, tghdrvar.description);
				       blocks_written++;
				   }

				   if(num_tgblocks == blocks_written)
				   {
				       tghdrvar.extended = -1;
				   }
				   else
				   {
				       tghdrvar.extended = desc_offset;
				       desc_offset++;
				       memset(&tgtxtvar, NULL, sizeof(tgtxtvar));
				       done = FALSE;
				       while(done == FALSE)
				       {
					   for(x = 0; x < 5; x++)
					   {
					       index++;
					       memset(tmpstr, NULL, sizeof(tmpstr));
					       strcpy(tmpstr, TGDesc -> get_tg_block(index));
					       tgtxtvar.extdesc[x][0] = (char) strlen(tmpstr);
					       Amustr_obj.ctopascal(tmpstr, &tgtxtvar.extdesc[x][1]);
					       blocks_written++;
					       if(num_tgblocks == blocks_written)
					       {
						   done = TRUE;
						   break;
					       }
					   }
					   if(done == TRUE)
					   {
					       tgtxtvar.nextlink = -1;
					   }
					   else
					   {
					       tgtxtvar.nextlink = desc_offset;
					       desc_offset++;
					   }
					   tgtxtvar.l0 = (unsigned char) strlen(currec -> filename);
					   Amustr_obj.ctopascal(currec -> filename,
								tgtxtvar.filename);
					   fwrite(&tgtxtvar, sizeof(tgtxtvar), 1, txtfile);
					   memset(&tgtxtvar, NULL, sizeof(tgtxtvar));
				       }
				   }
				   fwrite(&tghdrvar, sizeof(tghdrvar), 1, hdrfile);
				   delete(TGDesc);
			       }
			       currec = currec -> nextrec;
			   }
			   break;

	case TG310_FDB   : desc_offset = 0;
			   while(currec)
			   {
			       memset(&tg310hdrvar, NULL, sizeof(tghdrvar));
			       if(!Utility_obj.bitset(currec -> attribute, AMU_HEADER))
			       {

			       _splitpath(currec -> filename, drive, dir, fname, ext);

			       Amustr_obj.pad(fname, 8);
			       Amustr_obj.pad(ext, 4);
			       sprintf(currec -> filename, "%s%s", fname, ext);

			       tg310hdrvar.l1 = (unsigned char) strlen(currec -> filename);
			       Amustr_obj.ctopascal(currec -> filename,
						    tg310hdrvar.filename);
			       tg310hdrvar.size = currec -> size;
			       tg310hdrvar.passwordCRC = currec -> passwordcrc;
			       tg310hdrvar.l2 = (unsigned char) strlen(currec -> uploader);
			       Amustr_obj.ctopascal(currec -> uploader,
						    tg310hdrvar.uploader);
			       tg310hdrvar.filedate = currec -> timedate.getSecondsSince1970();

			       // The upload and download fields are only supposed to contain
			       // the date, not the time.
			       currec -> uploadtimedate.getPackedDateTime(&tmpdate, &tmptime);
			       currec -> uploadtimedate.createDate(tmpdate, 0);
			       tg310hdrvar.uldate = currec -> uploadtimedate.getSecondsSince1970();
			       currec -> lastdl.getPackedDateTime(&tmpdate, &tmptime);
			       currec -> lastdl.createDate(tmpdate, 0);
			       tg310hdrvar.dldate = currec -> lastdl.getSecondsSince1970();


			       tg310hdrvar.downloads = currec -> timesdl;
			       tg310hdrvar.filestatus = (unsigned char) currec -> bbsattrib;
			       tg310hdrvar.filepoints = currec -> cost;
			       }

			       /* Only write it back if not marked for deletion */
			       if(!Utility_obj.bitset(currec -> attribute, AMU_DELETED))
			       {

				   TGDesc = new Tgfdb(currec -> description);
				   memset(tmpdesc, NULL, MAX_DESC_SIZE);
				   num_tgblocks = TGDesc -> get_num_blocks();
				   for(index = 1; index <= num_tgblocks; index++)
				   {
				       strcat(tmpdesc, TGDesc -> get_tg_block(index));
				       ptr = &tmpdesc[strlen(tmpdesc)-1];
				       if(*ptr != '\r')
				       {
					   strcat(tmpdesc, "\r");
				       }
				   }

				   // Write the filename + description
				   tg310hdrvar.descofs = desc_offset;
				   tg310hdrvar.desclength = strlen(tmpdesc);
				   fwrite(&tg310hdrvar.l1, 1, 13, txtfile);
				   fwrite(tmpdesc, 1, tg310hdrvar.desclength, txtfile);
				   desc_offset += (13 + strlen(tmpdesc));
				   fwrite(&tg310hdrvar, sizeof(tg310hdrvar), 1, hdrfile);
				   delete(TGDesc);
			       }
			       currec = currec -> nextrec;
			   }
			   break;

	case EZY_FDB     : x = 0;
			   desc_offset = 0;
			   while(currec)
			   {
			       memset(&ezyhdrvar, NULL, sizeof(ezyhdrvar));

			       if(!Utility_obj.bitset(currec -> attribute, AMU_HEADER))
			       {

			       ezyhdrvar.l1 = (unsigned char) strlen(currec -> filename);
			       Amustr_obj.ctopascal(currec -> filename,
						    ezyhdrvar.FileName);
			       ezyhdrvar.FSize = currec -> size;

			       ezyhdrvar.l2 = (unsigned char) strlen(currec -> uploader);
			       Amustr_obj.ctopascal(currec -> uploader,
						    ezyhdrvar.Uploader);
			       tmptime = 0;
			       currec -> timedate.getPackedDateTime(&ezyhdrvar.FDate, &tmptime);
			       currec -> uploadtimedate.getPackedDateTime(&ezyhdrvar.ArrivalDate, &tmptime);
			       currec -> lastdl.getPackedDateTime(&ezyhdrvar.DownloadDate, &tmptime);
			       ezyhdrvar.Downloads = currec -> timesdl;
			       ezyhdrvar.Attribute = (unsigned char) currec -> bbsattrib;
			       }

			       ezyhdrvar.FltStart = desc_offset;
//			       desc_offset++; // increment to take into account the NULL
			       ezyhdrvar.FilePath = Area;

			       /* Only write it back if not marked for deletion */
			       if(!Utility_obj.bitset(currec -> attribute, AMU_DELETED))
			       {
				   Amustr_obj.trimend(currec -> description);
				   ptr = strchr(currec -> description, 0);
				   if(ptr)
				   {
				       ptr--;
				       if(*ptr == '\r' || *ptr == '\n')
				       {
					   *ptr = NULL;
				       }
				   }
				   Amustr_obj.trimend(currec -> description);

				   fwrite(currec -> description, strlen(currec -> description) + 1, 1, txtfile);
				   desc_offset += strlen(currec -> description) + 1;
				   ezyhdrvar.FltLength = strlen(currec -> description) + 1;

/*
				   desc_offset += fprintf(txtfile, "%s",
							  currec -> description);
				   ptr = strchr(currec -> description, NULL);
				   tmpstr[0] = NULL;
				   desc_offset++;
				   fwrite(&tmpstr[0], 1, 1, txtfile);
*/

			     /* Make sure the description ends with a \r */
				/*
				   if(ptr && currec -> filename[0])
				   {
				       tmpstr[2] = NULL;
				       ptr--;
				       tmpstr[1] = *ptr;
				       ptr--;
				       tmpstr[0] = *ptr;
				       if(!strstr(tmpstr, "\r"))
				       {
					   desc_offset += 2;
					   fseek(txtfile, ftell(txtfile) - 1, SEEK_SET);
					   fprintf(txtfile, "\r");
				       }

				   }

				   */

                                   if(ezyhdrvar.l1 != NULL)
                                   {
                                       x++;
                                   }
                                   fwrite(&ezyhdrvar, sizeof(ezyhdrvar), 1, hdrfile);
                               }
			       currec = currec -> nextrec;
                           }

                           /* Now update the FLCOUNT.BBS with the number of files in this area */
                           sprintf(tmpstr, "%sFLCOUNT.BBS", Config_obj.amu_cfgvar.FDBpath);
                           idxfile = _fsopen(tmpstr, "r+b", SH_DENYNO);
                           if(!idxfile && Config_obj.amu_cfgvar.create_if_notexist)
                           {
                               idxfile = _fsopen(tmpstr, "w+b", SH_DENYNO);
                               if(idxfile)
                               {
				   sprintf(LOGSTR, "[WRITE_AREA] Note - Creating '%s'", tmpstr);
                                   Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                               }
                           }

                           if(!idxfile)
                           {
                               sprintf(LOGSTR, "? [WRITE_AREA] Unable to open '%s' - (%s)",
                                       tmpstr, strerror(errno));
			       Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                           }
                           else
                           {
                               /* Make sure there are enough records */
                               i = filelength(fileno(idxfile)) / sizeof(short);
                               j = 0;
                               while(i < Config_obj.num_filearea)
                               {
                                   fseek(idxfile, 0, SEEK_END);
                                   fwrite(&j, sizeof(short), 1, idxfile);
                                   i++;
			       }

                               fseek(idxfile, (Area - 1) * sizeof(short), SEEK_SET);
                               fread(&i, sizeof(short), 1, idxfile);
                               fseek(idxfile, (Area - 1) * sizeof(short), SEEK_SET);
                               fwrite(&x, sizeof(short), 1, idxfile);
                               fclose(idxfile);
                           }
			   break;


	case LORA_FDB    : while(currec)
			   {
			       memset(&loradatavar, NULL, sizeof(loradatavar));

			       if(!Utility_obj.bitset(currec -> attribute, AMU_HEADER))
			       {

			       loradatavar.Id = FILEBASE_ID;
			       strcpy(loradatavar.Area, fileareavar.lora3key);
			       strcpy(loradatavar.Name, currec -> filename);
			       if(loradatavar.Name[0] != NULL)
			       {
				   sprintf(loradatavar.Complete, "%s%s", fileareavar.filepath, currec -> filename);
			       }
			       loradatavar.Flags = currec -> bbsattrib;
			       loradatavar.Description = strlen(currec -> description);
			       loradatavar.Uploader = strlen(currec -> uploader);
			       strcpy(loradatavar.Keyword, currec -> keyword[0]);
			       loradatavar.Size = currec -> size;
			       loradatavar.DlTimes = currec -> timesdl;
			       loradatavar.Cost = currec -> cost;
			       loradatavar.Password = currec -> passwordcrc;
			       loradatavar.Level = currec -> level;
			       loradatavar.AccessFlags = currec -> accessflags;
			       loradatavar.DenyFlags = currec -> denyflags;
			       loradatavar.UploadDate = currec -> uploadtimedate.getSecondsSince1970();
			       loradatavar.FileDate = currec -> timedate.getSecondsSince1970();
			       }

                               /* Only write it back if not marked for deletion */
                               if(!Utility_obj.bitset(currec -> attribute, AMU_DELETED))
                               {
                                   fwrite(&loradatavar, sizeof(loradatavar), 1, hdrfile);
                                   if(loradatavar.Description > 0)
                                   {
                                       fwrite(currec -> description, loradatavar.Description, 1, hdrfile);
				   }
                                   if(loradatavar.Uploader > 0)
                                   {
                                       fwrite(currec -> uploader, loradatavar.Uploader, 1, hdrfile);
                                   }
                               }
			       currec = currec -> nextrec;
                           }
                           break;

        case CONCORD_FDB : while(currec)
			   {
			       if(!Utility_obj.bitset(currec -> attribute, AMU_DELETED))
			       {
				  memset(&concordhdrvar, NULL, sizeof(concordhdrvar));
				  if(!Utility_obj.bitset(currec -> attribute, AMU_HEADER))
				  {

				  packname(currec -> filename);
				  concordhdrvar.size = currec -> size;
				  currec -> timedate.getPackedDateTime(&concordhdrvar.uploaddate, &concordhdrvar.uploadtime);
				  concordhdrvar.downloads = currec -> timesdl;
				  concordhdrvar.attrib = currec -> bbsattrib;

				  }
				  concordhdrvar.descptr = desc_offset;
				  concordhdrvar.descreclen = (unsigned short) strlen(currec -> description) + 1;
				  concordhdrvar.uploaderlen = (unsigned char) strlen(currec -> uploader) + 1;
				  fwrite(&concordhdrvar, sizeof(concordhdrvar), 1, hdrfile);
				  fwrite(currec -> description, concordhdrvar.descreclen, 1, txtfile);
				  fwrite(currec -> uploader, concordhdrvar.uploaderlen, 1, txtfile);
				  currec -> lastdl.getPackedDateTime(&tmpdate, &tmptime);
				  fwrite(&tmpdate, 2, 1, txtfile);
				  fwrite(&currec -> cost, 2, 1, txtfile);
				  desc_offset += (concordhdrvar.descreclen +
						   concordhdrvar.uploaderlen + 4);
			       }
			       currec = currec -> nextrec;
			   }
			   break;

	case FILESBBS    : while(currec)
			   {
			       space_used = FALSE;
			       if(Utility_obj.bitset(currec -> attribute, AMU_DELETED))
			       {
				   currec = currec -> nextrec;
				   continue;
			       }

			       // Handle headers and comment lines
			       if(!currec -> filename[0])
			       {
				   Amustr_obj.strip_n(currec -> description);
				   fprintf(filesbbsfile, "%s\n", currec -> description);
				   currec = currec -> nextrec;
				   continue;
			       }

			       /* Set up the first line */
			       tmpstr2[0] = NULL;
			       if(fileareavar.attrib.cdrom)
			       {
				   if(fileareavar.cdformat == CD_1)
				   {
				       sprintf(tmpstr2, "%10ld %s",
					       currec -> size,
					       currec -> timedate.getDateStr(DATES_MMDDYY));
				   }
				   if(fileareavar.cdformat == CD_4)
				   {
				       sprintf(tmpstr2, "%s %10ld",
					       currec -> timedate.getDateStr(DATES_MMDDYY),
					       currec -> size);
				   }
				   if(fileareavar.cdformat == CD_5)
				   {
				       sprintf(tmpstr2, "%s",
					       currec -> timedate.getDateStr(DATES_MMDDYY));
				   }
                                   if(fileareavar.cdformat == CD_2)
                                   {
                                       sprintf(tmpstr2, "%10ld", currec -> size);
                                   }
                               }

			       if(strlen(currec -> filename) < 12)
                               {
				   Amustr_obj.pad(currec -> filename, 12);
                               }

                               if(Config_obj.amu_cfgvar.counter_width > 0)
                               {
                                   sprintf(tmpstr, "%d", currec -> timesdl);
                                   if(strlen(tmpstr) < Config_obj.amu_cfgvar.counter_width)
                                   {
                                       j = strlen(tmpstr);
                                       strrev(tmpstr);
                                       for(i = 0; i < (Config_obj.amu_cfgvar.counter_width - j); i++)
                                       {
                                           strcat(tmpstr, "0");
                                       }
                                       strrev(tmpstr);
                                   }

				   if(tmpstr2[0])
                                   {
				       fprintf(filesbbsfile, "%s %s %c%s%c ", currec -> filename, tmpstr2, Config_obj.amu_cfgvar.left_bracket, tmpstr,
                                                              Config_obj.amu_cfgvar.right_bracket);
                                   }
                                   else
                                   {
                                       fprintf(filesbbsfile, "%s %c%s%c ", currec -> filename, Config_obj.amu_cfgvar.left_bracket, tmpstr,
                                                              Config_obj.amu_cfgvar.right_bracket);
                                   }

                               }
                               else
                               {
                                   if(tmpstr2[0])
                                   {
                                       fprintf(filesbbsfile, "%s %s ", currec -> filename, tmpstr2);
                                   }
                                   else
                                   {
                                       fprintf(filesbbsfile, "%s ", currec -> filename);
                                   }
                               }

                               /* Now handle the description - first line */
                               ptr = currec -> description;
                               ptr2 = tmpstr;
                               while(*ptr && *ptr != '\n')
                               {
                                   *ptr2 = *ptr;
                                   ptr++;
                                   ptr2++;
                               }
                               *ptr2 = NULL;
                               fprintf(filesbbsfile, "%s\n", tmpstr);

                               /* Now check for more lines */
                               if(*ptr)
                               {
                                   tmpstr2[0] = Config_obj.amu_cfgvar.ext_desc_char[0];
                                   tmpstr2[1] = NULL;

			       /* If it's a space, flag it */
                                   if(tmpstr2[0] == ' ')
				   {
                                       space_used = TRUE;
                                   }

                                   ptr++;
                                   while(*ptr)
                                   {
                                       ptr2 = tmpstr;
                                       while(*ptr && *ptr != '\n')
                                       {
                                           *ptr2 = *ptr;
                                           ptr++;
                                           ptr2++;
                                       }
                                       *ptr2 = NULL;

                                /* No need to pad if it's spaces */
                                       if(space_used == FALSE)
                                       {
					   strrev(tmpstr);
                                           strcat(tmpstr, tmpstr2);
					   strrev(tmpstr);
                                           Amustr_obj.lpad(tmpstr, strlen(tmpstr) + Config_obj.amu_cfgvar.ext_offset - 1);
                                       }

                                       fprintf(filesbbsfile, "%s\n", tmpstr);
                                       if(*ptr)
                                       {
                                           ptr++;
                                       }
                                   }
                               }
                               currec = currec -> nextrec;
                           }
                           break;

        default          : break;
    }
    free(tmpdesc);
}

/**********************************************************************/

void FileOptions::close_area(void)
{
    switch(fileareavar.listtype)
    {
	case RA_FDB      : fclose(hdrfile);
			   fclose(idxfile);
			   fclose(txtfile);
			   break;

	case CONCORD_FDB : fclose(hdrfile);
			   fclose(txtfile);
			   break;

	case LORA_FDB    : fclose(hdrfile);
			   if(idxfile)
			   {
			      fclose(idxfile);
			   }
			   break;

	case EZY_FDB     : fclose(hdrfile);
			   fclose(txtfile);
			   break;

	case TG310_FDB   :
	case TG_FDB      : fclose(hdrfile);
			   fclose(txtfile);
			   break;

	case FILESBBS    : fclose(filesbbsfile);
			   break;
    }
    filesbbsfile = hdrfile = idxfile = txtfile = NULL;
}

/*********************************************************************/
/* De-allocate the file area array */
void FileOptions::deallocate_area(void)
{
    currec = toprec;
    while(currec)
    {
        tmprec = currec;
        currec = currec -> nextrec;
	if(tmprec -> description != NULL)
	{
	    free(tmprec -> description);
	}
	free(tmprec);
    }
    toprec = currec = endrec = tmprec = prevrec = NULL;
}

/*********************************************************************/
/* Unpack Concord's packed filename style */
char *FileOptions::unpackname(char *str)
{
    char instr[15];
    static char outstr[15];
    int i, j;

    strcpy(instr, str);
    if(instr[0] == ' '  ||  instr[0] == NULL)
    {
        outstr[0] = NULL;
    }
    else
    {
         /* Copy the root fileoutstr */
        for(i = 0; i < 8; i++)
        {
            if(instr[i] != ' ')
            {
                outstr[i] = instr[i];
            }
            else
            {
                break;
            }
        }
        outstr[i] = '.';
        j = i + 1;

        /* Now copy the extension */
        while(instr[i] == ' ')
        {
            i++;
        }
        while(i < 11)
        {
            outstr[j] = instr[i];
            i++;
            j++;
        }
        outstr[j] = NULL;
    }
    return(outstr);
}

/************************************************************************/
/* Pack a filename into Concord's format */
void FileOptions::packname(char *s)
{
    int i, j;
    char tmpname[15], *ptr;

    strcpy(tmpname, s);

    /* Update the root filename */
    memset(concordhdrvar.name, ' ', 11);
    for(i = 0; i < 8; i++)
    {
        if(tmpname[i] != '.')
        {
            concordhdrvar.name[i] = tmpname[i];
        }
        else
        {
            break;
        }
    }

        /* Update the extension */
    ptr = strchr(tmpname, '.');
    if(ptr)
    {
        ptr++;
        j = strlen(ptr);
        i = sizeof(concordhdrvar.name) - j;
        while(*ptr)
        {
            concordhdrvar.name[i] = *ptr;
            i++;
            ptr++;
        }
    }
}

/************************************************************************/
/* Process file area options */
int FileOptions::process_area(int area, struct filearea *areainfo, int argc, char *argv[])
{
    struct screeninfo s;
    int x, skip_area;

    /* If the area is blank, skip it */
    if(!Config_obj.fileareavar.areaname[0] || !Config_obj.fileareavar.filepath[0])
    {
        return(TRUE);
    }
    memcpy(&fileareavar, areainfo, FILEAREA_SIZE);
    update_area = FALSE;

    /* If there are parameters being used, figure out which options to process */
    if(argc > 1)
    {
        fileareavar.sort = TRUE;
        fileareavar.headers = TRUE;
        fileareavar.adopt = TRUE;
        fileareavar.orphan = TRUE;
        fileareavar.old = TRUE;
        fileareavar.backup = TRUE;
        fileareavar.pack = TRUE;
        fileareavar.rearchive = TRUE;
        fileareavar.comment = TRUE;
        fileareavar.virus = TRUE;
        fileareavar.importdiz = TRUE;
        fileareavar.exportdiz = TRUE;
        fileareavar.importbbs = TRUE;
        fileareavar.exportbbs = TRUE;
        fileareavar.bbsdls = TRUE;
        fileareavar.mailerdls = TRUE;
        fileareavar.move_nodesc = TRUE;
        fileareavar.compress_txt = TRUE;

        x = Utility_obj.check_param(argc, argv, "BACKUP", area);
        switch(x)
        {
            case FALSE        : fileareavar.backup = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.backup = Config_obj.fileareavar.backup;
                                break;
        }

        x = Utility_obj.check_param(argc, argv, "SORT", area);
        switch(x)
        {
            case FALSE        : fileareavar.sort = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.sort = Config_obj.fileareavar.sort;
                                break;
        }

        x = Utility_obj.check_param(argc, argv, "HEADERS", area);
        switch(x)
        {
            case FALSE        : fileareavar.headers = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.headers = Config_obj.fileareavar.headers;
                                break;
        }

        x = Utility_obj.check_param(argc, argv, "ADOPT", area);
        switch(x)
        {
            case FALSE        : fileareavar.adopt = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.adopt = Config_obj.fileareavar.adopt;
                                break;
        }


        x = Utility_obj.check_param(argc, argv, "ORPHAN", area);
        switch(x)
        {
            case FALSE        : fileareavar.orphan = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.orphan = Config_obj.fileareavar.orphan;
                                break;
        }

        x = Utility_obj.check_param(argc, argv, "OLD", area);
        switch(x)
        {
            case FALSE        : fileareavar.old = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.old = Config_obj.fileareavar.old;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "BBSDL", area);
        switch(x)
        {
            case FALSE        : fileareavar.bbsdls = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.bbsdls = Config_obj.fileareavar.bbsdls;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "MAILERDL", area);
        switch(x)
        {
            case FALSE        : fileareavar.mailerdls = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.mailerdls = Config_obj.fileareavar.mailerdls;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "PACK", area);
        switch(x)
        {
            case FALSE        : fileareavar.pack = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.pack = Config_obj.fileareavar.pack;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "REARC", area);
        switch(x)
        {
            case FALSE        : fileareavar.rearchive = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.rearchive = Config_obj.fileareavar.rearchive;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "COMMENT", area);
        switch(x)
        {
            case FALSE        : fileareavar.comment = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.comment = Config_obj.fileareavar.comment;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "SCAN", area);
        switch(x)
        {
            case FALSE        : fileareavar.virus = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.virus = Config_obj.fileareavar.virus;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "IMPORTDIZ", area);
        switch(x)
        {
            case FALSE        : fileareavar.importdiz = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.importdiz = Config_obj.fileareavar.importdiz;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "EXPORTDIZ", area);
        switch(x)
        {
            case FALSE        : fileareavar.exportdiz = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.exportdiz = Config_obj.fileareavar.exportdiz;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "IMPORTBBS", area);
        switch(x)
        {
            case FALSE        : fileareavar.importbbs = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.importbbs = Config_obj.fileareavar.importbbs;
                                break;
        }
        x = Utility_obj.check_param(argc, argv, "EXPORTBBS", area);
        switch(x)
        {
            case FALSE        : fileareavar.exportbbs = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.exportbbs = Config_obj.fileareavar.exportbbs;
                                break;
        }

        x = Utility_obj.check_param(argc, argv, "NODESC", area);
        switch(x)
        {
            case FALSE        : fileareavar.move_nodesc = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.move_nodesc = Config_obj.fileareavar.move_nodesc;
                                break;
        }

        x = Utility_obj.check_param(argc, argv, "COMPTXT", area);
        switch(x)
        {
            case FALSE        : fileareavar.compress_txt = FALSE;
                                break;
            case DEFAULT_PARAM: fileareavar.compress_txt = Config_obj.fileareavar.compress_txt;
                                break;
        }
    }

    sprintf(s.curarea, "(%d) %s", area, fileareavar.areaname);
    Area = area;
    Sort_Type = fileareavar.sort_type;
    skip_area = TRUE;
    if(fileareavar.sort) skip_area = FALSE;
    if(fileareavar.headers) skip_area = FALSE;
    if(fileareavar.adopt) skip_area = FALSE;
    if(fileareavar.orphan) skip_area = FALSE;
    if(fileareavar.old) skip_area = FALSE;
    if(fileareavar.backup) skip_area = FALSE;
    if(fileareavar.pack) skip_area = FALSE;
    if(fileareavar.rearchive) skip_area = FALSE;
    if(fileareavar.comment) skip_area = FALSE;
    if(fileareavar.virus) skip_area = FALSE;
    if(fileareavar.importdiz) skip_area = FALSE;
    if(fileareavar.exportdiz) skip_area = FALSE;
    if(fileareavar.importbbs) skip_area = FALSE;
    if(fileareavar.exportbbs) skip_area = FALSE;
    if(fileareavar.bbsdls) skip_area = FALSE;
    if(fileareavar.mailerdls) skip_area = FALSE;
    if(fileareavar.move_nodesc) skip_area = FALSE;
    if(fileareavar.compress_txt) skip_area = FALSE;

    if(skip_area && Utility_obj.check_param(argc, argv, "LISTS", 0))
    {
        for(x = 1; x <= Config_obj.num_lists; x++)
        {
            Config_obj.read_record(ALLFILE_RECORD, x);
            if(Config_obj.active(Area) && Config_obj.allnewvar.enabled)
            {
                skip_area = FALSE;
                break;
            }
        }
    }
    x = Utility_obj.check_param(argc, argv, "RESTORE", area);
    if(argc > 1 && (x == TRUE || x == DEFAULT_PARAM))
    {
        sprintf(s.curoption, "Restoring file listing #%d", Area);
        Screen_obj.display(&s);
        Utility_obj.logentry(s.curoption, LOG_NORMAL);
        if(!open_area(READ_MODE, NO_BACKUP, DO_RESTORE))
        {
            return(FALSE);
        }
        close_area();
    }
    if(skip_area)
    {
        strcpy(s.curoption, "No options enabled, skipping area");
        Screen_obj.display(&s);
        return(0);
    }

    sprintf(LOGSTR, "Processing area #%d", area);
    Utility_obj.logentry(LOGSTR, LOG_NORMAL);

    /* Check to see if we need to import before we try to open the area */
    if(fileareavar.importbbs)
    {
        strcpy(s.curoption, "Importing FILES.BBS data");
        Screen_obj.display(&s);
        import();
    }
    strcpy(s.curoption, "Reading file area");
    Screen_obj.display(&s);
    if(fileareavar.backup)
    {
        strcpy(s.curoption, "Backing up file listings");
        Screen_obj.display(&s);
        if(!open_area(READ_MODE, DO_BACKUP, NO_RESTORE))
        {
            return(FALSE);
        }
    }
    else
    {
        if(!open_area(READ_MODE, NO_BACKUP, NO_RESTORE))
        {
            return(FALSE);
        }
    }

    x = read_area();
    if(x != 0)
    {
        switch(x)
        {
            case 1: sprintf(LOGSTR, "! Not enough memory to read file area");
                    break;
            case 2: sprintf(LOGSTR, "! Error reading area from disk");
                    break;
        }
        close_area();
        deallocate_area();
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(FALSE);
    }
    close_area();

    if(fileareavar.adopt)
    {
        strcpy(s.curoption, "Adopting missing files");
        Screen_obj.display(&s);
        adopt();
        update_area = TRUE;
    }

    if(fileareavar.orphan)
    {
        strcpy(s.curoption, "Removing orphan files");
        Screen_obj.display(&s);
        killorphans();
        update_area = TRUE;
    }

    if(fileareavar.old)
    {
        strcpy(s.curoption, "Moving/Deleting old files");
        Screen_obj.display(&s);
        old();
        update_area = TRUE;
    }

    if(fileareavar.pack)
    {
        strcpy(s.curoption, "Packing file database");
        Screen_obj.display(&s);
        pack();
        update_area = TRUE;
    }

    strcpy(s.curoption, "Rearc/Scan/Import/Export/Comment");
    Screen_obj.display(&s);
    process_archives();

    if(fileareavar.sort)
    {
        strcpy(s.curoption, "Sorting file entries");
        Screen_obj.display(&s);
        sort();
        update_area = TRUE;
    }

    if(fileareavar.mailerdls || fileareavar.bbsdls)
    {
        strcpy(s.curoption, "Updating download counters");
        Screen_obj.display(&s);
        counters();
        update_area = TRUE;
    }

    if(fileareavar.move_nodesc)
    {
        strcpy(s.curoption, "Moving files with 'Missing Desc'");
        Screen_obj.display(&s);
        move_nodesc();
        update_area = TRUE;
    }

    if(fileareavar.compress_txt)
    {
        strcpy(s.curoption, "Compressing text files");
        Screen_obj.display(&s);
        compress_text();
        update_area = TRUE;
    }

    strcpy(s.curoption, "Compiling area totals");
    Screen_obj.display(&s);
    analyze_area(&infovar);

    if(fileareavar.headers)
    {
        if(Config_obj.amu_cfgvar.BBStype == LORA3)
        {
            sprintf(LOGSTR, "! [PROCESS_AREA] Note - 'Headers' option is incompatible with LoraBBS 3.00, skipping");
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        }
        else
        {
            strcpy(s.curoption, "Adding headers");
            Screen_obj.display(&s);
            fixheaders();
            addhdr();
            update_area = TRUE;
        }
    }

    if(Utility_obj.check_param(argc, argv, "LISTS", 0))
    {
        strcpy(s.curoption, "Writing Allfiles/Newfiles");
        Screen_obj.display(&s);
        filelists(ALLNEW_FILL);
    }

    close_area();
    if(update_area && open_area(WRITE_MODE, NO_BACKUP, NO_RESTORE))
    {
        strcpy(s.curoption, "Updating file area");
        Screen_obj.display(&s);
        write_area();
        close_area();
    }
    deallocate_area();

    /* Check to see if we need to export the area */
    if(fileareavar.exportbbs)
    {
        strcpy(s.curoption, "Exporting FDB to FILES.BBS");
        Screen_obj.display(&s);
        export();
    }
    return(0);
}

/************************************************************************/
/* Remove file entries which do not exist on disk */
void FileOptions::killorphans(void)
{
    char filespec[MAX_FILESPEC];

    currec = toprec;
    while(currec)
    {
        if(!Utility_obj.bitset(currec -> attribute, AMU_HEADER) &&
           !Utility_obj.bitset(currec -> attribute, AMU_COMMENT))
        {
            sprintf(filespec, "%s%s", find_filepath(currec -> filename), currec -> filename);
            if(access(filespec, 0)  != 0)
            {
                sprintf(LOGSTR, "[ORPHAN] Removing '%s'", currec -> filename);
                Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                Utility_obj.setbit(&currec -> attribute, AMU_DELETED);
            }
        }
        currec = currec -> nextrec;
    }
}

/************************************************************************/
/* Adopt missing files */
void FileOptions::adopt(void)
{
    char filespec[MAX_FILESPEC], *buffer, *ptr, tmppath[MAX_FILESPEC];
    FILE *noadopt;
    struct find_t fileinfo;
    struct dosdate_t d;
    int done, found, x;
    FILE *txtfile;

   /* Here we have to call adopt() recursively to handle FA_nnn.CTL areas */
    strupr(fileareavar.filepath);
    sprintf(filespec, "FA_%d.CTL", Area);
    if(strstr(fileareavar.filepath, filespec))
    {
        Amustr_obj.noslash(fileareavar.filepath);
        txtfile = fopen(fileareavar.filepath, "rt");
        if(txtfile)
        {
            while(fgets(tmppath, sizeof(tmppath)-2, txtfile))
            {
                Amustr_obj.strip_n(tmppath);
                Amustr_obj.slash(tmppath);
                strcpy(fileareavar.filepath, tmppath);
                adopt();
            }
            fclose(txtfile);
        }
        Config_obj.read_record(FILEAREA_RECORD, Area);
        strcpy(fileareavar.filepath, Config_obj.fileareavar.filepath);
        return;
    }

    /* If the NOADOPT file exists, read it into a buffer.  This can
       then be checked by strstr() to see if a file should or should
       not be adopted */
    _dos_getdate(&d);
    sprintf(filespec, "%s%s", Config_obj.amu_cfgvar.AMUpath, NOADOPT_CTL);
    noadopt = _fsopen(filespec, "rt", SH_DENYWR);
    buffer = NULL;
    sprintf(filespec, "FILESBAK.%d", Area);
    if(noadopt)
    {
        x = filelength(fileno(noadopt));
        buffer = (char *)calloc(1, x + strlen(filespec) + 5);
        if(buffer)
        {
            strcpy(buffer, filespec);
            ptr = strchr(buffer, 0);
            fread(ptr, x, 1, noadopt);
            strupr(buffer);
        }
        fclose(noadopt);
    }
    if(!buffer)
    {
        buffer = (char *)calloc(1, strlen(filespec)+1);
        strcpy(buffer, filespec);
    }

    sprintf(filespec, "%s*.*", fileareavar.filepath);
    done = _dos_findfirst(filespec, _A_ARCH, &fileinfo);
    while(!done)
    {
        strupr(fileinfo.name);
        found = FALSE;
        if(buffer && strstr(buffer, fileinfo.name))
        {
            found = TRUE;
        }
        currec = toprec;
        while(currec && !found)
        {
            if(stricmp(currec -> filename, fileinfo.name) == 0)
            {
                found = TRUE;
            }
            else
            {
                currec = currec -> nextrec;
            }
	}


     /* If the file was not found, add it to the end of the linked list */
        if(!found)
        {
            currec = endrec;

          /* If the array is empty, we need to start from scratch */
            if(!currec)
            {
		currec = (struct filearray *)calloc(sizeof(struct filearray), 1);
                if(!currec)
                {
                    sprintf(LOGSTR, "! [ADOPT] Unable to allocate memory for adopted file");
                    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                    if(buffer)
                    {
                        free(buffer);
                    }
                    return;
                }
                else
                {
                    endrec = toprec = currec;
                }
            }
            else
            {
                currec -> nextrec = (struct filearray *)calloc(sizeof(struct filearray), 1);
                if(!currec -> nextrec)
                {
                    sprintf(LOGSTR, "! [ADOPT] Unable to allocate memory for adopted file");
                    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                    if(buffer)
                    {
                        free(buffer);
                        return;
                    }
                }
		currec = currec -> nextrec;
		currec -> prevrec = endrec;
		endrec = currec;
	    }
	    sprintf(LOGSTR, "[ADOPT] Adopting '%s'", fileinfo.name);
	    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
	    memset(currec, NULL, sizeof(struct filearray));
	    strcpy(currec -> filename, fileinfo.name);
	    strcpy(currec -> uploader, "AMU");
	    currec -> timedate.createDate((unsigned short)fileinfo.wr_date, (unsigned short)fileinfo.wr_time);
	    currec -> lastdl.createDate((unsigned short)fileinfo.wr_date, (unsigned short)fileinfo.wr_time);
	    currec -> uploadtimedate.createDate();
	    currec -> size = fileinfo.size;
	    currec -> description = (char *) calloc(1, sizeof(Config_obj.amu_cfgvar.missing_desc) + 5);
	    if(currec -> description)
	    {
		strcpy(currec -> description, Config_obj.amu_cfgvar.missing_desc);
	    }
	    switch(fileareavar.listtype)
	    {
		case TG310_FDB  :
		case TG_FDB     : // Mark the file as being available & validated
				  currec -> bbsattrib = 12;
				  break;
	    }

	}
	done = _dos_findnext(&fileinfo);
    }
    if(buffer)
    {
        free(buffer);
    }
}

/**********************************************************************/
/* Import a FILE_ID.DIZ or DESC.SDI file */
int FileOptions::get_diz(int decompress, char *filename)
{
    int diz_found, x, y, max_desc_length, str_size;
    char *str, filespec[MAX_FILESPEC];
    char *tmpdesc, *ptr, *ptr2;
    FILE *dizfile;

    str_size = 2049;
    diz_found = FALSE;
    tmpdesc = NULL;
    if(decompress)
    {
        sprintf(filespec, "%s%s", find_filepath(filename), filename);
        Execute_obj.decompress_some(filespec, "FILE_ID.DIZ DESC.SDI",
                                    Utility_obj.get_arctype(filespec));
    }

    /* Check for FILE_ID.DIZ/DESC.SDI */
    if(access("FILE_ID.DIZ", 0) == 0)
    {
        strcpy(filespec, "FILE_ID.DIZ");
	diz_found = TRUE;
    }
    if(!diz_found && access("DESC.SDI", 0) == 0)
    {
        strcpy(filespec, "DESC.SDI");
        diz_found = TRUE;
    }

    if(diz_found)
    {
        dizfile = _fsopen(filespec, "rt", SH_DENYNO);
        if(dizfile)
        {
            x = filelength(fileno(dizfile));
//          tmpdesc = (char *)calloc(1, x+1);
            tmpdesc = (char *)calloc(1, 5000);
            if(tmpdesc)
            {
		y = 0;
                str = (char *) calloc(1, str_size);
                fgets(str, str_size - 2, dizfile);
		while(!feof(dizfile) || y == 0)
                {
                    y++;
                    Amustr_obj.strip_n(str);
                    if(Config_obj.amu_cfgvar.max_dizwidth)
                    {
                        str[Config_obj.amu_cfgvar.max_dizwidth] = NULL;
                    }

		    switch(fileareavar.listtype)
		    {
                        case RA_FDB     :
                        case LORA_FDB   : strcat(str, "\r\n");
                                          break;
                        case EZY_FDB    :
			case CONCORD_FDB: strcat(str, "\r");
					  break;
			case TG310_FDB  :
			case TG_FDB     : strcat(str, "\n");
					  break;
			default         : if(Config_obj.amu_cfgvar.use_multiple_lines)
					  {
					      strcat(str, "\n");
					  }
					  else
					  {
					      strcat(str, " ");
					  }
					  break;
		    }

                    strcat(tmpdesc, str);
                    if(Config_obj.amu_cfgvar.max_dizlines && y >= Config_obj.amu_cfgvar.max_dizlines)
                    {
                        break;
                    }
                    fgets(str, str_size - 2, dizfile);
                }
                fclose(dizfile);
                free(str);
                x = strlen(tmpdesc);
                max_desc_length = MAX_DESC_SIZE;
                if(!Config_obj.amu_cfgvar.use_multiple_lines)
                {
                    max_desc_length = Config_obj.amu_cfgvar.max_single_length;
                }

                switch(fileareavar.listtype)
                {
                    case CONCORD_FDB: max_desc_length = 1024;
                                      break;
                    case RA_FDB     :
                    case LORA_FDB   : max_desc_length = 4096;
                                      break;
                    case EZY_FDB    : max_desc_length = FLTMAXSIZE;
                                      break;
                }

                if(x > max_desc_length)
                {
                    x = max_desc_length;
                    ptr = tmpdesc;
                    for(y = 0; y < x; x++)
                    {
                        ptr++;
                    }
                    *ptr = NULL;
                    x = strlen(tmpdesc);
                    sprintf(LOGSTR, "! [GET_DIZ] '%s' for '%s' too large, truncating",
                            filespec, filename);
                    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                }

                if(fileareavar.filter_graph)
                {
                    ptr = tmpdesc;
                    while(*ptr)
                    {
                        if(*ptr > 173)
                        {
                            x--;
                            *ptr = BACKSPACE;
                        }
                        ptr++;
                    }
                }

                /* Allocate room for the description */
                currec -> description = (char *)calloc(1, x+y+3);
                if(currec -> description)
                {
                    ptr = tmpdesc;
                    ptr2 = currec -> description;
                    while(*ptr)
                    {
                        if(*ptr != BACKSPACE)
                        {
                            *ptr2 = *ptr;
                            ptr2++;
                        }
                        ptr++;
                    }
                }
                else
                {
                    diz_found = FALSE;
                    sprintf(LOGSTR, "! [GET_DIZ] Not enough memory to read '%s'", filespec);
                    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                }
            }
            else
            {
                sprintf(LOGSTR, "! [GET_DIZ] Not enough memory to read '%s' for '%s'",
                                 filespec, filename);
                Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                diz_found = FALSE;
            }
        }
        else
        {
            diz_found = FALSE;
        }
    }

    /* Check for FILE_ID.DIZ/DESC.SDI and remove them */
    if(decompress && access("FILE_ID.DIZ", 0) == 0)
    {
        chmod("FILE_ID.DIZ", S_IREAD | S_IWRITE);
        remove("FILE_ID.DIZ");
    }
    if(decompress && access("DESC.SDI", 0) == 0)
    {
        chmod("DESC.SDI", S_IREAD | S_IWRITE);
        remove("DESC.SDI");
    }
    if(tmpdesc)
    {
        free(tmpdesc);
    }
    return(diz_found);
}

/************************************************************************/
/* Change the headers AMU uses - remove the #255 from the end and place
   a #8 (backspace) as the first character */
void FileOptions::fixheaders(void)
{
    char *ptr;

    currec = toprec;
    while(currec)
    {
        ptr = strchr(currec -> description, 0xFF);
        if(ptr)
        {
            *ptr = NULL;
            ptr = currec -> description;
            *ptr = BACKSPACE;
            Utility_obj.setbit(&currec -> attribute, AMU_HEADER);
        }
        currec = currec -> nextrec;
    }
}

/************************************************************************/
/* Pack the file database */
void FileOptions::pack(void)
{
    currec = toprec;
    while(currec)
    {
        if(fileareavar.listtype == RA_FDB)
        {
            if(Utility_obj.bitset(currec -> bbsattrib, RA_DELETED))
            {
                Utility_obj.setbit(&currec -> attribute, AMU_DELETED);
            }
        }
        if(fileareavar.listtype == EZY_FDB)
        {
            if(Utility_obj.bitset(currec -> bbsattrib, BIT5))
            {
                Utility_obj.setbit(&currec -> attribute, AMU_DELETED);
            }
        }
        if(fileareavar.listtype == LORA_FDB)
        {
            if(Utility_obj.bitset(currec -> bbsattrib, FILE_DELETED))
            {
                Utility_obj.setbit(&currec -> attribute, AMU_DELETED);
            }
        }
        currec = currec -> nextrec;
    }

}

/***********************************************************************/
/* Add headers */
void FileOptions::addhdr(void)
{
    char hdrfn[MAX_FILESPEC], instr[150];
    FILE *hdrfile;

    AMU_Headers_ptr = new AMU_Headers(&fileareavar, &infovar);
    Header = (char *)calloc(1, 200);

    sprintf(hdrfn, "%sAMU%d.HDR", Config_obj.amu_cfgvar.AMUpath, Area);
    if(access(hdrfn, 0) != 0)
    {
        sprintf(hdrfn, "%sAMU.HDR", Config_obj.amu_cfgvar.AMUpath);
    }
    hdrfile = _fsopen(hdrfn, "rt", SH_DENYWR);
    if(hdrfile)
    {
	/* Run through the list once and get rid of all old headers */
	currec = toprec;
	while(currec)
	{
	    if(Utility_obj.bitset(currec -> attribute, AMU_HEADER))
	    {
		Utility_obj.setbit(&currec -> attribute, AMU_DELETED);
	    }
	    currec = currec -> nextrec;
	}

	/* 'tmprec' will point to the top of the header */
	tmprec = prevrec = NULL;
	fgets(instr, sizeof(instr) - 2, hdrfile);
	while(!feof(hdrfile))
	{
	    Amustr_obj.strip_n(instr);
	    currec = (struct filearray *)calloc(sizeof(struct filearray), 1);
	    if(currec)
	    {
		if(!tmprec)
		{
		    tmprec = currec;
		}
		if(prevrec)
                {
                    prevrec -> nextrec = currec;
                }
                Header[0] = NULL;
                AMU_Headers_ptr -> get_expansion(instr, Header);
                currec -> description = (char *)calloc(1, strlen(Header) + 5);
                if(currec -> description)
                {
                    sprintf(currec -> description, "  %c", BACKSPACE);
                    strcat(currec -> description, Header);
                    Utility_obj.setbit(&currec -> attribute, AMU_HEADER);
                }
                currec -> nextrec = NULL;
                currec -> prevrec = prevrec;
                prevrec = currec;
            }
            fgets(instr, sizeof(instr) - 2, hdrfile);
        }
        fclose(hdrfile);
        if(toprec)
        {
            toprec -> prevrec = currec;
        }
        currec -> nextrec = toprec;
        toprec = tmprec;
    }
    else
    {
        sprintf(LOGSTR, "! [HEADERS] Unable to open '%s' - (%s)", hdrfn, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
    }
    free(Header);
    delete(AMU_Headers_ptr);
}

/***********************************************************************/
/* Process archives */
void FileOptions::process_archives(void)
{
    short do_scan, do_rearc, do_import, do_export, do_comment, arctype;
    short screen_swapped, result;
    char arcfilename[MAX_FILESPEC], newarcfilename[MAX_FILESPEC];
    char str[MAX_FILESPEC], *norearcbuf, *screenbuf, *ptr, fn[MAX_FILESPEC];
    long x;
    struct tracking_record *trackingvar;
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    char *tmpfilename;
    FILE *outfile, *arcfile, *commentfile, *tmpfile;
#ifdef __BORLANDC__
    unsigned int date, time;
#else
    unsigned short date, time;
#endif

   /* If NOREARC.CTL exists, read it into a buffer and use strstr()
      later to check for matches */
    norearcbuf = NULL;
    sprintf(arcfilename, "%s%s", Config_obj.amu_cfgvar.AMUpath, NOREARC_CTL);
    outfile = _fsopen(arcfilename, "rt", SH_DENYWR);
    sprintf(arcfilename, "FILESBAK.%d", Area);
    if(outfile)
    {
        x = filelength(fileno(outfile));
        norearcbuf = (char *)calloc(1, x + strlen(arcfilename) + 5);
        if(norearcbuf)
        {
            strcpy(norearcbuf, arcfilename);
            ptr = strchr(norearcbuf, 0);
            fread(ptr, x, 1, outfile);
            strupr(norearcbuf);
        }
        fclose(outfile);
    }
    if(!norearcbuf)
    {
        norearcbuf = (char *)calloc(1, strlen(arcfilename)+1);
        strcpy(norearcbuf, arcfilename);
    }

   /* Check to see if this is a CD area and make any adjustments */
    if(fileareavar.attrib.cdrom && fileareavar.rearchive)
    {
        fileareavar.rearchive = FALSE;
    }

    if(fileareavar.attrib.cdrom && fileareavar.exportdiz)
    {
        fileareavar.exportdiz = FALSE;
    }

    if(fileareavar.attrib.cdrom && fileareavar.comment)
    {
        fileareavar.comment = FALSE;
    }

    if(!fileareavar.rearchive && !fileareavar.virus && !fileareavar.comment
       && !fileareavar.importdiz && !fileareavar.exportdiz)
    {
        if(norearcbuf)
        {
            free(norearcbuf);
        }
        return;
    }

    screen_swapped = FALSE;
    screenbuf = NULL;
    Utility_obj.change_dir(Config_obj.amu_cfgvar.workpath);
    currec = toprec;
    while(currec)
    {
        if(!currec -> filename[0] || Utility_obj.bitset(currec -> attribute,
                                                        AMU_DELETED))
        {
            currec = currec -> nextrec;
            continue;
        }

        sprintf(arcfilename, "%s%s", find_filepath(currec -> filename), currec -> filename);
        arcfile = _fsopen(arcfilename, "rb", SH_DENYNO);
        if(arcfile)
        {
            _dos_getftime(fileno(arcfile), &date, &time);
            fclose(arcfile);
        }
        else
        {
            sprintf(LOGSTR, "! [ARCS] '%s' does not exist, skipping entry", arcfilename);
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            currec = currec -> nextrec;
            continue;
        }
        arctype = Utility_obj.get_arctype(arcfilename);
        do_scan = do_rearc = do_import = do_export = do_comment = FALSE;
        trackingvar = Utility_obj.read_tracking(arcfilename);

       /* Figure out which options need to be performed */
        if(fileareavar.rearchive && arctype != fileareavar.rearc_type
           && arctype != UNKNOWN)
        {
            do_rearc = TRUE;
        }

        if(fileareavar.rearchive && arctype == fileareavar.rearc_type
           && arctype != UNKNOWN && !trackingvar -> status.rearced &&
           fileareavar.force_rearc)
        {
            do_rearc = TRUE;
        }

        if(fileareavar.virus && !trackingvar -> status.scanned
           && arctype != UNKNOWN)
        {
            do_scan = TRUE;
        }
        if(fileareavar.importdiz && !trackingvar -> status.imported
           && arctype != UNKNOWN)
        {
            do_import = TRUE;
        }
        if(fileareavar.exportdiz && !trackingvar -> status.exported
           && arctype != UNKNOWN)
        {
            do_export = TRUE;
        }
        if(fileareavar.comment && !trackingvar -> status.commented
           && (arctype == RAR || arctype == ZIP || arctype == ARJ) && arctype != UNKNOWN)
        {
            do_comment = TRUE;
        }

        if((fileareavar.honor_av && Utility_obj.is_secure(arcfilename)) &&
           (do_rearc || do_comment || do_export))
        {
            sprintf(LOGSTR, "[ARCS] Note - Not modifying secure file '%s'", arcfilename);
            Utility_obj.logentry(LOGSTR, LOG_EXTENSIVE);
            do_export = do_rearc = do_comment = FALSE;
            trackingvar -> status.commented = TRUE;
            trackingvar -> status.exported = TRUE;
            trackingvar -> status.rearced = TRUE;
        }

     /* Check to see if this is multi-volume or not */
        if(Utility_obj.is_multivolume(arcfilename) == TRUE)
        {
            sprintf(LOGSTR, "[ARCS] Note - Not processing multivolume archive '%s'", arcfilename);
            Utility_obj.logentry(LOGSTR, LOG_EXTENSIVE);
            do_export = do_rearc = do_comment = FALSE;
            trackingvar -> status.commented = TRUE;
            trackingvar -> status.exported = TRUE;
            trackingvar -> status.rearced = TRUE;
        }

        if(fileareavar.attrib.cdrom && (do_export || do_comment || do_rearc))
        {
            sprintf(LOGSTR, "! [ARCS] CD area, disabling Rearc/Export/Comment");
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            do_rearc = do_comment = do_export = FALSE;
        }


        if(do_rearc && norearcbuf && strstr(norearcbuf, currec -> filename))
        {
            sprintf(LOGSTR, "[REARC] '%s' found in %s, skipping", currec -> filename, NOREARC_CTL);
            Utility_obj.logentry(LOGSTR, LOG_NORMAL);
            do_rearc = FALSE;
        }

        if(!do_export && !do_import && !do_comment && !do_scan && !do_comment && !do_rearc)
        {
            currec = currec -> nextrec;
            continue;
        }

       /* if the screen has not been swapped yet, swap it! */
        if(!screen_swapped)
        {
            screenbuf = (char *)malloc(4000);
            Screen_obj.getscreen(screenbuf);
            Screen_obj.clearscreen();
            Screen_obj.set_swapping(FALSE);
            screen_swapped = TRUE;
        }

        mkdir(TMPDIR);
        chdir(TMPDIR);
        Utility_obj.cleardir();
        strcpy(newarcfilename, arcfilename);
        if(do_scan || do_rearc)
        {
            update_area = TRUE;
            if(Execute_obj.decompress_all(arcfilename, arctype) == 0)
            {
                trackingvar -> status.rearced = TRUE;
                if(!Config_obj.amu_cfgvar.skip_nested)
                {
                    check_nested(do_scan, do_rearc);
                }
                if(do_scan)
                {
                    sprintf(LOGSTR, "[VIRUS] Scanning '%s'", arcfilename);
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                    trackingvar -> status.scanned = TRUE;
                    for(x = 0; x < MAX_SCANNERS; x++)
                    {
                        if(Execute_obj.virus_scan(x, arcfilename))
                        {
                            sprintf(LOGSTR, "! [VIRUS] Scanner %d reports virus in '%s'", x, arcfilename);
                            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                        }
                    }
                }
                if(do_import)
                {
                    trackingvar -> status.imported = TRUE;
                    if(get_diz(FALSE, currec -> filename))
                    {
                        sprintf(LOGSTR, "[IMPORT] Description imported for '%s'", currec -> filename);
                        Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                    }
                }
                if(do_export && !strstr(currec -> description, Config_obj.amu_cfgvar.missing_desc)
                   && strlen(currec -> description) > 10)
                {
                    outfile = _fsopen("FILE_ID.DIZ", "w+t", SH_DENYWR);
                    if(outfile)
                    {
                        sprintf(LOGSTR, "[EXPORT] Description exported for '%s'", currec -> filename);
                        Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                        trackingvar -> status.exported = TRUE;
                        fprintf(outfile, "%s", currec -> description);
                        fclose(outfile);
                    }
                }
                if(do_rearc)
                {

                   /* Add and remove files from the archive */
                    sprintf(str, "%s%s", Config_obj.amu_cfgvar.AMUpath, ADD_CTL);
                    Utility_obj.check_files(str, ADD_FILES);
                    sprintf(str, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRASH_CTL);
                    Utility_obj.check_files(str, REMOVE_FILES);

                    Utility_obj.get_newarc_ext(newarcfilename, fileareavar.rearc_type);
                    sprintf(LOGSTR, "[REARC] Converting '%s' to '%s'", arcfilename, newarcfilename);
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);

             /* If this is a force rearchiving, make a copy of the original, then
                delete the original.  If the conversion is not successful, the original
                can be restored */
                    tmpfilename = NULL;
                    if(strstr(arcfilename, newarcfilename))
                    {
                        tmpfilename = (char *) malloc(MAX_FILESPEC);
                        sprintf(tmpfilename, "%sTMPARC.AMU", Config_obj.amu_cfgvar.workpath);
                        Utility_obj.copyfile(arcfilename, tmpfilename);
                        remove(arcfilename);
                    }

                    result = Execute_obj.compress(newarcfilename, "*.*", fileareavar.rearc_type);
                    if(result == 0 && Config_obj.fileareavar.rearc_type != arctype)
                    {
                        remove(arcfilename);
                        _splitpath(newarcfilename, drive, dir, fname, ext);
                        sprintf(currec -> filename, "%s%s", fname, ext);
                    }
                    else
                    {
                        if(tmpfilename && result != 0)
                        {
                            Utility_obj.copyfile(tmpfilename, arcfilename);
                        }
                    }

                    if(tmpfilename)
                    {
                        remove(tmpfilename);
                        free(tmpfilename);
                        tmpfilename = NULL;
                    }


                    sprintf(newarcfilename, "%s%s", find_filepath(currec -> filename), currec -> filename);
                    arctype = Utility_obj.get_arctype(newarcfilename);
                }
            }
            else
            {
                if(Config_obj.amu_cfgvar.kill_bad_arcs)
                {
                    sprintf(LOGSTR, "! [ARCS] Removing bad archive '%s'", arcfilename);
                    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                    remove(arcfilename);
                    do_comment = do_rearc = do_import = do_export = do_scan = FALSE;
                }
            }
        }
        else
        {
            if(do_import)
            {
                update_area = TRUE;
                trackingvar -> status.imported = TRUE;
                if(get_diz(TRUE, currec -> filename))
                {
                    sprintf(LOGSTR, "[IMPORT] Description imported for '%s'", currec -> filename);
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                }
            }
            if(do_export && !strstr(currec -> description, Config_obj.amu_cfgvar.missing_desc)
               && strlen(currec -> description) > 10)
            {
                update_area = TRUE;
                outfile = _fsopen("FILE_ID.DIZ", "w+t", SH_DENYWR);
                if(outfile)
                {
                    sprintf(LOGSTR, "[EXPORT] Description exported for '%s'", currec -> filename);
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                    trackingvar -> status.exported = TRUE;
                    fprintf(outfile, "%s", currec -> description);
                    fclose(outfile);
                }
                Execute_obj.compress(arcfilename, "FILE_ID.DIZ", arctype);
            }
        }
        if(do_comment)
        {
            update_area = TRUE;
	    sprintf(LOGSTR, "[COMMENT] Adding comment to '%s'", currec -> filename);
            Utility_obj.logentry(LOGSTR, LOG_NORMAL);
            sprintf(fn, "%sCOMMENT.%d", Config_obj.amu_cfgvar.AMUpath, Area);
            if(access(fn, 0) != 0)
            {
		sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, COMMENT_TXT);
            }
            if(access(fn, 0) == 0)
            {
                commentfile = fopen(fn, "rt");
                sprintf(fn, "%sAMUTMP.CMT", Config_obj.amu_cfgvar.AMUpath);
                tmpfile = fopen(fn, "w+t");

                AMU_Headers_ptr = new AMU_Headers(&fileareavar, &infovar);
                Header = (char *)calloc(1, 200);
                while(fgets(str, sizeof(str)-2, commentfile))
                {
                    Amustr_obj.strip_n(str);
                    AMU_Headers_ptr -> get_expansion(str, Header);
                    fprintf(tmpfile, "%s\n", Header);
                }
		free(Header);
                delete(AMU_Headers_ptr);

                fclose(commentfile);
                fclose(tmpfile);
                Execute_obj.add_comment(newarcfilename, arctype, fn);

                /* Copy the archive to the work directory to comment 
                sprintf(str, "%s%s", Config_obj.amu_cfgvar.workpath, currec -> filename);
                Utility_obj.copyfile(newarcfilename, str);
                Execute_obj.add_comment(str, arctype, fn);
                Utility_obj.copyfile(str, newarcfilename);
                remove(str);
*/
                remove(fn);
                trackingvar -> status.commented = TRUE;
            }
            else
            {
                do_comment = FALSE;
                sprintf(LOGSTR, "! [COMMENT] Unable to open '%s'", fn);
                Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            }
        }
        arcfile = _fsopen(newarcfilename, "r+b", SH_DENYNO);
        if(arcfile)
        {
            _dos_setftime(fileno(arcfile), date, time);
            currec -> size = filelength(fileno(arcfile));
            fclose(arcfile);
        }
        Utility_obj.cleardir();
        chdir("..");
        rmdir(TMPDIR);

        if(do_import && fileareavar.import_gif && strstr(currec -> filename, ".GIF"))
        {
            sprintf(arcfilename, "%s%s", find_filepath(currec -> filename), currec -> filename);
            strcpy(str, get_gif(arcfilename));
            if(str[0])
            {
                currec -> description = (char *) realloc(currec -> description,
                                                     strlen(currec -> description) +
                                                     strlen(arcfilename) + 1);
                strcat(currec -> description, str);
                sprintf(LOGSTR, "[IMPORT] Imported GIF information for '%s'", currec -> filename);
                Utility_obj.logentry(LOGSTR, LOG_NORMAL);
            }
        }

        Utility_obj.update_tracking(trackingvar);
        if(do_rearc)
        {
            trackingvar = Utility_obj.read_tracking(newarcfilename);
            trackingvar -> status.rearced = TRUE;
            if(do_import)
            {
                trackingvar -> status.imported = TRUE;
            }
            if(do_export)
            {
                trackingvar -> status.exported = TRUE;
            }
            if(do_comment)
            {
                trackingvar -> status.commented = TRUE;
            }
            if(do_scan)
            {
                trackingvar -> status.scanned = TRUE;
            }
            Utility_obj.update_tracking(trackingvar);
        }
        currec = currec -> nextrec;
    }
    Utility_obj.change_dir(Config_obj.amu_cfgvar.AMUpath);

    if(screen_swapped)
    {
        Screen_obj.set_swapping(TRUE);
        Screen_obj.putscreen(screenbuf);
        free(screenbuf);
    }
    if(norearcbuf)
    {
       free(norearcbuf);
    }
}

/************************************************************************/
/* Rearchive nested archives */
void FileOptions::check_nested(int scan, int rearc)
{
    char *filespec, *newfilespec, *str, *tmpfilename;
    struct find_t fileinfo;
    int done, arctype, x, do_scan, do_rearc, result;
    static int count = 0;
    FILE *arcfile;
#ifdef __BORLANDC__
    unsigned int date, time;
#else
    unsigned short date, time;
#endif

    filespec = (char *) calloc(1, MAX_FILESPEC);
    newfilespec = (char *) calloc(1, MAX_FILESPEC);
    str = (char *) calloc(1, MAX_FILESPEC);

    count++;
    mkdir(TMPDIR);
    chdir(TMPDIR);
    Utility_obj.cleardir();
    sprintf(filespec, "..\\*.*");
    done = _dos_findfirst(filespec, _A_ARCH, &fileinfo);
    while(!done)
    {
        do_scan = scan;
        do_rearc = rearc;
        sprintf(filespec, "..\\%s", fileinfo.name);
        arcfile = _fsopen(filespec, "rb", SH_DENYNO);
        if(arcfile)
        {
            _dos_getftime(fileno(arcfile), &date, &time);
            fclose(arcfile);
        }
        arctype = Utility_obj.get_arctype(filespec);
        if(arctype == UNKNOWN)
        {
            do_scan = do_rearc = FALSE;
        }
        else
        {
            if(arctype == fileareavar.rearc_type && !fileareavar.force_rearc)
            {
                do_rearc = FALSE;
            }
        }
        if((fileareavar.honor_av && Utility_obj.is_secure(filespec)) &&
           (do_rearc))
        {
            do_rearc = FALSE;
            sprintf(LOGSTR, "[REARC] Skipping secure nested archive '%s'", filespec);
            Utility_obj.logentry(LOGSTR, LOG_EXTENSIVE);
        }

        if(arctype != UNKNOWN && (do_scan || do_rearc))
        {
            if(Execute_obj.decompress_all(filespec, arctype) == 0)
            {
                check_nested(scan, rearc);
                if(do_scan)
                {
                    sprintf(LOGSTR, "[VIRUS] Scanning nested archive '%s'", filespec);
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                    for(x = 0; x < MAX_SCANNERS; x++)
                    {
                        if(Execute_obj.virus_scan(x, filespec))
                        {
                            sprintf(LOGSTR, "! [VIRUS] Scanner %d reports virus in '%s'", x, filespec);
                            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                        }
                    }
                }
                strcpy(newfilespec, filespec);
                if(do_rearc)
                {
                   /* Add and remove files from the archive */
                    sprintf(str, "%s%s", Config_obj.amu_cfgvar.AMUpath, ADD_CTL);
                    Utility_obj.check_files(str, ADD_FILES);
                    sprintf(str, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRASH_CTL);
                    Utility_obj.check_files(str, REMOVE_FILES);

                    Utility_obj.get_newarc_ext(newfilespec, fileareavar.rearc_type);
                    sprintf(LOGSTR, "[REARC] Converting nested file '%s' to '%s'", filespec, newfilespec);
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);

             /* If this is a force rearchiving, make a copy of the original, then
                delete the original.  If the conversion is not successful, the original
                can be restored */
                    tmpfilename = NULL;
                    if(strstr(filespec, newfilespec))
                    {
                        tmpfilename = (char *) malloc(MAX_FILESPEC);
                        sprintf(tmpfilename, "%sTMPNEST.%d", Config_obj.amu_cfgvar.workpath, count);
                        Utility_obj.copyfile(filespec, tmpfilename);
                        remove(filespec);
                    }

                    result = Execute_obj.compress(newfilespec, "*.*", fileareavar.rearc_type);
                    if(result == 0 && Config_obj.fileareavar.rearc_type != arctype)
                    {
                        remove(filespec);
                        strcpy(filespec, newfilespec);
                    }
                    else
                    {
                        if(tmpfilename && result != 0)
                        {
                            Utility_obj.copyfile(tmpfilename, filespec);
                        }
                    }
                    if(tmpfilename)
                    {
                        remove(tmpfilename);
                        free(tmpfilename);
                        tmpfilename = NULL;
                    }
                    Utility_obj.cleardir();

                }
            }
            else
            {
                if(Config_obj.amu_cfgvar.kill_bad_arcs)
                {
                    sprintf(LOGSTR, "! [ARCS] Removing bad nested archive '%s'", filespec);
                    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                    remove(filespec);
                }
            }
        }
        arcfile = _fsopen(filespec, "r+b", SH_DENYNO);
        if(arcfile)
        {
            _dos_setftime(fileno(arcfile), date, time);
            fclose(arcfile);
        }
        done = _dos_findnext(&fileinfo);
    }
    Utility_obj.cleardir();
    chdir("..");
    rmdir(TMPDIR);
    free(filespec);
    free(newfilespec);
    free(str);
}

/***********************************************************************/
/* Sort file listings */
void FileOptions::sort(void)
{
    struct filearray *topsortlist, *endsortlist, *cursortlist, *nextrec;
    int x;

    currec = toprec;
    while(currec)
    {
       /* Skip header and comment lines */
	if(Utility_obj.bitset(currec -> attribute, AMU_HEADER) ||
	   Utility_obj.bitset(currec -> attribute, AMU_COMMENT))
	{
	    currec = currec -> nextrec;
	}
	else
        {
          /* Initilize pointers at the first record to be sorted */
            topsortlist = cursortlist = endsortlist = currec;
            x = 0;

           /* Save the previous record so we know where to insert the
              sorted segment
           */
            if(currec -> prevrec)
            {
                prevrec = currec -> prevrec;
            }
            else
            {
                prevrec = NULL;
            }

          /* Find out where this segment ends */
            while(cursortlist && !Utility_obj.bitset(cursortlist -> attribute, AMU_HEADER)
                  && !Utility_obj.bitset(cursortlist -> attribute, AMU_COMMENT))
            {
                x++;
                endsortlist = cursortlist;
                cursortlist = cursortlist -> nextrec;
            }
            nextrec = endsortlist -> nextrec;
            endsortlist -> nextrec = NULL;

            /* Copy these fields into the sorting array */
            sortvar = (struct sortarray *)calloc(x, sizeof(struct sortarray));
            if(!sortvar)
            {
                sprintf(LOGSTR, "! [SORT] Unable to allocate sorting array");
                Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                break;
            }
            else
            {
                sortptr = sortvar;
		cursortlist = topsortlist;
                while(cursortlist)
                {
                    strcpy(sortvar -> name, cursortlist -> filename);
		    sortvar -> key = currec -> timedate.getSecondsSince1970();
                    sortvar -> thisrec = cursortlist;
                    cursortlist = cursortlist -> nextrec;
                    if(cursortlist)
                    {
                        sortvar++;
                    }
                }
                sortvar = sortptr;
                qsort(sortvar, x, sizeof(struct sortarray), sort_function);

                /* Put the records back into the linked list */
                if(!prevrec)
                {
                    currec = toprec = sortptr -> thisrec;
                    x--;
                    sortptr++;
                }
                else
                {
                    currec = prevrec;
                }
                while(x > 0)
                {
                    currec -> nextrec = sortptr -> thisrec;
                    currec -> nextrec -> prevrec = currec;
                    currec = currec -> nextrec;
                    sortptr++;
                    x--;
                }
                currec -> nextrec = nextrec;
                currec = currec -> nextrec;
                free(sortvar);
            }
        }
    }
}

/**********************************************************************/
/* Sort function for the sort() option */
int sort_function(const void *a, const void *b)
{
   struct sortarray a1, b1;
#if defined (__AMU2__) ||  (__AMU95__)
   char tmpstr1[270], tmpstr2[270];
#else
   char tmpstr1[21], tmpstr2[21];
#endif

   memcpy(&a1, a, sizeof(struct sortarray));
   memcpy(&b1, b, sizeof(struct sortarray));
   switch(Sort_Type)
   {
       case SORT_NORMAL: return(stricmp(a1.name, b1.name));

       case SORT_REVERSE: return( (-1) * (stricmp(a1.name, b1.name)) );

       case SORT_REVERSE_OLD: return(a1.key - b1.key);

       case SORT_NORMAL_NEW: return(b1.key - a1.key);

       case SORT_NORMAL_OLD: sprintf(tmpstr1, "%ld%s", a1.key, a1.name);
                             sprintf(tmpstr2, "%ld%s", b1.key, b1.name);
                             return( stricmp(tmpstr1, tmpstr2) );

       case SORT_REVERSE_NEW:sprintf(tmpstr1, "%ld%s", a1.key, a1.name);
                             sprintf(tmpstr2, "%ld%s", b1.key, b1.name);
                             return( (-1) * (stricmp(tmpstr1, tmpstr2)) );
   }
   return(0);
}

/***********************************************************************/
/* Move/Kill old files */
void FileOptions::old(void)
{
    char fn[MAX_FILESPEC], target[MAX_FILESPEC], movepath[MAX_FILESPEC];
    char *buffer;
    FILE *lockedfile;
    struct filearray *old_toprec, *old_currec, *old_prevrec;
    int age;
    class FileOptions MoveArea_obj;

    if(fileareavar.attrib.move_old && fileareavar.move_area < 1)
    {
        sprintf(LOGSTR, "! [OLD] Area to move to must be greater than 0");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    if(fileareavar.days_old < 1)
    {
        sprintf(LOGSTR, "! [OLD] Days Old must be greater than 0");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    if(fileareavar.move_area == Area && fileareavar.attrib.move_old)
    {
        sprintf(LOGSTR, "! [OLD] Area to move to cannot be current area");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    if(fileareavar.attrib.cdrom)
    {
        sprintf(LOGSTR, "! [OLD] This option not for use on CD areas");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    if(fileareavar.attrib.move_old && fileareavar.move_area > 0)
    {
        Config_obj.read_record(FILEAREA_RECORD, fileareavar.move_area);
        strcpy(movepath, Config_obj.fileareavar.filepath);

        sprintf(fn, ".CTL");
        if(strstr(Config_obj.fileareavar.filepath, fn))
        {
            sprintf(LOGSTR, "! [OLD] Area to move to cannot be a multiple directory area");
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            Config_obj.read_record(FILEAREA_RECORD, Area);
            return;
        }
        Config_obj.read_record(FILEAREA_RECORD, Area);
    }

    buffer = NULL;
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, LOCKED_CTL);
    lockedfile = _fsopen(fn, "rt", SH_DENYNO);
    if(lockedfile)
    {
        buffer = (char *)calloc(1, filelength(fileno(lockedfile))+2);
        if(buffer)
        {
            fread(buffer, filelength(fileno(lockedfile)), 1, lockedfile);
            strupr(buffer);
        }
        fclose(lockedfile);
    }

    old_toprec = old_currec = old_prevrec = NULL;
    currec = toprec;
    while(currec)
    {
	age = 0;
	if((fileareavar.listtype == RA_FDB || fileareavar.listtype == LORA_FDB ||
	    fileareavar.listtype == EZY_FDB)
	   && Config_obj.fileareavar.useuldate)
	{
	    age = currec -> uploadtimedate.getAge();
	}
	else
	{
	    age = currec -> timedate.getAge();
	}

	/* See if this file is in the LOCKED.CTL file */
	if(buffer && currec -> filename[0])
	{
	    if(strstr(buffer, currec -> filename))
	    {
		Utility_obj.setbit(&currec -> attribute, AMU_LOCKED);
	    }
	}

	if(currec -> filename[0] && age > fileareavar.days_old &&
	   !Utility_obj.bitset(currec -> attribute, AMU_LOCKED) &&
	   !Utility_obj.bitset(currec -> attribute, AMU_DELETED))
	{
	    sprintf(fn, "%s%s", find_filepath(currec -> filename), currec -> filename);
	    sprintf(target, "%s%s", movepath, currec -> filename);
	    if(fileareavar.attrib.move_old)
	    {
		old_currec = (struct filearray *) calloc(1, sizeof(struct filearray));
		if(!old_currec)
		{
		    sprintf(LOGSTR, "! [OLD] Unable to allocate temporary array");
		    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
		}
		else
		{
		    if(!old_toprec)
		    {
			old_toprec = old_currec;
		    }
		    memcpy(old_currec, currec, sizeof(struct filearray));

		    /* Create a new description for 'old_currec'.  If not,
		       it will try to be deallocated twice.  Not good! */
		    if(old_currec -> description)
		    {
			old_currec -> description = (char *)calloc(1, strlen(currec -> description) + 1);
			if(old_currec -> description)
			{
			    strcpy(old_currec -> description, currec -> description);
			}
		    }

                    if(old_prevrec)
                    {
                        old_prevrec -> nextrec = old_currec;
		    }
                    old_currec -> prevrec = old_prevrec;
                    old_currec -> nextrec = NULL;
                    old_prevrec = old_currec;
                }
                if(Utility_obj.copyfile(fn, target))
                {
                    remove(fn);
                }
                sprintf(LOGSTR, "[OLD] '%s' is %d days old, moved to area #%d",
                                 currec -> filename, age, fileareavar.move_area);
                Utility_obj.logentry(LOGSTR, LOG_NORMAL);
            }
            else
            {
                sprintf(LOGSTR, "[OLD] '%s' is %d days old, deleted",
                                currec -> filename, age);
                Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                remove(fn);
            }
            Utility_obj.setbit(&currec -> attribute, AMU_DELETED);
        }
        currec = currec -> nextrec;
    }
    if(old_toprec)
    {
        MoveArea_obj.set_area(fileareavar.move_area);
        Config_obj.read_record(FILEAREA_RECORD, fileareavar.move_area);
	if(MoveArea_obj.open_area(READ_MODE, NO_BACKUP, NO_RESTORE) == TRUE)
	{
	    MoveArea_obj.read_area();
	    MoveArea_obj.close_area();
	    MoveArea_obj.append_link(old_toprec);
	    MoveArea_obj.open_area(WRITE_MODE, NO_BACKUP, NO_RESTORE);
	    MoveArea_obj.write_area();
	    MoveArea_obj.close_area();
	    MoveArea_obj.deallocate_area();
	}
	else
	{
	    sprintf(LOGSTR, "! [OLD] Unable to update file listing in destination area");
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	}
        Config_obj.read_record(FILEAREA_RECORD, Area);
    }
    if(buffer)
    {
        free(buffer);
    }
}

/* Move files that have no description or have 'Missing' description */
void FileOptions::move_nodesc(void)
{
    char fn[MAX_FILESPEC], target[MAX_FILESPEC], movepath[MAX_FILESPEC];
    struct filearray *old_toprec, *old_currec, *old_prevrec;
    int empty_desc;
    class FileOptions MoveArea_obj;

    if(fileareavar.attrib.cdrom)
    {
        sprintf(LOGSTR, "! [NODESC] This option not for use on CD areas");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    if(fileareavar.nodesc_area < 1)
    {
        sprintf(LOGSTR, "! [NODESC] Area to move to must be greater than 0");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    if(fileareavar.nodesc_area == Area)
    {
        sprintf(LOGSTR, "! [NODESC] Area to move to cannot be current area");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    if(fileareavar.nodesc_area > 0)
    {
        Config_obj.read_record(FILEAREA_RECORD, fileareavar.nodesc_area);
        strcpy(movepath, Config_obj.fileareavar.filepath);

        sprintf(fn, ".CTL");
        if(strstr(Config_obj.fileareavar.filepath, fn))
        {
            sprintf(LOGSTR, "! [NODESC] Area to move to cannot be a multiple directory area");
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            Config_obj.read_record(FILEAREA_RECORD, Area);
            return;
        }
        Config_obj.read_record(FILEAREA_RECORD, Area);
    }

    old_toprec = old_currec = old_prevrec = NULL;
    currec = toprec;
    while(currec)
    {
        empty_desc = FALSE;
        if(currec -> description[0] == NULL || (currec -> description[0] == '\n' && currec -> description[1] == NULL) ||
           (currec -> description[0] == '\r' && currec -> description[0] == NULL) ||
           (strstr(currec -> description, Config_obj.amu_cfgvar.missing_desc) && Config_obj.amu_cfgvar.missing_desc[0]))
        {
            empty_desc = TRUE;
        }

        if(currec -> filename[0] && empty_desc == TRUE &&
           !Utility_obj.bitset(currec -> attribute, AMU_LOCKED) &&
           !Utility_obj.bitset(currec -> attribute, AMU_DELETED))
        {
            sprintf(fn, "%s%s", find_filepath(currec -> filename), currec -> filename);
            sprintf(target, "%s%s", movepath, currec -> filename);
            old_currec = (struct filearray *) calloc(1, sizeof(struct filearray));
            if(!old_currec)
            {
                sprintf(LOGSTR, "! [NODESC] Unable to allocate temporary array");
                Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            }
            else
            {
                if(!old_toprec)
                {
                    old_toprec = old_currec;
                }
                memcpy(old_currec, currec, sizeof(struct filearray));

                    /* Create a new description for 'old_currec'.  If not,
                       it will try to be deallocated twice.  Not good! */
                if(old_currec -> description)
                {
                    old_currec -> description = (char *)calloc(1, strlen(currec -> description) + 3);
                    if(old_currec -> description)
                    {
                        strcpy(old_currec -> description, currec -> description);
                    }
                }

                if(old_prevrec)
                {
                    old_prevrec -> nextrec = old_currec;
                }
                old_currec -> prevrec = old_prevrec;
                old_currec -> nextrec = NULL;
                old_prevrec = old_currec;
                if(Utility_obj.copyfile(fn, target))
                {
                    remove(fn);
                }
                sprintf(LOGSTR, "[NODESC] '%s' has no description or 'Missing Desc', moved to area #%d",
                                 currec -> filename, fileareavar.nodesc_area);
                Utility_obj.logentry(LOGSTR, LOG_NORMAL);
            }
            Utility_obj.setbit(&currec -> attribute, AMU_DELETED);
        }
        currec = currec -> nextrec;
    }
    if(old_toprec)
    {
        MoveArea_obj.set_area(fileareavar.nodesc_area);
        Config_obj.read_record(FILEAREA_RECORD, fileareavar.nodesc_area);
        MoveArea_obj.open_area(READ_MODE, NO_BACKUP, NO_RESTORE);
        MoveArea_obj.read_area();
        MoveArea_obj.close_area();
        MoveArea_obj.append_link(old_toprec);
        MoveArea_obj.open_area(WRITE_MODE, NO_BACKUP, NO_RESTORE);
        MoveArea_obj.write_area();
        MoveArea_obj.close_area();
        MoveArea_obj.deallocate_area();
        Config_obj.read_record(FILEAREA_RECORD, Area);
    }
}

/* Compress text/ascii files */
void FileOptions::compress_text(void)
{
    char *buffer, fn[MAX_FILESPEC], fn2[MAX_FILESPEC];
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    FILE *txtfile;
    int result;

    if(fileareavar.attrib.cdrom)
    {
        sprintf(LOGSTR, "! [COMP_TXT] This option not for use on CD areas");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    buffer = NULL;
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, ZIPTXT_CTL);
    txtfile = _fsopen(fn, "rt", SH_DENYNO);
    if(txtfile)
    {
        buffer = (char *)calloc(1, filelength(fileno(txtfile))+2);
        if(buffer)
        {
            fread(buffer, filelength(fileno(txtfile)), 1, txtfile);
            strupr(buffer);
        }
        fclose(txtfile);
    }
    else
    {
        sprintf(LOGSTR, "! [COMP_TXT] '%s' not found, aborting", ZIPTXT_CTL);
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    currec = toprec;
    while(currec)
    {
        if(currec -> filename[0] && !Utility_obj.bitset(currec -> attribute, AMU_LOCKED) &&
           !Utility_obj.bitset(currec -> attribute, AMU_DELETED))
        {
            _splitpath(currec -> filename, drive, dir, fname, ext);

            /* See if this extension is in the ZIPTEXT.CTL file */
            if(strstr(buffer, &ext[1]))
            {
                sprintf(fn, "%s%s%s", fileareavar.filepath, fname, ext);

                strcpy(fn2, fn);
                Utility_obj.get_newarc_ext(fn2, fileareavar.compresstxt_type);

                sprintf(LOGSTR, "[COMP_TXT] Compressing '%s' to '%s'", fn, fn2);
                Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                result = Execute_obj.compress(fn2, fn, fileareavar.compresstxt_type);
                if(result == 0)
                {
                    remove(fn);
                    _splitpath(fn2, drive, dir, fname, ext);
                    sprintf(currec -> filename, "%s%s", fname, ext);
                }
            }
        }
        currec = currec -> nextrec;
    }

    if(buffer != NULL)
    {
        free(buffer);
    }
}

/***********************************************************************/
/* Extract GIF information */
char *FileOptions::get_gif(char *fn)
{
    struct gif
    {
        unsigned short width,
                       length;
        unsigned char pixel;
      }gif;
    char signature[7], tmp1[6], tmp2[6], tmp3[6];
    static char gif_resolution[15];
    short colors;
    FILE *giffile;

    gif_resolution[0] = NULL;
    colors = 0;
    if(strstr(fn, ".GIF"))
    {
        giffile = _fsopen(fn, "rb", SH_DENYWR);
        fread(signature, 6, 1, giffile);
        signature[6] = 0;
        fread(&gif, sizeof(struct gif), 1, giffile);
        fclose(giffile);
        colors = 1 << ((gif.pixel & 0x07) + 1);
        sprintf(tmp1, "%d", gif.width);
        sprintf(tmp2, "%d", gif.length);
        sprintf(tmp3, "%d", colors);
        if(strstr(currec -> description, tmp1) && strstr(currec -> description, tmp2)
           && strstr(currec -> description, tmp3))
        {
            gif_resolution[0] = NULL;
        }
        else
        {
            sprintf(gif_resolution, " (%u%c%u%c%d)", gif.width, 'x', gif.length, 'x', colors);
        }
    }
    return(gif_resolution);
}

/************************************************************************/
/* Import FILES.BBS to FDB */
void FileOptions::import(void)
{
    int oldlisttype, x;
    char *ptr, *tmpptr, *tmpdesc;

    if(fileareavar.listtype != FILESBBS)
    {
	oldlisttype = fileareavar.listtype;
        fileareavar.listtype = FILESBBS;
        if(open_area(READ_MODE, NO_BACKUP, NO_RESTORE))
        {
            if(read_area() == 0)
            {
		currec = toprec;
		while(currec)
		{
		    switch(oldlisttype)
		    {
			case RA_FDB     :
			case LORA_FDB   : currec -> lastdl.createDate(currec -> timedate.getSecondsSince1970());
					  currec -> uploadtimedate.createDate(currec -> timedate.getSecondsSince1970());
					  ptr = currec -> description;
					  x = 0;
					  while(*ptr)
					  {
					      if(*ptr == '\n')
					      {
						  x++;
					      }
					      ptr++;
					  }
					  tmpdesc = (char *)calloc(strlen(currec -> description)+x+1, 1);
					  if(tmpdesc)
					  {
					    /* Replace \n's with \r\n */
					      ptr = currec -> description;
					      tmpptr = tmpdesc;
					      while(*ptr)
					      {
						  if(*ptr == '\n')
						  {
						      *tmpptr = '\r';
						      tmpptr++;
						  }
						  *tmpptr = *ptr;
						  ptr++;
						  tmpptr++;
					      }
					  }
					  *tmpptr = NULL;
					  currec -> description = (char *)realloc(currec -> description, strlen(tmpdesc)+1);
					  if(currec -> description)
					  {
					      strcpy(currec -> description, tmpdesc);
					  }
					  free(tmpdesc);
					  break;

			case CONCORD_FDB: /* Replace \n's with spaces */
					  ptr = currec -> description;
					  while(*ptr)
					  {
					      if(*ptr == '\n')
					      {
						  *ptr = ' ';
					      }
					      ptr++;
					  }
					  break;

			case TG310_FDB  :
			case TG_FDB     : // Mark the file as being available & validated
					  currec -> bbsattrib = 12;
					  currec -> lastdl.createDate(currec -> timedate.getSecondsSince1970());
					  currec -> uploadtimedate.createDate(currec -> timedate.getSecondsSince1970());
					  break;

			case EZY_FDB    : /* Replace \n's with \r's */
					  ptr = currec -> description;
					  while(*ptr)
					  {
					      if(*ptr == '\n')
					      {
						  *ptr = '\r';
					      }
					      ptr++;
					  }
					  break;
		    }

		    /* If this is a comment, get rid of the linefeeds */
		    if(!currec -> filename[0])
		    {
			Amustr_obj.strip_n(currec -> description);
		    }
		    currec = currec -> nextrec;
		}
		close_area();
		fileareavar.listtype = oldlisttype;
		if(open_area(WRITE_MODE, NO_BACKUP, NO_RESTORE))
		{
		    write_area();
		    close_area();
		    sprintf(LOGSTR, "[IMPORTBBS] Importing FILES.BBS to FDB");
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                }
            }
            else
            {
                close_area();
            }
            deallocate_area();
        }
	fileareavar.listtype = oldlisttype;
    }
}

/***********************************************************************/
/* Export FDB to FILES.BBS */
void FileOptions::export(void)
{
    int oldlisttype;
    char *ptr, tmp[51];

    if(fileareavar.attrib.cdrom)
    {
        sprintf(LOGSTR, "! [EXPORTBBS] This option not for use on CD areas");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    oldlisttype = fileareavar.listtype;
    if(fileareavar.listtype != FILESBBS)
    {
        if(open_area(READ_MODE, NO_BACKUP, NO_RESTORE))
        {
            if(read_area() == 0)
            {
                /* if this is RA, replace '\r\n' with ' \n' */
                if(oldlisttype == RA_FDB || oldlisttype == LORA_FDB)
                {
                    currec = toprec;
                    while(currec)
                    {
                        ptr = currec -> description;
                        while(*ptr)
                        {
                            if(*ptr == '\r')
                            {
                                *ptr = ' ';
                            }
                            ptr++;
                        }
			currec = currec -> nextrec;
                    }
                }

                /* if this is CONCORD, replace '\r' with ' \n' */
                if(oldlisttype == CONCORD_FDB || oldlisttype == EZY_FDB)
                {
                    currec = toprec;
                    while(currec)
                    {
                        ptr = currec -> description;
                        while(*ptr)
                        {
                            if(*ptr == '\r')
                            {
                                *ptr = '\n';
                            }
                            ptr++;
                        }
                        currec = currec -> nextrec;
                    }
                }

                close_area();
                fileareavar.listtype = FILESBBS;
                strcpy(tmp, fileareavar.listpath);
                sprintf(fileareavar.listpath, "%sFILES.BBS", fileareavar.filepath);
                if(open_area(WRITE_MODE, NO_BACKUP, NO_RESTORE))
                {
                    sprintf(LOGSTR, "[EXPORTBBS] Exporting FDB to FILES.BBS");
                    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
                    write_area();
                    close_area();
                }
                fileareavar.listtype = oldlisttype;
                strcpy(fileareavar.listpath, tmp);
                deallocate_area();
            }
            else
            {
		close_area();
            }
        }
    }
    fileareavar.listtype = oldlisttype;
}

/***********************************************************************/
/* Create allfiles/newfiles lists */
void FileOptions::filelists(int mode)
{
    short x, j, y;
    FILE *allnewfile;
    char tmpfn[MAX_FILESPEC];
    class AMU_Allfiles AMU_Allfiles_obj;
    #define LIST_SIZE 5000


    /* This part handles creating the temporary file and putting the
       main header in,*/
    if(mode == ALLNEW_BEGIN)
    {
        for(x = 1; x <= Config_obj.num_lists; x++)
        {
            Config_obj.read_record(ALLFILE_RECORD, x);
            Config_obj.allnewvar.totalfiles = 0.0;
            Config_obj.allnewvar.totalbytes = 0.0;
            Config_obj.allnewvar.totaldls = 0.0;
            if(Config_obj.allnewvar.list_format[0] == NULL)
            {
                strcpy(Config_obj.allnewvar.list_format, DEFAULT_LISTSTR);
            }
            if(!Config_obj.allnewvar.enabled)
            {
                continue;
            }

            /* Create the temporary filename */
            sprintf(tmpfn, "%sALL%d.$$$", Config_obj.amu_cfgvar.workpath, x);
            allnewfile = _fsopen(tmpfn, "w+t", SH_DENYRW);
            if(allnewfile)
            {
                /* Add the main header */
                import_file(allnewfile, Config_obj.allnewvar.main_hdr);
                fclose(allnewfile);
            }
            else
            {
                sprintf(LOGSTR, "! [ALLNEW] Unable to create temporary file for list #%d", x);
		Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            }
            Config_obj.update_record(ALLFILE_RECORD, x);
        }
    }

    if(mode == ALLNEW_FILL)
    {
	for(x = 1; x <= Config_obj.num_lists; x++)
	{
	    Config_obj.read_record(ALLFILE_RECORD, x);
	    if(!Config_obj.allnewvar.enabled || !Config_obj.active(Area))
	    {
		continue;
	    }
	    analyze_area(&infovar);
	    if(Config_obj.allnewvar.type == 1)
	    {
		y = FALSE;
		infovar.areafiles = infovar.areabytes = infovar.areadls = 0.0;
		currec = toprec;
		while(currec)
		{
		    if(Utility_obj.bitset(currec -> attribute, AMU_HEADER))
		    {
			currec = currec -> nextrec;
			continue;
		    }

		    if((fileareavar.listtype == RA_FDB || fileareavar.listtype == LORA_FDB ||
			fileareavar.listtype == EZY_FDB || fileareavar.listtype == TG_FDB ||
			fileareavar.listtype == TG310_FDB) && Config_obj.allnewvar.ulordos == 1)
		    {
			j = currec -> uploadtimedate.getAge();
		    }
		    else
		    {
			j = currec -> timedate.getAge();
		    }
		    if(j <= Config_obj.allnewvar.age)
		    {
			infovar.areafiles++;
			infovar.areabytes += (double) currec -> size;
			infovar.areadls += (double) currec -> timesdl;
			y = TRUE;
		    }
		    currec = currec -> nextrec;
                }

                /* If no files would be included, get out of here */
		if(!y)
		{
		    continue;
		}
	    }
	    Config_obj.allnewvar.totalfiles += (double) infovar.areafiles;
	    Config_obj.allnewvar.totalbytes += (double) infovar.areabytes;
	    Config_obj.allnewvar.totaldls += (double) infovar.areadls;
	    Config_obj.update_record(ALLFILE_RECORD, x);

	    /* Create the temporary filename */
	    sprintf(tmpfn, "%sALL%d.$$$", Config_obj.amu_cfgvar.workpath, x);
	    allnewfile = _fsopen(tmpfn, "at", SH_DENYRW);
	    if(allnewfile)
	    {
		fseek(allnewfile, 0, SEEK_END);

		/* Add the area header */
		import_file(allnewfile, Config_obj.allnewvar.area_hdr);

		 /* Send the file area to the allfiles/newfiles list */
		Header = (char *)calloc(1, LIST_SIZE);
		currec = toprec;
		while(currec)
		{
		    if(Utility_obj.bitset(currec -> attribute, AMU_HEADER))
		    {
			currec = currec -> nextrec;
			continue;
		    }

		    AMU_Allfiles_obj.set_values(currec);

                   /* Check to see if this is a Newfiles list */
                    if(Config_obj.allnewvar.type == 1)
		    {
			if((fileareavar.listtype == RA_FDB || fileareavar.listtype == LORA_FDB ||
			    fileareavar.listtype == EZY_FDB || fileareavar.listtype == TG_FDB ||
			    fileareavar.listtype == TG310_FDB) && Config_obj.allnewvar.ulordos == 1)
			{
			    j = currec -> uploadtimedate.getAge();
			}
			else
			{
			    j = currec -> timedate.getAge();
			}
			if(j > Config_obj.allnewvar.age)
			{
			    currec = currec -> nextrec;
			    continue;
			}
		    }

		    if(Utility_obj.bitset(currec -> attribute, AMU_HEADER) ||
		       Utility_obj.bitset(currec -> attribute, AMU_DELETED) ||
		       (Utility_obj.bitset(currec -> attribute, AMU_COMMENT) &&
			!Config_obj.allnewvar.add_comments))
		    {
			currec = currec -> nextrec;
		    }
		    else
		    {
			if(Utility_obj.bitset(currec -> attribute, AMU_COMMENT))
			{
			    if(strchr(currec -> description, '\n'))
			    {
				fprintf(allnewfile, "%s", currec -> description);
			    }
			    else
			    {
				fprintf(allnewfile, "%s\n", currec -> description);
			    }
			}
			else
			{
			    memset(Header, NULL, LIST_SIZE);
			    AMU_Allfiles_obj.get_expansion(Config_obj.allnewvar.list_format, Header);
			    Amustr_obj.trimend(Header);
			    fprintf(allnewfile, "%s", Header);
			}
			currec = currec -> nextrec;
		    }
		}
		free(Header);

		/* Add the area footer */
		import_file(allnewfile, Config_obj.allnewvar.area_ftr);
		fclose(allnewfile);
	    }
	    else
	    {
		sprintf(LOGSTR, "! [ALLNEW] Unable to open temporary file for list #%d", x);
                Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            }
        }
    }


    /* This part handles putting the final footer in and archiving */
    if(mode == ALLNEW_END)
    {
        for(x = 1; x <= Config_obj.num_lists; x++)
        {
            Config_obj.read_record(ALLFILE_RECORD, x);
            if(!Config_obj.allnewvar.enabled)
            {
                continue;
            }

            infovar.totalfiles = Config_obj.allnewvar.totalfiles;
            infovar.totalbytes = Config_obj.allnewvar.totalbytes;
            infovar.totaldls = Config_obj.allnewvar.totaldls;

            /* Create the temporary filename */
            sprintf(tmpfn, "%sALL%d.$$$", Config_obj.amu_cfgvar.workpath, x);
            allnewfile = _fsopen(tmpfn, "at", SH_DENYRW);
            if(allnewfile)
            {
                fseek(allnewfile, 0, SEEK_END);

		/* Add the main footer */
		import_file(allnewfile, Config_obj.allnewvar.main_ftr);
		fclose(allnewfile);
		if(Utility_obj.copyfile(tmpfn, Config_obj.allnewvar.txtname))
		{
		    remove(tmpfn);
		    if(Config_obj.allnewvar.compress)
		    {
//                      remove(Config_obj.allnewvar.arcname);
                        if(Execute_obj.compress(Config_obj.allnewvar.arcname,
                                                Config_obj.allnewvar.txtname,
                                                Config_obj.allnewvar.arctype) == 0)
                        {
                            if(Config_obj.allnewvar.erase)
                            {
                                remove(Config_obj.allnewvar.txtname);
                            }
                        }
                    }
                }
                else
                {
                    sprintf(LOGSTR, "! [ALLNEW] Unable to copy '%s' to '%s' for list #%d",
                                    tmpfn, Config_obj.allnewvar.txtname, x);
                    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                }
            }
            else
            {
                sprintf(LOGSTR, "! [ALLNEW] Unable to open temporary file for list #%d", x);
                Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            }
        }
    }
}

/************************************************************************/
/* Gather the area information */
void FileOptions::analyze_area(struct fbaseinfo *i)
{
    memset(i, NULL, sizeof(struct fbaseinfo));
    i -> area = Area;

    currec = toprec;
    while(currec)
    {
        if(currec -> filename[0] && !Utility_obj.bitset(currec -> attribute, AMU_DELETED))
        {
            i -> areadls += (double) currec -> timesdl;
            i -> areafiles++;
            i -> areabytes += (double) currec -> size;
            if(currec -> timesdl >= i -> topfile_dls)
            {
                strcpy(i -> topfile, currec -> filename);
                i -> topfile_dls = (double) currec -> timesdl;
                i -> topfile_size = (double) currec -> size;
            }
        }
        currec = currec -> nextrec;
    }

   /* If the topfile has zero downloads, fix it */
    if(i -> topfile_dls == 0.0)
    {
        i -> topfile_size = 0.0;
        strcpy(i -> topfile, "[None]");
    }
}

void FileOptions::import_file(FILE *outfile, char *source)
{
    FILE *infile;
    char str[151];

    if(!*source)
    {
        return;
    }

    infile = fopen(source, "rt");
    if(!infile && *source)
    {
        sprintf(LOGSTR, "! [IMPORT_TXT] Unable to open '%s'", source);
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    AMU_Headers_ptr = new AMU_Headers(&fileareavar, &infovar);
    Header = (char *)calloc(1, 200);
    while(fgets(str, sizeof(str)-2, infile))
    {
        Amustr_obj.strip_n(str);
        AMU_Headers_ptr -> get_expansion(str, Header);
        fprintf(outfile, "%s\n", Header);
    }
    free(Header);
    delete(AMU_Headers_ptr);
    fclose(infile);
}

/***********************************************************************/
/* Update download counters */
void FileOptions::counters(void)
{
    char fn[MAX_FILESPEC];
    struct transferdata xfervar;
    FILE *xferfile;
    int updatefile;

    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRANSFER_UPD);
    xferfile = _fsopen(fn, "rb", SH_DENYWR);
    if(xferfile)
    {
	kill_counterdata = TRUE;
	fread(&xfervar, sizeof(xfervar), 1, xferfile);
	while(!feof(xferfile) && !ferror(xferfile))
	{
	    updatefile = FALSE;
	    if(fileareavar.mailerdls && xfervar.logtype == MAILER_LOG)
	    {
		updatefile = TRUE;
	    }
	    if(fileareavar.bbsdls && xfervar.logtype == BBS_LOG)
	    {
		updatefile = TRUE;
	    }

	    strupr(xfervar.fname);
	    currec = toprec;
	    while(updatefile && currec)
	    {
		if(strcmp(currec -> filename, xfervar.fname) == 0 && strlen(currec -> filename) > 0
		   && strlen(xfervar.fname) > 0)
		{
		    sprintf(LOGSTR, "[UPDATE] Updating counter for '%s'", currec -> filename);
		    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
		    currec -> timesdl++;
		    currec -> lastdl.createDate();
		    break;
		}
		currec = currec -> nextrec;
	    }
	    fread(&xfervar, sizeof(xfervar), 1, xferfile);
	}
	fclose(xferfile);
    }
}

/* Return information about area #'area' */
void FileOptions::get_info(int area, struct info *i)
{
    memset(i, NULL, sizeof(struct info));
    set_area(area);
    if(!open_area(READ_MODE, NO_BACKUP, NO_RESTORE))
    {
        sprintf(LOGSTR, "! [AREA_INFO] Unable to open area #%d", area);
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
    }
    else
    {
        if(read_area())
        {
            sprintf(LOGSTR, "! [AREA_INFO] Unable to read area #%d", area);
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        }
        else
        {
            analyze_area(&infovar);
            i -> dls = (double) infovar.areadls;
            i -> files = (double) infovar.areafiles;
            i -> bytes = (double) infovar.areabytes;
        }
        deallocate_area();
        close_area();
    }
}

/************************************************************************/
/* Create an OKFILE.LST type file */
void FileOptions::okfile(int argc, char *argv[])
{
    FILE *outfile;
    long sec_level, x;
    char param[51], *ptr1, *ptr2, fn[81];
    struct screeninfo s;

    strcpy(s.curarea, "Generating list of requestable directories");
    strcpy(s.curoption, s.curarea);
    sprintf(LOGSTR, "[OKFILE] %s", s.curarea);
    Utility_obj.logentry(LOGSTR, LOG_NORMAL);
    ptr1 = NULL;
    for(x = 1; x < argc; x++)
    {
        strupr(argv[x]);
        if(strstr(argv[x], "OKFILE"))
        {
            ptr1 = argv[x];
            break;
        }
    }
    if(ptr1 == NULL)
    {
        sprintf(LOGSTR, "! [OKFILE] No parameter passed on command line");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return;
    }

    /* Extract the security level from the parameter.
       The parameter would be passed in the form OKLST34 to create
       a list of areas with security less than or equal to 34 for example.
    */
    ptr2 = param;
    while(*ptr1)
    {
        if(isdigit(*ptr1))
        {
            *ptr2 = *ptr1;
            ptr1++;
            ptr2++;
        }
        else
        {
            ptr1++;
        }
    }
    *ptr2 = NULL;
    sec_level = atol(param);

    sprintf(fn, "%s", Config_obj.amu_cfgvar.freqdirs);
    outfile = fopen(fn, "wt");
    for(x = 1; x <= Config_obj.num_filearea; x++)
    {
        Config_obj.read_record(FILEAREA_RECORD, x);
        if(Config_obj.fileareavar.security <= sec_level &&
           Config_obj.fileareavar.areaname[0])
        {
            if(Config_obj.amu_cfgvar.mailertype != BT  &&  Config_obj.amu_cfgvar.mailertype != POP &&
               Config_obj.amu_cfgvar.mailertype != MCMAIL  &&  Config_obj.amu_cfgvar.mailertype != XENIA)
            {
                fprintf(outfile, "%s\n", Config_obj.fileareavar.filepath);
            }
            else
            {
                fprintf(outfile, "%s*.*\n", Config_obj.fileareavar.filepath);
            }
        }
    }
    fclose(outfile);
}


/***********************************************************************/
/* EOF - FILEOPTS.CPP */

