// Member functions for class FileOptions, Y2K
// Created 24 September 1995
// Revised 21 May 1998

#include <stdio.h>
#include <string.h>
#include <mem.h>
#include <share.h>
#include <stdlib.h>
#include <dos.h>
#include <malloc.h>
#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <conio.h>
#include <direct.h>
#include "extern.h"
#include "fileopts.h"
#include "config.h"
#include "screen.h"
#include "macros.h"
#include "logs.h"
#include "tgfdb.h"

#if defined(__AMU32__)
#include <graph.h>
#endif

/* External objects */
extern class Config Config_obj;

/************************************************************************/
/* Look in the FA_nnn.CTL file and figure out where 'fn' is */
char *FileOptions::find_filepath(char *fn)
{
    char str[MAX_FILESPEC];
    static char tmpstr[MAX_FILESPEC];
    FILE *txtfile;

    /* Only do this if this is a ProBoard 2.16 system */
    if(Config_obj.amu_cfgvar.BBStype != PB2)
    {
        Amustr_obj.slash(fileareavar.filepath);
        return(fileareavar.filepath);
    }

    /* See if the filepath contains the FA_nnn.CTL file */
    str[0] = NULL;
    strupr(fileareavar.filepath);
    Amustr_obj.noslash(fileareavar.filepath);
    sprintf(str, "FA_%d.CTL", Area);
    if(access(fileareavar.filepath, 0) != 0 || !strstr(fileareavar.filepath, str))
    {
        Amustr_obj.slash(fileareavar.filepath);
        return(fileareavar.filepath);
    }
    txtfile = fopen(fileareavar.filepath, "rt");
    Amustr_obj.slash(fileareavar.filepath);
    if(txtfile)
    {
        do
        {
            str[0] = tmpstr[0] = NULL;
            fgets(str, sizeof(str)-2, txtfile);
            Amustr_obj.strip_n(str);
            Amustr_obj.slash(str);
            strcpy(tmpstr, str);
            strcat(str, fn);
        }while(!feof(txtfile) && access(str, 0) != 0);
        fclose(txtfile);
        return(tmpstr);
    }
    return(NULL);
}


/* Split the FILEBASE.DAT used by LoraBBS 3.00 into $$$nnnnn.FDB files
   where 'nnnnn' is the area number.  The .FDB files consist of the
   datarecord followed by the file description */
int FileOptions::split_LoraFDB(void)
{
    struct
    {
        FILE *outfile;
        unsigned long crc32;
    }fdbvar;
    FILE *datafile;
    int x;
    unsigned long crc;
    char datafn[MAX_FILESPEC], outfn[MAX_FILESPEC];
    char *desc, *uploader;

    // Set the outfile pointers to NULL
    fdbvar.outfile = NULL;
    fdbvar.crc32 = 0;

    // Open the Lora filebase
    sprintf(datafn, "%sFILEBASE.DAT", Config_obj.amu_cfgvar.FDBpath);
    datafile = _fsopen(datafn, "rb", SH_DENYNO);

    /* If the database was not found and it should be created, create
       each of the temporary versions of the database */
    if(!datafile && Config_obj.amu_cfgvar.create_if_notexist)
    {
        for(x = 1; x <= Config_obj.num_filearea; x++)
        {
            sprintf(outfn, "%s$$$%u.FDB", Config_obj.amu_cfgvar.FDBpath, x);
            datafile = _fsopen(outfn, "w+b", SH_DENYNO);
            if(datafile)
            {
                fclose(datafile);
            }
        }
        sprintf(LOGSTR, "[SPLIT_FDB] Note - Lora filebase does not exist, one is being created");
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(TRUE);
    }
    if(!datafile && !Config_obj.amu_cfgvar.create_if_notexist)
    {
        sprintf(LOGSTR, "? [SPLIT_FDB] Unable to open '%s' - (%s)", datafn, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_NORMAL);
        return(FALSE);
    }

    fread(&loradatavar, sizeof(loradatavar), 1, datafile);
    while(!feof(datafile))
    {
        crc = Crc_obj.zmodemcrc32(loradatavar.Area);
        if((unsigned long) fdbvar.crc32 != (unsigned long) crc)
        {
            fdbvar.crc32 = crc;
            if(fdbvar.outfile)
            {
                fclose(fdbvar.outfile);
            }
            x = get_area_number(loradatavar.Area);
            if(x < 1)
            {
                fread(&loradatavar, sizeof(loradatavar), 1, datafile);
                continue;
            }

            sprintf(outfn, "%s$$$%u.FDB", Config_obj.amu_cfgvar.FDBpath, x);
            fdbvar.outfile = _fsopen(outfn, "w+b", SH_DENYRW);
            if(!fdbvar.outfile)
            {
		sprintf(LOGSTR, "? [SPLIT_FDB] Unable to create '%s' - (%s)",
                        outfn, strerror(errno));
                Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
                return(FALSE);
            }
        }

        // Read the description & uploader
        desc = uploader = NULL;
        if(loradatavar.Description > 0)
        {
            desc = (char *)calloc(loradatavar.Description + 5, 1);
            fread(desc, loradatavar.Description, 1, datafile);
        }
        if(loradatavar.Uploader > 0)
        {
            uploader = (char *)calloc(loradatavar.Uploader + 5, 1);
            fread(uploader, loradatavar.Uploader, 1, datafile);
        }


        // Write the datavar and the description to the new FDB
        fwrite(&loradatavar, sizeof(loradatavar), 1, fdbvar.outfile);
        if(desc != NULL)
        {
            fwrite(desc, loradatavar.Description, 1, fdbvar.outfile);
            free(desc);
        }
        if(uploader != NULL)
        {
            fwrite(uploader, loradatavar.Uploader, 1, fdbvar.outfile);
            free(uploader);
        }

        // Read the next records
        fread(&loradatavar, sizeof(loradatavar), 1, datafile);
    }


    // Close the files and clean up
    fclose(datafile);
    if(fdbvar.outfile)
    {
        fclose(fdbvar.outfile);
    }

    /* Now go through and create zero length temp files for areas which
       do not have one */
    for(x = 1; x <= Config_obj.num_filearea; x++)
    {
        sprintf(outfn, "%s$$$%u.FDB", Config_obj.amu_cfgvar.FDBpath, x);
        if(access(outfn, 0) == -1)
        {
            datafile = _fsopen(outfn, "w+b", SH_DENYNO);
            if(datafile)
            {
                fclose(datafile);
            }
        }
    }
    return(TRUE);
}

/* The inverse of split_LoraFDB() */
int FileOptions::merge_LoraFDB(void)
{
    int x;
    char infn[MAX_FILESPEC], datafn[MAX_FILESPEC], idxfn[MAX_FILESPEC];
    char *desc, *uploader;
    long offset;
    FILE *infile, *datafile, *idxfile;

    // Open the new filebase
    sprintf(datafn, "%sFILEBASE.D$$", Config_obj.amu_cfgvar.FDBpath);
    sprintf(idxfn, "%sFILEBASE.I$$", Config_obj.amu_cfgvar.FDBpath);
    datafile = _fsopen(datafn, "w+b", SH_DENYNO);
    if(!datafile)
    {
        sprintf(LOGSTR, "? [MERGE_FDB] Unable to create '%s' - (%s)", datafn, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_NORMAL);
	return(FALSE);
    }
    idxfile = _fsopen(idxfn, "w+b", SH_DENYNO);
    if(!idxfile)
    {
        sprintf(LOGSTR, "? [MERGE_FDB] Unable to create '%s' - (%s)", idxfn, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_NORMAL);
        fclose(datafile);
        return(FALSE);
    }

    offset = 0;
    for(x = 1; x <= Config_obj.num_filearea; x++)
    {
        sprintf(infn, "%s$$$%d.FDB", Config_obj.amu_cfgvar.FDBpath, x);
        infile = _fsopen(infn, "rb", SH_DENYRW);
        if(!infile)
        {
            continue;
        }

        fread(&loradatavar, sizeof(loradatavar), 1, infile);
        while(!feof(infile))
        {
            desc = uploader = NULL;

            if(loradatavar.Description > 0)
            {
                desc = (char *)calloc(1, loradatavar.Description + 5);
                fread(desc, loradatavar.Description, 1, infile);
            }
            if(loradatavar.Uploader > 0)
            {
                uploader = (char *)calloc(1, loradatavar.Uploader + 5);
                fread(uploader, loradatavar.Uploader, 1, infile);
            }

            Config_obj.read_record(FILEAREA_RECORD, x);
            loraidxvar.Area = Config_obj.fileareavar.keycrc32;
            strcpy(loraidxvar.Name, loradatavar.Name);
	    loraidxvar.UploadDate = loradatavar.UploadDate;
            loraidxvar.Offset = offset;
            loraidxvar.Flags = loradatavar.Flags;

            fwrite(&loradatavar, sizeof(loradatavar), 1, datafile);
            if(desc)
            {
                fwrite(desc, loradatavar.Description, 1, datafile);
                free(desc);
            }
            if(uploader)
            {
                fwrite(uploader, loradatavar.Uploader, 1, datafile);
                free(uploader);
            }
            fwrite(&loraidxvar, sizeof(loraidxvar), 1, idxfile);

            offset += (sizeof(loradatavar) + loradatavar.Uploader + loradatavar.Description);
            fread(&loradatavar, sizeof(loradatavar), 1, infile);
        }
        fclose(infile);
        remove(infn);
    }

    // Close the new filebase and rename it
    fclose(datafile);
    fclose(idxfile);
    sprintf(infn, "%sFILEBASE.DAT", Config_obj.amu_cfgvar.FDBpath);
    remove(infn);
    rename(datafn, infn);
    sprintf(infn, "%sFILEBASE.IDX", Config_obj.amu_cfgvar.FDBpath);
    remove(infn);
    rename(idxfn, infn);

    return(TRUE);
}

/* Return the area number associated with an area name */
long FileOptions::get_area_number(char *area)
{
    int index;

    for(index = 1; index <= Config_obj.num_filearea; index++)
    {
        Config_obj.read_record(FILEAREA_RECORD, index);
        if(strcmp(Config_obj.fileareavar.lora3key, area) == 0)
        {
	    return(index);
        }
    }
    return(0);
}

/* Shorten long filenames to 8.3 format */
void FileOptions::shorten_fnames(char *fn)
{
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];

    _splitpath(fn, drive, dir, fname, ext);
    if(strlen(fname) > 8)
    {
        fname[6] = NULL;
        strcat(fname, "~1");
    }
    ext[4] = NULL;
    sprintf(fn, "%s%s%s%s", drive, dir, fname, ext);
}
