// Functions for the File Manager menu
// Created 02 October 1995
// Revised 25 January 1998

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include "menus.h"
#include "FileMan.h"
#include "config.h"
#include "listbox.h"
#include "utility2.h"
#include "trckmenu.h"
#include "amuidx.h"

/* Classes */
class FileMan_areas FileMan_areas_obj;
class FileMan_global FileMan_global_obj;
class FileMan_change FileMan_change_obj;
class EditTrackMenu EditTrackMenu_obj;

/* external objects */
extern class Config Config_obj;
extern class ListBox ListBox_obj;
extern class AreasBox AreasBox_obj;
extern class Utility2 Utility2_obj;
extern class Menus Menus_obj;
extern listbox *filelistbox;
extern int check_bbsfiles(int force_import);

/**************************************************************************/

void FileMan::menu(void)
{
    int i;
    struct coordinates cvar;

    cvar.uses_blanks = TRUE;
    cvar.items = 6;
    cvar.width = 24;
    cvar.left = 35;
    cvar.top = 10;
    cvar.high_num = 0;
    cvar.position = 2;
    cvar.title = "File Areas";
    cvar.options = options();
    do
    {
        Menus_obj.set_help(MAIN_FILES_HELP);
        i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: action(cvar.position);
                        break;
            case F1   : Menus_obj.online_help(cvar.position - 2 + _GLOBAL);
                        break;
        }
    }while(i != ESC);
}

char *FileMan::options(void)
{
    strcpy(optionsstr, " ;Global options;Areas;Mark Areas;Unmark Areas; ;");
    return(optionsstr);
}

void FileMan::action(int position)
{
    char *tmpbuf;

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
	case 2: FileMan_global_obj.menu();
                break;
        case 3: FileMan_areas_obj.menu();
                break;
        case 4: EditTrackMenu_obj.menu(AREAS_ON);
                break;
        case 5: EditTrackMenu_obj.menu(AREAS_OFF);
                break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/**************************************************************************/

int FileMan_global::menu(void)
{
    int i;
    char *tmpbuf, str[21];

    cvar.uses_blanks = TRUE;
    cvar.items = 18;
    cvar.width = 57;
    cvar.left = 10;
    cvar.top = 4;
    cvar.position = 2;
    cvar.high_num = 19;
    strcpy(str, "Global Options");
    cvar.title = str;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
	Menus_obj.set_help(GLOBAL_HELP);
        cvar.options = options();
	i = Menus_obj.display_menu(&cvar, 1);
        switch(i)
        {
            case ENTER: action(cvar.position);
                        break;
            case F1   : Menus_obj.online_help(_GLOBAL);
                        break;
	}
    }while(i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    return(i);
}

char *FileMan_global::options(void)
{
    char tmpstr[11];

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Missing Desc      : ");
    strcat(optionsstr, Config_obj.amu_cfgvar.missing_desc);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Ext. Char         : ");
    sprintf(tmpstr, "%s;", Config_obj.amu_cfgvar.ext_desc_char);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, " Semicolon ok?   : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.semicolon_ok));

    strcat(optionsstr, "Ext. Offset       : ");
    if(Config_obj.amu_cfgvar.ext_offset < 1)
    {
	Config_obj.amu_cfgvar.ext_offset = 1;
    }
    sprintf(tmpstr, "%d;", Config_obj.amu_cfgvar.ext_offset);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Left Bracket      : ");
    sprintf(tmpstr, "%c;", Config_obj.amu_cfgvar.left_bracket);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Right Bracket     : ");
    sprintf(tmpstr, "%c;", Config_obj.amu_cfgvar.right_bracket);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Counter Width     : ");
    sprintf(tmpstr, "%d;", Config_obj.amu_cfgvar.counter_width);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Max DIZ Lines     : ");
    sprintf(tmpstr, "%d;", Config_obj.amu_cfgvar.max_dizlines);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Max DIZ Width     : ");
    sprintf(tmpstr, "%d;", Config_obj.amu_cfgvar.max_dizwidth);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Mult. Desc Lines  : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.use_multiple_lines));

    strcat(optionsstr, " Max Single Line : ");
    if(!Config_obj.amu_cfgvar.use_multiple_lines)
    {
	sprintf(tmpstr, "%d;", Config_obj.amu_cfgvar.max_single_length);
    }
    else
    {
	sprintf(tmpstr, "n/a;");
    }
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "Kill Bad Archives : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.kill_bad_arcs));

    strcat(optionsstr, "Change Uploader   : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.replace_ul));

    strcat(optionsstr, "Skip Nested Arcs  : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.skip_nested));

    strcat(optionsstr, "Create file lists : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.create_if_notexist));

    strcat(optionsstr, "Shorten filenames : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.amu_cfgvar.shorten_fnames));

    strcat(optionsstr, "  ;");
    return(optionsstr);
}

void FileMan_global::action(int position)
{
    char tmpstr[11];
    int offset = 22;

    Menus_obj.set_validtype(SPACES_OK);
    switch(position)
    {
	case 2: strcpy(Config_obj.amu_cfgvar.missing_desc, Menus_obj.getfield(Config_obj.amu_cfgvar.missing_desc, cvar.left + offset, cvar.top + position, 35));
		break;
	case 3: Menus_obj.set_validtype(SPACES_OK);
		strcpy(Config_obj.amu_cfgvar.ext_desc_char, Menus_obj.getfield(Config_obj.amu_cfgvar.ext_desc_char, cvar.left + offset, cvar.top + position, 10));
		Menus_obj.set_validtype(SPACES_OK);
		break;
	case 4: Utility2_obj.toggle(&Config_obj.amu_cfgvar.semicolon_ok);
		break;
	case 5: Menus_obj.set_validtype(RANGE_5);
		sprintf(tmpstr, "%d", Config_obj.amu_cfgvar.ext_offset);
		strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 2));
		Config_obj.amu_cfgvar.ext_offset = atoi(tmpstr);
		Menus_obj.set_validtype(SPACES_OK);
		break;
	case 6: Menus_obj.set_validtype(FILENM);
		sprintf(tmpstr, "%c", Config_obj.amu_cfgvar.left_bracket);
		strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 1));
		Config_obj.amu_cfgvar.left_bracket = tmpstr[0];
		Menus_obj.set_validtype(SPACES_OK);
		break;
	case 7: Menus_obj.set_validtype(FILENM);
		sprintf(tmpstr, "%c", Config_obj.amu_cfgvar.right_bracket);
		strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 1));
		Config_obj.amu_cfgvar.right_bracket = tmpstr[0];
		Menus_obj.set_validtype(SPACES_OK);
		break;
	case 8: Menus_obj.set_validtype(RANGE_4);
		sprintf(tmpstr, "%d", Config_obj.amu_cfgvar.counter_width);
		strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 2));
		Config_obj.amu_cfgvar.counter_width = atoi(tmpstr);
		Menus_obj.set_validtype(SPACES_OK);
		break;
	case 9: Menus_obj.set_validtype(RANGE_7);
		sprintf(tmpstr, "%d", Config_obj.amu_cfgvar.max_dizlines);
		strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 5));
		Config_obj.amu_cfgvar.max_dizlines = atoi(tmpstr);
		Menus_obj.set_validtype(SPACES_OK);
		break;
	case 10: Menus_obj.set_validtype(RANGE_5);
		 sprintf(tmpstr, "%d", Config_obj.amu_cfgvar.max_dizwidth);
		 strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 2));
		 Config_obj.amu_cfgvar.max_dizwidth = atoi(tmpstr);
		 Menus_obj.set_validtype(SPACES_OK);
		 break;
	case 11: Utility2_obj.toggle(&Config_obj.amu_cfgvar.use_multiple_lines);
		 break;
	case 12: if(!Config_obj.amu_cfgvar.use_multiple_lines)
		 {
		     Menus_obj.set_validtype(RANGE_3);
		     sprintf(tmpstr, "%d", Config_obj.amu_cfgvar.max_single_length);
		     strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + position, 5));
		     Config_obj.amu_cfgvar.max_single_length = atoi(tmpstr);
		     Menus_obj.set_validtype(SPACES_OK);
		 }
		 break;
	case 13: Utility2_obj.toggle(&Config_obj.amu_cfgvar.kill_bad_arcs);
		 break;
	case 14: Utility2_obj.toggle(&Config_obj.amu_cfgvar.replace_ul);
		 break;
	case 15: Utility2_obj.toggle(&Config_obj.amu_cfgvar.skip_nested);
		 break;
	case 16: Utility2_obj.toggle(&Config_obj.amu_cfgvar.create_if_notexist);
		 break;
	case 17: Utility2_obj.toggle(&Config_obj.amu_cfgvar.shorten_fnames);
		 break;
    }
}

/**************************************************************************/

int FileMan_areas::menu(void)
{
    long crc;
    int i, index, x;
    char str[100];
    struct coordinates cvar2;

    check_bbsfiles(FALSE);

    index = DEFAULT_RECORD;
    cvar.uses_blanks = FALSE;
    cvar.items = 33;
    cvar.width = 66;
    cvar.left = 6;
    cvar.top = 10;
    cvar.position = 1;
    cvar.high_num = 10;
    cvar.title = NULL;
    cvar2.uses_blanks = FALSE;
    cvar2.items = 2;
    cvar2.width = 40;
    cvar2.left = 19;
    cvar2.top = 6;
    cvar2.position = 1;
    cvar2.high_num = 0;
    cvar2.title = NULL;
    Config_obj.open_config(FILEAREA_RECORD);
    do
    {
	Menus_obj.set_help(AREAS_HELP);
	Menus_obj.help("File Area Manager - F2 Global changes; F3 Copy Settings; F4 Goto Area");
	if(index > Config_obj.num_filearea)
	{
	    index = DEFAULT_RECORD;
	}
	if(index < DEFAULT_RECORD)
	{
	    index = Config_obj.num_filearea;
	}
	Config_obj.open_config(FILEAREA_RECORD);
        Config_obj.read_record(FILEAREA_RECORD, index);
        sprintf(str, "Record    : %d/%d;",
		index, Config_obj.num_filearea);
        strcat(str, "Areaname  : ");
        strcat(str, Config_obj.fileareavar.areaname);
        strcat(str, ";");
        cvar2.options = str;
        cvar.options = options();
	Menus_obj.dialog(&cvar2, DEL, 1);
	i = Menus_obj.dialog(&cvar, ENTER, 3);
	switch(i)
	{
		 case LEFT : index--;
			     break;
		 case RIGHT: index++;
			     break;
		 case ENTER: cvar.position = 1;
			     break;
		 case HOME : index = DEFAULT_RECORD;
			     break;
		 case END  : index = Config_obj.num_filearea;
			     break;
		 case F1   : Menus_obj.online_help(_AREA_MANAGER);
			     break;
		 case F2   : FileMan_change_obj.menu();
			     break;
		 case F3   : copy_area();
			     break;
		 case F4   : x = ListBox_obj.display_listbox(filelistbox, "Area to jump to:", 50);
			     if(x > 0)
			     {
				 index = x;
			     }
			     break;

		 case ESC  : Config_obj.close_config(FILEAREA_RECORD);
			     return(i);
	}
	if(i == ENTER)
	{
	    crc = Crc_obj.struct_crc((char *) &Config_obj.fileareavar,
		  sizeof(Config_obj.fileareavar));
	    do
	    {
		Menus_obj.set_help(AREAS_HELP);
		cvar.options = options();
		i = Menus_obj.display_menu(&cvar, 3);
		switch(i)
                {
                    case ENTER: action(cvar.position);
				break;
                    case F1   : Menus_obj.online_help(_AREA_MANAGER);
				break;
		}
            }while(i != ESC);
	    if(crc != Crc_obj.struct_crc((char *) &Config_obj.fileareavar, sizeof(Config_obj.fileareavar))
		&&  Menus_obj.prompt(0))
	    {
		Config_obj.open_config(FILEAREA_RECORD);
		Config_obj.update_record(FILEAREA_RECORD, index);
	    }
	    i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
	}
    }while(i != ESC);
    Config_obj.close_config(FILEAREA_RECORD);
    return(i);
}

char *FileMan_areas::options(void)
{
    char tmpstr[11];

    memset(optionsstr, NULL, sizeof(optionsstr));

    strcpy(optionsstr, "Storage   : ");
    strcat(optionsstr, Utility2_obj.listtype_str(Config_obj.fileareavar.listtype));

    strcat(optionsstr, "CD Area   : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.attrib.cdrom));

    strcat(optionsstr, "Format   : ");
    if(Config_obj.fileareavar.listtype == FILESBBS && Config_obj.fileareavar.attrib.cdrom)
    {
	strcat(optionsstr, Utility2_obj.cdformat_str(Config_obj.fileareavar.cdformat));
    }
    else
    {
	strcat(optionsstr, "n/a");
    }
    strcat(optionsstr, ";");

    strcat(optionsstr, "Sort      : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.sort));

    strcat(optionsstr, "Type     : ");
    strcat(optionsstr, Utility2_obj.sorttype_str(Config_obj.fileareavar.sort_type));
    strcat(optionsstr, ";");

    strcat(optionsstr, "Headers   : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.headers));

    strcat(optionsstr, "Old       : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.old));

    strcat(optionsstr, "Del/Move : ");
    if(Config_obj.fileareavar.attrib.move_old)
    {
	strcat(optionsstr, "Move;");
    }
    else
    {
	strcat(optionsstr, "Delete;");
    }

    strcat(optionsstr, "Days Old : ");
    sprintf(tmpstr, "%d;", Config_obj.fileareavar.days_old);
    strcat(optionsstr, tmpstr);

    strcat(optionsstr, "UL Date  : ");
    if(Config_obj.fileareavar.listtype == RA_FDB || Config_obj.fileareavar.listtype == LORA_FDB ||
       Config_obj.fileareavar.listtype == EZY_FDB)
    {
	strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.useuldate));
    }
    else
    {
	strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "New Area : ");
    if(Config_obj.fileareavar.attrib.move_old)
    {
	sprintf(tmpstr, "%d;", Config_obj.fileareavar.move_area);
	strcat(optionsstr, tmpstr);
    }
	 else
    {
	strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Adopt     : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.adopt));

    strcat(optionsstr, "Orphan    : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.orphan));

    strcat(optionsstr, "BBS DLs   : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.bbsdls));

    strcat(optionsstr, "Mailer DLs: ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.mailerdls));

    strcat(optionsstr, "Backup    : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.backup));

    strcat(optionsstr, "Pack      : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.pack));

    strcat(optionsstr, "Rearchive : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.rearchive));

    strcat(optionsstr, "Format   : ");
    strcat(optionsstr, Utility2_obj.arctype_str(Config_obj.fileareavar.rearc_type));
    strcat(optionsstr, ";");

    strcat(optionsstr, "Force    : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.force_rearc));

    strcat(optionsstr, "Honor AV : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.honor_av));

    strcat(optionsstr, "Comment   : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.comment));

    strcat(optionsstr, "Scan      : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.virus));

    strcat(optionsstr, "ImportDIZ : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.importdiz));

    strcat(optionsstr, "Filter   : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.filter_graph));

    strcat(optionsstr, "GIF Info : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.import_gif));

    strcat(optionsstr, "ExportDIZ : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.exportdiz));

    strcat(optionsstr, "ImportBBS : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.importbbs));

    strcat(optionsstr, "ExportBBS : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.exportbbs));

    strcat(optionsstr, "Move Blank: ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.move_nodesc));

    strcat(optionsstr, "New Area : ");
    if(Config_obj.fileareavar.move_nodesc)
    {
	sprintf(tmpstr, "%d;", Config_obj.fileareavar.nodesc_area);
	strcat(optionsstr, tmpstr);
    }
	 else
    {
	strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Comp. Text: ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.fileareavar.compress_txt));

    strcat(optionsstr, "Format   : ");
    strcat(optionsstr, Utility2_obj.arctype_str(Config_obj.fileareavar.compresstxt_type));
    strcat(optionsstr, ";");

    return(optionsstr);
}

void FileMan_areas::action(int position)
{
    char tmpstr[11];
    int offset, x;

    offset = 14;
    switch(position)
    {
	case 1: Menus_obj.get_listtype(&Config_obj.fileareavar.listtype);
		break;
	case 2: Config_obj.fileareavar.attrib.cdrom BIT_TOGGLE;
		break;
	case 3: if(Config_obj.fileareavar.attrib.cdrom)
		{
		    Menus_obj.get_cdformat(&Config_obj.fileareavar.cdformat);
		}
		break;
	case 4: Utility2_obj.toggle(&Config_obj.fileareavar.sort);
		break;
	case 5: Menus_obj.get_sorttype(&Config_obj.fileareavar.sort_type);
		break;
	case 6: Utility2_obj.toggle(&Config_obj.fileareavar.headers);
		break;
	case 7: Utility2_obj.toggle(&Config_obj.fileareavar.old);
		break;
	case 8: Config_obj.fileareavar.attrib.move_old BIT_TOGGLE;
		break;
	case 9: Menus_obj.set_validtype(RANGE_7);
		sprintf(tmpstr, "%d", Config_obj.fileareavar.days_old);
		strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset,
		       cvar.top + position, 5));
		Config_obj.fileareavar.days_old = atoi(tmpstr);
		break;
	case 10: Utility2_obj.toggle(&Config_obj.fileareavar.useuldate);
		 break;
	case 11: if(Config_obj.fileareavar.attrib.move_old)
		 {
		     x = ListBox_obj.display_listbox(filelistbox, "Destination", 50);
		     if(x > 0)
		     {
			 Config_obj.fileareavar.move_area = x;
		     }
		  }
		  break;
	case 12: Utility2_obj.toggle(&Config_obj.fileareavar.adopt);
		 break;
	case 13: Utility2_obj.toggle(&Config_obj.fileareavar.orphan);
		 break;
	case 14: Utility2_obj.toggle(&Config_obj.fileareavar.bbsdls);
		 break;
	case 15: Utility2_obj.toggle(&Config_obj.fileareavar.mailerdls);
		 break;
	case 16: Utility2_obj.toggle(&Config_obj.fileareavar.backup);
		 break;
	case 17: Utility2_obj.toggle(&Config_obj.fileareavar.pack);
		 break;
	case 18: Utility2_obj.toggle(&Config_obj.fileareavar.rearchive);
		 break;
	case 19: Menus_obj.arctype_toggle(&Config_obj.fileareavar.rearc_type);
		 break;
	case 20: Utility2_obj.toggle(&Config_obj.fileareavar.force_rearc);
		 break;
	case 21: Utility2_obj.toggle(&Config_obj.fileareavar.honor_av);
		 break;
	case 22: Utility2_obj.toggle(&Config_obj.fileareavar.comment);
		 break;
	case 23: Utility2_obj.toggle(&Config_obj.fileareavar.virus);
		 break;
	case 24: Utility2_obj.toggle(&Config_obj.fileareavar.importdiz);
		 break;
	case 25: Utility2_obj.toggle(&Config_obj.fileareavar.filter_graph);
		 break;
	case 26: Utility2_obj.toggle(&Config_obj.fileareavar.import_gif);
		 break;
	case 27: Utility2_obj.toggle(&Config_obj.fileareavar.exportdiz);
		 break;
	case 28: Utility2_obj.toggle(&Config_obj.fileareavar.importbbs);
		 break;
	case 29: Utility2_obj.toggle(&Config_obj.fileareavar.exportbbs);
		 break;
	case 30: Utility2_obj.toggle(&Config_obj.fileareavar.move_nodesc);
		 break;
	case 31: if(Config_obj.fileareavar.move_nodesc)
		 {
		     x = ListBox_obj.display_listbox(filelistbox, "Destination", 50);
		     if(x > 0)
		     {
			 Config_obj.fileareavar.nodesc_area = x;
		     }
		  }
		  break;
	case 32: Utility2_obj.toggle(&Config_obj.fileareavar.compress_txt);
		 break;
	case 33: Menus_obj.arctype_toggle(&Config_obj.fileareavar.compresstxt_type);
		 break;
    }
}

/**************************************************************************/
/* Global changes */
void FileMan_change::menu(void)
{
    int i;

    cvar.uses_blanks = FALSE;
    cvar.items = 33;
    cvar.width = 36;
    cvar.left = 24;
    cvar.top = 5;
    cvar.high_num = 0;
    cvar.position = 1;
    cvar.title = "Global changes";
    cvar.options = options();
    do
    {
	Menus_obj.set_help(AREAS_HELP);
	i = Menus_obj.display_menu(&cvar, 2);
        switch(i)
        {
            case ENTER: action(cvar.position);
			break;
            case F1   : Menus_obj.online_help(_AREA_MANAGER);
                        break;
        }
    }while(i != ESC);
}

char *FileMan_change::options(void)
{
    strcpy(optionsstr, "Storage type;CD Area;Format;Sort;Type;");
    strcat(optionsstr, "Headers;Old;Delete/Move;Days old;UL Date;Move Area;Adopt;");
    strcat(optionsstr, "Orphan;BBS DLs;Mailer DLs;Backup;Pack;Rearchive;Format;Force;Honor AV;Comment;Virus scan;");
    strcat(optionsstr, "ImportDIZ;Filter;Import GIF;ExportDIZ;ImportBBS;ExportBBS;");
    strcat(optionsstr, "Move Blank;New Area;Comp. Text;Format;");
    return(optionsstr);
}

void FileMan_change::make_changes(int position, int newvalue, int start, int end)
{
    int x;

    if(newvalue == -1 || start == -1 || end == -1)
    {
	return;
    }

    /* See if the user really wants to go ahead with the changes */
    if(!Menus_obj.prompt(0))
    {
	return;
    }

    for(x = start; x <= end; x++)
    {
	Config_obj.read_record(FILEAREA_RECORD, x);
	switch(position)
	{
	    case 1: Config_obj.fileareavar.listtype = newvalue;
		    break;
	    case 2: Config_obj.fileareavar.attrib.cdrom = Config_obj.active(x);
		    break;
	    case 3: Config_obj.fileareavar.cdformat = newvalue;
		    break;
	    case 4: Config_obj.fileareavar.sort = Config_obj.active(x);
		    break;
	    case 5: Config_obj.fileareavar.sort_type = newvalue;
		    break;
	    case 6: Config_obj.fileareavar.headers = Config_obj.active(x);
		    break;
	    case 7: Config_obj.fileareavar.old = Config_obj.active(x);
		    break;
	    case 8: Config_obj.fileareavar.attrib.move_old = newvalue;
		    break;
	    case 9: Config_obj.fileareavar.days_old = newvalue;
		    break;
	    case 10: Config_obj.fileareavar.useuldate = newvalue;
		     break;
	    case 11: Config_obj.fileareavar.move_area = newvalue;
		     break;
	    case 12: Config_obj.fileareavar.adopt = Config_obj.active(x);
		     break;
	    case 13: Config_obj.fileareavar.orphan = Config_obj.active(x);
		     break;
	    case 14: Config_obj.fileareavar.bbsdls = Config_obj.active(x);
		     break;
	    case 15: Config_obj.fileareavar.mailerdls = Config_obj.active(x);
		     break;
	    case 16: Config_obj.fileareavar.backup = Config_obj.active(x);
		     break;
	    case 17: Config_obj.fileareavar.pack = Config_obj.active(x);
		     break;
	    case 18: Config_obj.fileareavar.rearchive = Config_obj.active(x);
		     break;
	    case 19: Config_obj.fileareavar.rearc_type = newvalue;
		     break;
	    case 20: Config_obj.fileareavar.force_rearc = newvalue;
		     break;
	    case 21: Config_obj.fileareavar.honor_av = newvalue;
		     break;
	    case 22: Config_obj.fileareavar.comment = Config_obj.active(x);
		     break;
	    case 23: Config_obj.fileareavar.virus = Config_obj.active(x);
		     break;
	    case 24: Config_obj.fileareavar.importdiz = Config_obj.active(x);
		     break;
	    case 25: Config_obj.fileareavar.filter_graph = newvalue;
		     break;
	    case 26: Config_obj.fileareavar.import_gif = newvalue;
		     break;
	    case 27: Config_obj.fileareavar.exportdiz = Config_obj.active(x);
		     break;
	    case 28: Config_obj.fileareavar.importbbs = Config_obj.active(x);
		     break;
	    case 29: Config_obj.fileareavar.exportbbs = Config_obj.active(x);
		     break;
	    case 30: Config_obj.fileareavar.move_nodesc = Config_obj.active(x);
		     break;
	    case 31: Config_obj.fileareavar.nodesc_area = newvalue;
		     break;
	    case 32: Config_obj.fileareavar.compress_txt = Config_obj.active(x);
		     break;
	    case 33: Config_obj.fileareavar.compresstxt_type = newvalue;
		     break;
	}
	Config_obj.update_record(FILEAREA_RECORD, x);
    }
}

void FileMan_change::action(int position)
{
    char begin_str[21], end_str[21];
    int x, start, end;
    short newvalue;

    strcpy(begin_str, "Begin area");
    strcpy(end_str, "End area");
    newvalue = -100;
    start = 1;
    end = Config_obj.num_filearea;
    memset(&Config_obj.areasvar, 0, AREAS_SIZE);
    switch(position)
    {
	case 1: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		Menus_obj.get_listtype(&newvalue);
		break;
	case 2: for(x = 1; x <= Config_obj.num_filearea; x++)
		{
		    Config_obj.read_record(FILEAREA_RECORD, x);
		    if(Config_obj.fileareavar.attrib.cdrom)
		    {
			Config_obj.togglearea(x);
		    }
		}
		break;
	case 3: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		Menus_obj.get_cdformat(&newvalue);
		break;
	case 4: for(x = 1; x <= Config_obj.num_filearea; x++)
		{
		    Config_obj.read_record(FILEAREA_RECORD, x);
		    if(Config_obj.fileareavar.sort)
		    {
			Config_obj.togglearea(x);
		    }
		}
		break;
	case 5: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		Menus_obj.get_sorttype(&newvalue);
		break;
	case 6: for(x = 1; x <= Config_obj.num_filearea; x++)
		{
		    Config_obj.read_record(FILEAREA_RECORD, x);
		    if(Config_obj.fileareavar.headers)
		    {
			Config_obj.togglearea(x);
		    }
		}
		break;
	case 7: for(x = 1; x <= Config_obj.num_filearea; x++)
		{
		    Config_obj.read_record(FILEAREA_RECORD, x);
		    if(Config_obj.fileareavar.old)
		    {
			Config_obj.togglearea(x);
		    }
		}
		break;
	case 8: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		newvalue = Menus_obj.get_yesno();
		break;
	case 9: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		newvalue = Menus_obj.get_point(3, RANGE_7);
		break;
	case 10: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 newvalue = Menus_obj.get_yesno();
		 break;
	case 11: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 newvalue = ListBox_obj.display_listbox(filelistbox, "New destination", 50);
		 break;
	case 12: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.adopt)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 13: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.orphan)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 14: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.bbsdls)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 15: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.mailerdls)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 16: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.backup)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 17: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
			  if(Config_obj.fileareavar.pack)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 18: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.rearchive)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 19: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 Menus_obj.arctype_toggle(&newvalue);
		 break;
	case 20: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 newvalue = Menus_obj.get_yesno();
		 break;
	case 21: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 newvalue = Menus_obj.get_yesno();
		 break;
	case 22: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.comment)
			  {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 23: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.virus)
		     {
			 Config_obj.togglearea(x);
			  }
		 }
		 break;
	case 24: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.importdiz)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 25: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 newvalue = Menus_obj.get_yesno();
		 break;
	case 26: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 newvalue = Menus_obj.get_yesno();
		 break;
	case 27: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.exportdiz)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 28: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.importbbs)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 29: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.exportbbs)
			  {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 30: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.move_nodesc)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 31: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 newvalue = ListBox_obj.display_listbox(filelistbox, "New destination", 50);
		 break;
	case 32: for(x = 1; x <= Config_obj.num_filearea; x++)
		 {
		     Config_obj.read_record(FILEAREA_RECORD, x);
		     if(Config_obj.fileareavar.compress_txt)
		     {
			 Config_obj.togglearea(x);
		     }
		 }
		 break;
	case 33: start = ListBox_obj.display_listbox(filelistbox, begin_str, 50);
		 end = ListBox_obj.display_listbox(filelistbox, end_str, 50);
		 Menus_obj.arctype_toggle(&newvalue);
		 break;
    }

   /* Get the areas to make the global changes to */
    if(newvalue == -100)
    {
	AreasBox_obj.display_listbox(filelistbox, "Areas to change:", 50);
    }

    /* The FILEAREA.AMU needs to be opened again since the read_filearray()
       function may have closed it */
    Config_obj.open_config(FILEAREA_RECORD);
    make_changes(position, newvalue, start, end);
}

/* Copy the settings for the current area to several other areas */
void FileMan_areas::copy_area(void)
{
    struct filearea fileareavar;
    int x;

    memcpy(&fileareavar, &Config_obj.fileareavar, sizeof(fileareavar));
    memset(&Config_obj.areasvar, 0, sizeof(Config_obj.areasvar));
    AreasBox_obj.display_listbox(filelistbox, "Areas to copy settings to", 50);
    Config_obj.open_config(FILEAREA_RECORD);
    for(x = 1; x <= Config_obj.num_filearea; x++)
    {
        if(Config_obj.active(x))
        {
            Config_obj.read_record(FILEAREA_RECORD, x);
            Config_obj.fileareavar.days_old = fileareavar.days_old;
            Config_obj.fileareavar.move_area = fileareavar.move_area;
            Config_obj.fileareavar.rearc_type = fileareavar.rearc_type;
	    Config_obj.fileareavar.sort_type = fileareavar.sort_type;
	    Config_obj.fileareavar.attrib.move_old = fileareavar.attrib.move_old;
	    Config_obj.fileareavar.filter_graph = fileareavar.filter_graph;
	    Config_obj.fileareavar.import_gif = fileareavar.import_gif;
	    Config_obj.fileareavar.force_rearc = fileareavar.force_rearc;
	    Config_obj.fileareavar.honor_av = fileareavar.honor_av;
	    memcpy(&Config_obj.fileareavar.sort, &fileareavar.sort, NUM_FAREA_OPTIONS * sizeof(short));
	    Config_obj.update_record(FILEAREA_RECORD, x);
	}
    }
}

//***********************************************************************
// EOF - FileMan.CPP
