/********************************************************************
 * Ezycom structures converted to C format V1.20 2/3/96
 * by Peter Davies
 *
 * These structures may ONLY be used in accordance with those
 * agreements laid out in the Official Ezycom Structures.
 * Peter Davies takes no responsibility whatsoever
 * for the correctness of these structures.
 *
 * If, you find any faults please notify us of them.
 *
 * Please refer to the pascal structures for more explanation, before
 * querying us
 *
 ********************************************************************/

#ifndef EZYCOMH

#define EZYCOMH

#define  word    unsigned short
#define  byte    unsigned char
#define  longint signed   long int
#define  sword	 signed   short

#define  EZYVER "1.20"
#define  VERSIONHIGH 1
#define  VERSIONLOW 20
#define  PRODNAME "Ezycom"
#define  COPYRIGHT "Peter Davies"
#define  COPYRIGHTYEAR "1992-1996"
#define  MAXFREE  1238
#define  USERFREE 121
#define  CONSTANTFILEFREESPACE 441
#define  MAXNODES 256
#define  MAXAKA 32
#define  MAXMESSALL 1536
#define  MAXMESS    MAXMESSALL
#define  MAXBAUDREC 22
#define  FLTMAXSIZE  2048   //      maximum size of a file description

/****** Take Note ********************************************************
Boolean can be defined as a Char value under C or as an enum with a
true/false value under C++ (if compiled with enum to char switch)
**************************************************************************/
/* typedef char Boolean; */

/* Swapping Types : 0=None, 1=Ems, 2=Xms, 3=Disk, 4=EmsXms, 5=XmsEms */

/* The following can also be defined as enum under C++ */

typedef unsigned char AskType;        // 0=yes,1=no,2=ask default yes,
                                      // 3=ask default no
typedef unsigned char PhoneType;      // 0=business,1=data,2=nophone

typedef unsigned char MsgType;

#define mtLocal     0
#define mtNetMail   1
#define mtEchoMail  2
#define mtPassThru  3
#define mtWaitThru  4
#define mtAllMail   5
#define mtInternet  6
#define mtNews      7
#define mtFax       8

typedef unsigned char MsgKindsType;   // 0=public,1=private,2=both
typedef unsigned char ShowFileSizeType; // 0=nosize,1=bytes,2=kilobytes
typedef char MaxStr[256];
typedef char UserString[36];
typedef char FileStr[13];    // max length of a FileName
typedef char DomainStr[21];  // domain string
typedef char AreaTagStr[76];
typedef char Str3[4];
typedef char Str4[5];
typedef char Str8[9];
typedef char Str12[13];
typedef char Str23[24];
typedef char Str30[31];
typedef char Str72[73];
typedef char Str128[129];
typedef unsigned char FlagType[4];
typedef unsigned char GroupType[4];

typedef struct DateTime {
   word  Year,
	      Month,
	      Day,
	      Hour,
	      Min,
				Sec;
} DateTime;

typedef struct SecurityType {
  word      Security;
  FlagType  OnFlags,
            OffFlags;
} SecurityType;

typedef struct DateRecord {
  word      Year;
  byte      Month,
            Day;
} DateRecord;

/**********************************************************

  FileName     : filebase path\FLCOUNT.BBS

  Description  : Stores number of files in each file area
                 (does not include comment lines)

  Records      : 1..65000
                 Always the same as FILES.EZY + FILEPATH.EZY

  Last Revised : 25/2/92(pwd)

  Sharing      : Always use DENYNONE + READWRITE

 **********************************************************/

  /*  Each record contains a word (2 bytes) which stores the
      amount of files in each file area.

      When reading the information, just seek to the
      appropriate record and read the 2 bytes

      When updating the count, lock the 2 bytes, then read
      it, then increate/decrease the amount, then write it
      back, and then release the lock. */


/**********************************************************

  FileName     : FLHXXXXX.BBS

  Description  : Stores file list information

  Last Revised : 25/2/92(pwd)

  Sharing      : Always use DENYNONE + READWRITE

  attribute 
    Bit 0 : checked
        1 : nokill
        2 : offline
        3 : [Reserved]
        4 : private
        5 : deleted
      6-7 : [Reserved] 

  attribute2 
   bit 0-7: [Reserved] 

 **********************************************************/

  typedef struct FileLineRecord {
    longint       FltStart;               // start of info in FLTXXXXX.BBS
    word          FltLength;              // length including null termiantor
    byte          Attribute;
    char          FileName[13];           // if the length of FileName is 0,
                                          // then it is a comment
    word          FilePath;               // pointer to filepath.ezy for path
                                          // of file 0= do not know where the 
                                          // file is 
    longint       FSize;                  // size of the actual file
    word          FDate,                  // date of the actual file
                  ArrivalDate,            // date the file arrived on the system
                  Downloads,
                  DownloadDate;           // last time the file was downloaded
                                          // if (downloads = 0) then
                                          //  this field is invalid
    byte          Attribute2;
    UserString    Uploader;
    byte          FreeSpace[57];
  } FileLineRecord;

/**********************************************************

  FileName     : FLTXXXXX.BBS

  Description  : Stores file list description information

  Last Revised : 25/2/92(pwd)

 **********************************************************/

   #define  FLTMAXSIZE  2048            // maximum size of a file description


  /* The FLTXXXXX.BBS has contains a null terminated string.

     It is either a comment, or a file description.  The description
     or comment can be upto FTLMAXSIZE in length.

     A comment maybe only 1 line long, and may NOT contain line feeds
     or carriage returns.

     A description can be any number of lines long, and may contain
     carriage returns, but may NOT contain line feeds (waste space)

     When writing to the description file, the file MUST be opened
     in DENYWRITE + READWRITE.  When reading from it, it MUST
     be opened in DENYNONE + READONLY */


/**********************************************************

  FileName     :  FFPTR.BBS

  Description  :  Index Pointer File for the Fast Find Index

  Last Revised :  25/2/94(pwd)

  Format       :  Files with First Character #0 through to #64
                  start at Position 0 in FFIDX.BBS

                  [730] is all new files after the last sort
                  [729] is all files with a first letter after
                        'Z' (besides new files)
                  [1..728] is files that start with A#0 through
                        to Z#255
                  eg: AA is 2, AB is 3, ZZ is 727, ZY is 726

                  A value of 0x0FFFFFFFF (-1) in any position
                  indicates no files are present for that
                  position.

**********************************************************/

  typedef longint  FastPointerRecord[730];

/**********************************************************

  FileName     : FFIDX.BBS

  Description  : Index File of all files available for download

  Last Revised : 1/2/94 (pwd)

  Records      : 0..Infinite

  To add a file to the fast find index, just add an extra
  record to the end of this file.  File sharing should be
  DENYNONE + READWRITE

  attribute;
    Bit 0 : Deleted
       1-7: [Reserved]

 **********************************************************/

  typedef struct FastIndexRecord {
    FileStr     Name;
    word        FilePath;               // FILEPATH.EZY 1 ->
    byte        Attribute;
    longint     FileSize;
  } FastIndexRecord;








/****************************************  MESSAGE BASE ***********************************/


/**********************************************************

  FileName:     <msgpath>\AREA<(<area>-1)/100+1>\MH<area>.BBS
                eg: \ezy\msgbase\area1\mh00001.bbs     for area 1
                eg: \ezy\msgbase\area10\mh01001.bbs    for area 1001
                eg: \ezy\msgbase\area100\mh10001.bbs   for area 10001

  Description:  Used by Ezycom to store message header

  msgattr,
    Bit 0 : Deleted
        1 : Netmail pending export
        2 : [Reserved]
        3 : Private
        4 : Received
        5 : Echomail pending export
        6 : Locally generated msg
        7 : Do not kill message 

  netattr,
    Bit 0 : Kill/sent
        1 : Sent
        2 : File Attach
        3 : Crash
        4 : File Req
        5 : Request Receipt
        6 : Audit Request
        7 : Is a Return Receipt 

   extattr   : byte;
     Bit 0-7 : [Reserved] 

 **********************************************************/

  typedef struct MsgHdrRecord {
    word          PrevReply,
                  NextReply;                // 0 = No Reply Chain
    longint       StartPosition,            // Physical Start Position in
                                            // MSGT???.BBS
                  MessageLength;            // Message Length including
                                            // Null Terminator
    NetRecord     DestNet,
                  OrigNet;
    word          Cost;
    byte          MsgAttr,
                  NetAttr,
                  ExtAttr;
    longint       PostTimeDate,             // DOS Format Packed DateTime
                  RecvTimeDate;             // DOS Format Packed DateTime
    UserString    WhoTo,
                  WhoFrom;
    char          Subject[73];
  } MsgHdrRecord;

/**********************************************************

  FileName:     <msgpath>\AREA<<area-1>/100+1>\MT<area>.BBS
                eg: \ezy\msgbase\area1\mt00001.bbs     for area 1
                eg: \ezy\msgbase\area10\mt01001.bbs    for area 1001
                eg: \ezy\msgbase\area100\mt10001.bbs   for area 10001

  Description:  Used by Ezycom to store message text

 **********************************************************/

   /* Message Text

          Each text part of the message starts at 'startposition',
     and continues on until a NULL terminator is found, or end
     of file is reached (shouldn't happen, but just in case).
     Each message is contained of plain text, with 0x08D
     terminators for wrapped lines or 0x0D terminators for hard
     carriage returns.  No line of text should exceed 79 characters
     excluding the terminator */

/**********************************************************

  FileName:     <msgpath>MSGFAST.BBS

  Description:  Used by Ezycom for mail checks

 **********************************************************/

  typedef struct MsgFastRecord {
    longint      WhoTo;		       // standard 32 Bit CRC on whoto in
                                       // MH???.BBS Username is CRCd in
                                       // UPPERCASE, and does not include
                                       // null terminator or length byte
    word         MsgBoard,
                 MsgNumber;
  } MsgFastRecord;


#endif
