/* Functions for the External menu */
/* Last updated 20 September 1996  */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dir.h>
#include "execute.h"
#include "menus.h"
#include "extmenu.h"
#include "config.h"
#include "utility2.h"
#include "crc.h"
#include "menus.h"
#include "amuidx.h"

/* external objects */
extern class Utility2 Utility2_obj;
extern class Config Config_obj;
extern class Crc Crc_obj;
extern class Menus Menus_obj;

int ExtMenu::menu(void)
{
    int i;
    struct coordinates cvar;

    cvar.uses_blanks = FALSE;
    cvar.items = 15;
    cvar.width = 24;
    cvar.left = 45;
    cvar.top = 9;
    cvar.high_num = 0;
    cvar.position = 1;
    cvar.title = NULL;
    cvar.options = options();
    do
    {
	Menus_obj.set_help(NO_HELP);
	Menus_obj.help("External utility configuration");
	i = Menus_obj.display_menu(&cvar, 3);
        switch(i)
	{
	    case ENTER: action(cvar.position);
			break;
	    case F1   : Menus_obj.online_help(EXTERNAL_UTILITY);
			break;
	}
    }while(i != ESC);
    return(i);
}

char *ExtMenu::options(void)
{
    static char str[100];
    strcpy(str, "ARC;ARJ;HAP;LZH;PAK;SQZ;ZIP;ZOO;UC2;RAR;Virus 1;Virus 2;Virus 3;Virus 4;Virus 5;");
    return(str);
}

void ExtMenu::action(int position)
{
    char *tmpbuf;

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    Archiver_obj.menu(position);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/**************************************************************************/

int ExtMenu_archivers::menu(int position)
{
    int i;
    char *tmpbuf, str[21];
	 
    cvar.uses_blanks = TRUE;
    cvar.items = 10;
    cvar.width = 65;
    cvar.left = 8;
    cvar.top = 8;
    cvar.position = 2;
    cvar.high_num = 20;

    strcpy(str, "Archivers");
    if(position <= 10)
    {
	Menus_obj.set_help(ARCHIVER_HELP);
	dos_arc = Config_obj.amu_cfgvar.archivers[position-1].dos_arc;
	dos_unarc = Config_obj.amu_cfgvar.archivers[position-1].dos_unarc;
	dos_arcparam = Config_obj.amu_cfgvar.archivers[position-1].dos_arcparam;
	dos_unarcparam = Config_obj.amu_cfgvar.archivers[position-1].dos_unarcparam;
	os2_arc = Config_obj.amu_cfgvar.archivers[position-1].os2_arc;
	os2_unarc = Config_obj.amu_cfgvar.archivers[position-1].os2_unarc;
	os2_arcparam = Config_obj.amu_cfgvar.archivers[position-1].os2_arcparam;
	os2_unarcparam = Config_obj.amu_cfgvar.archivers[position-1].os2_unarcparam;
    }
    if(position > 10)
    {
	Menus_obj.set_help(SCANNER_HELP);
	dos_arc = Config_obj.amu_cfgvar.scanners[position-11].dos_scanner;
	dos_arcparam = Config_obj.amu_cfgvar.scanners[position-11].dos_parameters;
	dos_unarc = Config_obj.amu_cfgvar.scanners[position-11].dos_path;
	dos_unarcparam = Config_obj.amu_cfgvar.scanners[position-11].dos_viruslevel;
	os2_arc = Config_obj.amu_cfgvar.scanners[position-11].os2_scanner;
	os2_arcparam = Config_obj.amu_cfgvar.scanners[position-11].os2_parameters;
	os2_unarc = Config_obj.amu_cfgvar.scanners[position-11].os2_path;
	os2_unarcparam = Config_obj.amu_cfgvar.scanners[position-11].os2_viruslevel;
	strcpy(str, "Virus scanner");
    }

    cvar.title = str;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    do
    {
	cvar.options = options(position);
	i = Menus_obj.display_menu(&cvar, 1);
	switch(i)
	{
            case ENTER: action(cvar.position);
                        break;
	    case F1   : Menus_obj.online_help(EXTERNAL_UTILITY);
			break;
	}
    }while(i != ESC);
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    return(i);
}

char *ExtMenu_archivers::options(int position)
{
    strcpy(optionsstr, "  ;");

    if(position <= 10)
    {
	mode = ARCHIVER;

	strcat(optionsstr, "DOS Compressor       : ");
	strcat(optionsstr, dos_arc);
	strcat(optionsstr, ";");

	strcat(optionsstr, " Parameters         : ");
	strcat(optionsstr, dos_arcparam);
	strcat(optionsstr, ";");

	strcat(optionsstr, "DOS Decompressor     : ");
	strcat(optionsstr, dos_unarc);
	strcat(optionsstr, ";");

	strcat(optionsstr, " Parameters         : ");
	strcat(optionsstr, dos_unarcparam);
	strcat(optionsstr, ";");

	strcat(optionsstr, "OS/2 Compressor      : ");
	strcat(optionsstr, os2_arc);
	strcat(optionsstr, ";");

	strcat(optionsstr, " Parameters         : ");
	strcat(optionsstr, os2_arcparam);
	strcat(optionsstr, ";");

	strcat(optionsstr, "OS/2  Decompressor   : ");
	strcat(optionsstr, os2_unarc);
	strcat(optionsstr, ";");

	strcat(optionsstr, " Parameters         : ");
	strcat(optionsstr, os2_unarcparam);
	strcat(optionsstr, ";");
    }

    if(position >= 11)
    {
	mode = SCANNER;

	strcat(optionsstr, "DOS virus scanner    : ");
	strcat(optionsstr, dos_arc);
	strcat(optionsstr, ";");

	strcat(optionsstr, " Parameters         : ");
	strcat(optionsstr, dos_arcparam);
	strcat(optionsstr, ";");

	strcat(optionsstr, "Path to DOS scanner  : ");
	strcat(optionsstr, dos_unarc);
	strcat(optionsstr, ";");

	strcat(optionsstr, "DOS virus errorlevel : ");
	strcat(optionsstr, dos_unarcparam);
	strcat(optionsstr, ";");

	strcat(optionsstr, "OS/2 virus scanner   : ");
	strcat(optionsstr, os2_arc);
	strcat(optionsstr, ";");

	strcat(optionsstr, " Parameters         : ");
	strcat(optionsstr, os2_arcparam);
	strcat(optionsstr, ";");

	strcat(optionsstr, "Path to OS/2 scanner : ");
	strcat(optionsstr, os2_unarc);
	strcat(optionsstr, ";");

	strcat(optionsstr, "OS2 virus errorlevel : ");
	strcat(optionsstr, os2_unarcparam);
	strcat(optionsstr, ";");
    }

    strcat(optionsstr, "  ;");
    return(optionsstr);
}

void ExtMenu_archivers::action(int position)
{
    int offset = 25;
	 
    switch(position)
    {
	case 2: Menus_obj.set_validtype(FILENM);
		strcpy(dos_arc, Menus_obj.getfield(dos_arc, cvar.left + offset, cvar.top + position, 12));
		break;
	case 3: Menus_obj.set_validtype(SPACES_OK);
		strcpy(dos_arcparam, Menus_obj.getfield(dos_arcparam, cvar.left + offset, cvar.top + position, 41));
		break;
	case 4: if(mode == ARCHIVER)
		{
		    Menus_obj.set_validtype(FILENM);
		    strcpy(dos_unarc, Menus_obj.getfield(dos_unarc, cvar.left + offset, cvar.top + position, 12));
		}
		else
		{
		    Menus_obj.set_validtype(PATH);
		    strcpy(dos_unarc, Menus_obj.getfield(dos_unarc, cvar.left + offset, cvar.top + position, 41));
		}
		break;
	case 5: if(mode == ARCHIVER)
		{
		    Menus_obj.set_validtype(SPACES_OK);
		    strcpy(dos_unarcparam, Menus_obj.getfield(dos_unarcparam, cvar.left + offset, cvar.top + position, 41));
		}
		else
		{
		    Menus_obj.set_validtype(RANGE_1);
		    strcpy(dos_unarcparam, Menus_obj.getfield(dos_unarcparam, cvar.left + offset, cvar.top + position, 3));
		}
		break;
	case 6: Menus_obj.set_validtype(FILENM);
		strcpy(os2_arc, Menus_obj.getfield(os2_arc, cvar.left + offset, cvar.top + position, 12));
		break;
	case 7: Menus_obj.set_validtype(SPACES_OK);
		strcpy(os2_arcparam, Menus_obj.getfield(os2_arcparam, cvar.left + offset, cvar.top + position, 41));
		break;
	case 8: if(mode == ARCHIVER)
		{
		    Menus_obj.set_validtype(FILENM);
		    strcpy(os2_unarc, Menus_obj.getfield(os2_unarc, cvar.left + offset, cvar.top + position, 12));
		}
		else
		{
		    Menus_obj.set_validtype(PATH);
		    strcpy(os2_unarc, Menus_obj.getfield(os2_unarc, cvar.left + offset, cvar.top + position, 41));
		}
		break;
	case 9: if(mode == ARCHIVER)
		{
		    Menus_obj.set_validtype(SPACES_OK);
		    strcpy(os2_unarcparam, Menus_obj.getfield(os2_unarcparam, cvar.left + offset, cvar.top + position, 41));
		}
		else
		{
		    Menus_obj.set_validtype(RANGE_1);
		    strcpy(os2_unarcparam, Menus_obj.getfield(os2_unarcparam, cvar.left + offset, cvar.top + position, 3));
		}
		break;
    }
}

/************************************************************************/


/* EOF - EXTMENU.CPP */
