// General structures and defines for AMU
// Created 23 July 1994
// Revised 10 October 1998

#if !defined(__EXTERN__)

#define __EXTERN__

#define byte  unsigned char
#define word  unsigned short
#define dword unsigned long

typedef enum{false=0,true=1}boolean;

//#define __AMUKEY__
//#define AMUCFG
#define __AMUONLY__

//#define __AMU16__
//#define __AMU32__
//#define __AMU2__
#define __AMU95__

#define __DOS__

#if defined(__AMU16__)
#define PLATFORM "DOS Version"
#endif

#if defined(__AMU32__)
#define PLATFORM "DPMI Version"
#endif

#if defined(__AMU2__)
#define PLATFORM "OS/2 Version"
#endif

#if defined(__AMU95__)
#define PLATFORM "Windows Version"
#endif

#include "spawno.h"


/* Global structures and defines */

#define VERSION "3.20"     // Current version
#define BIT_TOGGLE ^= 1
#define BBS_LOG              0  // Denotes a BBS logfile
#define MAILER_LOG           1  // Denotes a mailer logfile
#define TRUE                 1  // True
#define FALSE                0  // False
#define MAX_SCANNERS         5  // Maximum number of virus scanners

#define MAX_DESC_SIZE 2049      /* Maximum description length       */
#define MAX_FILESPEC  256       /* Maximum length of a filespec     */

#define DEFAULT_LISTSTR " @FILENAME<<<<@ @SIZE>>>>>@ @DATE@ @DLS@ @DESC@"

#if defined(__AMU2__) || defined(__AMU95__)
  #define MAX_FILENAME  256       /* Maximum length of a filename     */
#else
  #define MAX_FILENAME 13
#endif

#define COMMENT_TXT "COMMENT.TXT"  // Comment file for archives

/* Methods in which the Sorting of file listings may be performed */
#define SORT_NORMAL      0    // Sort A-Z
#define SORT_REVERSE     1    // Sort Z-A
#define SORT_NORMAL_NEW  2    // Sort A-Z with new files first
#define SORT_NORMAL_OLD  3    // Sort A-Z with old files first
#define SORT_REVERSE_NEW 4    // Sort Z-A with new files first
#define SORT_REVERSE_OLD 5    // Sort Z-A with old files first

/* Number of supported BBS's and Mailers */
#define NUM_BBS  16             // Number of BBS types
#define NUM_MAIL 9              // Number of mailer types
#define NUM_LOG  21             // Number of logfile types

/* Types of BBS's */
#define RA2      0              // RA 2.02
#define SBBS     1              // SBBS 1.17
#define QBBS     2              // QBBS 2.76
#define RA250    3              // RA 2.50
#define RA1      4              // RA 1.11
#define QBBSC    5              // QBBS 2.80 - Classic
#define QBBSG    6              // QBBS 2.80 - Goldbase
#define CONCORD  8              // Concord O.O1
#define PB2      9              // ProBoard 2.12
#define LORA     10             // Lora 2.40
#define MAXIMUS2 11             // Maximus 2.00
#define MAXIMUS3 12             // Maximus 3.00
#define LORA3    13             // LoraBBS 3.00
#define EZ       15             // EzyCom 1.48
#define TG3      16             // TeleGard 3.02
#define TG310    17             // TeleGard 3.10

/* Types of mailers */
#define NOMAIL 0                // No mailer used
#define FD     1                // FrontDoor
#define DB     2                // D'Bridge
#define BT     3                // BinkleyTerm
#define IM     4                // InterMail
#define POP    5                // Portal Of Power
#define MD     6                // MainDoor
#define LORAM  7                // Lora
#define XENIA  8                // Xenia
#define MCMAIL 9                // McMail

/* Types of logfiles */
#define RA_L      0             // RemoteAccess
#define QBBS_L    1             // QuickBBS
#define SBBS_L    2             // SuperBBS
#define PB_L      3             // ProBoard
#define FD_L      5             // FrontDoor
#define IM_L      6             // InterMail
#define DB_L      7             // D'Bridge
#define BT_L      8             // BinkleyTerm
#define POP_L     9             // Portal of Power
#define SX_L      10            // Silver Express
#define BW_L      11            // BlueWave
#define JC_L      12            // JC-QWK
#define CONCORD_L 13            // Concord
#define LORA_L    15            // Lora
#define MD_L      16            // MainDoor
#define MAX_L     17            // Maximus
#define XENIA_L   18            // Xenia
#define MCMAIL_L  19            // McMail
#define OLMS_L    20            // OLMS
#define EZ_L      21            // EzyCom
#define TG_L      22            // TeleGard

/* Define the archive types */
#define ARC 0
#define ARJ 1
#define HAP 2
#define LZH 3
#define PAK 4
#define SQZ 5
#define ZIP 6
#define ZOO 7
#define UC2 8
#define RAR 9
#define SFX 50
#define NUM_ARC_FORMATS 10
#define UNKNOWN -1

/* Define BIT values */
#define BIT0  1
#define BIT1  2
#define BIT2  4
#define BIT3  8
#define BIT4  16
#define BIT5  32
#define BIT6  64
#define BIT7  128
#define BIT8  256
#define BIT9  512
#define BIT10 1024
#define BIT11 2048
#define BIT12 4096
#define BIT13 8192
#define BIT14 16384
#define BIT15 32768

/* Define errorlevel constants */
#define NO_ERRORS   0           // Normal termination
#define NO_CONFIG   1           // Error with the configuration file
#define NO_ENV      2           // AMU or COMPSEC variable not set
#define BAD_PARAMS  3           // Bad parameter list

/* Define the various combinations of swapping available */
#define MODE_1 (SWAP_ANY)
#define MODE_2 (SWAP_EMS | SWAP_XMS)
#define MODE_3 (SWAP_DISK)

#endif
/***********************************************************************/
/* EOF - EXTERN.H */
