// Functions for the Execute object
// Created 05 June 1995
// Revised 13 January 1998

#include <stdio.h>
#include <process.h>
#include <stddef.h>
#include <string.h>
#include <malloc.h>
#include <conio.h>
#include <stdlib.h>
#include <share.h>
#include <dos.h>
#include <io.h>
#include "extern.h"
#include "screen.h"
#include "config.h"
#include "msgs.h"
#include "execute.h"

/* external variables */
extern class Config Config_obj;
extern class Screen Screen_obj;

#if defined(__AMU32__)
unsigned __near __minreal = 100 * 1024;
#endif

/***********************************************************************/
/* Constructor for the Execute class */
Execute::Execute(void)
{
    char *ptr;

    ptr = getenv("COMSPEC");

    /* Get the COMSPEC variable */
    if(ptr == NULL)
    {
        #if defined(__DOS__)
	strcpy(Comspec, "C:\\COMMAND.COM");
	#endif

	#if defined(__OS2__)
	strcpy(Comspec, "C:\\OS2\\CMD.EXE");
	#endif
    }
    else
    {
	strcpy(Comspec, getenv("COMSPEC"));
    }
    strupr(Comspec);
}

/***********************************************************************/
/* Execute a child process while swapping */
int Execute::execute(char *fn, char *params, int report_child)
{
    char param[MAX_FILESPEC], *tmpbuf, str[151];
    int i;
#if defined(__OS2__)
    FILE *cmdfile, *exefile;
    char cmdname[MAX_FILESPEC], buffer[4];
    int use_cmd;
#endif

    /* If the filename given is null, get out of here */
    if(!*fn)
    {
        return(1);
    }
    strcpy(param, params);

    sprintf(str, "Executing: '%s %s'", fn, params);
    tmpbuf = (char *)malloc(4000);
    Screen_obj.getscreen(tmpbuf);
    Screen_obj.clearscreen();
    Screen_obj.writestr(1, 1, 12, str);

#if defined(__OS2__)

   /* If this is not an OS/2 executable, use a .CMD file to execute it */
    use_cmd = TRUE;
    exefile = _fsopen(fn, "rb", SH_DENYNO);
    if(exefile)
    {
        fread(buffer, 3, 1, exefile);
        fclose(exefile);
        buffer[3] = NULL;
        if(strstr(buffer, "MZP"))
        {
            use_cmd = FALSE;
        }
    }
    if(use_cmd)
    {
        sprintf(cmdname, "%sEXECUTE.CMD", Config_obj.amu_cfgvar.AMUpath);
        cmdfile = _fsopen(cmdname, "w+t", SH_DENYRW);
        fprintf(cmdfile, "%s %s\n", fn, param);
        fclose(cmdfile);
        sprintf(param, "/c %s", cmdname);
        i = spawnlp(P_WAIT, Comspec, Comspec, param, NULL);
        remove(cmdname);
    }
    else
    {
	i = spawnlp(P_WAIT, fn, fn, param, NULL);
    }
#else
    i = spawnlp(P_WAIT, Comspec, Comspec, "/c", fn, param, NULL);
#endif

    /* If an error occured, report it in the logfile */

    if(i == -1)
    {
        sprintf(LOGSTR, "! Error executing '%s' - (%s)", fn, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
    }

    if(i > 0  &&  report_child)
    {
        /* If COMMAND.COM returns level 1, ignore it */
        if( i == 1  &&  strstr(fn, Comspec))
        {
        }
        else
        {
            sprintf(LOGSTR, " - %s returned errorlevel %d on [%s %s]", fn, i, fn, params);
            Utility_obj.logentry(LOGSTR, LOG_NORMAL);
        }
    }
    Screen_obj.putscreen(tmpbuf);
    Screen_obj.hide_cursor();
    free(tmpbuf);
    return(i);
}

/************************************************************************/
/* Handle the compression of file(s) */
int Execute::compress(char *name, char *target, int arctype)
{
    int status;
    char fn[MAX_FILESPEC], param[MAX_FILESPEC];

    if(arctype < NUM_ARC_FORMATS)
    {
        #ifdef __DOS__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].dos_arc);
        sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].dos_arcparam,
                name);
        #endif

        #ifdef __OS2__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].os2_arc);
        sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].os2_arcparam,
                name);
        #endif
    }
    strncat(param, target, sizeof(param) - strlen(param) - 1);
    status = execute(fn, param, TRUE);
    return(status);
}

/**********************************************************************/
/* Handle the compression of file(s), target is a list file*/
int Execute::compress_list(char *name, char *target, int arctype)
{
    int status;
    char newtarget[MAX_FILESPEC], fn[MAX_FILESPEC], param[MAX_FILESPEC];

    strncpy(newtarget, target, sizeof(newtarget)-1);
    if(arctype == ARJ)
    {
        /* ARJ uses a '!' to indicate a list file */
        newtarget[0] = '!';
    }
    if(arctype < NUM_ARC_FORMATS)
    {
        #ifdef __DOS__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].dos_arc);
        sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].dos_arcparam,
                name);
        #endif

        #ifdef __OS2__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].os2_arc);
        if(arctype == ZIP && strcmp(Config_obj.amu_cfgvar.archivers[arctype].os2_arc, "ZIP.EXE") == 0)
        {
            sprintf(param, "%s -@ %s ", Config_obj.amu_cfgvar.archivers[arctype].os2_arcparam,
                    name);
            newtarget[0] = '<';
        }
        else
        {
            sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].os2_arcparam,
                    name);
        }
        #endif
    }
    strncat(param, newtarget, sizeof(param) - strlen(param) - 1);
    status = execute(fn, param, TRUE);
    return(status);
}

/************************************************************************/
/* Decompress the entire archive */
int Execute::decompress_all(char *name, int arctype)
{
    char fn[MAX_FILESPEC], param[MAX_FILESPEC];
    int status;
    struct find_t fileinfo;

    /* Get the amount of free disk-space.  If the free diskspace is
       less than three times the size of the file being unarced, abort */
    _dos_findfirst(name, _A_ARCH, &fileinfo);
    if(!Utility_obj.disk_ok(fileinfo.size * 3, ""))
    {
        sprintf(LOGSTR, "! Not enough free space to decompress '%s'", name);
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(1);
    }

    if(arctype < NUM_ARC_FORMATS)
    {
        #ifdef __DOS__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].dos_unarc);
        sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].dos_unarcparam,
                name);
        #endif

        #ifdef __OS2__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].os2_unarc);
        sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].os2_unarcparam,
                name);
        #endif
    }
    status = execute(fn, param, TRUE);
    return(status);
}

/***********************************************************************/
/* Handle the decompression of individual files */
int Execute::decompress_some(char *name, char *target, int arctype)
{
    char fn[MAX_FILESPEC], param[MAX_FILESPEC];
    int status;
    struct find_t fileinfo;

    _dos_findfirst(name, _A_ARCH, &fileinfo);
    if(!Utility_obj.disk_ok(fileinfo.size * 3, ""))
    {
        sprintf(LOGSTR, "! Not enough free space to decompress '%s'", name);
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(1);
    }

    if(arctype < NUM_ARC_FORMATS)
    {
        #ifdef __DOS__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].dos_unarc);
        sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].dos_unarcparam,
                name);
        #endif

        #ifdef __OS2__
        sprintf(fn, "%s", Config_obj.amu_cfgvar.archivers[arctype].os2_unarc);
        sprintf(param, "%s %s ", Config_obj.amu_cfgvar.archivers[arctype].os2_unarcparam,
                name);
        #endif
    }
    strncat(param, target, sizeof(param) - strlen(param) - 1);
    status = execute(fn, param, FALSE);
    return(status);
}

/***********************************************************************/
/* Scan files in the current directory for viruses, return TRUE if
   the scanner returns the 'viruslevel', FALSE otherwise */
int Execute::virus_scan(int x, char *fname)
{
    FILE *txtfile;
    int status;
#ifdef __AMUONLY__
    struct msgpostinfo msgpostvar;
    class Msgs *Msgs_ptr;
#endif
    char param[MAX_FILESPEC], fn[MAX_FILESPEC];

    status = FALSE;
    #ifdef __DOS__
    if(!Config_obj.amu_cfgvar.scanners[x].dos_scanner[0])
    {
        return(FALSE);
    }
    sprintf(param, "%s *.*", Config_obj.amu_cfgvar.scanners[x].dos_parameters);
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.scanners[x].dos_path,
            Config_obj.amu_cfgvar.scanners[x].dos_scanner);
    if(execute(fn, param, FALSE) == atoi(Config_obj.amu_cfgvar.scanners[x].dos_viruslevel))
    {
        status = TRUE;
    }
    #endif

    #ifdef __OS2__
    if(!Config_obj.amu_cfgvar.scanners[x].os2_scanner[0])
    {
        return(FALSE);
    }
    sprintf(param, "%s *.*", Config_obj.amu_cfgvar.scanners[x].os2_parameters);
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.scanners[x].os2_path,
            Config_obj.amu_cfgvar.scanners[x].os2_scanner);
    if(execute(fn, param, FALSE) == atoi(Config_obj.amu_cfgvar.scanners[x].os2_viruslevel))
    {
	status = TRUE;
    }
    #endif

    if(status)
    {
	sprintf(fn, "%s%s", Config_obj.amu_cfgvar.workpath, "AMUVIRUS.MSG");
	txtfile = fopen(fn, "w+t");
	fprintf(txtfile, "At the post time of this message, scanner #%d returned the\n", x);
	fprintf(txtfile, "errorlevel defined to indicate a virus was found in '%s'.\n", fname);
	fprintf(txtfile, "\n\n--- AMU %s", VERSION);
	fclose(txtfile);

#if !defined(AMUCFG)
	Msgs_ptr = new Msgs();
	Config_obj.read_record(MSGAREA_RECORD, Config_obj.amu_cfgvar.amu_area);
	msgpostvar.area = &Config_obj.msgareavar;
	strcpy(msgpostvar.to, Config_obj.amu_cfgvar.sysop);
	strcpy(msgpostvar.from, "AMU");
	strcpy(msgpostvar.subject, "Possible virus found!");
	strcpy(msgpostvar.fn, fn);
	Msgs_ptr->post_msg(&msgpostvar, NULL);
	remove(fn);
	delete(Msgs_ptr);
#endif
    }
    return(status);
}

/***********************************************************************/
/* Add comments to archives */
int Execute::add_comment(char *name, int arctype, char *txtfile)
{
    char param[129];

    switch(arctype)
    {
#ifdef __OS2__
        case ARJ: sprintf(param, "/c %s c -s1 %s -z%s", Config_obj.amu_cfgvar.archivers[ARJ].os2_arc,
                          name, txtfile);
                  break;
        case RAR: sprintf(param, "/c %s c %s =%s", Config_obj.amu_cfgvar.archivers[RAR].os2_arc,
                          name, txtfile);
                  break;
        case ZIP: sprintf(param, "/c ZIP.EXE -z %s < %s", name, txtfile);
                  break;
#endif

#ifdef __DOS__
        case ARJ: sprintf(param, "/c %s c -s1 %s -z%s", Config_obj.amu_cfgvar.archivers[ARJ].dos_arc,
                          name, txtfile);
                  break;
        case RAR: sprintf(param, "/c %s c %s =%s", Config_obj.amu_cfgvar.archivers[RAR].dos_arc,
                          name, txtfile);
                  break;
	case ZIP: sprintf(param, "/c PKZIP.EXE -) -k %s -z < %s", name, txtfile);
                  break;
#endif
    }
    return(execute(Comspec, param, FALSE));
}

/***********************************************************************/
/* Execute some other program */
int Execute::general_exec(char *name, char *params)
{
    char param[MAX_FILESPEC], tmpfn[MAX_FILESPEC], *ptr;
    int use_cmd;

    param[0] = NULL;
    use_cmd = TRUE;
    strcpy(tmpfn, name);
    if(name[0])
    {
        strupr(name);
        if(strchr(name, '.'))
        {
            if(strstr(name, ".EXE"))
            {
                use_cmd = FALSE;
            }
            if(strstr(name, ".COM"))
            {
                use_cmd = FALSE;
            }
        }
        else
        {
            sprintf(tmpfn, "%s.EXE", name);
            if(access(tmpfn, 0) == 0)
            {
                use_cmd = FALSE;
            }
            if(use_cmd)
            {
                sprintf(tmpfn, "%s.COM", name);
                if(access(tmpfn, 0) == 0)
                {
                    use_cmd = FALSE;
                }
            }
            if(use_cmd)
            {
                strcpy(tmpfn, name);
                strrev(tmpfn);
                ptr = strchr(tmpfn, '\\');
                if(ptr)
                {
                    *ptr = NULL;
                }
                strrev(tmpfn);
            }
        }
    }

    if(use_cmd == TRUE)
    {
        sprintf(param, "/c %s %s", tmpfn, params);
        return(execute(Comspec, param, TRUE));
    }
    return(execute(tmpfn, params, TRUE));
}

/***********************************************************************/
// EOF - EXECUTE.CPP

