/* Menu to allow editting of the CTL files */
/* Created 19 April 1996                   */
/* Last updated 27 April 1996              */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include "editmenu.h"
#include "config.h"
#include "menus.h"
#include "execute.h"
#include "listbox.h"
#include "utility.h"

extern char curdir[256];
extern class Utility Utility_obj;
extern class ListBox ListBox_obj;
extern class Menus Menus_obj;
extern class Config Config_obj;
extern class Execute Execute_obj;

/************************************************************************/
void EditMenu::menu(void)
{
    listbox *editlistbox, listboxitem, *listboxitemptr;
    char filename[81];
    int x;

    editlistbox = ListBox_obj.create_listbox();
    listboxitem.itemnum = 0;

    sprintf(listboxitem.itemname, "%sNOADOPT.CTL", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sCARRIER.CTL", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sTRASH.CTL", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sADD.CTL", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sLOCKED.CTL", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sCOMMENT.TXT", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sAMU.HDR", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sNOPOST.CTL", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    sprintf(listboxitem.itemname, "%sSEMAPHOR.CTL", Config_obj.amu_cfgvar.AMUpath);
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    /* Get the information from the Allfiles */
    Config_obj.open_config(ALLFILE_RECORD);
    for(x = 1; x <= Config_obj.num_lists; x++)
    {
	Config_obj.read_record(ALLFILE_RECORD, x);
	if(!Config_obj.allnewvar.enabled)
	{
	    continue;
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.allnewvar.main_hdr);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.allnewvar.main_ftr);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.allnewvar.area_hdr);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.allnewvar.area_ftr);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}
    }
    Config_obj.close_config(ALLFILE_RECORD);

    /* Get the information from the Enforce */
    Config_obj.open_config(ENFORCE_RECORD);
    for(x = 1; x <= Config_obj.num_enforce; x++)
    {
	Config_obj.read_record(ENFORCE_RECORD, x);
	if(!Config_obj.enforcevar.enabled)
	{
	    continue;
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.enforcevar.user_fn);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.enforcevar.sysop_fn);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}
    }
    Config_obj.close_config(ENFORCE_RECORD);

    /* Get the information from the Bulletins */
    Config_obj.open_config(BULLETIN_RECORD);
    for(x = 1; x <= Config_obj.num_bulletin; x++)
    {
	Config_obj.read_record(BULLETIN_RECORD, x);
	if(!Config_obj.bulletinvar.enabled || Config_obj.bulletinvar.type != BULL_DOORS)
	{
	    continue;
	}

	sprintf(listboxitem.itemname, "%s%s.CTL", Config_obj.amu_cfgvar.AMUpath, Config_obj.bulletinvar.datafname);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}
    }
    Config_obj.close_config(BULLETIN_RECORD);

    /* Get the information from the User Messages */
    Config_obj.open_config(USERMSGS_RECORD);
    for(x = 1; x <= Config_obj.num_usermsgs; x++)
    {
	Config_obj.read_record(USERMSGS_RECORD, x);
	if(!Config_obj.usermsgsvar.enabled)
	{
	    continue;
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.usermsgsvar.user_fn);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.usermsgsvar.sysop_fn);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}
    }
    Config_obj.close_config(USERMSGS_RECORD);

    /* Get the information from the Maintenance */
    Config_obj.open_config(MAINT_RECORD);
    for(x = 1; x <= Config_obj.num_maint; x++)
    {
	Config_obj.read_record(MAINT_RECORD, x);
	if(!Config_obj.maintvar.enabled)
	{
	    continue;
	}

	sprintf(listboxitem.itemname, "%s", Config_obj.maintvar.fname);
	if(!ListBox_obj.item_exists(editlistbox, listboxitem.itemname))
	{
	    listboxitem.itemnum++;
	    ListBox_obj.additem(&listboxitem, &editlistbox);
	}
    }
    Config_obj.close_config(MAINT_RECORD);

    sprintf(listboxitem.itemname, "Other");
    listboxitem.itemnum++;
    ListBox_obj.additem(&listboxitem, &editlistbox);

    do
    {
	x = ListBox_obj.display_listbox(editlistbox, "Select file to edit", 50);
        if(x != -1)
        {
            filename[0] = NULL;
            if(x == ListBox_obj.item_count(editlistbox))
            {
                get_filename(filename);
            }
            else
            {
                listboxitemptr = ListBox_obj.get_item(editlistbox, x);
                strcpy(filename, listboxitemptr -> itemname);
            }
            if(filename[0])
            {
#if defined(__AMU2__)
                Execute_obj.general_exec(Config_obj.amu_cfgvar.os2editor, filename);
#endif
#if defined(__AMU16__)
                Execute_obj.general_exec(Config_obj.amu_cfgvar.doseditor, filename);
#endif
		Utility_obj.change_dir(curdir);
                _setcursortype(_NOCURSOR);
            }   
        }
    }while(x != -1);
    ListBox_obj.destroy_listbox(&editlistbox);
}

void EditMenu::get_filename(char *filename)
{
    char *tmpbuf, str[400];
    class Menus Menus_obj;
    struct coordinates cvar;

    cvar.uses_blanks = TRUE;
    cvar.items = 5;
    cvar.width = 55;
    cvar.left = 12;
    cvar.top = 8;
    cvar.position = 4;
    cvar.high_num = 0;
    cvar.title = NULL;
    strcpy(str, " ;     Enter the filename to edit:              ; ; ; ;");

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    cvar.options = str;
    Menus_obj.dialog(&cvar, DEL, 1);
    Menus_obj.set_validtype(FILENM);
    *filename = NULL;
    strcpy(filename, Menus_obj.getfield(filename, cvar.left + 7, cvar.top + 4, 40));
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    textcolor(LIGHTGRAY);
    textbackground(BLACK);
}

/***********************************************************************/
/* EOF - EDITMENU.CPP */
