/* Class definition for DateTime */
/* Created 12 June 1994             */
/* Revised 14 May 1997              */

#if !defined(__DATETIME__)
#define __DATETIME__

    struct dat
    {
	unsigned short day: 5,
		       month: 4,
		       year: 7;
    };

    struct tim
    {
	unsigned short seconds: 5,
		       minutes: 6,
		       hours: 5;
    };

    union date_rec
    {
	struct dat datevar;
	unsigned short date;
    };

    union time_rec
    {
	struct tim timevar;
	unsigned short time;
    };

	union bbstimedate
	{
	    struct
	    {
		union time_rec time;
		union date_rec date;
	    }t1;
	    long t2;
	};

class DateTime
{
   /* Private data */
    private:
    int days_since_1980;
    char sep;

    public:
    short months[12];

    public:
    DateTime(void);
    void set_separator(char x) { sep = x; }
    char *curdate(int mode);
    char *curtime(void);
    int get_year(void);
    int get_day(void);
    int get_month(void);
    char *get_monthname(void);
    char *get_dayname(void);
    int file_age(unsigned short date);
    char *getdatestr(int mode, short date);
    int get_julian(void);
    char *curdate_fn(int type);
    char *fido_date(void);
    char *calc_date(int start_year, long num_days);
    char *getloradate(char *datestr);
    char *putloradate(int day, int month, int year);
    int date_diff(int month, int day, int year);
    short Date2Word(short yy, short mm, short dd);
};
#endif

/**********************************************************************/
/* EOF - DATETIME.H */
