/* Functions for the DateTime class */
/* Created 12 June 1994             */
/* Revised 14 May 1997              */

#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include "datetime.h"

/*********************************************************************/
/* Constructor for the DateTime object */
DateTime::DateTime(void)
{
    int i;
    struct dosdate_t d;

    months[0] = 31;
    months[1] = 28;
    months[2] = 31;
    months[3] = 30;
    months[4] = 31;
    months[5] = 30;
    months[6] = 31;
    months[7] = 31;
    months[8] = 30;
    months[9] = 31;
    months[10] = 30;
    months[11] = 31;

    _dos_getdate(&d);

    /* See if this is a leap year */
    if((d.year % 4) == 0)
    {
        months[1] = 29;
    }

    /* Calculate how many days it is since 1980 */
    days_since_1980 = ((d.year - 1980) * 365);
    d.month--;
    for(i = 0; i < d.month; i++)
    {
        days_since_1980 += months[i];
    }
    days_since_1980 += d.day;
    sep = '-';
}

/************************************************************************/
/* Return todays date */
char *DateTime::curdate(int mode)
{
    static char date[9];
    struct dosdate_t d;

    _dos_getdate(&d);
    d.year -= 1900;
    if(d.year > 99)
    {
        d.year -= 100;
    }
      /*
         -1 - mmddyy
         0  - mmddyy
         1  - mmyydd
         2  - ddmmyy
         3  - ddyymm
         4  - yymmdd
         5  - yyddmm
      */

    switch(mode)
    {
	case -1: sprintf(date, "%02d%c%02d%c%02d", d.month, sep, d.day, sep, d.year);
		 break;
	case 0: sprintf(date, "%02d%c%02d%c%02d", d.month, sep, d.day, sep, d.year);
		break;
	case 1: sprintf(date, "%02d%c%02d%c%02d", d.month, sep, d.year, sep, d.day);
		break;
	case 2: sprintf(date, "%02d%c%02d%c%02d", d.day, sep, d.month, sep, d.year);
		break;
	case 3: sprintf(date, "%02d%c%02d%c%02d", d.day, sep, d.year, sep, d.month);
		break;
	case 4: sprintf(date, "%02d%c%02d%c%02d", d.year, sep, d.month, sep, d.day);
		break;
	case 5: sprintf(date, "%02d%c%02d%c%02d", d.year, sep, d.day, sep, d.month);
		break;
    }
    return(date);
}

/***********************************************************************/
/* Return the current time */
char *DateTime::curtime(void)
{
    struct dostime_t t;
    static char time[6];

    _dos_gettime(&t);
    sprintf(time, "%02d:%02d", t.hour, t.minute);
    return(time);
}

/************************************************************************/
/* Return the age of a file */
int DateTime::file_age(unsigned short date)
{
    int age2, i, j;
    union date_rec datevar;

    datevar.date = date;
    /* Calculate how many days it is since 1980, relative to the file's timestamp */
    age2 = ((datevar.datevar.year) * 365);
    j = datevar.datevar.month - 1;
    for(i = 0; i < j; i++)
    {
        age2 += months[i];
    }
    age2 += datevar.datevar.day;

    return(abs(days_since_1980 - age2));
}

/************************************************************************/
/* Return todays date */
char *DateTime::getdatestr(int mode, short date)
{
    static char datestr[9];
    union date_rec d;

    d.date = date;
    d.datevar.year += 80;
    if(d.datevar.year > 99)
    {
        d.datevar.year -= 100;
    }
      /*
         -1 - mmddyy
         0  - mmddyy
         1  - mmyydd
         2  - ddmmyy
         3  - ddyymm
         4  - yymmdd
         5  - yyddmm
      */

    switch(mode)
    {
	case -1: sprintf(datestr, "%02d%c%02d%c%02d", d.datevar.month, sep, d.datevar.day, sep, d.datevar.year);
		 break;
	case 0: sprintf(datestr, "%02d%c%02d%c%02d", d.datevar.month, sep, d.datevar.day, sep, d.datevar.year);
		break;
	case 1: sprintf(datestr, "%02d%c%02d%c%02d", d.datevar.month, sep, d.datevar.year, sep, d.datevar.day);
		break;
	case 2: sprintf(datestr, "%02d%c%02d%c%02d", d.datevar.day, sep, d.datevar.month, sep, d.datevar.year);
		break;
	case 3: sprintf(datestr, "%02d%c%02d%c%02d", d.datevar.day, sep, d.datevar.year, sep, d.datevar.month);
		break;
	case 4: sprintf(datestr, "%02d%c%02d%c%02d", d.datevar.year, sep, d.datevar.month, sep, d.datevar.day);
		break;
	case 5: sprintf(datestr, "%02d%c%02d%c%02d", d.datevar.year, sep, d.datevar.day, sep, d.datevar.month);
		break;
    }
    return(datestr);
}

/*************************************************************************/
/* Return the Julian date */
int DateTime::get_julian(void)
{
    int i, julian;
    struct dosdate_t d;

    julian = 0;
    _dos_getdate(&d);
    for(i = 0; i < d.month - 1; i++)
    {
	julian += months[i];
    }
    julian += d.day;
    return(julian);
}

/************************************************************************/
/* Returns the date without hyphens for use in a filename */
char *DateTime::curdate_fn(int type)
{
    char date[9], *ptr1, *ptr2;
    static char newdate[9];

    strcpy(date, curdate(type));
    ptr1 = date;
    ptr2 = newdate;
    while(*ptr1)
    {
	if(*ptr1 != sep)
	{
	    *ptr2 = *ptr1;
	    ptr2++;
	}
	ptr1++;
    }
    *ptr2 = NULL;
    return(newdate);
}

/***********************************************************************/
/*  Creates Fido standard- 01 Jan 89 21:05:18  */
char *DateTime::fido_date(void)
{
    static char date[21];
    char month[4];
    struct dosdate_t d;
    struct dostime_t t;

    _dos_getdate(&d);
    _dos_gettime(&t);
    d.year -= 1900;
    if(d.year > 99)
    {
	d.year -= 100;
    }
    switch(d.month)
    {
	case 1: strcpy(month, "Jan");
		break;
	case 2: strcpy(month, "Feb");
		break;
	case 3: strcpy(month, "Mar");
		break;
	case 4: strcpy(month, "Apr");
		break;
	case 5: strcpy(month, "May");
		break;
	case 6: strcpy(month, "Jun");
		break;
	case 7: strcpy(month, "Jul");
		break;
	case 8: strcpy(month, "Aug");
		break;
	case 9: strcpy(month, "Sep");
		break;
	case 10: strcpy(month, "Oct");
		 break;
	case 11: strcpy(month, "Nov");
		 break;
	case 12: strcpy(month, "Dec");
		 break;
    }

/*  Creates Fido standard- 01 Jan 89 21:05:18  */
    sprintf(date, "%02d %s %02d %02d:%02d:%02d", d.day, month, d.year,
		   t.hour, t.minute, t.second);
    return(date);
}

/************************************************************************/
/* Calculate the date from the number of days elapsed since a certain year */
char *DateTime::calc_date(int start_year, long num_days)
{
    int x, i, year, month, day, months[12];
    static char date[19];

    /* If the num_days is 65535, there is no sub date */
    if(num_days == 65535)
    {
	date[0] = NULL;
	return(date);
    }

    months[0] = 31;
    months[1] = 28;
    months[2] = 31;
    months[3] = 30;
    months[4] = 31;
    months[5] = 30;
    months[6] = 31;
    months[7] = 31;
    months[8] = 30;
    months[9] = 31;
    months[10] = 30;
    months[11] = 31;

    /* Calculate which year it should now be */
    year = start_year + (num_days / 365);

    /* Calculate the number of days left over, accounting for leap years */
    x = (num_days % 365) - ((year - start_year) / 4);

    /* Account for the leap year "phenomenon" at the turn of a century */
    x += (1900 - start_year) / 100;

    day = month = 0;
    for(i = 0; i < 12; i++)
    {
	if((x - months[i]) >= 0)
	{
	    x -= months[i];
	}
	else
	{
	    break;
	}
    }
    day = abs(x);
    month = i + 1;
    year -= 1900;
    sprintf(date, "%02d%c%02d%c%02d", month, sep, day, sep, year);

    /* If the length of 'date' is not 8, then this is an invalid date */
    if(strlen(date) != 8)
    {
	date[0] = NULL;
    }
    return(date);
}

/***********************************************************************/
/* Return a MM-DD-YY date string from a Lora xx Mon xx string */
char *DateTime::getloradate(char *datestr)
{
    static char date[9];
    char monthstr[4], junk1, junk2;
    short day, year, month;

    /* If there is a hyphen, then the user must have a MM-DD-YY format
       for their date, so just return it.  If it's wrong, that's the
       Sysop's own fault for entering an invalid format */
    if(strstr(datestr, "-") || strchr(datestr, sep))
    {
	strcpy(date, datestr);
	return(date);
    }

    sscanf(datestr, "%d%c%s%c%d", &day, &junk1, monthstr, &junk2, &year);
    strupr(monthstr);
    if(strstr(monthstr, "JAN"))
    {
	month = 1;
    }
    if(strstr(monthstr, "FEB"))
    {
	month = 2;
    }
    if(strstr(monthstr, "MAR"))
    {
	month = 3;
    }
    if(strstr(monthstr, "APR"))
    {
	month = 4;
    }
    if(strstr(monthstr, "MAY"))
    {
	month = 5;
    }
    if(strstr(monthstr, "JUN"))
    {
	month = 6;
    }
    if(strstr(monthstr, "JUL"))
    {
	month = 7;
    }
    if(strstr(monthstr, "AUG"))
    {
	month = 8;
    }
    if(strstr(monthstr, "SEP"))
    {
	month = 9;
    }
    if(strstr(monthstr, "OCT"))
    {
	month = 10;
    }
    if(strstr(monthstr, "NOV"))
    {
	month = 11;
    }
    if(strstr(monthstr, "DEC"))
    {
	month = 12;
    }

    sprintf(date, "%02d%c%02d%c%02d", month, sep, day, sep, year);
    return(date);
}

/***********************************************************************/
/* Return a Lora date */
char *DateTime::putloradate(int day, int month, int year)
{
    static char date[15];
    char monthstr[4];

    switch(month)
    {
	case 1: strcpy(monthstr, "Jan");
		break;
	case 2: strcpy(monthstr, "Feb");
		break;
	case 3: strcpy(monthstr, "Mar");
		break;
	case 4: strcpy(monthstr, "Apr");
		break;
	case 5: strcpy(monthstr, "May");
		break;
	case 6: strcpy(monthstr, "Jun");
		break;
	case 7: strcpy(monthstr, "Jul");
		break;
	case 8: strcpy(monthstr, "Aug");
		break;
	case 9: strcpy(monthstr, "Sep");
		break;
	case 10: strcpy(monthstr, "Oct");
		 break;
	case 11: strcpy(monthstr, "Nov");
		 break;
	case 12: strcpy(monthstr, "Dec");
		 break;
	default: strcpy(monthstr, "Err");
		 break;
    }
    sprintf(date, "%02d %s %02d", day, monthstr, year);
    return(date);
}

/************************************************************************/
/* Return the days between today and the input date */
int DateTime::date_diff(int month, int day, int year)
{
    char tmp[11];
    unsigned long today, date;
    int age, x;
    struct dosdate_t d;

    if(month == 0 && day == 0 && year == 100)
    {
	return(-1);
    }

    _dos_getdate(&d);
    d.year -= 1900;
    sprintf(tmp, "%d%02d%02d", year, month, day);
    date = atol(tmp);
    sprintf(tmp, "%d%02d%02d", d.year, d.month, d.day);
    today = atol(tmp);
    if(today > date)
    {
	return(-1);
    }

    age = 0;
    age += 365 * (year - d.year);
    for(x = d.month; x < month; x++)
    {
	age += months[x-1];
    }
    age += day - d.day;
    return(age);
}

/* Return the year */
int DateTime::get_year(void)
{
    struct dosdate_t d;

    _dos_getdate(&d);
    return(d.year);
}

/* Return the month */
int DateTime::get_month(void)
{
    struct dosdate_t d;

    _dos_getdate(&d);
    return(d.month);
}

/* Return the day */
int DateTime::get_day(void)
{
    struct dosdate_t d;

    _dos_getdate(&d);
    return(d.day);
}



/* Return the name of the month */
char *DateTime::get_monthname(void)
{
    struct dosdate_t d;
    static char tmp[15];

    _dos_getdate(&d);
    switch(d.month)
    {
	case 1: strcpy(tmp, "January");
		break;
	case 2: strcpy(tmp, "February");
		break;
	case 3: strcpy(tmp, "March");
		break;
	case 4: strcpy(tmp, "April");
		break;
	case 5: strcpy(tmp, "May");
		break;
	case 6: strcpy(tmp, "June");
		break;
	case 7: strcpy(tmp, "July");
		break;
	case 8: strcpy(tmp, "August");
		break;
	case 9: strcpy(tmp, "September");
		break;
	case 10: strcpy(tmp, "October");
		 break;
	case 11: strcpy(tmp, "November");
		 break;
	case 12: strcpy(tmp, "December");
		 break;
	default: strcpy(tmp, "Invalid");
		 break;
    }
    return(tmp);
}

/* Return the day of the week */
char *DateTime::get_dayname(void)
{
    struct dosdate_t d;
    static char tmp[15];

    _dos_getdate(&d);
    switch(d.dayofweek)
    {
	case 0: strcpy(tmp, "Sunday");
		break;
	case 1: strcpy(tmp, "Monday");
		break;
	case 2: strcpy(tmp, "Tuesday");
		break;
	case 3: strcpy(tmp, "Wednesday");
		break;
	case 4: strcpy(tmp, "Thursday");
		break;
	case 5: strcpy(tmp, "Friday");
		break;
	case 6: strcpy(tmp, "Saturday");
		break;
	default: strcpy(tmp, "Invalid");
		 break;
    }
    return(tmp);
}

short DateTime::Date2Word(short yy, short mm, short dd)
{
    short tofield=0;

    tofield = dd-1;
    tofield = tofield + ((mm-1) << 5);
    tofield = tofield + ((yy-1980) << 9);

    return(tofield);
}

/***********************************************************************/
/* EOF DATETIME.CPP */

