// Header file for DATES.CPP  Year 2000 compliant
// Created 29 October 1997
// Revised 21 May 1998

#if !defined(__DATESY2K__)
#define __DATESY2K__

#define DATES_BASECOMPARISON 1600
#define DATES_SECONDS_PER_DAY 86400

#define DATES_MMDDYY     0
#define DATES_MMYYDD     1
#define DATES_DDMMYY     2
#define DATES_DDYYMM     3
#define DATES_YYMMDD     4
#define DATES_YYDDMM     5
#define DATES_MMDDYYYY   6
#define DATES_MMYYYYDD   7
#define DATES_DDMMYYYY   8
#define DATES_DDYYYYMM   9
#define DATES_YYYYMMDD   10
#define DATES_YYYYDDMM   11
#define DATES_DDMMMYY    12
#define DATES_DDMMMYYYY  13
#define DATES_FIDODATE   14

#define DATES_HHMMSS12   20
#define DATES_HHMMSS24   21
#define DATES_HHMM12     22
#define DATES_HHMM24     23


class Dates
{
    // Private data
    private:
    int   _seconds,    // seconds
	  _minutes,    // minutes
	  _hour,       // hour (0-23)
	  _day,        // day (1-31)
	  _month,      // month (1-12)
	  _year,       // year (0-32767)
	  _dayofweek,  // Day of week (1-7), 1 = Sunday
	  _dayofyear;  // Day of the year (1-366)
    char _datesep,     // Character to separate components of a date
	 _timesep;     // Character to separate components of a time

    // Public methods
    public:
    Dates(void);
    void createDate(void);
    void createDate(int year, int month, int day, int hour, int minutes, int seconds);
    void createDate(long date);
    void createDate(char *d, char *t);
    void createDate(unsigned short date, unsigned short time);
    void createDate(int start_year, long num_days);
    int compareDates(class Dates *dateObj);
    long getSecondsSince1970(void);
    long getDaysSince(int start_year);
    int getAge(void);
    int getDateDiff(class Dates *D);
    int getDay(void);
    int getYear(void);
    int getMonth(void);
    char *getMonthStr(void);
    char *getMonthStrAbbrv(void);
    int getDayOfWeek(void);
    char *getDayOfWeekStr(void);
    char *getDayOfWeekStrAbbrv(void);
    int getDayOfYear(void);
    int getSeconds(void);
    int getMinutes(void);
    int getHour24(void);
    int getHour12(void);
    char *getExtendedFormatStr(void);
    char *getTimeStr(int format);
    char *getDateStr(int format);
    char getDateSep(void);
    char getTimeSep(void);
    void setDateSep(char s);
    void setTimeSep(char s);
    void getPackedDateTime(unsigned short *date, unsigned short *time);

    private:
    void initializeDateTime(void);
    long toSecondsSince1970(int year, int month, int day, int hours, int minutes, int seconds);
    void convertToInternal(long date);

};

#endif
// EOF - DATES.H

