// Class declarations for the CONFIG class
// Created 14 April 1996
// Revised 21 May 1998

#if !defined(__CONFIG_H__)
#define __CONFIG_H__

#include <stdio.h>
#include "dates.h"
#include "utility.h"
#include "amustr.h"
#include "crc.h"
#include "extern.h"

#define REVISION             10        // Current revision of configuration
#define PREVIOUS_REVISION    9         // The previous revision
#define DEFAULT_RECORD    0
#define CONFIG_AMU   "CONFIG.AMU"      // Filename of AMU's configuration
#define HIDDEN_STAMP "HS"              // Hidden file in AMU directory
#define LISTS_AMU    "LISTS.AMU"
#define ARCHIVES_AMU "ARCHIVES.AMU"
#define ENFORCE_AMU  "ENFORCE.AMU"
#define LOGS_AMU     "LOGS.AMU"
#define FILEAREA_AMU "FILEAREA.AMU"
#define BULLETIN_AMU "BULLETIN.AMU"
#define USERMSGS_AMU "USERMSGS.AMU"
#define MSGAREA_AMU  "MSGAREA.AMU"
#define MAINT_AMU    "MAINT.AMU"

#define MAX_SCANNERS         5        // Maximum number of virus scanners

#define SAVE_ALL       0              // Save all of the configuration
#define SAVE_EXTERNAL  1              // Dont' save CONFIG.AMU

#define CFG_ABORT      0
#define CFG_IGNORE     1
#define CFG_IMPORT     2

#define CFG_RECORD     -1
#define ALLFILE_RECORD  0
#define ARCHIVE_RECORD  1
#define ENFORCE_RECORD  2
#define LOGFILE_RECORD  3
#define FILEAREA_RECORD 4
#define BULLETIN_RECORD 5
#define LANGUAGE_RECORD 6
#define USERMSGS_RECORD 7
#define MSGAREA_RECORD  8
#define MAINT_RECORD    9

#define LOG_MINIMAL   -1     /* Just log the basics    */
#define LOG_NORMAL     0     /* Log each operation     */
#define LOG_EXTENSIVE  1     /* Extended logging       */

#define ADD_NEW_RECORD  0
#define COPY_CUR_RECORD 1

    struct filearray
    {
#if defined (__AMU16__)
       char filename[13],
#endif
#if defined (__AMU32__)
       char filename[13],
#endif
#if defined (__AMU2__)
        char filename[256],
#endif
#if defined (__AMU95__)
        char filename[256],
#endif
             uploader[36],
	     password[16],
             keyword[5][16],
	     *description;
	long size,
	     longdescptr,
	     keywordcrc[5];
	unsigned short timesdl,
			bbsattrib,
		       cost;
	unsigned attribute;
	class Dates uploadtimedate,
		    timedate,
		    lastdl;
	unsigned long  passwordcrc;         // 32bit CRC of file's download password
	unsigned short level;            // Security level
	unsigned long  accessflags;      // Access flags
	unsigned long  denyflags;        // Deny flags


	struct filearray *nextrec, *prevrec;
    };

struct track
{
    unsigned long crc;	// CRC-32 of the user name
    short day,		// Day
	  month,	// Month
	  year,		// Year
	  value;	// Any value being tracked
    short deleted;	// Is the record deleted?
};

/* Structure to hold filebase information */
struct fbaseinfo
{
    double areabytes,
	   areafiles,
	   areadls,
	   totalbytes,
	   totalfiles,
	   totaldls,
	   topfile_dls,
	   topfile_size;
    long area;
    char topfile[MAX_FILENAME];
};

struct user_array
{
    char name[51],
	 alias[51],
	 city[51],
	 hidden;
    long calls,
	 posts,
	 uls,
	 dls,
	 ulkb,
	 dlkb;
    unsigned short security,
		   credit,
		   daysforward;
    class Dates BirthDate,
		SubDate;
    struct user_array *nextrec;
};

/* Structure for the TMPUSERS.AMU file */
struct amu_users
{
    char realname[51],
	 handle[51],
	 location[51];
    class Dates BirthDate,
		SubDate;
    long calls,
	 posts,
	 uls,
	 dls,
	 ulkb,
	 dlkb;
};


  /* Block 1 - Header record */
#define HDR_SIZE sizeof(struct amuhdr)
struct amuhdr
{
  short Revision;                // Revision level of config files
  long Config_CRC;               // CRC of everything beyond this point
  unsigned long Begin_Date;      // Day AMU usage was begun
  unsigned short files_time,     // Time BBS file cfg last updated
		 files_date,     // Date BBS file cfg last updated
		 msgs_time,      // Time BBS msg cfg last updated
		 msgs_date;      // Date BBS msg cfg last updated
  char freespace[100];           // Future expansion
};

  /* Block 2 - AMU configuration file record structure */
#define CFG_SIZE sizeof(struct amucfg)
struct amucfg
{
    char sysop[41],         /* Sysop's real name            */
	 sysopalias[41],    /* Sysop's alias                */
	 bbsname[41];       /* Name of the BBS              */

    struct
    {
	char dos_arc[12],       /* DOS archiver                */
	     dos_unarc[12],     /* DOS unarchiver              */
	     dos_arcparam[42],  /* DOS archiver parameters     */
	     dos_unarcparam[42],/* DOS unarchiver parameters   */
	     os2_arc[12],       /* OS/2 archiver               */
	     os2_unarc[12],     /* OS/2 unarchiver             */
	     os2_arcparam[42],  /* OS/2 archiver parameters    */
	     os2_unarcparam[42],/* OS/2 unarchiver parameters  */
	     win_arc[12],       /* Win  archiver               */
	     win_unarc[12],     /* Win  unarchiver             */
	     win_arcparam[42],  /* Win  archiver parameters    */
	     win_unarcparam[42];/* Win  unarchiver parameters  */
    }archivers[15];

    struct
    {
	char dos_scanner[12],   /* DOS virus scanner            */
	     dos_parameters[42],/* DOS parameters               */
	     dos_path[42],      /* Path to virus scanner        */
	     dos_viruslevel[4], /* Errorlevel for a virus       */
	     os2_scanner[12],   /* OS2 virus scanner            */
	     os2_parameters[42],/* OS/2 parameters              */
	     os2_path[42],      /* Path to virus scanner        */
	     os2_viruslevel[4], /* Errorlevel for a virus       */
	     win_scanner[12],   /* Win virus scanner            */
	     win_parameters[42],/* Win  parameters              */
	     win_path[42],      /* Path to virus scanner        */
	     win_viruslevel[4]; /* Errorlevel for a virus       */
    }scanners[MAX_SCANNERS];


    char AMUpath[41],          /* AMU system directory         */
	 emptyspace[41],
	 BBSsyspath[41],       /* BBS system directory         */
	 FDBpath[41],          /* FDB root directory           */
	 workpath[41],         /* Work directory               */
	 cdlistpath[41],       /* FILES.nnn directory - RA 1.11*/
	 userpath[41],         /* User file directory          */
	 hmbpath[41],          /* Path to Hudson/GoldBase files*/
	 doseditor[41],        /* DOS external text editor     */
	 os2editor[41],        /* OS/2 external text editor    */
	 wineditor[41],        /* Windows external text editor */
	 AMUlogfile[41],       /* AMU logfile                  */
	 freqdirs[41];         /* 'OKFILE' list path           */


    short alias_system,
	  BBStype,
	  mailertype,
	  date_format,
	  counter_width,
	  postlog,
	  posterrors,
	  max_dizlines,     /* Maximum DIZ lines to import 0 = all   */
	  max_dizwidth,     /* Max width of DIZ lines 0 = Don't care */
	  shorten_fnames,    /* If long filenames should be shortened */
	  unused2,                                                    
	  swaptype;


    char missing_desc[41],
	 ext_desc_char[11], // Extended description indicators
	 left_bracket,
	 right_bracket;
    short ext_offset;
    char doskey[21],
	 os2key[21],
	 winkey[21];
    short unused4,
	  use_multiple_lines,       /* Use multiple lines or one line desc */
	  max_single_length,        /* Max length of a single line desc    */
	  kill_bad_arcs,            /* Delete bad archives   */
	  replace_ul,               /* Replace blank or AMU ul with Sysop */
	  skip_nested,              /* Skip nested archives */
	  amu_area,                 /* Area AMU can post to */
	  _switch,                  /* Enable 'Switch' option? */
	  clean,                    /* Enable 'Clean' option?  */
	  semicolon_ok,             /* Semi-colons can be used as ext char? */
	  logging_level,            /* Level of logging                     */
	  unused3,
	  old_config;               /* How to handle an outdated BBS cfg  */
    unsigned long passwordcrc;      /* CRC-32 of password to access AMUCFG */
    short create_if_notexist;       /* Create file listing if it doesn't exist */
    char date_separator;            /* Date separator character */
    char future_expansion[969];
};

/************************************************************************/
/* Structure for the Allfiles/Newfiles records */
#define ALLNEW_SIZE sizeof(struct allnew)
#define USE_FILEDATE 0
#define USE_ULDATE 1
struct allnew
{
    short type;               /* 0 = Allfiles, 1 = Newfiles */
    char txtname[41],
	 arcname[41],
	 main_hdr[41],
	 main_ftr[41],
	 area_hdr[41],
	 area_ftr[41],
	 unused[41];
    short compress,
	  arctype,
	  erase,
	  age,                  /* For newfiles listing only */
	  enabled,
	  deleted,
	  ulordos,             /* 1 = Use upload date, 0 = use DOS date */
	  add_comments;        /* Send comment lines to the list or not */
    double totalfiles,
	   totalbytes,
	   totaldls;
    char list_format[81];
    char freespace[200];
};

/************************************************************************/
#define ARC_DATED       0
#define ARC_JULIAN_REN  1
#define ARC_JULIAN_COMP 2
#define ARC_BYTES       3

#define ARC_SIZE sizeof(struct archives)
struct archives
{
    char name[41];
    char path[41];
    char ltrs[3];
    short arctype,
	  date_format,
	  erase,
	  monthly_arc,
	  erase_daily,
	  enabled,
	  deleted,
	  type,            // Type of archive this is: 0 = Normal, 1 = Julian (Rename), 2 = Julian (Compress)
	  day,             // Day this is executed on
	  max_size;
    char freespace[48];
};

/************************************************************************/
#define LOG_SIZE sizeof(struct logs)
struct logs
{
    char name[41];
    short type,
	  enabled,
	  deleted;

    /* Record the offsets/CRC-32's for this logfile for the various */
    long crc,
	 offset;
    char freespace[90];
};

/*************************************************************************/
/* Structure to enforcement file */
#define ULS 0            // Enforce by # Uls
#define DLS 1            // Enforce by # Dls
#define POSTS 2          // Enforce by # Posts
#define CALLS 3          // Enforce by # Calls
#define ULDL 4           // Enforce by Ul:Dl ratio (Files)
#define ULDLKB 5         // Enforce by Ul:Dl ratio (KBs)
#define POSTCALL 6       // Enforce by Post:Call ratio
#define SUBSCRIPTION 7   // Subscription expiration

#define GREATER 0
#define LESS    1

#define ENFORCE_SIZE sizeof(struct enforce)
struct enforce
{
    unsigned short cur_level,  // Level a user must have to activate this
		   next_level; // Level to change user to
    long num;                  // # days in advance to notify a user of subscription expiration, #dls, etc.
    char user_fn[81];          // Text file to post to user if level is changed
    short type;                // Which type of record is this?
    long num2;
    short comparison;          // 0 = greater than, 1 = less than
    short days_forward;        // Number of days to move a subscription date forward
    short user_area;
    short sysop_area;
    char sysop_fn[41];
    char freespace[27];        // Future expansion
    short enabled;             // Enabled?
    short deleted;
};

/*************************************************************************/
/* Structure to hold On/Off definitions for the file areas */
#define AREAS_SIZE sizeof(struct areas)
#define MAX_AREAS 8192                         // Maximum number of file areas
#define NUM_ELEMENTS MAX_AREAS / 16            // Number of elements of the array
struct areas
{
    unsigned short status[NUM_ELEMENTS];
};

/************************************************************************/
/* Structure to hold information for each file area */
#define FILEAREA_SIZE sizeof(struct filearea)
#define RA_FDB          0       /* RemoteAccess filebase                */
#define CONCORD_FDB     1       /* Concord filebase                     */
#define FILESBBS        2       /* FILES.BBS                            */
#define LORA_FDB        3       /* LoraBBS filebase                     */
#define EZY_FDB         4       /* EzyCom filebase                      */
#define TG_FDB          5       /* TeleGard 3.02 Filebase               */
#define TG310_FDB       6       /* TeleGard 3.10 Filebase               */
#define CD_1            0       /* fn size date desc                    */
#define CD_2            1       /* fn size desc                         */
#define CD_3            2       /* fn desc                              */
#define CD_4            3       /* fn date size desc                    */
#define CD_5            4       /* fn date desc                         */

#define NUM_FAREA_OPTIONS 22

struct filearea
{

/* The first group of variables are taken from the BBS configuration    */
/* and may not be edited by the user in AMUCFG                          */

    char  areaname[41];         /* Name of this area                    */
    unsigned long keycrc32;     /* CRC-32 of the Key field in Lora 3.0  */
    char lora3key[16];          /* Key field for Lora 3.0               */
    char  unused1[21],
	  unused2[41];
    long  security;             /* List security                        */
    short listtype;             /* Type of file listing:                */
				/*    0 - RA 2.0x FDB                   */
				/*    1 - Concord O.O1 FDB              */
				/*    2 - FILES.BBS                     */


/* Settings that may be editted by the user in AMUSETUP */

    short days_old,             /* Days old for the Old option          */
	  move_area,            /* Area to Move old files to            */
	  rearc_type,           /* Rearchive format                     */
	  sort_type,            /* Sorting format for 'Sort' option     */
	  cdformat;             /* Format of CD-ROM areas               */


    struct
    {
	short cdrom       : 1,  /* Is this area on CD-ROM?              */
	      password    : 1,  /* Is this area password protected?     */
	      move_old    : 1,  /* 0 = Kill, 1 = Move                   */
	      unused      : 13;
    }attrib;

    short force_rearc,              /* Force rearchiving */
	  honor_av,                 /* Honor -AV validation */
	  deleted;
    unsigned short areanum;
    short sort,
	  headers,
	  adopt,
	  orphan,
	  old,
	  backup,
	  pack,
	  rearchive,
	  comment,
	  virus,
	  importdiz,
	  exportdiz,
	  importbbs,
	  exportbbs,
	  bbsdls,
	  mailerdls,
	  import_gif,       /* Import GIF information               */
	  filter_graph,     /* Filter graphics from DIZ files?      */
	  move_nodesc,      /* Move files with missing desc         */
	  nodesc_area,      /* Area to move files with no desc      */
	  compress_txt,     /* Compress text files as encountered?  */
	  compresstxt_type, /* Format for compression               */
	  useuldate;        /* For RA, use Upload or File date for moving files? */

    char filepath[129],     /* Path to the files                    */
	 listpath[129];     /* Name of alternate FILES.BBS type     */
    char freespace[200];
};

/**************************************************************************/
/* Bulletin structure */
#define BULL_TOPUL     0         /* Top uploaders (Files)      */
#define BULL_TOPULK    1         /* Top uploaders (Kb)         */
#define BULL_TOPDL     2         /* Top downloaders (Files)    */
#define BULL_TOPDLK    3         /* Top downloaders (Kb)       */
#define BULL_ULDL      4         /* Top Ul:Dl (Files)          */
#define BULL_ULDLK     5         /* Top Ul:Dl (Kb)             */
#define BULL_TOPPOST   6         /* Top message posters        */
#define BULL_TOPCALL   7         /* Top callers                */
#define BULL_POSTCALL  8         /* Top Post:Call ratio        */
#define BULL_TOPFILE   20        /* Top files by downloads     */
#define BULL_FILEOVR   21        /* File Area Overview         */
#define BULL_MSGOVR    30        /* Message Base Overview      */
#define BULL_DOORS     40        /* Door Usage bulletin        */
#define BULL_DAILYDL   50        /* Daily download bulletin    */
#define BULL_DAILYUL   60        /* Daily upload bulletin      */
#define BULL_USERLIST  70        /* User listing               */
#define BULL_TODAYCALL 71        /* Today's Callers            */
#define BULL_BIRTHDAY  72        /* Birthdates today           */
#define BULL_SUBEXP    73        /* Subscription expirations   */

#define BULLETIN_SIZE sizeof(struct bulletin)
struct bulletin
{
    short type,                 /* Type of bulletin           */
	  unused1,
	  num_listed,           /* Number of items to list    */
	  unused2[9];
    char fname[41];             /* Bulletin filename          */
    struct
    {
	short include_sysop: 1, /* Include the sysop?         */
	      create_ascii : 1, /* Create a .ASC bulletin?    */
	      create_ansi  : 1, /* Create a .ANS bulletin?    */
	      create_avatar: 1, /* Create a .AVT bulletin?    */
	      create_html  : 1, // Create HTML version?
	      freespace    : 11;
    }attrib;
    short enabled,
	  deleted;
    char datafname[9],         /* Tracking file for Doors, Msgovr */
	 templatefn[41];       /* Template file for the bulletin  */
    char html_template[41];    // Template for HTML bulletins
    char freespace[159];
};


/*************************************************************************/
/* Language structure - CURRENTLY NOT IN USE!! */
#define LANGUAGE_SIZE sizeof(struct language)
struct language
{
    char name[21],              /* Name of this language      */
	 fname[41];             /* Filename of .LNG file      */
    short enabled,              /* Is this language available */
	  deleted;              /* Deleted?                   */
    char freespace[50];         /* Freespace                  */
};


/**************************************************************************/
/* User messages */
#define MSG_NEWUSER   0         /* New user messages          */
#define MSG_UPLOADS   1         /* Uploading messages         */
#define MSG_CARRIER   2         /* Lost Carrier messages      */
#define MSG_BIRTHDAY  3         /* Birthday messages          */
#define MSG_SUBEXP    4         /* Subscription expiration    */
#define MSG_CREDIT    5         /* Low Credit messages        */

#define USERMSGS_SIZE sizeof(struct usermsgs)
struct usermsgs
{
    short type,                 /* Type of message entry this is */
	  language,             /* Post to users with this lng.  */
	  num_credit,           /* Number of credits for Credit  */
	  post_zero,            /* 0 = Don't post for zero credit*/
	  num_days,             /* Days for SubExp msg           */
	  user_area,            /* Area to post user messages    */
	  sysop_area;           /* Area to post sysop messages   */
    char  user_fn[41],          /* Message text to post to user  */
	  sysop_fn[41],         /* Message text to post to sysop */
	  freespace[50];        /* Future Expansion              */
    short deleted;              /* Record deleted?               */
    short enabled;              /* Enabled?                      */
};

/*************************************************************************/
/* Maintenance records */
#define MAINT_DAILY    0        /* Daily Maintenance            */
#define MAINT_WEEKLY   1        /* Weekly Maintenance           */
#define MAINT_MONTHLY  2        /* Monthly Maintenance          */
#define MAINT_INTERVAL 3        /* Every XX days Maintenance    */

#define MAINT_SIZE sizeof(struct maintenance)
struct maintenance
{
    short type,                 /* Type of record this is          */
	  days,                 /* Execute every x days - Interval */
	  weekly_day,           /* Day of week for Weekly type     */
	  monthly_day;          /* Day of month for Monthly type   */
    long last_date;             /* Last date executed (Interval)   */
    char fname[41];             /* Filename of maintenance file    */
    short enabled,              /* Active?                         */
          deleted;              /* Record deleted?                 */
    char freespace[50];         /* Freespace                       */
};

/************************************************************************/
/* Message areas */
#define HUDSON_TYPE          0  //Hudson message base
#define JAM_TYPE             1  // JAM message bases
#define GOLD_TYPE            2  // GoldBase message base
#define SQUISH_TYPE          3  // Squish message base
#define MSG_TYPE             4  // *.MSG message base
#define EZY_TYPE             5  // EzyCom message basee
#define UNKNOWN_TYPE         10 // Unknown areas
#define MSGAREA_SIZE sizeof(struct msgarea)
struct msgarea
{
    char areaname[41],          /* Name of the message area */
	 unused1[81];
    short security,             /* Read security for area   */
	  areatype,             /* Type of message base     */
	  areanum,
	  deleted;
    char basepath[129];         /* Path of the message base */
    char freespace[200];
};

/************************************************************************/
/* Class definition for the Config object */
class Config
{
    public:
    unsigned long crc;
    int num_lists,
	num_archives,
	num_enforce,
	num_logs,
	num_filearea,
	num_bulletin,
	num_usermsgs,
	num_msgarea,
	num_maint;
    struct amucfg amu_cfgvar;
    struct amuhdr amu_hdrvar;
    struct enforce enforcevar;
    struct allnew allnewvar;
    struct archives archivesvar;
    struct logs logsvar;
    struct filearea fileareavar;
    struct msgarea msgareavar;
    struct language languagevar;
    struct bulletin bulletinvar;
    struct usermsgs usermsgsvar;
    struct maintenance maintvar;
    struct areas areasvar;

    private:
    class Utility Utility_obj;
    class Amustr Amustr_obj;
    class Crc Crc_obj;
    FILE *AMUcfgfile,
	 *LISTScfg,
	 *ARCHIVEScfg,
	 *ENFORCEcfg,
	 *LOGScfg,
	 *FILEAREAcfg,
	 *BULLETINcfg,
	 *USERMSGScfg,
	 *MSGAREAcfg,
	 *MAINTcfg;

    unsigned short BIT_ARRAY[16];
    char cfg_filename[129],
	 registered_to[51],
	 bbs_software[51],
	 comspec[256];

    private:

    public:
    Config(void);
    int read_bbsfiles(void);
    int read_bbsmsgs(void);
    void upgrade_config(void);             /* Upgrade the configuration  */
    char *get_comspec(void);               /* Return the COMSPEC         */
    char *get_bbstype(void);               /* Return BBS type            */
    int create_config(void);               /* Create a new AMU config    */
    int open_config(int type);             /* Open AMU configuration     */
    void close_config(int type);           /* Close AMU configuration    */
    int read_record(int type, int num);    /* Read a record from cfg     */
    void read_main_config(void);
    int update_record(int type, int num);  /* Update a record in cfg     */
    int add_record(int type, int mode);    /* Adds a new record to cfg   */
    void save_cfg(int type);                /* Save the configuration     */
    void init_external(void);              /* Initialize external progs  */
    int active(long area);                 /* See if an area is active   */
    void togglearea(long area);            /* Toggle an area             */
};

#endif
/***********************************************************************/
/* EOF - CONFIG.H */