/* Concord 0.01 */
struct t
{
    unsigned short time,
		   date;
};

union timedate2
{
    struct t t1;
    long t2;
};


/*
  (* File areas, message areas and doors may contain of different levels,    *)
  (* like in DOS file structure. There may be sub directories which may have *)
  (* more sub directories etc. Each directory resides in its own file which  *)
  (* are always located in BBS system path and are named MAREAS.* (msgs),    *)
  (* FAREAS.* (files) and DOORS.* (doors). The main level file's extension   *)
  (* is always DAT, others can be freely selected.                           *)

  (* If attribute ?AREA_JUMP or DOOR_JUMP is on, filename to that (either    *)
  (* sub or parent) directory is stored in PathName (msgs), DownloadPath     *)
  (* (files) or CmdLine (doors).                                             *)


	 FILE_CHECK_OFFLINE    = $01; (* Bit 0 - Check if files are offline  *)
	 FILE_FORCE_FILESBBS   = $02; (* Bit 1 - Force FILES.BBS support     *)

{ok}     FAREA_ACTIVE    = $0001; (* Bit 0 - Active?                         *)
{ok}     FAREA_NEWFILES  = $0002; (* Bit 1 - Include in new files check      *)
         FAREA_DEFAULT   = $0004; (* Bit 2 - Tagged by default               *)
{ok}     FAREA_DUPECHK   = $0008; (* Bit 3 - Include upload dupe check       *)
{ok}     FAREA_VIRUSCHK  = $0010; (* Bit 4 - Include upload virus check      *)
	 FAREA_FREE      = $0020; (* Bit 5 - All files are free              *)
{ok}     FAREA_CDROM     = $0040; (* Bit 6 - CD-ROM area (ie. READONLY)      *)
         FAREA_NOLISTREQ = $0080; (* Bit 7 - Allow dl files not in file list *)
{ok}     FAREA_JUMP      = $0100; (* Bit 8 - DownloadPath = New area list!   *)

{ok}     MAREA_ACTIVE    = $0001;       (* Bit 0 - Active?                   *)
{ok}     MAREA_DELETE    = $0002;       (* Bit 1 - Allow deleting messages   *)
         MAREA_TAGLINE   = $0004;       (* Bit 2 - Allow tag lines           *)
         MAREA_FATTACH   = $0008;       (* Bit 3 - Allow file attaches       *)
	 MAREA_SELECT    = $0010;       (* Bit 4 - Allow selecting from list *)
	 MAREA_CTRLCHAR  = $0020;       (* Bit 5 - Allow control chars       *)
	 MAREA_DEFAULT   = $0040;       (* Bit 6 - Tagged by default         *)
         MAREA_MAILCHK   = $0080;       (* Bit 7 - Force mail check          *)
         MAREA_ORIGIN    = $0100;       (* Bit 8 -                           *)
{ok}     MAREA_JUMP      = $0200;       (* Bit 9 - PathName = New area list! *)

*/
#define MAREAFMT_HMB     0
#define MAREAFMT_JAM     1
#define MAREAFMT_MSG     2
#define MAREAFMT_SQUISH  3
/*
	 MAREAFMT_HMB    = $0000;                                 (* Hudson  *)
	 MAREAFMT_JAM    = $0001;                                 (* JAM     *)
	 MAREAFMT_MSG    = $0002;                                 (* .MSG    *)
	 MAREAFMT_SQUISH = $0003;                                 (* Squish  *)

	 MAREATYPE_LOCAL = $0000;                              (* Local area *)
	 MAREATYPE_ECHO  = $0001;                              (* Echo area  *)
	 MAREATYPE_NET   = $0002;                              (* Net mail   *)

	 MAREAKIND_BOTH  = $0000;        (* Both public and private messages *)
	 MAREAKIND_PRIV  = $0001;        (* Only private messages            *)
	 MAREAKIND_PUB   = $0002;        (* Only public messages             *)
	 MAREAKIND_RO    = $0003;        (* Read-only                        *)
*/

struct security
{
    unsigned short bpsrate;
    unsigned char age;
    unsigned short seclvl;
    char flags[10],
	 notflags[10];
};

// FAREAS.*
struct concord_files
{
    long id,
	 attrib;
    unsigned char l1;
    char name[60];
    struct security dlsec,
		    ulsec,
		    listsec;
    unsigned char l2;
    char password[15];
    unsigned char l3;
    char downloadpath[67];
    unsigned char l4;
    char Basename[8];
    char emptyspace[51];
    unsigned short subdirnum,
		   jumpdirnum;
    long uploadarea;
    unsigned char l5;
    char group[3];
    unsigned char archivefmt;
    unsigned short killdaysdl,
	     killdaysfd,
	     filepoints,
	     openfrom,
	     opento;
    unsigned char l6;
    char filesbbs[79];
};

// MAREAS.*
struct concord_msgs
{
    long id,
	 attrib;
    unsigned char format,
		  l1;
    char pathname[79];
    unsigned char l2;
    char name[60];
    unsigned char l3;
    char shortname[12];
    unsigned char l4;
    char group[3];
    unsigned char l5;
    char password[15];
    unsigned char ownboard, // area number for HMB
		  type,
		  kinds,
		  replystatus,
		  usealias;
    struct security readsec,
		    writesec,
		    sysopsec;
    unsigned short dayskill,
		   receivedkill,
		   countkill,
		   SubDirNum;
    unsigned char useaka,
		  chartable,
		  l6;
    char originline[60];
    unsigned short openfrom,
	     opento,
	     jumpdirnum;
//	     commentlen;
};

// ????????.HDR
struct concord_hdr
{
    char name[11];
    long size;
    union timedate2 uploadtimedate;
    unsigned short downloads,
	     attrib;
    long descptr;
    unsigned short descreclen;
    unsigned char uploaderlen;
};

/*
 { Attributes
   bit        description
     0         Deleted
     1         For Sysop
     2         OFFLINE
     3         Unlisted

     4         No-kill   NOT YET IMPLEMENTED
  }
*/

// ????????.TXT
/* The .TXT file is of the following format:
  1. Description, the length of which is determined from the .HDR .desclen
     field, up to a maximum of 1024 bytes.
  2. Uploader name, the length of which is determined from the .HDR .namelen
     field.
  3. 2 bytes for the lastdl date.
  4. 2 bytes for the cost.

  3 & 4 are not yet implemented.

  DescriptionRec = record                             (* ????????.TXT *)
    Desc:        array[1..desclen] of char; (max. length 1024 bytes)
    Uploader:    array[1..namelen] of char;
    LastDL:      DateRec; NOT YET IMPLEMENTED
    Cost:        Word;    NOT YET IMPLEMENTED
  end;
*/

/*
   The file names are 32 bit CRCs counted from UPPERCASE (capital letters)
   filearea name converted to hexa decimals specified in FLSEARCH.BBS and
   stored in the path specified in SCONFIG.BBSs FILEBASEPATH variable.
*/


/*
	 ID_USR       = ID_VER or $00040000;
	 ID_USR_HDR   = ID_USR or $01000000;
	 ID_USR_REC   = ID_USR or $02000000;

	 USER_DELETED      = $00000001; (* Bit  0 - User deleted             *)
	 USER_MAILCHK      = $00000002; (* Bit  1 - Mail check               *)
	 USER_FILECHK      = $00000004; (* Bit  2 - New files check          *)
	 USER_NORATIO      = $00000008; (* Bit  3 - No DL ratios             *)
	 USER_FEMALE       = $00000010; (* Bit  4 - Female                   *)
	 USER_CLRSCR       = $00000020; (* Bit  5 - Clear screen             *)
	 USER_MORE         = $00000040; (* Bit  6 - More prompts             *)
	 USER_NOKILL       = $00000080; (* Bit  7 - User cannot be removed   *)
	 USER_COLORS       = $00000100; (* Bit  8 - Colors                   *)
	 USER_NODISTURB    = $00000200; (* Bit  9 - Do not disturb           *)
	 USER_HOTKEYS      = $00000400; (* Bit 10 - Hot keys                 *)
         USER_IGNDLHOURS   = $00000800; (* Bit 11 - Ignore download hours    *)
	 USER_DELAFTERVIEW = $00001000; (* Bit 12 - Delete file after viewed *)
         USER_VIEWED       = $00002000; (* Bit 13 - File viewed              *)
         USER_VIEWONLYONCE = $00004000; (* Bit 14 - View file only once      *)
	 USER_SYSOP        = $00008000; (* Bit 15 - Added BBS to BBS list    *)
         USER_VIP          = $00010000; (* Bit 16 - VIP member               *)
         USER_BULLETCHK    = $00020000; (* Bit 17 - New bulletins check      *)

						 (* OfflineAttrib :          *)
         OFFLINE_WELCOME   = $00000001;          (* Include WELCOME.ANS      *)
         OFFLINE_NEWS      = $00000002;          (* Include NEWS.ANS         *)
         OFFLINE_GOODBYE   = $00000004;          (* Include GOODBYE.ANS      *)
         OFFLINE_NEWFILES  = $00000008;          (* Include new files list   *)
         OFFLINE_NEWBULLET = $00000010;          (* Include new bulletins    *)
         OFFLINE_LASTREAD  = $00000020;          (* Include last read ptrs   *)
         OFFLINE_ALLMAIL   = $00000040;          (* 'All' msgs as personal?  *)
         OFFLINE_AUTOMATIC = $00000080;          (* Offline packing used     *)
         OFFLINE_RECEIVED  = $00000100;          (* Mark personal msgs read  *)
         OFFLINE_NOOWNMSGS = $00000200;          (* Do not include own msgs  *)

         OFFLINEPKT_NONE  = $00;                 (* No offline packet format *)
	 OFFLINEPKT_ASCII = $01;                 (* ASCII format             *)
	 OFFLINEPKT_QWK   = $02;                 (* QWK format               *)
	 OFFLINEPKT_OMEN  = $03;                 (* OMEN format              *)
	 OFFLINEPKT_BWAVE = $04;                 (* Bluewave format          *)
*/

// USERINFO.DAT header
struct concord_users_hdr
{
    long id,
	 version;
    unsigned short usersize; // Size of user record in bytes
};

// USERINFO.DAT main records
struct concord_users
{
    long id;
    char l1,
	 name[35],
	 l2,
	 alias[35],
	 l3,
	 city[25],
	 l4,
	 voice[20],
	 l5,
	 data[20];
    unsigned short birthday;
    char l6,
	 password[15];
    struct security sec;
    unsigned char screenlen;
    long attrib1,
	 attrib2,
	 firsttime,
	 lasttime,
	 timescalled,
	 totalminutes,
	 pages,
	 publicmsgs,
	 privatemsgs,
	 upk,
	 uptimes,
	 downk,
	 downtimes;
    char l7,
	 sysopcomment[60],
	 protocol,
	 editor,
	 viewer,
	 packer,
	 charset;
    unsigned short lastfilechk,
	     lastbullchk,
	     expiration;
    char l8,
	 firstmenu[8],
	 l9,
	 language[8];
    long messagearea;
    char l10,
	 mareaext[3];
    long filearea;
    char l11,
	 fareaext[3];
    long door;
    char l12,
	 doorext[3];
    long chatchannel;
    unsigned char todaycalls;
    unsigned short todayelapsed;
    long todaydownk,
	 todaydowns,
	 timeinbank,
	 dllimitinbank;
    char l13,
	 viewfilename[12],
	 offlinefmt,
	 offlinedays;
    long offlineattrib;
    unsigned char readmsgnum,
		  filelistnum,
		  todaylastpkt,
		  verifycalls,
		  passwordtries;
    unsigned short offlinemaxnum;
    long flexpos;
    unsigned short lastpktdl;
    long bbscrc;
    unsigned char emulation,
		  textfiletype,
		  empty[85];
};

/* EOF - CONC100.H */
