// Functions for the Bulletins menu
// Created 20 March 1996
// Revised 10 October 1998

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dir.h>
#include <mem.h>
#include "execute.h"
#include "menus.h"
#include "bullmenu.h"
#include "utility2.h"
#include "utility.h"
#include "crc.h"
#include "listbox.h"
#include "config.h"
#include "amuidx.h"

/* external objects */
extern class Utility Utility_obj;
extern class Utility2 Utility2_obj;
extern class Crc Crc_obj;
extern class Menus Menus_obj;
extern class Config Config_obj;
extern class AreasBox AreasBox_obj;
extern listbox *filelistbox, *msglistbox;

int BullMenu::menu(void)
{
    long crc, crc2;
    int i, index;
    char str[51];

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 15;
    cvar.width = 60;
    cvar.left = 9;
    cvar.top = 7;
    cvar.position = 2;
    cvar.high_num = 15;
    Config_obj.open_config(BULLETIN_RECORD);
    do
    {
        Menus_obj.help("Bulletin Manager; F3 - Copy");
        Menus_obj.set_help(BULLETIN_HELP);
        if(index > Config_obj.num_bulletin)
        {
            index = 1;
        }
        if(index < 1)
        {
            index = Config_obj.num_bulletin;
	}
        Config_obj.read_record(BULLETIN_RECORD, index);
        sprintf(str, "Bulletins - Record %d/%d", index, Config_obj.num_bulletin);
	if(Config_obj.bulletinvar.deleted)
        {
            strcat(str, " [Deleted]");
	}
        cvar.title = str;
        cvar.options = options();
        i = Menus_obj.dialog(&cvar, ENTER, 1);
	switch(i)
	{
            case LEFT: index--;
                       break;
            case RIGHT: index++;
                        break;
            case ENTER: cvar.position = 2;
                        break;
            case HOME: index = 1;
                       break;
            case END: index = Config_obj.num_bulletin;
		      break;
            case DEL: Utility2_obj.toggle(&Config_obj.bulletinvar.deleted);
                      Config_obj.update_record(BULLETIN_RECORD, index);
		      break;
            case INS: Config_obj.add_record(BULLETIN_RECORD, ADD_NEW_RECORD);
                      index = Config_obj.num_bulletin;
		      break;
	    case F1   : Menus_obj.online_help(BULLETIN_MANAGER);
                        break;
            case F3: Config_obj.add_record(BULLETIN_RECORD, COPY_CUR_RECORD);
		     index = Config_obj.num_bulletin;
		     break;
	    case ESC: Config_obj.close_config(BULLETIN_RECORD);
		      return(i);
	}
        if(i == ENTER)
        {
	    crc = Crc_obj.struct_crc((char *) &Config_obj.bulletinvar, sizeof(Config_obj.bulletinvar));
            crc2 = Crc_obj.struct_crc((char *) &Config_obj.areasvar, sizeof(Config_obj.areasvar));
            strcpy(str, "Bulletin Settings");
            cvar.title = str;
	    do
            {
                Menus_obj.set_help(BULLETIN_HELP);
		cvar.options = options();
		i = Menus_obj.display_menu(&cvar, 1);
                switch(i)
		{
                    case ENTER: action(cvar.position);
                                break;
                    case F1   : Menus_obj.online_help(BULLETIN_MANAGER);
				break;
		}
            }while(i != ESC);

	    if((crc != Crc_obj.struct_crc((char *) &Config_obj.bulletinvar, sizeof(Config_obj.bulletinvar))
		||  crc2 != Crc_obj.struct_crc((char *) &Config_obj.areasvar, sizeof(Config_obj.areasvar)))
		&&  Menus_obj.prompt(0))
	    {
		Config_obj.update_record(BULLETIN_RECORD, index);
	    }
	    i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
	}
    }while(i != ESC);
    Config_obj.close_config(BULLETIN_RECORD);
    return(i);
}


char *BullMenu::options(void)
{
    char tmpstr[11];

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Bulletin type : ");
    switch(Config_obj.bulletinvar.type)
    {
        case BULL_TOPUL    : strcat(optionsstr, "Top Uploaders (Files);");
			     break;
        case BULL_TOPULK   : strcat(optionsstr, "Top Uploaders (KB);");
                             break;
        case BULL_TOPDL    : strcat(optionsstr, "Top Downloaders (Files);");
			     break;
        case BULL_TOPDLK   : strcat(optionsstr, "Top Downloaders (KB);");
                             break;
	case BULL_ULDL     : strcat(optionsstr, "Top Ul:Dl Ratio (Files);");
			     break;
	case BULL_ULDLK    : strcat(optionsstr, "Top Ul:Dl Ratio (KB);");
			     break;
	case BULL_TOPPOST  : strcat(optionsstr, "Top Message Posters;");
			     break;
	case BULL_TOPCALL  : strcat(optionsstr, "Top Callers;");
			     break;
	case BULL_POSTCALL : strcat(optionsstr, "Top Post:Call Ratio;");
			     break;
	case BULL_TOPFILE  : strcat(optionsstr, "Most Downloaded Files;");
			     break;
	case BULL_FILEOVR  : strcat(optionsstr, "File Area Overview;");
			     break;
	case BULL_MSGOVR   : strcat(optionsstr, "Message Base Overview;");
			     break;
	case BULL_DOORS    : strcat(optionsstr, "Most Popular Doors;");
			     break;
	case BULL_DAILYDL  : strcat(optionsstr, "Daily Downloads;");
			     break;
	case BULL_DAILYUL  : strcat(optionsstr, "Daily Uploads;");
			     break;
	case BULL_USERLIST : strcat(optionsstr, "User Listing;");
			     break;
	case BULL_TODAYCALL: strcat(optionsstr, "Today's Calls;");
			     break;
	case BULL_BIRTHDAY : strcat(optionsstr, "Today's Birthdays;");
			     break;
	case BULL_SUBEXP   : strcat(optionsstr, "Today's Sub. Exp.;");
			     break;
     }

    strcat(optionsstr, "Filename      : ");
    strcat(optionsstr, Config_obj.bulletinvar.fname);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Template      : ");
    strcat(optionsstr, Config_obj.bulletinvar.templatefn);
    strcat(optionsstr, ";");

    strcat(optionsstr, "HTML Template : ");
    strcat(optionsstr, Config_obj.bulletinvar.html_template);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Data filename : ");
    if(Config_obj.bulletinvar.type == BULL_MSGOVR ||
       Config_obj.bulletinvar.type == BULL_DOORS)
    {
	strcat(optionsstr, Config_obj.bulletinvar.datafname);
	strcat(optionsstr, ";");
    }
    else
    {
	strcat(optionsstr, "n/a;");
    }
    strcat(optionsstr, "Max entries   : ");
    if(Config_obj.bulletinvar.type == BULL_FILEOVR ||
       Config_obj.bulletinvar.type == BULL_MSGOVR ||
       Config_obj.bulletinvar.type == BULL_DOORS ||
       Config_obj.bulletinvar.type == BULL_DAILYDL ||
       Config_obj.bulletinvar.type == BULL_DAILYUL ||
       Config_obj.bulletinvar.type == BULL_USERLIST ||
       Config_obj.bulletinvar.type == BULL_BIRTHDAY ||
       Config_obj.bulletinvar.type == BULL_SUBEXP ||
       Config_obj.bulletinvar.type == BULL_TODAYCALL)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	sprintf(tmpstr, "%d;", Config_obj.bulletinvar.num_listed);
	strcat(optionsstr, tmpstr);
    }

    strcat(optionsstr, "Include Sysop : ");
    if(Config_obj.bulletinvar.type == BULL_TOPFILE ||
       Config_obj.bulletinvar.type == BULL_FILEOVR ||
       Config_obj.bulletinvar.type == BULL_MSGOVR ||
       Config_obj.bulletinvar.type == BULL_DOORS)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Utility2_obj.YN(Config_obj.bulletinvar.attrib.include_sysop));
    }

    switch(Config_obj.bulletinvar.type)
    {
	case BULL_FILEOVR:
	case BULL_MSGOVR :
	case BULL_TOPFILE:
			   strcat(optionsstr, "Areas         : Press Enter to edit;");
			   break;
	default          : strcat(optionsstr, "Areas         : n/a;");
			   break;
    }

    strcat(optionsstr, "ASCII version : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.bulletinvar.attrib.create_ascii));

    strcat(optionsstr, "ANSI  version : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.bulletinvar.attrib.create_ansi));

    strcat(optionsstr, "AVATAR version: ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.bulletinvar.attrib.create_avatar));

    strcat(optionsstr, "HTML version  : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.bulletinvar.attrib.create_html));

    strcat(optionsstr, "Enabled       : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.bulletinvar.enabled));

    strcat(optionsstr, "  ;");
    return(optionsstr);
}

void BullMenu::action(int position)
{
    char tmpstr[11], str[81], *tmpbuf;
    int offset = 18;
    struct coordinates c;

    switch(position)
    {
	case 2: Menus_obj.get_bulletintype();
		break;
	case 3: Menus_obj.set_validtype(NO_EXT);
		strcpy(Config_obj.bulletinvar.fname,
		Menus_obj.getfield(Config_obj.bulletinvar.fname, cvar.left +
				   offset, cvar.top + position, 40));
		break;

	case 4: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.bulletinvar.templatefn,
		Menus_obj.getfield(Config_obj.bulletinvar.templatefn, cvar.left +
				   offset, cvar.top + position, 40));
		break;

	case 5: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.bulletinvar.html_template,
		Menus_obj.getfield(Config_obj.bulletinvar.html_template, cvar.left +
				   offset, cvar.top + position, 40));
		break;

	case 6: if(Config_obj.bulletinvar.type == BULL_MSGOVR ||
		   Config_obj.bulletinvar.type == BULL_DOORS)
		{
		    Menus_obj.set_validtype(NO_EXT);
		    strcpy(Config_obj.bulletinvar.datafname,
		    Menus_obj.getfield(Config_obj.bulletinvar.datafname, cvar.left +
				       offset, cvar.top + position, 8));
		}
		break;

	case 7: if(Config_obj.bulletinvar.type != BULL_FILEOVR &&
		   Config_obj.bulletinvar.type != BULL_MSGOVR &&
		   Config_obj.bulletinvar.type != BULL_DOORS &&
		   Config_obj.bulletinvar.type != BULL_DAILYDL &&
		   Config_obj.bulletinvar.type != BULL_DAILYUL)
		{
		    Menus_obj.set_validtype(RANGE_3);
		    sprintf(tmpstr, "%d", Config_obj.bulletinvar.num_listed);
		    strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset,
			   cvar.top + position, 5));
		    Config_obj.bulletinvar.num_listed = atoi(tmpstr);
		}
		break;
	case 8: if(Config_obj.bulletinvar.type != BULL_TOPFILE &&
		   Config_obj.bulletinvar.type != BULL_FILEOVR &&
		   Config_obj.bulletinvar.type != BULL_MSGOVR &&
		   Config_obj.bulletinvar.type != BULL_DOORS)
		{
		    Config_obj.bulletinvar.attrib.include_sysop BIT_TOGGLE;
		}
		break;
	case 9: if(Config_obj.bulletinvar.type == BULL_TOPFILE  ||
		   Config_obj.bulletinvar.type == BULL_FILEOVR)
		{
		    AreasBox_obj.display_listbox(filelistbox, "Select file areas", 50);
		}
		if(Config_obj.bulletinvar.type == BULL_MSGOVR)
		{
		    AreasBox_obj.display_listbox(msglistbox, "Select message areas", 50);
		}
		break;
	case 10: Config_obj.bulletinvar.attrib.create_ascii BIT_TOGGLE;
		 break;
	case 11: Config_obj.bulletinvar.attrib.create_ansi BIT_TOGGLE;
		 break;
	case 12: Config_obj.bulletinvar.attrib.create_avatar BIT_TOGGLE;
		 break;
	case 13: Config_obj.bulletinvar.attrib.create_html BIT_TOGGLE;
		 break;
	case 14: Utility2_obj.toggle(&Config_obj.bulletinvar.enabled);
		 break;
    }

    c.uses_blanks = FALSE;
    c.top = 10;
    c.high_num = 0;
    c.title = NULL;
    c.options = str;

    if(Utility_obj.system_filename(Config_obj.bulletinvar.datafname))
    {
	tmpbuf = (char *) malloc(4000);
	c.left = 20;
	c.width = 40;
	c.items = 3;
	sprintf(str, "  ;Data filename cannot be '%s';  ;", Config_obj.bulletinvar.datafname);
	gettext(1, 1, 80, 25, tmpbuf);
	Menus_obj.dialog(&c, ' ', 1);
	puttext(1, 1, 80, 25, tmpbuf);
	action(18);
	free(tmpbuf);
    }
}

/************************************************************************/

// EOF - BULLMENU.CPP

