/* Header file for the object which writes bulletins */
/* Last updated 05 April 1996 */

#if !defined(__BULLIO_H__)
#define __BULLIO_H__

#include <stdio.h>

#define MAX_COLUMNS 4

/* Information for the header of each bulletin */
struct hdrinfo
{
    char name[61],                 /* Name of this bulletin */
	 column[MAX_COLUMNS][31];  /* Title for each column */
    int width[MAX_COLUMNS];        /* Width for each column */
};

/* Information for the body of each bulletin */
struct txtinfo
{
    char column[MAX_COLUMNS][45];  /* Text for each column */
    int width[MAX_COLUMNS];        /* Width for each column */
};

struct ftrinfo
{
    char row[MAX_COLUMNS][81];        /* Text for each row */
    int width[MAX_COLUMNS];        /* Width for each column */
};

class BullIO
{
    private:
    FILE *ansifile, *asciifile;
    char ansiname[81], asciiname[81], LOGSTR[101];
    char INIT[5], CLS[5];
    int HORIZONTAL, VERTICAL, LEFT_T, RIGHT_T,  LEFT_TOP, RIGHT_TOP, LEFT_BOTTOM,
	RIGHT_BOTTOM, BOTTOM_T, TOP_T, MIDDLE_X;

    public:
    int open_txtfiles(char *str);
    void write_hdr(struct hdrinfo *hdrvar);
    void write_txt(struct txtinfo *txtvar);
    void write_ftr(struct ftrinfo *ftrvar);
    void close_txtfiles(void);
    char *bar(float percent);

    private:
    char *ansiback(int backcolor);
    char *ansicolor(int color);
};
#endif

/* EOF - BULLIO.H */
