// Header file for the bulletin routines
// Created 19 February 1996
// Revised 21 May 1998

#if !defined(__BULLETIN_H__)
#define __BULLETIN_H__

#include "sort.h"
#include "msgs.h"
#include "users.h"
#include "logs.h"
#include "macros.h"
#include "dates.h"
#include "fileopts.h"
#include "utility.h"
#include "screen.h"
#include "crc.h"
#include "amustr.h"


struct msgtrack
{
    long reads,
	 posts;
};

struct door_struct
{
    unsigned long keycrc;
    char keyword[41];
    char description[81];
    struct door_struct *nextrec;
};

struct doors_track
{
    unsigned long crc,    /* CRC-32 of the keyword */
		  num;    /* Number of accesses    */
};

class Bulletin
{
    private:
    char LOGSTR[101];
    class Msgs Msgs_obj;
    class InsertSort Sort_obj;
    class FileOptions BullFileOptions;
    class AMU_Bulletins Bulletin_Macros;
    class Utility Utility_obj;
    class Crc Crc_obj;
    class Amustr Amustr_obj;
    class Dates Todays_Date;
    FILE *mtrackfile;
    sortptr sort_ptr;
    struct sort_array sortvar;
    struct msgtrack msgtrackvar;
    struct door_struct *doortoprec, *doorcurrec, *doortmprec;
    struct transferdata xfervar;
    struct userdata userdatavar;
    struct calldata calldatavar;
    struct msgbase msgbasevar;
    struct info infovar;
    struct amu_users *amu_userptr;
    struct screeninfo s;
    struct filearray *toprec, *currec;
    struct doors_track doorvar;

    public:
    Bulletin(void);
    void create_bulletins(int argc, char *argv[]);

    private:
    int is_sysop(struct amu_users *user);
    char *bar(float percent);
    char *get_bullname(void);
    char *get_bulltype(void);
    float get_value(struct amu_users *ptr);
    int open_track_file(void);
    void update_area(int mode, long area);
    void get_area(int area, double *posts, double *reads);
    void close_track_file(void) { fclose(mtrackfile); }
    int process_doors(void);
    void update_doors(FILE *doorfile, unsigned long crc);
    void free_doors(void);
};
#endif

/* EOF - BULLETIN.H */
