// Bulletin routines, Y2K
// Created 21 March 1996
// Revised 21 May 1998

#include <stdio.h>
#include <stdlib.h>
#include <share.h>
#include <conio.h>
#include <io.h>
#include <mem.h>
#include <string.h>
#include "config.h"
#include "bulletin.h"
#include "screen.h"
#include "extern.h"

static int sort_function(const void *a, const void *b);
static int door_sort(const void *a, const void *b);
static int Sort_Type;

extern class Config Config_obj;
extern class Screen Screen_obj;

/***********************************************************************/

/* Constructor for the bulletins class */
Bulletin::Bulletin(void)
{
    amu_userptr = NULL;
    toprec = currec = NULL;
}

/* Create bulletins */
void Bulletin::create_bulletins(int argc, char *argv[])
{
    FILE *datafile, *tmpuserfile;
    char *user_buffer, fn[MAX_FILENAME], tmpparam[41];
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    int index, x, num_entries, delete_msgbase, delete_doors, ok, z;
    long usersize, num_users, low_bps, high_bps;
    double percent;

    delete_msgbase = delete_doors = FALSE;
    user_buffer = NULL;
    strcpy(s.curoption, "Processing bulletins");
    Config_obj.open_config(BULLETIN_RECORD);
    for(index = 1; index <= Config_obj.num_bulletin; index++)
    {
	if(user_buffer)
	{
	    free(user_buffer);
	    user_buffer = NULL;
	}
	if(!Config_obj.read_record(BULLETIN_RECORD, index))
	{
	    sprintf(LOGSTR, "! [BULLETIN] Error reading bulletin #%d", index);
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	    continue;
	}

	if(!Config_obj.bulletinvar.enabled)
	{
	    continue;
	}

        if((Config_obj.bulletinvar.type == BULL_TOPPOST || Config_obj.bulletinvar.type == BULL_POSTCALL) &&
           Config_obj.amu_cfgvar.BBStype == LORA3)
        { 
            sprintf(LOGSTR, "! [BULLETIN] Top Posters and Post:Call bulletins not available for Lora 3.00 systems");
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            continue;
        }


	if(Config_obj.bulletinvar.fname == NULL)
	{
	    sprintf(LOGSTR, "! [BULLETIN] Bulletin filename not defined, skipping #%d", index);
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	    continue;
	}

	if(Config_obj.bulletinvar.templatefn == NULL)
	{
	    sprintf(LOGSTR, "! [BULLETIN] Bulletin template file not defined, skipping #%d", index);
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	    continue;
	}

	switch(Config_obj.bulletinvar.type)
	{
            case BULL_TOPUL   :
            case BULL_TOPULK  :
            case BULL_TOPDL   :
	    case BULL_TOPDLK  :
            case BULL_ULDL    :
            case BULL_ULDLK   :
            case BULL_TOPPOST :
            case BULL_TOPCALL :
            case BULL_POSTCALL: strcpy(tmpparam, "TOPUSERS");
				break;
	    case BULL_TOPFILE : strcpy(tmpparam, "TOPFILE");
				break;
	    case BULL_FILEOVR : strcpy(tmpparam, "FILEOVR");
				break;
            case BULL_MSGOVR  : strcpy(tmpparam, "MSGOVR");
				break;
            case BULL_DOORS   : strcpy(tmpparam, "DOORS");
				break;
            case BULL_DAILYDL : strcpy(tmpparam, "DAILYDL");
				break;
	    case BULL_DAILYUL : strcpy(tmpparam, "DAILYUL");
				break;
	    case BULL_USERLIST: strcpy(tmpparam, "USERLIST");
				break;
	    case BULL_TODAYCALL: strcpy(tmpparam, "TODAYCALL");
				break;
	    case BULL_BIRTHDAY: strcpy(tmpparam, "BDAYLIST");
				break;
	    case BULL_SUBEXP  : strcpy(tmpparam, "SUBLIST");
				break;
	    default: tmpparam[0] = NULL;
		     break;
	}
	if(!Utility_obj.check_param(argc, argv, tmpparam, 0))
	{
	    continue;
	}

	/* Tell the Bulletin_Macros object about the new bulletin */
	Bulletin_Macros.set_bulletin(&Config_obj.bulletinvar);

	_splitpath(Config_obj.bulletinvar.fname, drive, dir, fname, ext);
	sprintf(s.curarea, "Bulletin record #%d - '%s'", index, fname);
	Utility_obj.logentry(s.curarea, LOG_NORMAL);
	Screen_obj.display(&s);

	  /* If this is a user bulletin, try to read the user index */
	if(Config_obj.bulletinvar.type <= BULL_POSTCALL ||
	   Config_obj.bulletinvar.type == BULL_DAILYDL ||
	   Config_obj.bulletinvar.type == BULL_DAILYUL ||
	   Config_obj.bulletinvar.type == BULL_USERLIST ||
	   Config_obj.bulletinvar.type == BULL_SUBEXP ||
	   Config_obj.bulletinvar.type == BULL_TODAYCALL ||
	   Config_obj.bulletinvar.type == BULL_BIRTHDAY)
	{

	    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TMPUSERS_AMU);
	    tmpuserfile = _fsopen(fn, "rb", SH_DENYNO);
	    if(!tmpuserfile)
	    {
		sprintf(LOGSTR, "! [BULLETIN] Unable to open AMU user index '%s'", fn);
		Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
		continue;
	    }
	    usersize = filelength(fileno(tmpuserfile));
	    user_buffer = (char *) malloc(usersize);
	    if(!user_buffer)
	    {
		sprintf(LOGSTR, "! [BULLETIN] Unable to allocate memory for AMU user index");
		Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
		fclose(tmpuserfile);
		continue;
	    }
	    fread(user_buffer, usersize, 1, tmpuserfile);
	    fclose(tmpuserfile);
	    Sort_Type = Config_obj.bulletinvar.type;
	    num_users = usersize / sizeof(struct amu_users);

	    if(Config_obj.bulletinvar.type <= BULL_POSTCALL)
	    {
		qsort(user_buffer, num_users, sizeof(struct amu_users), sort_function);
	    }
	}

	switch(Config_obj.bulletinvar.type)
	{
	    case BULL_TOPUL   :
	    case BULL_TOPULK  :
	    case BULL_TOPDL   :
	    case BULL_TOPDLK  :
	    case BULL_ULDL    :
	    case BULL_ULDLK   :
	    case BULL_TOPPOST :
	    case BULL_TOPCALL :
	    case BULL_POSTCALL:

				/* Set the pointer to the user buffer,
				   allocate a new Macros class, and
				   clear the current macro record */
				amu_userptr = (struct amu_users *) user_buffer;
				Bulletin_Macros.clear_macro_record();

				/* Run through the user buffer and accumulate
				   the totals for each piece of user information */
				z = num_users;
				for(x = 0; x < z; x++)
				{
				    if(!Config_obj.bulletinvar.attrib.include_sysop &&
				       is_sysop(amu_userptr))
				    {
					num_users--;
				    }
				    else
				    {
					Bulletin_Macros.macrosvar.TotalUls += (double) amu_userptr->uls;
					Bulletin_Macros.macrosvar.TotalUlsk += (double) amu_userptr->ulkb;
					Bulletin_Macros.macrosvar.TotalDls += (double) amu_userptr->dls;
					Bulletin_Macros.macrosvar.TotalDlsk += (double) amu_userptr->dlkb;
					Bulletin_Macros.macrosvar.TotalPosts += (double) amu_userptr->posts;
					Bulletin_Macros.macrosvar.TotalCalls += (double) amu_userptr->calls;
				    }
				    amu_userptr++;
				}

				/* Calculate the ratios */
				if(Bulletin_Macros.macrosvar.TotalDls > 0.0)
				{
				    Bulletin_Macros.macrosvar.TotalUlDlRatio = Bulletin_Macros.macrosvar.TotalUls / Bulletin_Macros.macrosvar.TotalDls;
				}
				if(Bulletin_Macros.macrosvar.TotalDlsk > 0.0)
				{
				    Bulletin_Macros.macrosvar.TotalUlDlRatiok = Bulletin_Macros.macrosvar.TotalUlsk / Bulletin_Macros.macrosvar.TotalDlsk;
				}
				if(Bulletin_Macros.macrosvar.TotalCalls > 0.0)
				{
				    Bulletin_Macros.macrosvar.TotalPostCallRatio = Bulletin_Macros.macrosvar.TotalPosts / Bulletin_Macros.macrosvar.TotalCalls;
				}

				/* Calculate the averages */
				if(num_users > 0)
				{
				    Bulletin_Macros.macrosvar.AverageUls = Bulletin_Macros.macrosvar.TotalUls / (double) num_users;
				    Bulletin_Macros.macrosvar.AverageUlsk = Bulletin_Macros.macrosvar.TotalUlsk / (double) num_users;
				    Bulletin_Macros.macrosvar.AverageDls = Bulletin_Macros.macrosvar.TotalDls / (double) num_users;
				    Bulletin_Macros.macrosvar.AverageDlsk = Bulletin_Macros.macrosvar.TotalDlsk / (double) num_users;
				    Bulletin_Macros.macrosvar.AveragePosts = Bulletin_Macros.macrosvar.TotalPosts / (double) num_users;
				    Bulletin_Macros.macrosvar.AverageCalls = Bulletin_Macros.macrosvar.TotalCalls / (double) num_users;
				    Bulletin_Macros.macrosvar.AverageUlDlRatio = Bulletin_Macros.macrosvar.TotalUlDlRatio / (double) num_users;
				    Bulletin_Macros.macrosvar.AverageUlDlRatiok = Bulletin_Macros.macrosvar.TotalUlDlRatiok / (double) num_users;
				    Bulletin_Macros.macrosvar.AveragePostCallRatio = Bulletin_Macros.macrosvar.TotalPostCallRatio / (double) num_users;
				}


				/* Now see if the number of users needs to be adjusted */
				if(num_users < Config_obj.bulletinvar.num_listed)
				{
				    Config_obj.bulletinvar.num_listed = num_users;
				}

				/* Call the method to process the headers */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				/* Run through the user buffer and call the
				   method to write the repeating data */

				amu_userptr = (struct amu_users *) user_buffer;
				for(x = 0; x < Config_obj.bulletinvar.num_listed; x++)
				{
				    if(!Config_obj.bulletinvar.attrib.include_sysop &&
				       is_sysop(amu_userptr))
				    {
					amu_userptr++;
					continue;
				    }
				    Bulletin_Macros.macrosvar.Rank++;
				    strcpy(Bulletin_Macros.macrosvar.UserName, amu_userptr->realname);
				    strcpy(Bulletin_Macros.macrosvar.UserAlias, amu_userptr->handle);
				    strcpy(Bulletin_Macros.macrosvar.Location, amu_userptr->location);
				    Bulletin_Macros.macrosvar.UserUls = (double) amu_userptr->uls;
				    Bulletin_Macros.macrosvar.UserUlsk = (double) amu_userptr->ulkb;
				    Bulletin_Macros.macrosvar.UserDls = (double) amu_userptr->dls;
				    Bulletin_Macros.macrosvar.UserDlsk = (double) amu_userptr->dlkb;
				    Bulletin_Macros.macrosvar.UserPosts = (double) amu_userptr->posts;
				    Bulletin_Macros.macrosvar.UserCalls = (double) amu_userptr->calls;
				    Bulletin_Macros.macrosvar.Birthdate = amu_userptr->BirthDate;
				    Bulletin_Macros.macrosvar.Subdate = amu_userptr->SubDate;

				    Bulletin_Macros.macrosvar.UserUlDlRatio = Bulletin_Macros.macrosvar.UserUls;
				    Bulletin_Macros.macrosvar.UserUlDlRatiok = Bulletin_Macros.macrosvar.UserUlsk;
				    Bulletin_Macros.macrosvar.UserPostCallRatio = Bulletin_Macros.macrosvar.UserPosts;
				    if(Bulletin_Macros.macrosvar.UserDls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatio = Bulletin_Macros.macrosvar.UserUls / Bulletin_Macros.macrosvar.UserDls;
				    }
				    if(Bulletin_Macros.macrosvar.UserDlsk > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatiok = Bulletin_Macros.macrosvar.UserUlsk / Bulletin_Macros.macrosvar.UserDlsk;
				    }
				    if(Bulletin_Macros.macrosvar.UserCalls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserPostCallRatio = Bulletin_Macros.macrosvar.UserPosts / Bulletin_Macros.macrosvar.UserCalls;
				    }

				    percent = 0.0;
				    switch(Config_obj.bulletinvar.type)
				    {
					case BULL_TOPUL   : if(Bulletin_Macros.macrosvar.TotalUls)
							    {
								percent = Bulletin_Macros.macrosvar.UserUls / Bulletin_Macros.macrosvar.TotalUls;
							    }
							    break;
					case BULL_TOPULK  : if(Bulletin_Macros.macrosvar.TotalUlsk)
							    {
								percent = Bulletin_Macros.macrosvar.UserUlsk / Bulletin_Macros.macrosvar.TotalUlsk;
							    }
							    break;
					case BULL_TOPDL   : if(Bulletin_Macros.macrosvar.TotalDls)
							    {
								percent = Bulletin_Macros.macrosvar.UserDls / Bulletin_Macros.macrosvar.TotalDls;
							    }							    break;
					case BULL_TOPDLK  : if(Bulletin_Macros.macrosvar.TotalDlsk)
							    {
								percent = Bulletin_Macros.macrosvar.UserDlsk / Bulletin_Macros.macrosvar.TotalDlsk;
							    }							    break;
					case BULL_ULDL    : percent = 0.0;
							    break;
					case BULL_ULDLK   : percent = 0.0;
							    break;
					case BULL_TOPPOST : if(Bulletin_Macros.macrosvar.TotalPosts)
							    {
								percent = Bulletin_Macros.macrosvar.UserPosts / Bulletin_Macros.macrosvar.TotalPosts;
							    }							    break;
					case BULL_TOPCALL : if(Bulletin_Macros.macrosvar.TotalCalls)
							    {
								percent = Bulletin_Macros.macrosvar.UserCalls / Bulletin_Macros.macrosvar.TotalCalls;
							    }							    break;
					case BULL_POSTCALL: percent = 0.0;
							    break;
				    }
				    strcpy(Bulletin_Macros.macrosvar.UsageGraph, bar(percent));
				    Bulletin_Macros.process_template(PROCESS_TEXT);
				    amu_userptr++;
				}
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				Bulletin_Macros.close_bulletins();
				amu_userptr = NULL;
				break;

	    case BULL_DOORS   : if(Config_obj.bulletinvar.datafname[0] == NULL)
				{
				    sprintf(LOGSTR, "! [BULLETIN] Data filename not defined, skipping bulletin #%d.  Run AMUCFG to correct.", index);
				    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				    continue;
				}

				if(!process_doors())
				{
				    continue;
				}
				sprintf(fn, "%s%s.AMU", Config_obj.amu_cfgvar.AMUpath,
					Config_obj.bulletinvar.datafname);
				datafile = _fsopen(fn, "rb", SH_DENYWR);
				if(!datafile)
				{
				    sprintf(LOGSTR, "! [BULLETIN] Unable to open '%s'", fn);
				    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				    free_doors();
				    continue;
				}

				/* Create a new AMU_Bulletins instance and
				   clear the macros record */
				Bulletin_Macros.clear_macro_record();

				/* Create the files & the header */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

			       /* Get the total number of door accesses */
				fread(&doorvar, sizeof(doorvar), 1, datafile);
				while(!feof(datafile))
				{
				    Bulletin_Macros.macrosvar.TotalDoorAccess += (double) doorvar.num;
				    fread(&doorvar, sizeof(doorvar), 1, datafile);
				}

				x = 0;
				fseek(datafile, 0, SEEK_SET);
				fread(&doorvar, sizeof(doorvar), 1, datafile);
				while(!feof(datafile))
				{
				    doorcurrec = doortoprec;
				    while(doorcurrec)
				    {
					if(doorcurrec -> keycrc == doorvar.crc)
					{
					    break;
					}
					doorcurrec = doorcurrec -> nextrec;
				    }
				    x++;
				    Bulletin_Macros.macrosvar.Rank++;
				    Bulletin_Macros.macrosvar.DoorAccess = (double) doorvar.num;
				    strcpy(Bulletin_Macros.macrosvar.DoorName, doorcurrec -> description);
				    if(Bulletin_Macros.macrosvar.TotalDoorAccess > 0.0)
				    {
					percent = Bulletin_Macros.macrosvar.DoorAccess / Bulletin_Macros.macrosvar.TotalDoorAccess;
				    }
				    else
				    {
					percent = 0.0;
				    }
				    strcpy(Bulletin_Macros.macrosvar.UsageGraph, bar(percent));
				    Bulletin_Macros.process_template(PROCESS_TEXT);
				    fread(&doorvar, sizeof(doorvar), 1, datafile);
				}
				fclose(datafile);
				free_doors();
				if(x > 0)
				{
				    Bulletin_Macros.macrosvar.AverageDoorAccess = Bulletin_Macros.macrosvar.TotalDoorAccess / (double) x;
				}
				else
				{
				    Bulletin_Macros.macrosvar.AverageDoorAccess = 0.0;
				}
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				Bulletin_Macros.close_bulletins();
				delete_doors = TRUE;
				break;

	    case BULL_MSGOVR :  if(Config_obj.bulletinvar.datafname[0] == NULL)
				{
				    sprintf(LOGSTR, "! [BULLETIN] Data filename not defined, skipping bulletin #%d.  Run AMUCFG to correct.", index);
				    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				    continue;
				}

				Config_obj.open_config(MSGAREA_RECORD);
				if(!open_track_file())
				{
				    Config_obj.close_config(MSGAREA_RECORD);
				    continue;
				}
				sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, MSGBASE);
				datafile = _fsopen(fn, "rb", SH_DENYNO);
				if(!datafile)
				{
				    sprintf(LOGSTR, "! [BULLETIN] Unable to open msgbase info file");
				    Config_obj.close_config(MSGAREA_RECORD);
				    close_track_file();
				    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				    continue;
				}

				/* Create a new AMU_Bulletins instance and
				   clear the macros record */
				Bulletin_Macros.clear_macro_record();

				/* Create the files & the header */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				x = fread(&msgbasevar, sizeof(msgbasevar), 1, datafile);
				while(!feof(datafile) && !ferror(datafile) && x == 1)
				{
				    update_area(msgbasevar.type, msgbasevar.areanum);
				    x = fread(&msgbasevar, sizeof(msgbasevar), 1, datafile);
				}
				fclose(datafile);

				for(x = 1; x <= Config_obj.num_msgarea; x++)
				{
				    Config_obj.read_record(MSGAREA_RECORD, x);
				    if(!Config_obj.active(x))
				    {
					continue;
				    }

				    if(Config_obj.msgareavar.areaname[0] == NULL)
				    {
					continue;
				    }

				    get_area(x, &Bulletin_Macros.macrosvar.AreaPosts, &Bulletin_Macros.macrosvar.AreaReads);
				    Bulletin_Macros.macrosvar.AreaMsgs = Msgs_obj.area_info(&Config_obj.msgareavar);
				    Bulletin_Macros.macrosvar.AreaNum = x;
				    strcpy(Bulletin_Macros.macrosvar.AreaName, Config_obj.msgareavar.areaname);
				    Bulletin_Macros.macrosvar.TotalMsgs += Bulletin_Macros.macrosvar.AreaMsgs;
				    Bulletin_Macros.macrosvar.TotalMsgPosts += Bulletin_Macros.macrosvar.AreaPosts;
				    Bulletin_Macros.macrosvar.TotalMsgReads += Bulletin_Macros.macrosvar.AreaReads;
				    Bulletin_Macros.process_template(PROCESS_TEXT);
				}
				Config_obj.close_config(MSGAREA_RECORD);
				close_track_file();
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				delete_msgbase = TRUE;
				break;

	    case BULL_FILEOVR :
				/* Create a new AMU_Bulletins instance and
				   clear the macros record */
				Bulletin_Macros.clear_macro_record();

				/* Create the files & the header */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				Config_obj.open_config(FILEAREA_RECORD);
				for(x = 1; x <= Config_obj.num_filearea; x++)
				{
				    if(!Config_obj.active(x))
				    {
					continue;
				    }

				    Config_obj.read_record(FILEAREA_RECORD, x);
				    if(Config_obj.fileareavar.areaname[0] == NULL)
				    {
					continue;
				    }

				    BullFileOptions.get_info(x, &infovar);

				    /* Increment the total count */
				    Bulletin_Macros.macrosvar.TotalSize += (double) infovar.bytes;
				    Bulletin_Macros.macrosvar.TotalFiles += (double) infovar.files;
				    Bulletin_Macros.macrosvar.TotalFileDls += (double) infovar.dls;

				    /* Increment the Area Count */
				    Bulletin_Macros.macrosvar.AreaSize = (double) infovar.bytes;
				    Bulletin_Macros.macrosvar.AreaSizek = (double) infovar.bytes / 1024.0;
				    Bulletin_Macros.macrosvar.AreaFiles = (double) infovar.files;
				    Bulletin_Macros.macrosvar.AreaFileDls = (double) infovar.dls;
				    strcpy(Bulletin_Macros.macrosvar.AreaName, Config_obj.fileareavar.areaname);
				    Bulletin_Macros.macrosvar.AreaNum = x;

				    Bulletin_Macros.process_template(PROCESS_TEXT);
				}
				Bulletin_Macros.macrosvar.TotalSizek = Bulletin_Macros.macrosvar.TotalSize / 1024.0;
				Config_obj.close_config(FILEAREA_RECORD);
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				break;

	    case BULL_TOPFILE : sort_ptr = Sort_obj.sortinit();
				if(!sort_ptr)
				{
				    sprintf(LOGSTR, "! [TOPFILE] Unable to allocate sorting space");
				    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				    continue;
				}

				/* Create a new AMU_Bulletins instance and
				   clear the macros record */
				Bulletin_Macros.clear_macro_record();

				/* Create the files & the header */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				Config_obj.open_config(FILEAREA_RECORD);
				for(x = 1; x <= Config_obj.num_filearea; x++)
				{
				    if(!Config_obj.active(x))
				    {
					continue;
				    }

				    Config_obj.read_record(FILEAREA_RECORD, x);
				    if(Config_obj.fileareavar.areaname[0] == NULL)
				    {
					continue;
				    }

				    if(!Utility_obj.check_param(argc, argv, "TOPFILE", x))
				    {
					continue;
				    }

				    BullFileOptions.set_area(x);
				    if(BullFileOptions.open_area(READ_MODE, NO_BACKUP, NO_RESTORE)
				       && BullFileOptions.read_area() == 0)
				    {
					toprec = currec = BullFileOptions.get_toprec();
					while(currec)
					{
					    if(currec -> filename[0] != NULL)
					    {
						Bulletin_Macros.macrosvar.TotalFileDls += (double) currec->timesdl;
						Bulletin_Macros.macrosvar.TotalFiles++;
						Bulletin_Macros.macrosvar.TotalSize += (double) currec->size;

						strncpy(sortvar.fname, currec -> filename, sizeof(sortvar.fname)-1);
						sortvar.sortfield = currec -> timesdl;
						sortvar.filesize = currec -> size;
						sortvar.areanum = x;
						Sort_obj.addtoarray(&sortvar);
					    }
					    currec = currec -> nextrec;
					}
					BullFileOptions.close_area();
					BullFileOptions.deallocate_area();
				    }
				}

				  // Figure the total sizek and average dls
				Bulletin_Macros.macrosvar.TotalSizek = Bulletin_Macros.macrosvar.TotalSize / 1024.0;
				if(Bulletin_Macros.macrosvar.TotalFiles > 0.0)
				{
				    Bulletin_Macros.macrosvar.AverageFileDls = Bulletin_Macros.macrosvar.TotalFileDls / Bulletin_Macros.macrosvar.TotalFiles;
				}

				Sort_obj.sortarray();
				if(Config_obj.bulletinvar.num_listed > MAX_SORT)
				{
				    Config_obj.bulletinvar.num_listed = MAX_SORT;
				}
				for(x = 0; x < Config_obj.bulletinvar.num_listed; x++)
				{
				    Config_obj.read_record(FILEAREA_RECORD, sort_ptr[x].areanum);
				    strcpy(Bulletin_Macros.macrosvar.AreaName, Config_obj.fileareavar.areaname);

				    strcpy(Bulletin_Macros.macrosvar.FileName, sort_ptr[x].fname);
				    Bulletin_Macros.macrosvar.Rank++;
				    Bulletin_Macros.macrosvar.FileDls = (double) sort_ptr[x].sortfield;
				    Bulletin_Macros.macrosvar.FileSize = (double) sort_ptr[x].filesize;
				    Bulletin_Macros.macrosvar.FileSizek = (double) sort_ptr[x].filesize / 1024.0;

				    Bulletin_Macros.process_template(PROCESS_TEXT);
				}
				Config_obj.close_config(FILEAREA_RECORD);
				Sort_obj.freearray();

				Bulletin_Macros.process_template(PROCESS_FOOTER);
				break;

	    case BULL_DAILYDL :
	    case BULL_DAILYUL : sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TRANSFER_BULL);
				datafile = _fsopen(fn, "rb", SH_DENYNO);
				if(!datafile)
				{
				    sprintf(LOGSTR, "! [BULLETIN] Unable to open transfer info file");
				    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				    continue;
				}

				/* Create a new AMU_Bulletins instance and
				   clear the macros record */
				Bulletin_Macros.clear_macro_record();

				/* Create the files & the header */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				low_bps = -1;
				high_bps = 0x7FFFFFFF;
				num_entries = 0;

				fread(&xfervar, sizeof(xfervar), 1, datafile);
				while(!feof(datafile))
				{
				    if(!Config_obj.bulletinvar.attrib.include_sysop)
				    {
					if(strstr(xfervar.username, Config_obj.amu_cfgvar.sysop) ||
					   strstr(xfervar.username, Config_obj.amu_cfgvar.sysopalias))
					{
					    fread(&xfervar, sizeof(xfervar), 1, datafile);
					    continue;
					}
				    }
				    if(xfervar.username[0] && ( (xfervar.type == UPLOAD && Config_obj.bulletinvar.type == BULL_DAILYUL) ||
								(xfervar.type == DOWNLOAD && Config_obj.bulletinvar.type == BULL_DAILYDL)))
				    {
					num_entries++;
					if(xfervar.bps > 0 && (xfervar.bps < low_bps  ||  low_bps == -1))
					{
					    low_bps = xfervar.bps;
					}
					if(xfervar.bps > 0 && (xfervar.bps > high_bps  ||  high_bps == 0x7FFFFFFF))
					{
					    high_bps = xfervar.bps;
					}

					amu_userptr = (struct amu_users *) user_buffer;
					for(x = 0; x < num_users; x++)
					{
					    if(strstr(amu_userptr -> realname, xfervar.username) ||
					       strstr(amu_userptr -> handle, xfervar.username))
					    {
						Bulletin_Macros.macrosvar.Rank++;
						strcpy(Bulletin_Macros.macrosvar.UserName, amu_userptr->realname);
						strcpy(Bulletin_Macros.macrosvar.UserAlias, amu_userptr->handle);
						strcpy(Bulletin_Macros.macrosvar.Location, amu_userptr->location);
						break;
					    }
					    amu_userptr++;
					}
					strcpy(Bulletin_Macros.macrosvar.FileName, xfervar.fname);
					Bulletin_Macros.macrosvar.BpsRate = xfervar.bps;
					Bulletin_Macros.process_template(PROCESS_TEXT);
				    }
				    fread(&xfervar, sizeof(xfervar), 1, datafile);
				}
				fclose(datafile);
				if(high_bps == 0x7FFFFFFF && low_bps == -1)
				{
				    high_bps = low_bps = 0;
				}
				else
				{
				    if(low_bps == 0x7FFFFFFF)
				    {
					low_bps = high_bps;
				    }
				    if(high_bps == -1)
				    {
					high_bps = low_bps;
				    }
				}
				Bulletin_Macros.macrosvar.LowestBpsRate = low_bps;
				Bulletin_Macros.macrosvar.HighestBpsRate = high_bps;
				Bulletin_Macros.macrosvar.NumXfer = (double) num_entries;
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				break;

	    case BULL_USERLIST:
				/* Set the pointer to the user buffer,
				   allocate a new Macros class, and
				   clear the current macro record */
				amu_userptr = (struct amu_users *) user_buffer;
				Bulletin_Macros.clear_macro_record();

				/* Call the method to process the headers */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				/* Run through the user buffer and call the
				   method to write the repeating data */
				amu_userptr = (struct amu_users *) user_buffer;
				for(x = 0; x < num_users; x++)
				{
				    if(!Config_obj.bulletinvar.attrib.include_sysop &&
				       is_sysop(amu_userptr) == TRUE)
				    {
					amu_userptr++;
					continue;
				    }
				    Bulletin_Macros.macrosvar.Rank++;
				    strcpy(Bulletin_Macros.macrosvar.UserName, amu_userptr->realname);
				    strcpy(Bulletin_Macros.macrosvar.UserAlias, amu_userptr->handle);
				    strcpy(Bulletin_Macros.macrosvar.Location, amu_userptr->location);
				    Bulletin_Macros.macrosvar.UserUls = (double) amu_userptr->uls;
				    Bulletin_Macros.macrosvar.UserUlsk = (double) amu_userptr->ulkb;
				    Bulletin_Macros.macrosvar.UserDls = (double) amu_userptr->dls;
				    Bulletin_Macros.macrosvar.UserDlsk = (double) amu_userptr->dlkb;
				    Bulletin_Macros.macrosvar.UserPosts = (double) amu_userptr->posts;
				    Bulletin_Macros.macrosvar.UserCalls = (double) amu_userptr->calls;
				    Bulletin_Macros.macrosvar.Birthdate = amu_userptr->BirthDate;
				    Bulletin_Macros.macrosvar.Subdate = amu_userptr->SubDate;
				    if(Bulletin_Macros.macrosvar.UserDls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatio = Bulletin_Macros.macrosvar.UserUls / Bulletin_Macros.macrosvar.UserDls;
				    }
				    if(Bulletin_Macros.macrosvar.UserDlsk > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatiok = Bulletin_Macros.macrosvar.UserUlsk / Bulletin_Macros.macrosvar.UserDlsk;
				    }
				    if(Bulletin_Macros.macrosvar.UserCalls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserPostCallRatio = Bulletin_Macros.macrosvar.UserPosts / Bulletin_Macros.macrosvar.UserCalls;
				    }
				    Bulletin_Macros.process_template(PROCESS_TEXT);
				    amu_userptr++;
				}
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				Bulletin_Macros.close_bulletins();
				amu_userptr = NULL;
				break;

	    case BULL_BIRTHDAY:
	    case BULL_SUBEXP  :
				/* Set the pointer to the user buffer,
				   allocate a new Macros class, and
				   clear the current macro record */
				amu_userptr = (struct amu_users *) user_buffer;
				Bulletin_Macros.clear_macro_record();

				/* Call the method to process the headers */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				/* Run through the user buffer and call the
				   method to write the repeating data */
				amu_userptr = (struct amu_users *) user_buffer;
				for(x = 0; x < num_users; x++)
				{
				    if(!Config_obj.bulletinvar.attrib.include_sysop &&
				       is_sysop(amu_userptr))
				    {
					amu_userptr++;
					continue;
				    }

				    ok = FALSE;
				    if(Config_obj.bulletinvar.type == BULL_BIRTHDAY)
				    {
					if(amu_userptr -> BirthDate.getDay() == Todays_Date.getDay() &&
					   amu_userptr -> BirthDate.getMonth() == Todays_Date.getMonth())
					{
					    ok = TRUE;
					}
				    }
				    if(Config_obj.bulletinvar.type == BULL_SUBEXP)
				    {
					if(Todays_Date.getDateDiff(&amu_userptr -> SubDate) == 0)
					{
					    ok = TRUE;
					}
				    }

				    if(ok == FALSE)
				    {
					amu_userptr++;
					continue;
				    }

				    Bulletin_Macros.macrosvar.Rank++;
				    strcpy(Bulletin_Macros.macrosvar.UserName, amu_userptr->realname);
				    strcpy(Bulletin_Macros.macrosvar.UserAlias, amu_userptr->handle);
				    strcpy(Bulletin_Macros.macrosvar.Location, amu_userptr->location);
				    Bulletin_Macros.macrosvar.UserUls = (double) amu_userptr->uls;
				    Bulletin_Macros.macrosvar.UserUlsk = (double) amu_userptr->ulkb;
				    Bulletin_Macros.macrosvar.UserDls = (double) amu_userptr->dls;
				    Bulletin_Macros.macrosvar.UserDlsk = (double) amu_userptr->dlkb;
				    Bulletin_Macros.macrosvar.UserPosts = (double) amu_userptr->posts;
				    Bulletin_Macros.macrosvar.UserCalls = (double) amu_userptr->calls;
				    Bulletin_Macros.macrosvar.Birthdate = amu_userptr->BirthDate;
				    Bulletin_Macros.macrosvar.Subdate = amu_userptr->SubDate;
				    if(Bulletin_Macros.macrosvar.UserDls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatio = Bulletin_Macros.macrosvar.UserUls / Bulletin_Macros.macrosvar.UserDls;
				    }
				    if(Bulletin_Macros.macrosvar.UserDlsk > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatiok = Bulletin_Macros.macrosvar.UserUlsk / Bulletin_Macros.macrosvar.UserDlsk;
				    }
				    if(Bulletin_Macros.macrosvar.UserCalls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserPostCallRatio = Bulletin_Macros.macrosvar.UserPosts / Bulletin_Macros.macrosvar.UserCalls;
				    }
				    Bulletin_Macros.process_template(PROCESS_TEXT);
				    amu_userptr++;
				}
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				Bulletin_Macros.close_bulletins();
				amu_userptr = NULL;
				break;

	    case BULL_TODAYCALL:
				sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, TODAYCALLINFO);
				datafile = _fsopen(fn, "rb", SH_DENYWR);
				if(!datafile)
				{
				    sprintf(LOGSTR, "! [TODAYCALL] Unable to open '%s' - (%s)", fn, strerror(errno));
				    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
				    continue;
				}

				Bulletin_Macros.clear_macro_record();

				/* Call the method to process the headers */
				Bulletin_Macros.create_bulletins();
				Bulletin_Macros.process_template(PROCESS_HEADER);

				fread(&calldatavar, sizeof(calldatavar), 1, datafile);
				while(!feof(datafile))
				{
				    ok = FALSE;
				    amu_userptr = (struct amu_users *) user_buffer;
				    x = 0;
				    while(amu_userptr && x < num_users)
				    {
					if(strcmp(amu_userptr->realname, calldatavar.username) == 0 ||
					   strcmp(amu_userptr->handle, calldatavar.username) == 0)
					{
					    ok = TRUE;
					    if(Config_obj.bulletinvar.attrib.include_sysop == FALSE &&
					       is_sysop(amu_userptr) == TRUE)
					    {
						ok = FALSE;
					    }
					    break;
					}
					x++;
					amu_userptr++;
				    }

				    if(ok == FALSE)
				    {
					fread(&calldatavar, sizeof(calldatavar), 1, datafile);
					continue;
				    }

				    Bulletin_Macros.macrosvar.Rank++;
				    Bulletin_Macros.macrosvar.BpsRate = calldatavar.bps;
				    strcpy(Bulletin_Macros.macrosvar.UserName, amu_userptr->realname);
				    strcpy(Bulletin_Macros.macrosvar.UserAlias, amu_userptr->handle);
				    strcpy(Bulletin_Macros.macrosvar.Location, amu_userptr->location);
				    Bulletin_Macros.macrosvar.UserUls = (double) amu_userptr->uls;
				    Bulletin_Macros.macrosvar.UserUlsk = (double) amu_userptr->ulkb;
				    Bulletin_Macros.macrosvar.UserDls = (double) amu_userptr->dls;
				    Bulletin_Macros.macrosvar.UserDlsk = (double) amu_userptr->dlkb;
				    Bulletin_Macros.macrosvar.UserPosts = (double) amu_userptr->posts;
				    Bulletin_Macros.macrosvar.UserCalls = (double) amu_userptr->calls;
				    Bulletin_Macros.macrosvar.Birthdate = amu_userptr->BirthDate;
				    Bulletin_Macros.macrosvar.Subdate = amu_userptr->SubDate;
				    if(Bulletin_Macros.macrosvar.UserDls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatio = Bulletin_Macros.macrosvar.UserUls / Bulletin_Macros.macrosvar.UserDls;
				    }
				    if(Bulletin_Macros.macrosvar.UserDlsk > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserUlDlRatiok = Bulletin_Macros.macrosvar.UserUlsk / Bulletin_Macros.macrosvar.UserDlsk;
				    }
				    if(Bulletin_Macros.macrosvar.UserCalls > 0.0)
				    {
					Bulletin_Macros.macrosvar.UserPostCallRatio = Bulletin_Macros.macrosvar.UserPosts / Bulletin_Macros.macrosvar.UserCalls;
				    }
				    Bulletin_Macros.process_template(PROCESS_TEXT);
				    fread(&calldatavar, sizeof(calldatavar), 1, datafile);
				}
				fclose(datafile);
				Bulletin_Macros.process_template(PROCESS_FOOTER);
				Bulletin_Macros.close_bulletins();
				break;
	}
	if(user_buffer != NULL)
	{
	    free(user_buffer);
	    user_buffer = NULL;
	}
    }
    Config_obj.close_config(BULLETIN_RECORD);
    if(delete_msgbase == TRUE)
    {
	sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, MSGBASE);
	remove(fn);
    }
    if(delete_doors == TRUE)
    {
	sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, DOORINFO);
	remove(fn);
    }
}

/**********************************************************************/
/* Sort function for the qsort() function */
int sort_function(const void *a, const void *b)
{
    float value1, value2;
    struct amu_users x, y;

    memcpy(&x, a, sizeof(struct amu_users));
    memcpy(&y, b, sizeof(struct amu_users));
    switch(Sort_Type)
    {
        case BULL_TOPUL: value1 = (float) x.uls;
                         value2 = (float) y.uls;
                         break;
        case BULL_TOPDL: value1 = (float) x.dls;
                         value2 = (float) y.dls;
                         break;
        case BULL_TOPULK: value1 = (float) x.ulkb;
                          value2 = (float) y.ulkb;
                          break;
        case BULL_TOPDLK: value1 = (float) x.dlkb;
                          value2 = (float) y.dlkb;
                          break;
        case BULL_TOPCALL: value1 = (float) x.calls;
                           value2 = (float) y.calls;
                           break;
        case BULL_TOPPOST: value1 = (float) x.posts;
			   value2 = (float) y.posts;
                           break;
        case BULL_ULDL: if(x.dls == 0)
                        {
                            x.dls = 1;
                        }
                        if(y.dls == 0)
                        {
                            y.dls = 1;
                        }
                        value1 = (float) x.uls / (float) x.dls;
                        value2 = (float) y.uls / (float) y.dls;
                        break;
        case BULL_ULDLK: if(x.dlkb == 0)
                         {
			     x.dlkb = 1;
                         }
                         if(y.dlkb == 0)
                         {
                             y.dlkb = 1;
                         }
                         value1 = (float) x.ulkb / (float) x.dlkb;
                         value2 = (float) y.ulkb / (float) y.dlkb;
                         break;
        case BULL_POSTCALL: if(x.calls == 0)
                            {
                                x.calls = 1;
                            }
                            if(y.calls == 0)
                            {
				y.calls = 1;
                            }
                            value1 = (float) x.posts / (float) x.calls;
                            value2 = (float) y.posts / (float) y.calls;
                            break;
	default: value1 = value2 = 0.0;
                 break;
    }
    if(value1 < value2)
    {
        return(1);
    }
    if(value1 > value2)
    {
        return(-1);
    }
    return(0);
}

/***********************************************************************/

int Bulletin::open_track_file(void)
{
    char fn[MAX_FILESPEC], fn2[MAX_FILESPEC];
    int status;

    status = TRUE;
    sprintf(fn, "%s%s.AMU", Config_obj.amu_cfgvar.AMUpath, Config_obj.bulletinvar.datafname);
    sprintf(fn2, "%s%s.$$$", Config_obj.amu_cfgvar.workpath, Config_obj.bulletinvar.datafname);
    mtrackfile = _fsopen(fn, "r+b", SH_DENYRW);
    if(!mtrackfile)
    {
	mtrackfile = _fsopen(fn, "w+b", SH_DENYRW);
	if(!mtrackfile)
	{
	    status = FALSE;
	    sprintf(LOGSTR, "! [BULLETIN] Unable to create '%s'", fn);
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	}
    }


    if(chsize(fileno(mtrackfile), sizeof(msgtrackvar) * Config_obj.num_msgarea) == -1)
    {
	Utility_obj.logentry("CHSIZE() screwed up", LOG_MINIMAL);
    }
    fseek(mtrackfile, 0, SEEK_SET);

    /* Now, set the number of records in this file to the number of
       message areas currently defined
    if(mtrackfile)
    {
	 num_recs = filelength(fileno(mtrackfile)) / sizeof(msgtrackvar);

	/* if there are not enough records, add some extras
	if(num_recs < Config_obj.num_msgarea)
	{
	    memset(&msgtrackvar, NULL, sizeof(msgtrackvar));
	    fseek(mtrackfile, 0, SEEK_END);
	    while(num_recs < Config_obj.num_msgarea)
	    {
		fwrite(&msgtrackvar, sizeof(msgtrackvar), 1, mtrackfile);
	    }
	}

	/* If there are too many, get rid of the extra ones
	if(num_recs > Config_obj.num_msgarea)
	{
	    fseek(mtrackfile, 0, SEEK_SET);
	    newfile = fopen(fn2, "w+b");
	    if(newfile)
	    {
		for(x = 0; x < Config_obj.num_msgarea; x++)
		{
		    fread(&msgtrackvar, sizeof(msgtrackvar), 1, mtrackfile);
		    fwrite(&msgtrackvar, sizeof(msgtrackvar), 1, newfile);
		}
		fclose(newfile);
		fclose(mtrackfile);
		Utility_obj.copyfile(fn2, fn);
		mtrackfile = fopen(fn, "rb");
	    }
	}
	fseek(mtrackfile, 0, SEEK_SET);
    }
    */
    return(status);
}

/* update the reads/writes for a given area */
void Bulletin::update_area(int mode, long area)
{
    /* If this is the Combined area, get out of here */
    if(area == 0)
    {
	return;
    }

    msgtrackvar.reads = msgtrackvar.posts = 0;
    fseek(mtrackfile, (area-1) * sizeof(msgtrackvar), SEEK_SET);
    fread(&msgtrackvar, sizeof(msgtrackvar), 1, mtrackfile);

    switch(mode)
    {
	case MSG_READING: msgtrackvar.reads++;
			  break;
	case MSG_WRITE: msgtrackvar.posts++;
			break;
    }
    fseek(mtrackfile, (area-1) * sizeof(msgtrackvar), SEEK_SET);
    fwrite(&msgtrackvar, sizeof(msgtrackvar), 1, mtrackfile);
}

/* Get the posts and reads for a given area from the MSGOVR.AMU type file */
void Bulletin::get_area(int area, double *posts, double *reads)
{
    fseek(mtrackfile, (area-1) * sizeof(msgtrackvar), SEEK_SET);
    if(fread(&msgtrackvar, sizeof(msgtrackvar), 1, mtrackfile) == 1)
    {
	*posts = (double) msgtrackvar.posts;
	*reads = (double) msgtrackvar.reads;
    }
    else
    {
	*posts = *reads = 0.0;
    }
}

/**********************************************************************/

/* Process the DOORINFO.AMU file */
int Bulletin::process_doors(void)
{
    FILE *doortxtfile, *doordatfile, *infofile, *tmpfile;
    struct doors_track trackvar;
    char fn[MAX_FILESPEC], str[101], *ptr;
    int found;
    long x;

    sprintf(fn, "%s%s.CTL", Config_obj.amu_cfgvar.AMUpath, Config_obj.bulletinvar.datafname);
    doortxtfile = _fsopen(fn, "rt", SH_DENYWR);
    if(!doortxtfile)
    {
        sprintf(LOGSTR, "! [DOORS] Unable to open '%s'", fn);
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(FALSE);
    }
    sprintf(fn, "%s%s", Config_obj.amu_cfgvar.AMUpath, DOORINFO);
    infofile = _fsopen(fn, "rt", SH_DENYWR);
    if(!infofile)
    {
        sprintf(LOGSTR, "! [DOORS] Unable to open '%s'", fn);
        fclose(doortxtfile);
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(FALSE);
    }
    sprintf(fn, "%s%s.AMU", Config_obj.amu_cfgvar.AMUpath, Config_obj.bulletinvar.datafname);
    doordatfile = _fsopen(fn, "r+b", SH_DENYWR);
    if(!doordatfile)
    {
        doordatfile = _fsopen(fn, "w+b", SH_DENYWR);
        if(!doordatfile)
        {
            sprintf(LOGSTR, "! [DOORS] Unable to create '%s'", fn);
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            return(FALSE);
        }
    }

    /* Read the information from the DOORS.CTL type file into a list */
    doortoprec = doorcurrec = doortmprec = NULL;
    fgets(str, sizeof(str)-2, doortxtfile);
    while(!feof(doortxtfile))
    {
        if(str[0] != '\n' && str[0] != ';')
        {
            doortmprec = (struct door_struct *)calloc(1, sizeof(struct door_struct));
            if(doorcurrec)
            {
                doorcurrec -> nextrec = doortmprec;
            }
            doorcurrec = doortmprec;
            if(!doortoprec)
            {
                doortoprec = doorcurrec;
            }
            Amustr_obj.strip_n(str);
            sscanf(str, "%s", doorcurrec -> keyword);
            ptr = strchr(str, ' ');
            if(ptr)
            {
                strcpy(doorcurrec -> description, ptr);
                Amustr_obj.trimlead(doorcurrec -> description);
	    }
	    Amustr_obj.us_to_spaces(doorcurrec -> keyword);
	    strupr(doorcurrec -> keyword);
	    doorcurrec -> keycrc = Crc_obj.crc32(doorcurrec -> keyword);

            /* Now see if this entry exists in DOORS.AMU, if it does not,
               add a new entry */
            found = FALSE;
            fseek(doordatfile, 0, SEEK_SET);
            fread(&trackvar, sizeof(trackvar), 1, doordatfile);
            while(!feof(doordatfile) && !found)
            {
                if(trackvar.crc == doorcurrec -> keycrc)
                {
                    found = TRUE;
                }
                else
                {
                    fread(&trackvar, sizeof(trackvar), 1, doordatfile);
                }
            }
            if(!found)
            {
                fseek(doordatfile, 0, SEEK_END);
                trackvar.crc = doorcurrec -> keycrc;
                trackvar.num = 0;
                fwrite(&trackvar, sizeof(trackvar), 1, doordatfile);
            }

	}
        fgets(str, sizeof(str)-2, doortxtfile);
    }

    /* Now check to see if there are any entries in DOORS.AMU that
       need to be removed */
    sprintf(fn, "%s%s.AMU", Config_obj.amu_cfgvar.AMUpath, Config_obj.bulletinvar.datafname);
    sprintf(str, "%s%s.TMP", Config_obj.amu_cfgvar.AMUpath, Config_obj.bulletinvar.datafname);
    tmpfile = _fsopen(str, "w+b", SH_DENYWR);

    fseek(doordatfile, 0, SEEK_SET);
    fread(&trackvar, sizeof(trackvar), 1, doordatfile);
    while(!feof(doordatfile))
    {
        found = FALSE;
        doorcurrec = doortoprec;
        while(!found && doorcurrec)
        {
            if(trackvar.crc == doorcurrec -> keycrc)
            {
                found = TRUE;
            }
            else
            {
                doorcurrec = doorcurrec -> nextrec;
            }
        }
        if(found == TRUE)
        {
            fwrite(&trackvar, sizeof(trackvar), 1, tmpfile);
	}
        fread(&trackvar, sizeof(trackvar), 1, doordatfile);
    }

    fclose(tmpfile);
    fclose(doordatfile);
    Utility_obj.copyfile(str, fn);
    remove(str);
    doordatfile = _fsopen(fn, "r+b", SH_DENYWR);

    /* Read through the info file and update the DOORS.AMU type file */
    while(fgets(str, sizeof(str)-2, infofile))
    {
        strupr(str);
        doorcurrec = doortoprec;
        while(doorcurrec)
        {
            if(strstr(str, doorcurrec -> keyword))
            {
                update_doors(doordatfile, doorcurrec -> keycrc);
                doorcurrec = NULL;
            }
            else
            {
                doorcurrec = doorcurrec -> nextrec;
            }
        }
    }

    /* Now sort the door data file */
    fseek(doordatfile, 0, SEEK_SET);
    x = filelength(fileno(doordatfile));
    ptr = (char *)malloc(x);
    fread(ptr, x, 1, doordatfile);
    qsort(ptr, x / sizeof(struct doors_track), sizeof(struct doors_track), door_sort);
    fseek(doordatfile, 0, SEEK_SET);
    fwrite(ptr, x, 1, doordatfile);

    free(ptr);
    fclose(doordatfile);
    fclose(infofile);
    fclose(doortxtfile);
    return(TRUE);
}


/* See if a record matches the 'crc' value in 'doorfile'.  If so, update
   it, if not, add a new record */
void Bulletin::update_doors(FILE *doorfile, unsigned long crc)
{
    int found, x;
    struct doors_track trackvar;

    found = FALSE;
    x = 0;
    fseek(doorfile, 0, SEEK_SET);
    fread(&trackvar, sizeof(trackvar), 1, doorfile);
    while(!feof(doorfile) && !found)
    {
        if(trackvar.crc == crc)
	{
            trackvar.num++;
            fseek(doorfile, x * sizeof(trackvar), SEEK_SET);
            fwrite(&trackvar, sizeof(trackvar), 1, doorfile);
            found = TRUE;
        }
        else
        {
            fread(&trackvar, sizeof(trackvar), 1, doorfile);
            x++;
        }
    }
    if(!found)
    {
        fseek(doorfile, 0, SEEK_END);
        trackvar.crc = crc;
        trackvar.num = 1;
        fwrite(&trackvar, sizeof(trackvar), 1, doorfile);
    }
}

/* Free the doors list */
void Bulletin::free_doors(void)
{
    doorcurrec = doortoprec;
    while(doorcurrec)
    {
        doortmprec = doorcurrec;
        doorcurrec = doorcurrec -> nextrec;
        free(doortmprec);
    }
}

int door_sort(const void *a, const void *b)
{
    return( ((struct doors_track *)b)->num - ((struct doors_track *)a)->num);
}


/* Return the name of a bulletin */
char *Bulletin::get_bullname(void)
{
    static char type[51];

    sprintf(type, "Top %d ", Config_obj.bulletinvar.num_listed);
    switch(Config_obj.bulletinvar.type)
    {
            case BULL_TOPUL   : strcat(type, "Uploaders");
                                break;
            case BULL_TOPULK  : strcat(type, "Uploaders (KB)");
                                break;
            case BULL_TOPDL   : strcat(type, "Downloaders");
                                break;
            case BULL_TOPDLK  : strcat(type, "Downloaders (KB)");
                                break;
            case BULL_ULDL    : strcat(type, "UL:DL Ratio");
                                break;
            case BULL_ULDLK   : strcat(type, "UL:DL Ratio (KB)");
                                break;
            case BULL_TOPPOST : strcat(type, "Message Posters");
				break;
            case BULL_TOPCALL : strcat(type, "Callers");
                                break;
            case BULL_POSTCALL: strcat(type, "POST:CALL Ratio");
                                break;
    }
    return(type);
}

/* Get the bulletin type */
char *Bulletin::get_bulltype(void)
{
    static char type[6];

    switch(Config_obj.bulletinvar.type)
    {
            case BULL_TOPUL   : strcpy(type, "FILES");
                                break;
            case BULL_TOPULK  : strcpy(type, "KBs");
                                break;
            case BULL_TOPDL   : strcpy(type, "FILES");
                                break;
            case BULL_TOPDLK  : strcpy(type, "KBs");
                                break;
            case BULL_ULDL    : strcpy(type, "RATIO");
                                break;
            case BULL_ULDLK   : strcpy(type, "RATIO");
				break;
            case BULL_TOPPOST : strcpy(type, "POSTS");
                                break;
	    case BULL_TOPCALL : strcpy(type, "CALLS");
                                break;
            case BULL_POSTCALL: strcpy(type, "RATIO");
                                break;
    }
    return(type);
}

/* Return the value for this type of bulletin */
float Bulletin::get_value(struct amu_users *ptr)
{
    float value;

    value = 0.0;
    switch(Config_obj.bulletinvar.type)
    {
            case BULL_TOPUL   : value = (float) ptr -> uls;
                                break;
	    case BULL_TOPULK  : value = (float) ptr -> ulkb;
                                break;
            case BULL_TOPDL   : value = (float) ptr -> dls;
                                break;
            case BULL_TOPDLK  : value = (float) ptr -> dlkb;
                                break;
            case BULL_ULDL    : if(ptr -> dls != 0)
                                {
                                    value = (float) ptr -> uls / (float) ptr -> dls;
                                }
                                else
                                {
				    value = (float) ptr -> uls;
                                }
                                break;
            case BULL_ULDLK   : if(ptr -> dlkb != 0)
                                {
                                    value = (float) ptr -> ulkb / (float) ptr -> dlkb;
                                }
                                else
                                {
				    value = (float) ptr -> ulkb;
                                }
                                break;
	    case BULL_TOPPOST : value = (float) ptr -> posts;
                                break;
            case BULL_TOPCALL : value = (float) ptr -> calls;
                                break;
            case BULL_POSTCALL: if(ptr -> calls != 0)
                                {
                                    value = (float) ptr -> posts / (float) ptr -> calls;
                                }
                                else
                                {
                                    value = (float) ptr -> posts;
                                }
                                break;
    }
    return(value);
}

/* Create a usage graph */
char *Bulletin::bar(float percent)
{
    char disp[51], tmpstr[11], bar[3];
    static char str[41];
    int i, j;

    percent *= 10;
    i = 0;
    if(percent > 0.0)
    {
	i++;
    }
    if(percent > 1.0)
    {
	i++;
    }
    if(percent > 2.0)
    {
	i++;
    }
    if(percent > 3.0)
    {
	i++;
    }
    if(percent > 4.0)
    {
	i++;
    }
    if(percent > 5.0)
    {
	i++;
    }
    if(percent > 6.0)
    {
	i++;
    }
    if(percent > 7.0)
    {
	i++;
    }
    if(percent > 8.0)
    {
	i++;
    }
    if(percent > 9.0)
    {
	i++;
    }
    if(percent >= 10.0)
    {
	i++;
    }

    strcpy(bar, "");

    disp[0] = NULL;
    for(j = 0; j < i; j++)
    {
	strcat(disp, bar);
    }

    Amustr_obj.pad(disp, 20);
    sprintf(tmpstr, "%0.1f%% ", percent * 10);
    Amustr_obj.lpad(tmpstr, 10);
    sprintf(str, "%s%s", disp, tmpstr);
    return(str);
}

/* See if the current user is the Sysop or not */
int Bulletin::is_sysop(struct amu_users *user)
{
    int status;

    status = FALSE;
    if(user)
    {
	if(strcmp(user->realname, Config_obj.amu_cfgvar.sysop) == 0 ||
	   strcmp(user->handle, Config_obj.amu_cfgvar.sysopalias) == 0)
	{
	    status = TRUE;
	}
    }
    return(status);
}

/***********************************************************************/
/* EOF - BULLETIN.CPP */
