// Structures for BBS system files
// Created 11 February 1996
// Revised 13 January 1998

#if !defined(__BBSINFO__)
#define __BBSINFO__
#include "extern.h"
#include "amustr.h"
#include "config.h"
#include "utility.h"
#include "crc.h"

    struct dat
    {
	unsigned short day: 5,
		       month: 4,
		       year: 7;
    };

    struct tim
    {
	unsigned short seconds: 5,
		       minutes: 6,
		       hours: 5;
    };

    union date_rec
    {
	struct dat datevar;
	unsigned short date;
    };

    union time_rec
    {
	struct tim timevar;
	unsigned short time;
    };

	union bbstimedate
	{
	    struct
	    {
		union time_rec time;
		union date_rec date;
	    }t1;
	    long t2;
	};


#define MAXIMUS_TMP "MAXTMP.AMU"

/***********************************************************************/

/* Telegard 3.02 / 3.10 - USERS.DAT */
typedef struct          /* USERS.DAT status flags */
{
    short lockedout : 1,                 /* if locked out */
	  udeleted : 1,                  /* if deleted */
	  trapactivity : 1,              /* if trapping users activity */
	  trapseparate : 1,              /* if trap to separate TRAP file */
	  chatauto : 1,                  /* if autochat trapping */
	  chatseparate : 1,              /* if separate chat file to trap to */
	  slogseparate : 1,              /* if separate SysOp log kept */
	  alert : 1;                     /* alert SysOp when use logs on */
}
tguserstatus;

typedef struct          /* USERS.DAT - User flags */
{
    short newusermsg : 1,                /* sent newuse message? */
	  clsmsg : 1,                    /* clear screen before messages? */
	  flinput : 1,                   /* full line input? */
	  hotkey : 1,                    /* menu hotkeys active */
	  pause : 1,                     /* pause? */
	  novice : 1,                    /* user is at novice help level */
	  hiddenlog : 1,                 /* not displayed in call/online listing */
	  hiddenlist : 1;                /* not displayed in user listings */
}
tguserflags;

typedef struct          /* user AC flags */
{
    short rlogon : 1;                    /* L - One call per day */
    short rchat : 1;                     /* C - Can't page the SysOp */
    short rnetmaildel : 1;               /* F - Force Netmail deletion */
    short ramsg : 1;                     /* A - Can't post AutoMessage */
    short rpostan : 1;                   /* * - Can't post anonymously */
    short rpostpvt : 1;                  /* E - Can't post private */
    short rpostnet : 1;                  /* N - Can't post NetMail */
    short rpost : 1;                     /* P - Can't post at all */
    short rvoting : 1;                   /* K - Can't vote */
    short rmsg : 1;                      /* M - Forced email deletion */
    short rpostecho : 1;                 /* G - Can't post EchoMail */
    short fnodlratio : 1;                /* 1 - No UL/DL ratio */
    short fnopostratio : 1;              /* 2 - No post/call ratio */
    short fnofilepts : 1;                /* 3 - No file points checking */
    short fnodeletion : 1;               /* 4 - Protection from deletion */
    short fnodailyratio : 1;             /* 5 - No daily DL ratio */
    short fnodltime : 1;                 /* 6 - No DL time check */
    short fnopwchange : 1;               /* 7 - No forced pw change */
    short ftimepercall : 1;              /* 8 - Time on per call basis */
}
tguflags;

struct t302_users       /* USERS.DAT - User account records */
{
    char l1,
	 alias[36],                   /* user name */
	 l2,
	 name[36],                   /* real name */
	 street[31],                 /* mail address */
	 l3,
	 location[30],               /* city, province */
	 postalcode[11],             /* postal code */
	 voiceph[21],                /* voice phone # */
	 dataph[21],                 /* data phone # */

	 pwtext[21];                 /* user password */

    long int lastdate;                 /* laston date/time */
    char firstdate[9],               /* firston date */
	 pwdate[9],                  /* last date of PW change */
	 l4,
	 birthdate[8],               /* Birth date */
	 gender,                       /* gender - M/F */
	 l5,
	 subdate[8],                /* subscription started */
	 l6,
	 expiredate[8],              /* subscription expires */
	 expireto,                     /* expire to level A - Z, !=Delete */

	 comment[41],                /* SysOp comment on user */
	 notes[3][41],               /* SysOp definable variables (notes files) */
	 lockfile[9];                /* lockout msg to print */

    long pwcrc;                     /* CRC-32 of users password */

    char reserved1[14];                /* RESERVED */
    char ugraphics;                    /* user graphics protocol
					     0 : TTY - no fallback
					     1 : ANSI
					     2 : Avatar
					     3 : RIP    */
    char fallback;                     /* 2nd fallback protocol
					     1 : ANSI
					     2 : Avatar
					     3 : RIP
					     3rd TTY */
    char linelen;                      /* line length (# cols) */
    char pagelen;                      /* page length (# rows) */
    tguserflags flags;                   /* flags (see above) */
    tguserstatus status;                 /* status (see above) */
    char reserved2;                    /* RESERVED */

    char sl;                           /* SL */
    tguflags ac;                       /* user flags */
    char aflags1[4],                   /* Access flags - Set 1 */
	 aflags2[4];                   /* Access flags - Set 2 */
    long int userID;                    /* unique User-ID - THIS VALUE
					  SHOULD NOT BE CHANGED BY ANY
					  PROGRAM!! */
    char level;                        /* current validation level */
    char datefmt;                      /* Date Format
					  0 - MM/DD/YY
					  1 - DD/MM/YY
					  2 - YY/MM/DD */
    char reserved7;                    /* RESERVED */
    long int macroptr;                  /* pointer for MACROS.DAT (-1 = none) */
    long int votedate;                  /* last vote */
    char reserved3[17];                /* RESERVED */

    char lastgroup;                    /* last group */
    short lastmsg;                      /* last message base # */
    short pubpost;                      /* # public posts */
    short privpost;                     /* # private posts */
    short netpost;                      /* # netmail posts */
    char mailbox[37];                /* mailbox status
					  ''        Open/Normal
					  'CLOSED'  Closed
					  Username  Forwarded to... */
    long int credit;                    /* NetMail points (credit) */
    long int debit;                     /* NetMail points (debit) */
    char fsetype;                      /* FSE usage (0=never,1=always,2=ask) */
    char reserved4[32];                /* RESERVED */

    char qwkarc[4];                  /* QWK default archiver */
    char qwkfromyou;                /* bundle from user */
    char qwkbwctrl;                 /* create BW control file? */
    char qwknews;                   /* include news? */
    char qwkwelcome;                /* include welcome? */
    char qwkgoodbye;                /* include goodbye? */
    char qwknewfiles;               /* include new files list? */
    char qwkpointer;                /* include pointer file? */
    char qwksession;                /* include session listing? */
    char reserved5[23];                /* RESERVED */

    char defprotocol;                  /* default protocol (A-Z)
					  ! = Select at download time */
    short lastfile;                     /* last file base # */
    short uploads;                      /* amount ULed (files) */
    short downloads;                    /* amount DLed (file) */
    short todaydl;                      /* amount DLed today (files) */
    long uk;                        /* amount ULed (kbytes) */
    long dk;                        /* amount DLed (kbytes) */
    long todaydk;                   /* amount DLed today (kbytes) */
    long filepoints;                /* file points remaining */

    long totaltime;                 /* total time on system */
    short timebank;                     /* # mins in Time Bank */
    short totalcalls;                   /* total calls to system */
    short tltoday;                   /* time left today */
    short tbtoday;                   /* bank activit +/- time */
    char todaycalls;                   /* calls to system today */
    char illegal;                      /* illegal logons */
    char vote[20];                     /* voting data */
    char language[9];                /* langauge */
    char reserved6;                    /* RESERVED */
};


/* LoraBBS 3.00 USER.DAT */
struct l300_users
{
   unsigned short Size;             // Size of the record
   char   Name[48];                 // Name or nickname
   unsigned long  Password;         // Password as a 32bit CRC
   char   RealName[48];             // Real name
   char   Company[36];              // Company name (if allowed)
   char   Address[48];              // First line of the address
   char   City[48];                 // Second line of the address
   char   DayPhone[26];             // Daytime phone number
   char   Ansi;                     // TRUE=User can display ANSI
   char   Avatar;                   // TRUE=User can display AVATAR
   char   Color;                    // TRUE=User can display color informations
   char   HotKey;                   // TRUE=User can use hot keyed menus
   char   System;                   // System type (see above)
   char   Sex;                      // M=Male, F=Female (no other sex allowed at this writing)
   char  FullEd;                    // TRUE=Use fullscreen editor
   char  FullReader;                // TRUE=Use fullscreen reader
   char  NoDisturb;                 // TRUE=Do not disturb
   char  AccessFailed;              // TRUE=Last access attempt failed
   unsigned short ScreenHeight;     // User's screen width
   unsigned short ScreenWidth;      // User's screen height
   unsigned short Level;            // Level
   unsigned long  AccessFlags;      // Access flags
   unsigned long  DenyFlags;        // Deny access flags
   unsigned long  CreationDate;     // Record's creation date as a Unix-style timestamp
   unsigned long  LastCall;         // User's last call date/time as a Unix-style timestamp
   char   MailBox[32];              // User's mailbox name
   char   LimitClass[16];           // Class of limits
   unsigned long  TotalCalls;       // Number of calls to the system
   unsigned long  TodayTime;        // Number of minutes on-line today
   unsigned long  WeekTime;         // Number of minutes on-line this week
   unsigned long  MonthTime;        // Number of minutes on-line this month
   unsigned long  YearTime;         // Number of minutes on-line this year
   char   Language[16];             // Currently selected language (if any)
   char   FtpHost[48];              // Host name for FTP transfers
   char   FtpName[32];              // User name for FTP transfers
   char   FtpPwd[32];               // Password for FTP transfers
   char   LastMsgArea[16];          // Last message area visited
   char   LastFileArea[16];         // Last file area visited
   unsigned short UploadFiles;
   unsigned long  UploadBytes;
   unsigned short DownloadFiles;
   unsigned long  DownloadBytes;
   unsigned short FilesToday;
   unsigned long  BytesToday;
   char  ImportPOP3Mail;            // TRUE=Import e-mail from POP3 server
   char  UseInetAddress;            // TRUE=Use the personal Inet address
   char   InetAddress[64];          // Personal E-Mail address
   char   Pop3Pwd[32];              // Password for POP3 mail server
   char   Archiver[16];             // Default archiver
   char   Protocol[16];             // Default protocol
   char   Signature[64];            // Personal signature
   char   FullScreen;               // TRUE=Full screen enhancements
   char   IBMChars;                 // TRUE=Can display IBM characters
   char   MorePrompt;               // TRUE=Display More? prompt at each page
   char   ScreenClear;              // TRUE=Send screen clear codes
   char   InUserList;               // TRUE=Display in user list
   char   Kludges;                  // TRUE=Display message's kludge lines
   char   MailCheck;                // TRUE=Mail check at logon
   char   NewFileCheck;             // TRUE=Check for new files at logon
   char  BirthDay;                  // Day of birthdate
   char  BirthMonth;                // Month of birthdate
   unsigned short BirthYear;        // Year of birthdate
   unsigned long  LastPwdChange;    // Time of last password change
};

/* EzyCom 1.20 USERS.BBS */
struct e120_users
{
    char        l1,
		Name[35],
		l2,
		Alias[35],
		l3,
		Password[15];
    short       Security;
    char        Attribute,
		Attribute2,
		Attribute3,
		Attribute4,
		Flags[4],
		DataPhone[15],
		VoicePhone[15];
};

typedef struct DateRecord {
  short     Year;
  char      Month,
	    Day;
} DateRecord;

/* EzyCom 1.20 USERSEXT.BBS */
struct e120_users_xi
{
    char        l1,
		Location[25];
    long        LastTimeDate;    // DOS Packed Date/Time
    short       Credit,          // Users netmail credit
		Pending,         // Netmail cost pending export
		MsgsPosted,
		NoCalls,
		Uploads,
		TodayK,
		TimeUsed,
		Downloads;
    long        UploadsK,
		DownloadsK;
    char        ScreenLength,
		LastPwdChange;
    short       TimeBanked,
		KsBanked,
		FilePoints;
    char        QWKCompression,
		QWKDaysOld;
    char        Comment[41];     // Sysop/User Comment
    char        Colour1_2,       // To retrieve the first colour & 15
		Colour3_4,       // To retrieve the second colour >> 4
		Colour5_6,
		Colour7_8,
		BKColour,
		SessionFailures;  // Number of Session Failures since last
				  // successful logon
    char        TopMenu[9];       // User's Top Menu
    short       FilePointsGiven;  // Number of Filepoints credited since last logon
    DateRecord  DateOfBirth;
    char        Groups[4];        // user's group setting (compressed)
    short       RegoDate,         // Start of Registration
		FirstDate,        // Date of First Logon
		LastFileDate;     // Last Time a New Files Search was done
    char        DefProtocol;      // Blank means no default protocol
    short       TimeLeft,         // Users remaining time for today
		FileArea,         // Last file area user used
		MessArea,         // Last message area user used
		QWKMaxMsgs,
		QWKMaxMsgsPerArea;
    short       TodayBankWK;      // Kilobytes Withdrawn from Bank Today
				  // Negative Numbers indicate Deposited
    char        ForwardTo[36];    // forward local mail to
    char        TodayCalls;       // Times the user has called today
    short       TodayBankWT;      // Time Withdrawn from Bank Today
				  // Negative Numbers indicate Deposited
    char        Language;         // users language
    short       EndRegoDate;      // End Registration Date
    long        TotTimeUsed;      // Total Time Used by the User
				  // since the last time this field was
				  // reset.  Normally first logon
    char        LastBWPkt[4];     // name of last bw pkt extension
    char        ExtraSpace[121];
};

/* Old QuickBBS style - USERS.BBS */
struct q276_users
{
    unsigned char ln1;
    char name[35];
    unsigned char ln2;
    char location[25];
    unsigned char ln3;
    char pwd[15];
    unsigned char ln4;
    char dataphone[12];
    unsigned char ln5;
    char homephone[12];
    unsigned char ln6;
    char time[5];
    unsigned char ln7;
    char date[8];
    unsigned char attrib;
    unsigned char flags[4];
    unsigned short credit,
		   pending,
                   timesposted,
                   highmsgread,
		   seclvl,
                   times,
                   ups,
                   downs,
                   upk,
		   downk;
    short todayk,
          elapsed,
          len;
    unsigned short combinedptr,
                   aliasptr;
    long bdate;
};

  /* Structure of ALIAS.BBS */
struct aliasrecord
{
    unsigned char l1;
    char alias[35];
};

/***********************************************************************/
/* QuickBBS 2.80 style - USERS.BBS or USERS.DAT */
struct q280_users
{
    unsigned char  ln1;
    char           name[35];
    unsigned char  ln2;
    char           location[25];
    unsigned char  ReservedZero,
                   Language;
    long           PwdCrc;
    unsigned short PwdChangeDate,
                   expiredate;       /* Number of days since 1/1/1900 */
    long           HighMsgRead;      /* UnusedSpace for Classic version */
    char           ExtraSpace[2];
    unsigned char  DataPhoneLen;
    char           DataPhone[12];
    unsigned char  HomePhoneLen;
    char           HomePhone[12];
    unsigned char  l3;
    char           time[5];
    unsigned char  l4;
    char           date[8];
    unsigned char  Attrib,
		   Flags[4];
    unsigned short Credit,
		   Pending,
                   timesposted,
                   ObsoleteField, /* HighMsgRead for Classic */
                   security,
                   times,
                   ups,
                   downs,
                   upk,
                   downk;
    short          todayk,
                   Elapsed,
                   Len;
    unsigned short CombinedPtr, /* Record number in COMBINED.BBS */
                   aliasptr;    /* Record number in ALIAS.BBS */
    long           birthdate;   /* Number of days since 1/1/1600 */
};

/**********************************************************************/
/* RemoteAccess 2.0 user file - USERS.BBS */
struct ra20_users
{
    unsigned char  l1;
    char           name[35];
    unsigned char  l2;
    char           location[25];
    unsigned char  l3;
    char           organization[50];
    unsigned char  l4;
    char           address1[50];
    unsigned char  l5;
    char           address2[50];
    unsigned char  l6;
    char           address3[50];
    unsigned char  l7;
    char           handle[35];
    unsigned char  l8;
    char           comment[80];
    long           passwordcrc;
    unsigned char  l9;
    char           dataphone[15];
    unsigned char  l10;
    char           voicephone[15];
    unsigned char  l11;
    char           lasttime[5];
    unsigned char  l12;
    char           lastdate[8];
    unsigned char  attribute;
/*
                         { Bit 0 : Deleted
                            1 : Clear screen
                            2 : More prompt
                            3 : ANSI
                            4 : No-kill
                            5 : Xfer priority
                            6 : Full screen msg editor
                            7 : Quiet mode }
*/
    unsigned char  attribute2;
/*
                      { Bit 0 : Hot-keys
			    1 : AVT/0
                            2 : Full screen message viewer
                            3 : Hidden from userlist
                            4 : Page priority
			    5 : No echomail in mailbox scan
                            6 : Guest account
                            7 : Post bill enabled }
*/
    unsigned char  flags[4];
    long           credit,
                   pending;
    unsigned short msgsposted;
    unsigned short security;
    long           lastread,
                   nocalls,
                   uploads,
                   downloads,
                   uploadsk,
                   downloadsk,
                   todayk;
    short          elapsed;
    unsigned short screenlength;
    unsigned char  lastpwdchange;
    unsigned short group,
                   combinedinfo[200];
    unsigned char  l13;
    char           firstdate[8];
    unsigned char  l14;
    char           birthdate[8];
    unsigned char  l15;
    char           subdate[8];
    unsigned char  screenwidth,
                   language,
                   dateformat,
                   l16;
    char           forwardto[35];
    unsigned short msgarea,
                   filearea;
    char           defualtprot;
    unsigned short filegroup;
    unsigned char  lastdobcheck,
                   sex;
    long           XIrecord;
    unsigned short msggroup;
    char           freespace[48];
};

/***********************************************************************/
/* RemoteAccess 1.0 style - USERS.BBS and USERSXI.BBS */

struct ra10_users
{
    unsigned char  l1;
    char           name[35];
    unsigned char  l2;
    char           location[25];
    unsigned char  l3;
    char           pwd[15];
    unsigned char  l4;
    char           dataphone[12];
    unsigned char  l5;
    char           homephone[12];
    unsigned char  l6;
    char           time[5];
    unsigned char  l7;
    char           date[8];
    unsigned char  attrib,
                   flags[4];
    unsigned short credit,
                   pending,
		   timesposted,
                   highmsgread,
                   seclvl,
                   times,
                   ups,
                   downs,
                   upk,
                   downk;
    short          todayk,
                   elapsed;
    unsigned short len;
    unsigned char  lastpwdchange,
                   attribute2,     /* Bit 3 - Hidden */
                   group;
    unsigned short XIrecord;
    char           extraspace[3];
};

struct ra10_users_xi
{
    unsigned char   l1;
    char            handle[35];
    unsigned char   l2;
    char            comment[80];
    unsigned char   l3;
    char            firstdate[8];
    unsigned char   combined[25],
                    l4;
    char            birthdate[8];
    unsigned char   l5;
    char            subdate[8];
    unsigned char   screenwidth,
                    msgarea,
                    filearea,
                    language,
                    dateformat,
                    l6;
    char            forwardto[35];
    unsigned char   extraspace[43];
};

/***********************************************************************/
/* Lora 2.4 style - USERS.BBS */

typedef unsigned short bit;
struct lora_users
{
   char  name[36],
         handle[36],
         location[26];
   long  lastread[50],
         lastread2[20];
   char  pwd[16];
   long  calls;
   short nulls,
         msgarea;
   bit   avatar    :1;     /* 1=Avatar color/graphics enabled */
   bit   color     :1;     /* 1=Color codes will be sent */
   bit   scanmail  :1;     /* 1=Check for mail at logon */
   bit   use_lore  :1;     /* 0=Use the Ansi full screen editor */
   bit   more      :1;     /* 1=Pause at the end of each page */
   bit   ansi      :1;     /* 1=Ansi color/graphics enabled */
   bit   kludge    :1;     /* 1=Display the ^a kludge lines */
   bit   formfeed  :1;     /* 1=Screen clearing codes will be sent */

   bit   old_hotkey:1;     /* 1=Hot keyed menus (obsolete in 2.40+) */
   bit   tabs      :1;     /* 0=tabs (9) are converted to spaces */
   bit   full_read :1;     /* 1=Full screen message wiewer */
   bit   badpwd    :1;     /* 1=Bad password for the last call */
   bit   usrhidden :1;     /* 1=The user is hidden from the users list */
   bit   nokill    :1;     /* 1=Don't kill this user */
   bit   ibmset    :1;     /* 1=Character > 127 will be sent */
   bit   deleted   :1;     /* 1=User is deleted from the list */
   char  language,         /* User's language number */
         security;         /* User's privilege level */
   long  flags;            /* Flags settings */
   char  ldate[20];        /* User's last call date */
   short time;             /* Time the user has spent on-line today */
   long  uploadk,          /* User's total kbytes uploaded */
         downloadk;        /* User's total kbytes downloaded */
   unsigned short dnldl,            /* Users' kbytes downloaded today */
                  uploads,          /* Number of files uploaded */
                  downloads,        /* Number of files downloaded */
                  files,            /* User's last file area visited */
		  credit,           /* Netmail credit */
                  dbase;            /* <reserved> (**) */
   char  signature[58],    /* User's personal signature */
         voicephone[20],   /* User's voice telephone number */
	 dataphone[20],    /* User's data telephone number */
	 birthdate[10],    /* User's date of birth */
         expiredate[10],   /* Expiration date */
         firstdate[20],    /* User's first call date and time */
         lastpwdchange[10];/* User's last password change date */
   long  ptrquestion;      /* Pointer to the answer questionaire file */
   char  len;              /* User's screen length */
   char  width;            /* User's screen width */
   long  id;               /* This is the 32 bit CRC of the user's name */
   short posts;            /* Number of messages posted */
   char  comment[80];      /* Comment for advanced user editors */
   char  help;             /* <reserved> (**) */
   unsigned short old_baud_rate;    /* Last call connection speed (obsolete in 2.40+) */
   char  counter[10];      /* General purpose counters */
   unsigned short chat_minutes;     /* Minutes used today to chat with Sysop */
   bit   xfer_prior:1;     /* 1=No download limits */
   bit   quiet     :1;     /* <reserved> (**) */
   bit   nerd      :1;     /* 1=Yell don't bell for this user */
   bit   donotdisturb:1;   /* <reserved> (**) */
   bit   robbed    :1;     /* <reserved> (**) */
   bit   novote    :1;     /* <reserved> (**) */
   char  protocol;         /* User's default file trasnfer protocol */
   char  archiver;         /* User's default compressor */
   struct _ovr_class_rec {
      short max_time;       /* Minutes per day */
      short max_call;       /* Minutes per call */
      short max_dl;         /* Download limit */
      unsigned short  ratio;          /* Download/Upload ratio */
      unsigned short min_baud;       /* Minimum logon baud */
      unsigned short min_file_baud;  /* Minimum download bad */
      unsigned short start_ratio;    /* Start ratio */
   } ovr_class;
   short msg_sig;          /* Default message group */
   unsigned short account;          /* Account for time bank */
   unsigned short f_account;        /* Account for file bank */
   short votes;            /* Holds votes received */
   short file_sig;         /* Default file group */
   long  baud_rate;        /* New baud rate field (2.40+) */
   bit   hotkey    :1;     /* Hot key ON/OFF (2.40+) */
   long  alias_id;         /* 32 bit CRC of user's alias name (2.40+) */
   char  extradata[281];   /* Reserved for future use */
                           /* Total=1024 bytes */
};

/************************************************************************/
/* Concord 0.01 style - USERINFO.DAT */

/* Offsets into CONFIG.DAT */
#define FAREASIZE_OFFSET 14   // Offset for the record size of FAREA.DAT records
#define MAREASIZE_OFFSET 16   // Offset for the record size of MAREA.DAT records

struct security
{
    unsigned short bpsrate;
    unsigned char age;
    unsigned short seclvl;
    char flags[10],
	 notflags[10];
};

struct conc_usershdr
{
    long id,
         version;
    unsigned short usersize; // Size of user record in bytes
};

struct conc_users
{
    long id;
    char l1,
	 name[35],
	 l2,
	 alias[35],
         l3,
         city[25],
         l4,
         voice[20],
         l5,
         data[20];
    struct dat birthday;
    char l6,
	 password[15];
    struct security sec;
    unsigned char screenlen;
    long attrib1,
         attrib2,
         firsttime,
	 lasttime,
	 timescalled,
         totalminutes,
         pages,
	 publicmsgs,
         privatemsgs,
         upk,
         uptimes,
         downk,
         downtimes;
    char l7,
         sysopcomment[60],
         protocol,
         editor,
         viewer,
         packer,
         charset;
    unsigned short lastfilechk,
	     lastbullchk;
    struct dat expiration;
    char l8,
         firstmenu[8],
	 l9,
	 language[8];
    long messagearea;
    char l10,
	 mareaext[3];
    long filearea;
    char l11,
         fareaext[3];
    long door;
    char l12,
         doorext[3];
    long chatchannel;
    unsigned char todaycalls;
    unsigned short todayelapsed;
    long todaydownk,
         todaydowns,
         timeinbank,
         dllimitinbank;
    char l13,
         viewfilename[12],
         offlinefmt,
         offlinedays;
    long offlineattrib;
    unsigned char readmsgnum,
                  filelistnum,
                  todaylastpkt,
		  verifycalls,
                  passwordtries;
    unsigned short offlinemaxnum;
    long flexpos;
    unsigned short lastpktdl;
    long bbscrc;
    unsigned char emulation,
                  textfiletype,
                  empty[85];
};

/**********************************************************************/
/* Maximus 2.0 style - USER.BBS */
struct max2_users
{
    char   name[36],
           location[36];
    char   alias[21],
	   phone[15];
    unsigned short lastread_ptr;
    unsigned short timeremaining;
    unsigned char pwd[16];         /* Passunsigned short                                     */
    unsigned short times;           /* Number of previous calls to this system      */
    unsigned char help;            /* Help level                                   */
    unsigned char rsvd1[2];        /* Reserved by Maximus for future use           */
    unsigned char video;           /* user's video mode (see GRAPH_XXXX)           */
    unsigned char nulls;           /* Number of Nulls (delays) after <cr>          */
    unsigned char bits;            /* Bit flags for user (number 1)                */
    unsigned short rsvd2;           /* Reserved by Maximus for future use           */
    unsigned short bits2;           /* Bit flags for user (number 2)                */
    short security;                 /* Access level                                 */
    unsigned char rsvd3[19];       /* Reserved by Maximus for future use           */
    unsigned char struct_len;      /* len of struct, divided by 20. SEE ABOVE!     */
    unsigned short time;            /* Time on-line so far today                    */
    unsigned short delflag;
    unsigned char rsvd4[8];        /* Reserved by Maximus for future use           */
    unsigned char width;           /* Width of the caller's screen                 */
    unsigned char len;             /* Height of the caller's screen                */
    unsigned short credit;          /* Matrix credit, in cents                      */
    unsigned short debit;           /* Current matrix debit, in cents               */
    unsigned short  xp_priv;        /* Priv to demote to, when time or minutes run  */
    union date_rec expiredate;
    union time_rec expiretime;
    unsigned long xp_mins;        /* How many minutes the user has left before    */
    unsigned char  xp_flag;        /* Flags for expiry.  See above XFLAG_XXX defs. */
    unsigned char  xp_rsvd;
    union date_rec lastcalldate;
    union time_rec lastcalltime;
    unsigned long xkeys;          /* User's keys (all 32 of 'em)                  */
    unsigned char  lang;           /* The user's current language #                */
    char def_proto;              /* Default file-transfer protocol               */
    unsigned long up;             /* K-unsigned chars uploaded, all calls                  */
    unsigned long down;           /* K-unsigned chars downloaded, all calls                */
    unsigned long downtoday;      /* K-unsigned chars downloaded, today                    */
    unsigned char msg[10];   /* User's last msg area (string)                */
    unsigned char files[10]; /* User's last file area (string)               */
    unsigned char compress;        /* Default compression program to use           */
    unsigned char rsvd5;
    unsigned long extra;
};

/************************************************************************/

/* Masks for usr.bits1, below */
#define BITS_HOTKEYS     0x0001 /* Hotkeys, independent of HOTFLASH level   */
#define BITS_NOTAVAIL    0x0002 /* If set, user is NOT normally available   *
				 * for chat.                                */
#define BITS_FSR         0x0004 /* Full-screen reading in msg areas         */
#define BITS_NERD        0x0008 /* Yelling makes no noise on sysop console  */
#define BITS_NOULIST     0x0010 /* Don't display name in userlist           */

/* Maximus 3.0 style - USER.BBS */
struct max3_users
{
    char name[36];        /* Caller's name                               0*/
    char city[36];        /* Caller's location                          36*/
    char alias[21];       /* MAX: user's alias (handle)                 72*/
    char phone[15];       /* MAX: user's phone number                   93*/
    unsigned short lastread_ptr;
    unsigned short timeremaining;
    char pwd[16];         /* Password                                  112*/
    unsigned short calls;           /* Number of previous calls to this system   128*/
    char help;            /* Help level                                130*/
    unsigned short group;           /* Group number (not implemented)            131*/
    char video;           /* user's video mode (see GRAPH_XXXX)        133*/
    char nulls;           /* Number of Nulls (delays) after <cr>       134*/
    char bits;            /* Bit flags for user (number 1)             135*/
    unsigned short dob_year;        /* Date of birth: year (1900-)               136*/
    unsigned short bits2;           /* Bit flags for user (number 2)             138*/
    unsigned short max2priv;        /* Max 2.x priv level (NOT USED)             140*/
    char dataphone[19];   /* Data/business phone number                142*/
    char struct_len;      /* len of struct, divided by 20. SEE ABOVE!  161*/
    short time;            /* Time on-line so far today                 162*/
    short delflag;
    long msgs_posted;    /* Total number of messages posted           166*/
    long msgs_read;      /* Total number of messages read             170*/
    char width;           /* Width of the caller's screen              174*/
    char len;             /* Height of the caller's screen             175*/
    unsigned short credit;          /* Matrix credit, in cents                   176*/
    unsigned short debit;           /* Current matrix debit, in cents            178*/
    unsigned short xp_priv;         /* Priv to demote to, when time or minutes ru180*/
    union date_rec expiredate;
    union time_rec expiretime;
    long xp_mins;        /* How many minutes the user has left before 186*/
    char  xp_flag;        /* Flags for expiry.  See above XFLAG_XXX def190*/
    char  sex;            /* Sex: SEX_MALE or SEX_FEMALE)              191*/
    union date_rec lastdate;
    union time_rec lasttime;
    long xkeys;          /* User's keys (all 32 of 'em)               196*/
    char  lang;           /* The user's current language #             200*/
    char def_proto;      /* Default file-transfer protocol            201*/
    long up;             /* K-chars uploaded, all calls               202*/
    long down;           /* K-chars downloaded, all calls             206*/
    long downtoday;     /* K-chars downloaded, today                 210*/
    char rsvd45[18];      /* Reserved by Maximus for future use        214*/
    unsigned short todaycall;            /* Number of previous calls today            232*/
    char compress;        /* Default compression program to use        234*/
    char df_save;         /* Used for storing real usr.delflag in      235*/
    long extra;                                                     /*236*/
    union date_rec firstcalldate;
    union time_rec firstcalltime;
    union date_rec passchangedate;
    union time_rec passchangetime;
    long nup;            /* Number of files uploaded                  248*/
    long ndown;          /* Number of files downloaded                252*/
    long ndowntoday;    /* Number of files downloaded today          256*/
    unsigned short time_added;      /* Time credited to the user for today       260*/
    char msg[64];   /* Current message area                      262*/
    char files[64]; /* Current file area                         326*/
    char dob_day;         /* Date of birth: day (1-31)                 390*/
    char dob_month;       /* Date of birth: month (1-12)               391*/
    long point_credit;   /* Total points allocated                    392*/
    long point_debit;    /* Total points used                         396*/
    union date_rec newfiledate;
    union time_rec newfiletime;
    unsigned short security;            /* Privilege level                           404*/
    char rsvd6[54];       /* Reserved for future use       460 total bytes*/
};

/*************************************************************************/
/* SuperBBS 1.17 - USERS.BBS and SUSERS.BBS */

struct s117_users
{
    unsigned char ln1;
    char name[35];
    unsigned char ln2;
    char location[25];
    unsigned char ln3;
    char password[15];
    unsigned char ln4;
    char dataphone[12];
    unsigned char ln5;
    char homephone[12];
    unsigned char ln6;
    char time[5];
    unsigned char ln7;
    char date[8];
    unsigned char attrib,
                  flags[4];
    short credit,
          pending;
    unsigned short msgsposted,
                   highmsgread,
		   seclvl,
                   times,
                   ups,
                   downs,
                   upk,
                   downk;
    short todayk,
          elapsed,
          len;
    unsigned char extraspace[2],
                  age;
    short extrauserrecptr;
    unsigned char extraspace2[3];
};

struct s117_users_xi
{
    unsigned char l1;
    char name[35];
    unsigned char l2;
    char birthday[8];
    unsigned short attrib;
    unsigned char flags[4];
    unsigned char l3;
    char firsttime[5];
    unsigned char l4;
    char firstdate[8];
    unsigned char combined[25];
    unsigned char l5;
    char sysopcomment[79];
    char defaultproto;
    short userrecptr;
    unsigned char colors[10],
                  filelisttype,
                  l6;
    char alias[35];
    long minutesused;
    unsigned char l7;
    char viewfilename[12];
    unsigned char l8;
    char menutorun[8];
    unsigned short timeinbank;
    unsigned char todaycalls,
                  l9;
    char languagefilen[8];
    unsigned char l10;
    char expirationdate[8];
    unsigned char currentfarea,
                  currentmarea,
                  currentdoor,
                  defaultpacker,
                  l11;
    char lastnewfilescheck[8];
    unsigned char callssincebverify,
                  extraspace[402];
};

/************************************************************************/
/* File & Message area system files                                     */
/************************************************************************/

/* RemoteAccess 2.0 - FILES.RA & MESSAGES.RA */
/* These are valid for RA 2.xx - for RA 2.50, use the 'Areanum' field */
/* to determine the actual area number for the FDB, Hudson, etc       */
struct ra20_msgs
{
    unsigned short areanum,
		   unused;
    unsigned char  l1;
    char           name[40];
    char           typ;
    char           msgkinds;
    unsigned char  attribute;
	//   Bit 0 : Enable EchoInfo
	//   1 : Combined access
	//   2 : File attaches
	//   3 : Allow aliases
	//   4 : Use SoftCRs as characters
	//   5 : Force handle
	//   6 : Allow deletes
	//   7 : Is a JAM area
    unsigned char  recvkill;
    unsigned char  dayskill;
    unsigned short countkill;
    unsigned short readsecurity;
    unsigned char  readflags[4];
    unsigned char  readnotflags[4];
    unsigned short writesec;
    unsigned char  writeflags[4];
    unsigned char  writenotflags[4];
    unsigned short sysopsec;
    unsigned char  sysopflags[4];
    unsigned char  sysopnotflags[4];
    unsigned char  l2;
    char           originline[60];
    unsigned char  akaaddress;
    unsigned char  age;
    unsigned char  l3;
    char           jambase[60];
    unsigned short group;
    unsigned short altgroup[3];
    unsigned char  attribute2;  // BIT 0 : Include all groups
    unsigned short netmailarea; /* RA 2.50 only */
    unsigned char  freespace2[7];
};

struct ra20_files
{
    unsigned short areanum,
		   unused;
    unsigned char  l1;
    char           name[40];
    unsigned char  attrib;
    /*                      0 : Include in new files scan
                            1 : Include in upload dupe scan
                            2 : Permit long descriptions
                            3 : Area is on CD-ROM
                            4 : All files are FREE
                            5 : Allow DLs not in FDB
                            6 : Allow users to passunsigned short uploads
                            7 : Scan uploads }
*/
    unsigned char  l2;
    char           filepath[40];
    unsigned short killsdaysdl;
    unsigned short killdaysfd;
    unsigned char  l3;
    char           password[15];
    unsigned short movearea;
    unsigned char  age;
    unsigned char  convertExt;
    unsigned short group;
    unsigned char  attrib2;    // BIT 0 : Include in all groups
    unsigned short defcost;
    unsigned short uploadarea;
    unsigned short uploadsec;
    unsigned char  uploadflags[4];
    unsigned char  uploadnotflags[4];
    unsigned short security;
    unsigned char  flags[4];
    unsigned char  noflags[4];
    unsigned short listsecurity;
    unsigned char  listflags[4];
    unsigned char  listnotflags[4];
    unsigned short altgroup[3];
    unsigned char  device;
    unsigned char  freespace[13];
};

/* RemoteAccess 1.11 - FILES.RA & MESSAGES.RA */
struct ra10_msgs
{
    unsigned char  l1;
    char           name[40];
    char           type;
    char           kinds;
    unsigned char  attribute;
    unsigned char  dayskill;
    unsigned char  recvkill;
    unsigned short countkill;
    unsigned short readseclvl;
    unsigned char  readflags[4];
    unsigned short writeseclvl;
    unsigned char  writeflags[4];
    unsigned short sysopseclvl;
    unsigned char  sysopflags[4];
    unsigned char  l2;
    char           origin_line[60];
    unsigned char  akaaddress;
};

struct ra10_files
{
    unsigned char  l1;
    char           name[30];
    unsigned char  attrib;
    unsigned char  l2;
    char           filepath[40];
    unsigned char  freespace[35];
    unsigned short uploadsecurity;
    unsigned char  uploadflags[4];
    unsigned short security;
    unsigned char  flags[4];
    unsigned short privatesecurity;
    unsigned char  privateflags[4];
};

/* Telegard 3.02/3.10 -  FILE.DAT */
typedef struct          /* FAREAS.DAT status flags */
{
    short fbnoratio : 1;                 /* <No Ratio> active */
    short fbvisible : 1;                 /* Visible to users w/o access? */
    short fbRESERVED1 :1;                /* RESERVED */
    short fbcdrom : 1;                   /* CD-ROM/read-only media */
    short fbusegifspecs : 1;             /* whether to use GifSpecs */
}
tgfareaflags;

struct t302_files       /* FAREAS.DAT - File base records */
{
    char l1;
    char name[40];                   /* area description */
    char l2;
    char filename[8];                /* filename */
    char l3;
    char infofile[8];                /* info filename */
    char l4;
    char path[40];                   /* path */
    char arctype[4];                 /* archive (''=inactive) */
    char reserved1;                    /* RESERVED */
    tgfareaflags fstatus;                /* file area status */
    char sysopacs[41],               /* SysOp access */
	   listacs[41],                    /* list/view access */
	   nameacs[41],                    /* see uploader name access */
	   ulacs[41],                      /* upload access */
	   dlacs[41];                      /* download access */
    char scantype;                     /* scan type    0=Default ON
						       1=Default OFF
						       2=Always */
    char cdlabel[12];                /* CD-ROM label */
    long int createdate;               /* base creation date */
    char l5;
    char filepath[40];               /* *.FB? storage path */
    char reserved2[42];                /* RESERVED */
};



/* LoraBBS 3.00 - FILE.DAT */
struct l300_files
{
   unsigned short Size;             // Size of this structure
   char   Display[128];             // Area's description
   char   Key[16];                  // Area's name
   unsigned short Level;            // Access level
   unsigned long  AccessFlags;      // Access flags
   unsigned long  DenyFlags;        // Deny flags
   unsigned short UploadLevel;      // Upload level
   unsigned long  UploadFlags;      // Upload flags
   unsigned long  UploadDenyFlags;  // Deny upload flags
   unsigned short DownloadLevel;    // Download level
   unsigned long  DownloadFlags;    // Download flags
   unsigned long  DownloadDenyFlags; // Deny download flags
   char   Age,                      // Minimum age to access the area
	  Download[128],            // Path where download files are stored
	  Upload[128],              // Path where uploaded files are to be stored
	  CdRom,                    // TRUE=The are is on CDROM
	  FreeDownload,             // TRUE=No download limits
	  ShowGlobal,               // TRUE=Show in global lists
	  MenuName[32],             // Name of the menu file for this area
	  Moderator[64];            // Name of the manager of this area
   unsigned long  Cost;             // Cost to access this area
   unsigned long  ActiveFiles;      // Number of files in this area
   unsigned long  UnapprovedFiles;  // Number of unapproved files
   char   EchoTag[64];              // Fileecho (TIC) tag name
   char   UseFilesBBS,              // Uses the files.bbs instead of the filebase
	  DlCost,                   // Cost for download each file
	  FileList[128];            // Alternative files list
};


/* Telegard 3.02 / 3.10 - MAREAS.DAT */
typedef struct          /* MAREAS.DAT status flags */
{
    short mbrealname : 1;                /* real names are forced */
    short mbvisible : 1;                 /* visible to users w/o access */
    short mbansi : 1;                    /* filter ANSI */
    short mb8bit : 1;                    /* filter 8-bit */
    short mbstrip : 1;                   /* strip center/title codes */
    short mbaddtear : 1;                 /* add tear/origin lines */
    short mbnopubstat : 1;               /* messages not added to user */
					 /*   public post total - i.e. */
					 /*   will not calculate in PCR */
    short mbnocredit : 1;                /* Netmail credit not used */
    short mbinternet : 1;                /* Internet (UUCP) handling */
    short mbfileattach : 1;              /* allow file attaches */
    short mbstripcolour : 1;             /* strip TG color codes */
    short mbareasubj : 1;                /* add AREA: to subject line */ // 3.10 only
}
tgmareaflags;

#define TGJAM                1          /* JAM format */
#define TGSQUISH             2          /* Squish format */

struct t302_msgs         /* MAREAS.DAT - Message base records */
{
    char l1;
    char name[40];                   /* message base description */
    char l2;
    char msgpath[40];                /* messages pathname */
    char l3;
    char filename[8];                /* data filenames */
    char l4;
    char infofile[8];                /* base info filename */
    char readacs[41],                /* read access */
	     postacs[41],                  /* post access */
	     sysopacs[41],                 /* SysOp access */
	     netacs[41];                   /* network access */
    short maxmsgs;                      /* max message count */
    short maxdays;                      /* max days to kee messages */
    tgmareaflags mstatus;                /* status */
    char mbformat;                     /* message base format */
    char mbtype;                       /* message base type */
    char anonymous;                    /* anonymous type */
    char mbpost;                       /* message base posting type */
    char origin[51];                 /* origin line */
    char kludge_color;                 /* color of kludge line */
    char quote_color;                  /* color of quoted line */
    char tear_color;                   /* color of tear line */
    char origin_color;                 /* color of origin line */
    char addr;                         /* network address # */
    char scantype;                     /* scan type    0 = Default ON
						       1 = Default OFF
						       2 = Mandatory */
    long createdate;               /* base creation date */
    long qwkindex;                  /* QWK-permanent index */
    char text_color;                   /* color of text line */
    char reserved[40];                 /* RESERVED */
};


// Message base type identification numbers
#define ST_JAM                0
#define ST_SQUISH             1
#define ST_USENET             2
#define ST_FIDO               3
#define ST_ADEPT              4
#define ST_HUDSON             5     // Not implemented
#define ST_GOLDBASE           6     // Not implemented
#define ST_PASSTHROUGH        7

/* LoraBBS 3.00 - MSG.DAT */
struct l300_msgs
{
   unsigned short Size;             // Size of this structure
   char   Display[128],             // Area's description
	  Key[16];                  // Area's name
   unsigned short Level;            // Access level
   unsigned long  AccessFlags;      // Access flags
   unsigned long  DenyFlags;        // Deny flags
   unsigned short WriteLevel;       // Write level
   unsigned long  WriteFlags;       // Write flags
   unsigned long  DenyWriteFlags;   // Deny write flags
   char   Age;                      // Minimum age to access the area
   unsigned short Storage;          // Message base type
   char   Path[128];                // Path to message base files
   unsigned short Board;            // Board number (for Goldbase and Hudson)
   unsigned short Flags;            // Flags
   unsigned short Group;            // Group number
   char   EchoMail,                 // TRUE=This is an echomail area
	  ShowGlobal,               // TRUE=Show this area in global areas list
	  UpdateNews,               // TRUE=Update messages from newsserver
	  Offline,                  // TRUE=Can be used with the Offline-reader
	  MenuName[32],             // Menu name for this area
	  Moderator[64];            // Name of this area's moderator
   unsigned long  Cost;             // Cost to access this area
   unsigned short DaysOld;          // Number of days to keep messages
   unsigned short RecvDaysOld;      // Number of days to keep a received message
   unsigned short MaxMessages;      // Maximum number of messages to keep
   unsigned long  ActiveMsgs;       // Number of messages in this area
   char   NewsGroup[128];           // Usenet newsgroup name
   unsigned long  Highest;          // Highest message retrived from the newsserver
   char   EchoTag[64];              // EchoMail tag name
   short  OriginIndex;              // Index to the origin line or special value
   char   Origin[80];               // Origin da usare al posto di quella di default
   unsigned long  HighWaterMark;    // Highest message number sent
   char   Address[48];              // Address to use when sending echomail messages
   unsigned long  FirstMessage;     // First message number in area
   unsigned long  LastMessage;      // Last message number in area
};





/* QuickBBS 2.76 - FILECFG.DAT & MSGCFG.DAT */
typedef struct
	{
            unsigned short security;
            unsigned char  Flags[4];
        }SecurityRecord;

struct q276_files
{
    unsigned char  ln1;
    char           areaname[66];
    unsigned char  ln2;
    char           filepath[66];
    unsigned char  ln3;
    char           listpath[66];
    char           allowuploads,
                   ignoreklimit,
                   ignoreratio;
    SecurityRecord dlsec,
                   searchsec,
                   templatesec;
    unsigned char  checkdupes,
                   group,
                   spare[10];
};

struct q276_msgs
{
    unsigned char  ln1;
    char           name[40];
    unsigned char  typ,
                   kinds,
                   combined,
                   aliases,
                   aka,
                   ln2;
    char           originline[58];
    unsigned char  allowdelete;
    unsigned short keepcnt,
                   killrcvd,
                   killold;
    SecurityRecord readsec,
                   writesec,
                   templatesec,
                   sysopsec;
    short          filearea;
    unsigned char  group,
                   spare[9];
};

/* QuickBBS 2.80 - MSGCFG.DAT & FILECFG.DAT */

struct q280_files
{
    unsigned char   ln1;
    char            areaname[66];
    unsigned char   ln2;
    char            filepath[66];
    unsigned char   ln3;
    char            listpath[66];
    char            AllowUploads;
    char            IgnoreKlimit;
    char            IgnoreRatio;
    SecurityRecord  dlsec;
    SecurityRecord  searchsec;
    SecurityRecord  templatesec;
    char            CheckDupes;
    unsigned char   Group;
    unsigned char   Spare[10];
};

struct q280_msgs
{
    unsigned char  ln1;
    char           name[40];
    char           Typ;
    char           Kinds;
    char           Combined;
    char           Aliases;
    unsigned char  Aka;
    unsigned char  ln2;
    char           OriginLine[58];
    char           AllowDelete;
    unsigned short KeepCnt;   /* Max # of Msgs to keep */
    unsigned short KillRcvd;  /* Kill received msgs after this many days */
    unsigned short KillOld;   /* Kill msgs after this many days */
    SecurityRecord readsec;
    SecurityRecord writesec;
    SecurityRecord templatesec;
    SecurityRecord sysopSec;
    short          FileArea; /* for Fmail */
    unsigned char  Group;
    unsigned char  Spare[9];
};

/* SuperBBS 1.17 - FLSEARCH.BBS & BOARDS.BBS */
struct s117_files
{
    unsigned char  ln1;
    char           name[60];
    unsigned char  ln2;
    char           directory[79];
    short          security;
    unsigned char  flags[4];
    short          pfilessec;
    unsigned char  pflags[4],
                   attrib,
                   age,
                   ln3;
    char           listname[67];
    unsigned short equiredbpsrate;
    unsigned char  extraspace[28];
};

struct s117_msgs
{
    unsigned char  ln1;
    char           name[30];
    unsigned char  ln2;
    char           qwkname[12];
    unsigned char  typ,  /* 0=standard, 1=net, 2=echo */
                   kinds, /* 0 = private & public, 1 = private, 2 = public, 3 = readonly */
                   aliases; /* 0 = no aliases, 1 = yes, 2 = ask alias, 3 = alias/name */
    short          readseclvl;
    unsigned char  readflags[4];
    short          writeseclvl;
    unsigned char  writeflags[4];
    short          sysopseclvl;
    unsigned char  sysopflags[4];
    char           group;
    unsigned char  replystatus,
                   age,
                   attrib,
                   useaka;
};

/* Concord 0.01 - FAREAS.DAT & MAREAS.DAT */
struct csecurity
{
    unsigned short bpsrate;
    unsigned char age;
    unsigned short seclvl;
    char flags[10],
         notflags[10];
};

struct conc_files
{
    long           id,
                   attrib;
    unsigned char  l1;
    char           name[60];
    struct csecurity dlsec,
                     ulsec,
                     listsec;
    unsigned char  l2;
    char           password[15];
    unsigned char  l3;
    char           downloadpath[67];
    unsigned char  l4;
    char           Basename[8];
    char           emptyspace[51];
    unsigned short subdirnum,
                   jumpdirnum;
    long           uploadarea;
    unsigned char  l5;
    char           group[3];
    unsigned char  archivefmt;
    unsigned short killdaysdl,
                   killdaysfd,
                   filepoints,
                   openfrom,
                   opento;
    unsigned char  l6;
    char           filesbbs[79];

/* 1000 bytes of extra space.  The actual size of this record will be
   read from CONFIG.DAT, that way new fields can be added and AMU won't
   be broken as long as not more than 1000 bytes are added at a time...
   pretty safe bet
*/
    char empty[1000];
};

#define MAREAFMT_HMB     0
#define MAREAFMT_JAM     1
#define MAREAFMT_MSG     2
#define MAREAFMT_SQUISH  3
struct conc_msgs
{
    long           id,
                   attrib;
    unsigned char  format,
                   l1;
    char           pathname[79];
    unsigned char  l2;
    char           name[60];
    unsigned char  l3;
    char           shortname[12];
    unsigned char  l4;
    char           group[3];
    unsigned char  l5;
    char           password[15];
    unsigned char  ownboard, // area number for HMB
                   type,
                   kinds,
                   replystatus,
                   usealias;
    struct csecurity readsec,
                     writesec,
		     sysopsec;
    unsigned short dayskill,
                   receivedkill,
                   countkill,
                   SubDirNum;
    unsigned char  useaka,
                   chartable,
                   l6;
    char           originline[60];
    unsigned short openfrom,
                   opento,
                   jumpdirnum;
    long           replyarea;

/* 1000 bytes of extra space.  The actual size of this record will be
   read from CONFIG.DAT, that way new fields can be added and AMU won't
   be broken as long as not more than 1000 bytes are added at a time...
   pretty safe bet
*/
    char empty[1000];
};

/* Lora 2.40 - SYSFILE.DAT & SYSMSG.DAT */
struct lora_msgs
{
   char  msg_name[70];      /* Message area name */
   short msg_num;           /* Message area number */
   char  msg_path[40];      /* Message area path */
   char  origin[56];        /* Echomail origin line */
   bit   echomail  :1;      /* 1=Echomail area */
   bit   netmail   :1;      /* 1=Netmail area */
   bit   _public    :1;      /* 1=Public message allowed */
   bit   _private   :1;      /* 1=Private message allowed */
   bit   anon_ok   :1;      /* 1=Use the user's handle in the from field */
   bit   no_matrix :1;      /* <reserved> (**) */
   bit   squish    :1;      /* Squish<tm> message area */
   bit   kill_unlisted :1;  /* <reserved> (**) */
   unsigned short msg_sig;           /* Message area's group */
   char  echotag[32];       /* Echotag name */
   unsigned short pip_board;         /* Pip-base board number */
   char  quick_board;       /* QuickBBS board number */
   char  msg_priv;          /* Minimum level to access this area */
   long  msg_flags;         /* Flags settings */
   char  write_priv;        /* Minimum level to write messages */
   long  write_flags;       /* Flags settings */
   char  use_alias;         /* Use alias # with this area */
   short max_msgs;          /* Maximum number of messages in this area */
   short max_age;           /* Max age of messages (days) */
   short age_rcvd;          /* Max age of received messages (days) */
   char  forward1[80];      /* Forward node list 1/3 */
   char  forward2[80];      /* Forward node list 2/3 */
   char  forward3[80];      /* Forward node list 3/3 */
   bit   msg_restricted :1; /* Access restricted to message area's group */
   bit   passthrough    :1; /* Pass-through area */
   char  areafix;           /* Areafix access level for that area */
   char  qwk_name[14];      /* Short name used by the QWK mail packer */
   long  afx_flags;         /* Areafix flags */
   unsigned short gold_board;        /* Goldbase board number */
   char  filler1[27];
};

struct lora_files
{
   char  file_name[70];     /* File area name */
   short file_num;          /* File area number */
   char  uppath[40];        /* Upload path */
   char  filepath[40];      /* Download path */
   char  filelist[50];      /* CD-ROM list file name */
   bit   freearea  :1;      /* Free download limit */
   bit   norm_req  :1;      /* <reserved> (**) */
   bit   know_req  :1;      /* <reserved> (**) */
   bit   prot_req  :1;      /* <reserved> (**) */
   bit   nonews    :1;      /* <reserved> (**) */
   bit   no_global_search :1; /* 1=Exclude from global searches */
   bit   no_filedate :1;    /* <reserved> (**) */
   bit   file_restricted :1; /* Access restricted to file area's group */
   unsigned short file_sig;          /* <reserved> (**) */
   char  file_priv;         /* Minimum level to access this area */
   long  file_flags;        /* Flags settings */
   char  download_priv;     /* Minimum level to download files */
   long  download_flags;    /* Flags settings */
   char  upload_priv;       /* Minimum level to upload files */
   long  upload_flags;      /* Flags settings */
   char  list_priv;         /* Minimum level to see the file titles */
   long  list_flags;        /* Flags settings */
   char  filler2[10];
   char  short_name[13];    /* Area's short name */
   char  filler3[8];
   char  tic_tag[32];       /* TIC processor area's tag name */
   char  tic_forward1[80];  /* Forward node list (1/3) */
   char  tic_forward2[80];  /* Forward node list (2/3) */
   char  tic_forward3[80];  /* Forward node list (3/3) */
   char  tic_level;         /* TIC area's level */
   long  tic_flags;         /* TIC area's flags */
   bit   cdrom     :1;      /* 1=Area is on CD-ROM, 0=Hard disk */
   char  filler4[106];
};

/* ProBoard 2.10 - FILECFG.PRO & MESSAGES.PB */

struct pb21_files
{
   char name[80];       /* Name of file area                                */
   char listpath[80];   /* Path for file-list                               */
   char filepath[80];   /* Path for files                                   */
   unsigned short level;/* Level needed for access                          */
   long flags;          /* Flags needed for access                          */
   char type;           /* 1 = CDROM File listing type                      */
   short maxfiles;      /* Max files per day in this area downloadable      */
   short maxkb;         /* Max Kbytes per day in this area                  */
   char notops;         /* Set to 1 -> should not be listed in TOPFILES.A?? */
   char free;           /* Set to 1 -> free area                            */
   char groups[4];      /* Groups belonging to                              */
   char allGroups;      /* Belongs to all groups                            */
   char minAge;         /* Minimum age                                      */
   long flagsNot;       /* Access flags not allowed                         */
   char dateFormat;     /* Date format (same as in user file)               */
   char extra[2];
};

#define MSGBASE_HUDSON   0
#define MSGBASE_SQUISH   1
#define MSGBASE_SDM      2
#define MSGBASE_JAM      3
struct pb21_msgs
{
   unsigned short areaNum;    /* # of message area (1-10000)                    */
   unsigned short hudsonBase; /* Number of Hudson message base                  */
   char name[81];             /* Name of message area                           */
   char msgType;              /* Kind of message area (Net/Echo/Local)          */
   char msgKind;              /* Type of message (Private only/Public only/...) */
   char msgBaseType;          /* Type of message base                           */
   char path[81];             /* Path to Squish or *.MSG                        */
   char flags;                /* Alias allowed/forced/prohibited                */
   unsigned short readLevel;  /* Minimum level needed to read msgs              */
   long readFlags;            /* flags needed to read msgs                      */
   long readFlagsNot;         /* flags non-grata to read msgs                   */
   unsigned short writeLevel; /* Minimum level needed to write msgs             */
   long writeFlags;           /* flags needed to write msgs                     */
   long writeFlagsNot;        /* flags non-grata to read msgs                   */
   unsigned short sysopLevel; /* Minimum level needed to change msgs            */
   long sysopFlags;           /* flags needed to change msgs                    */
   long sysopFlagsNot;        /* flags non-grata to read msgs                   */
   char origin[62];           /* Origin line                                    */
   short aka;                 /* AKA                                            */
   unsigned short rcvKillDays;/* Kill received after xx days                    */
   unsigned short msgKillDays;/* Kill after xx days                             */
   unsigned short maxMsgs;    /* Max # msgs                                     */
   char sysop[36];            /* Area Sysop                                     */
   short replyBoard;          /* Area number where replies should go            */
   char echoTag[61];          /* Echomail Tag Name                              */
   char qwkTag[13];           /* QWK Area Name                                  */
   char groups[4];            /* Groups belonging to                            */
   char  allGroups;           /* Belongs to all groups                          */
   char minAge;               /* Minimum age for this area                      */
   char extra[112];
};


typedef struct SecurityType {
  short     Security;
  char      OnFlags[4],
	    OffFlags[4];
}SecurityType;


/* EzyCom 1.20 - FILES.EZY */
struct e120_files
{
    char          l1,
		  Name[30],
		  Attribute,
		  Attribute2,
		  Convert,
		  FileGroup,
		  AltGroups[3],
		  MinimumAge;
    short         UpFileArea,
		  AreaPath;               // relates to FILEPATH.EZY
    SecurityType  ListSecurity,
		  UpSecurity,
		  SysSecurity;
    short         NumDaysToDel,
		  NumArrivalDaysToDel,
		  NumDaysLastDownload,
		  FileIdxPos;            // Only in 1.48/Gamma, not in 1.20
    char          FreeSpace[47];
};

/* EzyCom 1.20 - FILEPATH.EZY (Additional information for FILES.EZY
  Attribute
    Bit 0 : CD Rom Path
	1 : File Displayed as Not Enough Security
	2 : Free Downloads
	3 : Auto Adopt Files?
       4-7: [Reserved]
*/
struct e120_files_xi
{
    char          l1,
		  FilePath[60],
		  l2,
		  FilesBBS[60],
		  KsPerFP;
    SecurityType  Security;
    short         UploadArea;
    char          Password[9],
		  MinimumAge,
		  Attribute,
		  CDRomStack,
		  FreeSpace[109];
};


/* EzyCom 1.20 - MESSAGES.EZY */
struct e120_msgs
{
    char          l1,
		  Name[30],
		  AreaTag[76],
		  QWKName[13],
		  Typ,
		  MsgKinds,
		  Attribute,
		  Attribute2,
		  Attribute3,
		  DaysKill,
		  RecvKill;
    short         CountKill,
		  KilobyteKill;
    SecurityType  ReadSecurity,
		  WriteSecurity,
		  SysopSecurity;
    char          MinimumAge,
		  OriginLine[51],
		  OriginAddress,
		  SeenBy[4],
		  AreaGroup,
		  MessGroup,
		  AltGroups[3],
		  EchomailFeed,             // 0=No Uplink
		  DestNodes[256/8];         // Nodes  1 to  8 - DestNode[1]
					    // Nodes  9 to 16 - DestNode[2]
					    // Nodes 17 to 24 - DestNode[3]
    short         MsgIdxPos;                // Position in Messages.Idx
    char          ArrivalKill,
		  FreeSpace[13];
};


/* Maximus 2.0 & 3.0 - FILEAREA.CTL & MSGAREA.CTL */
/* These are text files with the following format and can be in any order:

 FileArea BBS
	 Type       CD
	 ACS        Limited
	 Desc       BBS Programs and Support
	 Download   F:\BBS\
	 Upload     E:\FILES\UNCHECK\
	 Filelist   E:\FILES\CD\BBS.BBS
 End FileArea

MsgArea 1
        ACS        Transient
        Desc       Comments to the SysOp
        Style      Squish Local Pvt Attach
        Tag        SYSOP_MSGS
        Path       E:\JAM\J1\SYSOP_MS
        Renum Max  100
        Renum Days 7
End MsgArea

*/

/***********************************************************************/
/* Security level definitions for Maximus and Lora                     */
/***********************************************************************/
#define  L_TWIT        0x10
#define  L_DISGRACE    0x20
#define  L_LIMITED     0x30
#define  L_NORMAL      0x40
#define  L_WORTHY      0x50
#define  L_PRIVIL      0x60
#define  L_FAVORED     0x70
#define  L_EXTRA       0x80
#define  L_CLERK       0x90
#define  L_ASSTSYSOP   0xA0
#define  L_SYSOP       0xB0
#define  L_HIDDEN      0xC0

/* Maximus 2.02 levels */
#define  M_TWIT        -2
#define  M_DISGRACE    0x0000
#define  M_LIMITED     0x0001
#define  M_NORMAL      0x0002
#define  M_WORTHY      0x0003
#define  M_PRIVIL      0x0004
#define  M_FAVORED     0x0005
#define  M_EXTRA       0x0006
#define  M_CLERK       0x0007
#define  M_ASSTSYSOP   0x0008
#define  M_SYSOP       0x000A
#define  M_HIDDEN      0x000b

/***********************************************************************/
/* Message base structures                                             */
/***********************************************************************/

/* Hudson Message Base */

/* Msg Attributes:

      Bit 0: Deleted
      Bit 1: Unmoved Outgoing Net Message
      Bit 2: Is a Net Mail Message
      Bit 3: Private
      Bit 4: Received
      Bit 5: Unmoved Outgoing Echo Message
      Bit 6: Local Bit
      Bit 7: Group Message

   Net Attributes:

      Bit 0: Kill Message after it's been sent
      Bit 1: Sent OK
      Bit 2: File(s) Attached
      Bit 3: Crash Priority
      Bit 4: Request Receipt
      Bit 5: Audit Request
      Bit 6: Is a Return Receipt
      Bit 7: Freq

*/

/* MSGINFO.BBS */
struct hmb_msginfo
{
    unsigned short   lowmsg;
    unsigned short   highmsg;
    unsigned short   totalmsgs;
    unsigned short   totalonboard[200];
};

/* MSGIDX.BBS */
struct hmb_msgidx
{
    short msgnum;
    char  board;
};

/* MSGTOIDX.BBS */
struct hmb_msgtoidx
{
    char l1;
    char name[35];
};

/* MSGHDR.BBS */
struct hmb_msghdr
{
    short          msgnum;
    unsigned short prevreply;
    unsigned short nextreply;
    unsigned short timesread;
    unsigned short startblock;
    unsigned short numblocks;
    unsigned short destnet;
    unsigned short destnode;
    unsigned short orignet;
    unsigned short orignode;
    char           destzone;
    char           origzone;
    unsigned short cost;
    char           msgattr;
    char           netattr;
    char           board;
    unsigned char  l1;
    char           posttime[5];
    unsigned char  l2;
    char           postdate[8];
    unsigned char  l3;
    char           whoto[35];
    unsigned char  l4;
    char           whofrom[35];
    char           l5;
    char           subject[72];
};

/* MSGTXT.BBS */
struct hmb_msgtxt
{
    char l1;
    char text[255];
};

/***********************************************************************/

/* GoldBase message base */

/* MSGTOIDX.DAT*/
struct gold_msgtoidx
{
    char l1;
    char name[35];
};

/* MSGTXT.DAT */
struct gold_msgtxt
{
    char l1;
    char text[255];
};

/* MSGINFO.DAT */
struct gold_msginfo
{
    long           lowmsg,
		   highmsg,
                   totalmsgs;
    unsigned short totalonboard[500];
};

/* MSGIDX.DAT */
struct gold_msgidx
{
    long           msgnum;
    unsigned short board;
};

/* MSGHDR.DAT */
struct gold_msghdr
{
    long           msgnum;
    long           prevreply;
    long           nextreply;
    unsigned short timesread;
    long           startblock;
    unsigned short numblocks;
    unsigned short destnet;
    unsigned short destnode;
    unsigned short orignet;
    unsigned short orignode;
    char           destzone;
    char           origzone;
    unsigned short cost;
    unsigned short msgattr;
    unsigned short netattr;
    unsigned short board;
    char           l1;
    char           posttime[5];
    char           l2;
    char           postdate[8];
    char           l3;
    char           whoto[35];
    char           l4;
    char           whofrom[35];
    char           l5;
    char           subj[72];
};

/* JAM message base */
typedef char           CHAR8;
typedef unsigned long  UINT32;
typedef unsigned short UINT16;

/*  Message status bits */
#define MSG_LOCAL       0x00000001L    /* Msg created locally */
#define MSG_INTRANSIT   0x00000002L    /* Msg is in-transit */
#define MSG_PRIVATE     0x00000004L    /* Private */
#define MSG_READ        0x00000008L    /* Read by addressee */
#define MSG_SENT        0x00000010L    /* Sent to remote */
#define MSG_KILLSENT    0x00000020L    /* Kill when sent */
#define MSG_ARCHIVESENT 0x00000040L    /* Archive when sent */
#define MSG_HOLD        0x00000080L    /* Hold for pick-up */
#define MSG_CRASH       0x00000100L    /* Crash */
#define MSG_IMMEDIATE   0x00000200L    /* Send Msg now, ignore restrictions */
#define MSG_DIRECT      0x00000400L    /* Send directly to destination */
#define MSG_GATE        0x00000800L    /* Send via gateway */
#define MSG_FILEREQUEST 0x00001000L    /* File request */
#define MSG_FILEATTACH  0x00002000L    /* File(s) attached to Msg */
#define MSG_TRUNCFILE   0x00004000L    /* Truncate file(s) when sent */
#define MSG_KILLFILE    0x00008000L    /* Delete file(s) when sent */
#define MSG_RECEIPTREQ  0x00010000L    /* Return receipt requested */
#define MSG_CONFIRMREQ  0x00020000L    /* Confirmation receipt requested */
#define MSG_ORPHAN      0x00040000L    /* Unknown destination */
#define MSG_ENCRYPT     0x00080000L    /* Msg text is encrypted */
#define MSG_COMPRESS    0x00100000L    /* Msg text is compressed */
#define MSG_ESCAPED     0x00200000L    /* Msg text is seven bit ASCII */
#define MSG_FPU         0x00400000L    /* Force pickup */
#define MSG_TYPELOCAL   0x00800000L    /* Msg is for local use only (not for export) */
#define MSG_TYPEECHO    0x01000000L    /* Msg is for conference distribution */
#define MSG_TYPENET     0x02000000L    /* Msg is direct network mail */
#define MSG_NODISP      0x20000000L    /* Msg may not be displayed to user */
#define MSG_LOCKED      0x40000000L    /* Msg is locked, no editing possible */
#define MSG_DELETED     0x80000000L    /* Msg is deleted */

/*  Message header subfield types */
#define JAMSFLD_OADDRESS    0
#define JAMSFLD_DADDRESS    1
#define JAMSFLD_SENDERNAME  2
#define JAMSFLD_RECVRNAME   3
#define JAMSFLD_MSGID       4
#define JAMSFLD_REPLYID     5
#define JAMSFLD_SUBJECT     6
#define JAMSFLD_PID         7
#define JAMSFLD_TRACE       8
#define JAMSFLD_ENCLFILE    9
#define JAMSFLD_ENCLFWALIAS 10
#define JAMSFLD_ENCLFREQ    11
#define JAMSFLD_ENCLFILEWC  12
#define JAMSFLD_ENCLINDFILE 13
#define JAMSFLD_EMBINDAT    1000
#define JAMSFLD_FTSKLUDGE   2000
#define JAMSFLD_SEENBY2D    2001
#define JAMSFLD_PATH2D      2002
#define JAMSFLD_FLAGS       2003
#define JAMSFLD_TZUTCINFO   2004
#define JAMSFLD_UNKNOWN     0xffff

#define CURRENTREVLEV   1
#define HEADERSIGNATURE "JAM"


/* .JHR file */
/*  Header file information block, stored first in all .JHR files */
typedef struct
{
    CHAR8   Signature[4];              /* <J><A><M> followed by <NUL> */
    UINT32  DateCreated;               /* Creation date */
    UINT32  ModCounter;                /* Last processed counter */
    UINT32  ActiveMsgs;                /* Number of active (not deleted) msgs */
    UINT32  PasswordCRC;               /* CRC-32 of password to access */
    UINT32  BaseMsgNum;                /* Lowest message number in index file */
    UINT32  HighWaterMark;	       /* High Water Mark */
    CHAR8   RSRVD[996];                /* Reserved space */
}JAMHDRINFO;

/*  Message header */
typedef struct
    {
    CHAR8   Signature[4];              /* <J><A><M> followed by <NUL> */
    UINT16  Revision;                  /* CURRENTREVLEV */
    UINT16  ReservedWord;              /* Reserved */
    UINT32  SubfieldLen;               /* Length of subfields */
    UINT32  TimesRead;                 /* Number of times message read */
    UINT32  MsgIdCRC;                  /* CRC-32 of MSGID line */
    UINT32  ReplyCRC;                  /* CRC-32 of REPLY line */
    UINT32  ReplyTo;                   /* This msg is a reply to.. */
    UINT32  Reply1st;                  /* First reply to this msg */
    UINT32  ReplyNext;                 /* Next msg in reply chain */
    UINT32  DateWritten;               /* When msg was written */
    UINT32  DateReceived;              /* When msg was received/read */
    UINT32  DateProcessed;             /* When msg was processed by packer */
    UINT32  MsgNum;                    /* Message number (1-based) */
    UINT32  Attribute;                 /* Msg attribute, see "Status bits" */
    UINT32  Attribute2;                /* Reserved for future use */
    UINT32  TxtOffset;                 /* Offset of text in text file */
    UINT32  TxtLen;                    /* Length of message text */
    UINT32  PasswordCRC;               /* CRC-32 of password to access msg */
    UINT32  Cost;                      /* Cost of message */
    }JAMHDR;

/* Header subfield */
typedef struct
    {
    UINT16  LoID;                      /* Field ID, 0 - 0xffff */
    UINT16  HiID;                      /* Reserved for future use */
    UINT32  DatLen;                    /* Length of buffer that follows */
    }JAMBINSUBFIELD;

/* .JDX file */
/*  Message index record */
typedef struct
    {
    UINT32  UserCRC;                   /* CRC-32 of destination username */
    UINT32  HdrOffset;                 /* Offset of header in .JHR file */
    }JAMIDXREC;


/*  Squish message base */
#include "squish.h"


/* *.MSG message base */
#define _PRIVATE  0x0001
#define _FILE     0x0010
#define _LOCAL    0x0100

struct netmsg
{
    char from[36],
	 too[36],
	 subj[72],
	 date[20];
    unsigned short timesread,
		   destnode,
		   orignode,
		   cost,
		   orignet,
		   destnet,
		   freespace[4],
		   replyto,
		   attr,
		   nextreply;
};


/* EzyCom message base */

#define  MAXMESSALL 1536
#define  MAXMESS    MAXMESSALL
typedef struct NetRecord {
  short     Zone,
	    Net,
	    Node,
	    Point;
} NetRecord;

/**********************************************************

  FileName:     <msgpath>\AREA<(<area>-1)/100+1>\MH<area>.BBS
                eg: \ezy\msgbase\area1\mh00001.bbs     for area 1
                eg: \ezy\msgbase\area10\mh01001.bbs    for area 1001
                eg: \ezy\msgbase\area100\mh10001.bbs   for area 10001

  Description:  Used by Ezycom to store message header

  msgattr,
    Bit 0 : Deleted
        1 : Netmail pending export
	2 : [Reserved]
	3 : Private
	4 : Received
	5 : Echomail pending export
	6 : Locally generated msg
	7 : Do not kill message

  netattr,
    Bit 0 : Kill/sent
	1 : Sent
	2 : File Attach
	3 : Crash
	4 : File Req
	5 : Request Receipt
	6 : Audit Request
	7 : Is a Return Receipt

   extattr   : byte;
     Bit 0-7 : [Reserved]

 **********************************************************/

struct EZ_MsgHdrRecord
{
    short         PrevReply,
		  NextReply;                // 0 = No Reply Chain
    long          StartPosition,            // Physical Start Position in
					    // MSGT???.BBS
		  MessageLength;            // Message Length including
					    // Null Terminator
    NetRecord     DestNet,
		  OrigNet;
    short         Cost;
    char          MsgAttr,
		  NetAttr,
		  ExtAttr;
    long          PostTimeDate,             // DOS Format Packed DateTime
		  RecvTimeDate;             // DOS Format Packed DateTime
    char          l1,
		  WhoTo[35],
		  l2,
		  WhoFrom[35],
		  l3,
		  Subject[72];
  };

/**********************************************************

  FileName:     <msgpath>\AREA<<area-1>/100+1>\MT<area>.BBS
		eg: \ezy\msgbase\area1\mt00001.bbs     for area 1
		eg: \ezy\msgbase\area10\mt01001.bbs    for area 1001
		eg: \ezy\msgbase\area100\mt10001.bbs   for area 10001

  Description:  Used by Ezycom to store message text

 **********************************************************/

   /* Message Text

	  Each text part of the message starts at 'startposition',
     and continues on until a NULL terminator is found, or end
     of file is reached (shouldn't happen, but just in case).
     Each message is contained of plain text, with 0x08D
     terminators for wrapped lines or 0x0D terminators for hard
     carriage returns.  No line of text should exceed 79 characters
     excluding the terminator */

/**********************************************************

  FileName:     <msgpath>MSGFAST.BBS

  Description:  Used by Ezycom for mail checks

 **********************************************************/

struct EZ_MsgFastRecord
{
    long         WhoTo;		       // standard 32 Bit CRC on whoto in
				       // MH???.BBS Username is CRCd in
				       // UPPERCASE, and does not include
				       // null terminator or length byte
    short        MsgBoard,
		 MsgNumber;
};

/**********************************************************

  FileName:     <msgpath>MSGCOUNT.BBS

  Description:  Used by Ezycom and Utilities for
		message area counting.
		Reading the number of records of
		MHxxx.BBS gives the same effect as
		reading the conferences count.

 **********************************************************/

  typedef unsigned int  MsgAreaCountType[MAXMESS];





/************************************************************************/
/* File area databases                                                  */
/************************************************************************/

// RemoteAccess 2.0 FDB
struct ra_fileshdr
{
    unsigned char  l1;
    char           name[12];
    long           size;
    long           CRC32;
    unsigned char  l2;
    char           uploader[35];
    unsigned short uploadtime,
		   uploaddate,
		   filetime,
		   filedate,
		   lastdltime,
		   lastdldate;
    unsigned short timesdl;
    char           attrib;
    char           l3;
    char           password[15];
    struct
    {
        char l1;
        char desc[15];
    }keyword[5];
    unsigned short cost;
    long           longdescptr;
    char           freespace[20];
};

#define RA_DELETED      1
#define RA_UNLISTED     2
#define RA_FREE         4
#define RA_NOTAVAIL     8
#define RA_LOCKED       16
#define RA_MISSING      32
#define RA_NORESTRICT   64
/*
Attrib - Bit 0 : Deleted
             1 : Unlisted
             2 : Free (don't adjust ratio) - Does NOT affect "Cost"
             3 : Not available (don't allow downloads)
             4 : Locked (no kill)
             5 : Missing/offline
             6 : No time restrictions - always allow DL
*/

struct ra_filesidx
{
    unsigned char  l1;
    char           name[12];
    unsigned short uploadtime,
		   uploaddate;
    long           keywordcrc[5];
    long           longdescptr;
};

/*********************************************************************/

/* Concord FDB */

// ????????.HDR
struct concord_hdr
{
    char           name[11];
    long           size;
    unsigned short uploadtime,
		   uploaddate;
    unsigned short downloads,
                   attrib;
    long           descptr;
    unsigned short descreclen;
    unsigned char  uploaderlen;
};

/*
 { Attributes
   bit        description
     0         Deleted
     1         For Sysop
     2         OFFLINE
     3         Unlisted
     4         No-kill   NOT YET IMPLEMENTED
  }
*/

// ????????.TXT
/* The .TXT file is of the following format:
  1. Description, the length of which is determined from the .HDR .desclen
     field, up to a maximum of 1024 bytes.
  2. Uploader name, the length of which is determined from the .HDR .namelen
     field.
  3. 2 bytes for the lastdl date.
  4. 2 bytes for the cost.

  3 & 4 are not yet implemented.

  DescriptionRec = record                             (* ????????.TXT *)
    Desc:        array[1..desclen] of char; (max. length 1024 bytes)
    Uploader:    array[1..namelen] of char;
    LastDL:      DateRec; NOT YET IMPLEMENTED
    Cost:        Word;    NOT YET IMPLEMENTED
  end;
*/


/* LoraBBS 3.00 filebase - FILEBASE.DAT */
#define FILE_DELETED       0x8000
#define FILE_OFFLINE       0x4000
#define FILE_UNAPPROVED    0x2000
#define FILE_CDROM         0x1000

#define FILEBASE_ID        0x602C789FL

struct lora_filesdat
{
   unsigned long  Id;               // Must be FILEBASE_ID
   char   Area[32];                 // File area name
   char   Name[32];                 // File name
   char   Complete[128];            // Fully qualified pathfilename
   unsigned short Description;      // Description length
   unsigned short Uploader;         // Uploader name length
   char   Keyword[32];              // Optional keywords
   unsigned long  Size;             // Size in bytes
   unsigned long  DlTimes;          // Number of downloads
   unsigned long  FileDate;         // File's creation date and time (seconds since 1970)
   unsigned long  UploadDate;       // File's upload date and time
   unsigned long  Cost;             // Cost for download this file
   unsigned long  Password;         // 32bit CRC of file's download password
   unsigned short Level;            // Security level
   unsigned long  AccessFlags;      // Access flags
   unsigned long  DenyFlags;        // Deny flags
   unsigned short Flags;            // Miscellaneous flags
};

/* LoraBBS 3.00 filebase - FILEBASE.IDX */
struct lora_filesidx
{
   unsigned long  Area;             // 32bit CRC of file's area name
   char   Name[32];                 // File name
   unsigned long  UploadDate;       // File's upload date and time
   unsigned long  Offset;           // Offset of the FILEDATA structure
   unsigned short Flags;            // Miscellaneous flags
};



/* EzyCom 1.20 filebase */


/**********************************************************


  FileName     : filebase path\FLCOUNT.BBS

  Description  : Stores number of files in each file area
		 (does not include comment lines)

  Records      : 1..65000
		 Always the same as FILES.EZY + FILEPATH.EZY

  Last Revised : 25/2/92(pwd)

  Sharing      : Always use DENYNONE + READWRITE

 **********************************************************/

  /*  Each record contains a word (2 bytes) which stores the
      amount of files in each file area.

      When reading the information, just seek to the
      appropriate record and read the 2 bytes

      When updating the count, lock the 2 bytes, then read
      it, then increate/decrease the amount, then write it
      back, and then release the lock. */


/**********************************************************

  FileName     : FLHXXXXX.BBS

  Description  : Stores file list information

  Last Revised : 25/2/92(pwd)

  Sharing      : Always use DENYNONE + READWRITE

  attribute
    Bit 0 : checked
	1 : nokill
	2 : offline
	3 : [Reserved]
	4 : private
	5 : deleted
      6-7 : [Reserved]

  attribute2
   bit 0-7: [Reserved]

 **********************************************************/

struct EZY_FileHdrRecord
{
    long          FltStart;               // start of info in FLTXXXXX.BBS
    unsigned short FltLength;              // length including null termiantor
    char          Attribute,
		  l1,
		  FileName[12];           // if the length of FileName is 0,
					  // then it is a comment
    unsigned short FilePath;               // pointer to filepath.ezy for path
					  // of file 0= do not know where the
					  // file is
    long          FSize;                  // size of the actual file
    unsigned short FDate,                  // date of the actual file
		   ArrivalDate;            // date the file arrived on the system
    short	  Downloads;
    unsigned short DownloadDate;           // last time the file was downloaded
					  // if (downloads = 0) then
					  //  this field is invalid
    char          Attribute2,
		  l2,
		  Uploader[35],
		  FreeSpace[57];
};

/**********************************************************

  FileName     : FLTXXXXX.BBS

  Description  : Stores file list description information

  Last Revised : 25/2/92(pwd)

 **********************************************************/

   #define  FLTMAXSIZE  2048            // maximum size of a file description


  /* The FLTXXXXX.BBS has contains a null terminated string.

     It is either a comment, or a file description.  The description
     or comment can be upto FTLMAXSIZE in length.

     A comment maybe only 1 line long, and may NOT contain line feeds
     or carriage returns.

     A description can be any number of lines long, and may contain
     carriage returns, but may NOT contain line feeds (waste space)

     When writing to the description file, the file MUST be opened
     in DENYWRITE + READWRITE.  When reading from it, it MUST
     be opened in DENYNONE + READONLY */



/* Telegard 3.02 filebase */
typedef struct          /* *.FB status flags */
{
    short freedl : 1;                    /* if file is free */
    short notime : 1;                    /* if file is time check free */
    short validated : 1;                 /* if file is validated */
    short available : 1;                 /* if file is available - will */
				       /*    be toggled FALSE only */
				       /*    if failed by filescan */
    short offline : 1;                   /* if file is offline */
    short hatch : 1;                     /* if file hatched via SDS */
}
tgfbstat;

struct tg_hdr           /* *.FB File records */
{
    char l1;
    char filename[12];               /* filename */
    char l2;
    char description[45];            /* description */
    long extended;                  /* pointer to extended desc */
				       /*    -1 = no extended desc */
    long int size,                     /* length of file (bytes) */
	     uldate,                   /* date uploaded */
	     filedate,                 /* date on file */
	     dldate;                   /* date last downloaded */
    char filestatus;                 /* file status */
    short filepoints;                   /* points */
    short downloads;                    /* number of downloads */
    char l3;
    char uploader[36];               /* uploader's name */
    long passwordCRC;               /* CRC of password to dl */
    char reserved[20];                 /* RESERVED */
};

struct tg_etxt          /* *.FBE Extended descriptions */
{
    char l0;
    char filename[12];               /* filename (for reference) */
    char extdesc[5][46];             /* Descriptions */
    long nextlink;                  /* offset to next record */
				       /*      -1 = last record */
    char reserved[10];                 /* RESERVED */
};


// Telegard 3.10 filebase
/*
   Extra notes on QFILES.IDX:
      1) To delete a record, toggle the 'deleted' flag
      2) To insert a record, ensure there is no OTHER matching filename &
	 filearea that is *not* deleted (if it is deleted, IGNORE IT) --
	 if one exists, then do not add another record, otherwise append to
	 the end
      3) Read DEVELnnn.DOC for further information on the index!
*/

typedef struct {
    short fndeleted : 1;                 /* index is deleted? */
}
fileidxstat;

typedef struct          /* QFILES.IDX - File index record */
{
    char l1,
	 filename[12];                 /* filename [key] */
    long    filearea;                  /* filearea */
    fileidxstat status;                /* status bits */
}
fileidxrec;

typedef struct          /* *.FA status flags */
{
    short freedl : 1;                    /* if file is free */
    short notime : 1;                    /* if file is time check free */
    short validated : 1;                 /* if file is validated */
    short available : 1;                 /* if file is available - will */
				       /*    be toggled FALSE only */
				       /*    if failed by filescan */
    short offline : 1;                   /* if file is offline */
    short hatch : 1;                     /* if file hatched via SDS */
}
fbstat;

struct tg310_hdr          /* *.FA File records */
{
    char l1,
	 filename[12];                 /* filename */
    long    descofs;                   /* offset of file desc */
    short desclength;                  /* length of description */
				       /*   - does not include 13 */
				       /*   byte filename ID */
    long size,                         /* length of file (bytes) */
	 uldate,                       /* date uploaded */
	 filedate,                     /* date on file */
	 dldate;                       /* date last downloaded */
    char filestatus;                   /* file status */
    short filepoints;                  /* points */
    short downloads;                   /* number of downloads */
    char l2,
	 uploader[36];                 /* uploader's name */
    long passwordCRC;                  /* CRC of password to dl */
    char reserved[12];                 /* RESERVED */
};

/*
   *.FAD file

   The description is stored in a continuous character file--the
   description for a file can be found by searching to the description
   offset and reading a 13 byte signature, then the description of the
   appropriate length.  If the 13 byte signature does NOT match the
   filename field, then the description is invalid
*/



/***********************************************************************/

class BBSInfo
{
    /* Private variable declarations */
    private:
#if defined(__BORLANDC__)
    unsigned int file_date, file_time, msg_date, msg_time;
#else
    unsigned short file_date, file_time, msg_date, msg_time;
#endif
    unsigned short cur_filearea, cur_msgarea;

    class Utility Utility_obj;
    class Amustr Amustr_obj;
    class Crc Crc_obj;
    FILE *areafile, *indexfile;
    int rec_size, index_size;
    char LOGSTR[151];
    struct ra20_files ra20filesvar;
    struct ra10_files ra10filesvar;
    struct t302_files t302filesvar;
    struct q276_files q276filesvar;
    struct q280_files q280filesvar;
    struct s117_files s117filesvar;
    struct conc_files concfilesvar;
    struct lora_files lorafilesvar;
    struct pb21_files pb21filesvar;
    struct e120_files e120filesvar;
    struct e120_files_xi e120filesxivar;
    struct l300_files l300filesvar;

    struct ra20_msgs ra20msgsvar;
    struct ra10_msgs ra10msgsvar;
    struct t302_msgs t302msgsvar;
    struct q276_msgs q276msgsvar;
    struct q280_msgs q280msgsvar;
    struct s117_msgs s117msgsvar;
    struct conc_msgs concmsgsvar;
    struct lora_msgs loramsgsvar;
    struct pb21_msgs pb21msgsvar;
    struct e120_msgs e120msgsvar;
    struct l300_msgs l300msgsvar;

    /* Public member functions */
    public:
    BBSInfo(void);
    int open_files(void);
    int read_files(struct filearea *areavar);
    void close_files(void);
    int bbsfiles_changed(void);
    int get_ftime(void) { return(file_time); }
    int get_fdate(void) { return(file_date); }
    int open_msgs(void);
    int read_msgs(struct msgarea *);
    void close_msgs(void);
    int get_mtime(void) { return(msg_time); }
    int get_mdate(void) { return(msg_date); }
    int bbsmsgs_changed(void);

     /* Private member functions */
    private:
    int get_security(char *sec);
    void expand_ctlfile(FILE *outfile, char *filename);
};
#endif

/***********************************************************************/

/* EOF - BBSINFO.H */
