// Class and member functions to read BBS system files, Y2K
// Created 11 February 1996
// Revised 13 January 1998

#include <stdio.h>
#include <string.h>
#include <share.h>
#include <dos.h>
#include <stdlib.h>
#include <io.h>
#include "bbsinfo.h"
#include "extern.h"
#include "config.h"

extern class Config Config_obj;

/***********************************************************************/

/* Constructor */
BBSInfo::BBSInfo(void)
{
    indexfile = areafile = 0;
}

/* Translate a text string to a Maximus security level */
int BBSInfo::get_security(char *sec)
{
    int security;

    if(stricmp(sec, "TWIT") == 0)
    {
        security = M_TWIT;
    }
    if(stricmp(sec, "DISGRACE") == 0)
    {
        security = M_DISGRACE;
    }
    if(stricmp(sec, "LIMITED") == 0)
    {
        security = M_LIMITED;
    }
    if(stricmp(sec, "NORMAL") == 0)
    {
        security = M_NORMAL;
    }
    if(stricmp(sec, "WORTHY") == 0)
    {
        security = M_WORTHY;
    }
    if(stricmp(sec, "PRIVIL") == 0)
    {
        security = M_PRIVIL;
    }
    if(stricmp(sec, "FAVORED") == 0)
    {
        security = M_FAVORED;
    }
    if(stricmp(sec, "EXTRA") == 0)
    {
        security = M_EXTRA;
    }
    if(stricmp(sec, "CLERK") == 0)
    {
        security = M_CLERK;
    }
    if(stricmp(sec, "ASSTSYSOP") == 0)
    {
        security = M_ASSTSYSOP;
    }
    if(stricmp(sec, "SYSOP") == 0)
    {
        security = M_SYSOP;
    }
    if(stricmp(sec, "HIDDEN") == 0)
    {
        security = M_HIDDEN;
    }

    return(security);
}

int BBSInfo::open_files(void)
{
    char filename[MAX_FILESPEC], read_mode[3], tmpname[MAX_FILESPEC];
    char indexname[MAX_FILESPEC];
    FILE *tmpfile;

    file_date = file_time = rec_size = index_size = 0;
    strcpy(filename, Config_obj.amu_cfgvar.BBSsyspath);
    strcpy(indexname, filename);
    strcpy(read_mode, "r+b");
    switch(Config_obj.amu_cfgvar.BBStype)
    {
        case RA250    :
        case RA2      : strcat(filename, "FILES.RA");
                        rec_size = sizeof(ra20filesvar);
                        break;
        case RA1      : strcat(filename, "FILES.RA");
                        rec_size = sizeof(ra10filesvar);
			break;
	case TG310    :
	case TG3      : strcat(filename, "FAREAS.DAT");
                        rec_size = sizeof(t302filesvar);
                        break;
        case SBBS     : strcat(filename, "FLSEARCH.BBS");
                        rec_size = sizeof(s117filesvar);
                        break;
        case QBBS     : strcat(filename, "FILECFG.DAT");
                        rec_size = sizeof(q276filesvar);
                        break;
        case QBBSC    :
        case QBBSG    : strcat(filename, "FILECFG.DAT");
                        rec_size = sizeof(q280filesvar);
                        break;
        case PB2      : strcat(filename, "FILECFG.PRO");
                        rec_size = sizeof(pb21filesvar);
                        break;

        case EZ       : strcat(filename, "FILES.EZY");
                        strcat(indexname, "FILEPATH.EZY");
                        rec_size = sizeof(e120filesvar);
                        index_size = sizeof(e120filesxivar);
                        break;
        case CONCORD  : strcat(filename, "FAREAS.DAT");

                        /* Attempt to open the Concord CONFIG.DAT and
                           grab the record size for an FAREAS.DAT record */
                        sprintf(tmpname, "%sCONFIG.DAT", Config_obj.amu_cfgvar.BBSsyspath);
                        tmpfile = _fsopen(tmpname, "rb", SH_DENYNO);
                        if(tmpfile)
                        {
                            fseek(tmpfile, FAREASIZE_OFFSET, SEEK_SET);
                            fread(&rec_size, 2, 1, tmpfile);
                            fclose(tmpfile);
                        }
                        else
                        {
                           /* Otherwise, use a record size that is
                              not taking into the consideration the 1000
                              bytes of "buffer" space in the AMU definitions
                              of these records */
                            rec_size = sizeof(concfilesvar) - 1000;
                        }
                        break;

        case LORA     : strcat(filename, "SYSFILE.DAT");
                        rec_size = sizeof(lorafilesvar);
                        break;

        case LORA3    : strcat(filename, "FILE.DAT");
                        rec_size = sizeof(l300filesvar);
                        break;

        case MAXIMUS2 :
        case MAXIMUS3 :
                        strcat(filename, "FILEAREA.CTL");
                        rec_size = 0;
                        strcpy(read_mode, "rt");

                        /* Grab the file time & date */
                        areafile = fopen(filename, "rt");
                        if(areafile)
                        {
                            _dos_getftime(fileno(areafile), &file_date, &file_time);
                            fclose(areafile);
                        }

                        /* First we need to create the temporary control
                           file that will include all files marked with a
                           'Include' */
                        sprintf(tmpname, "%s%s", Config_obj.amu_cfgvar.workpath,
                                MAXIMUS_TMP);
                        tmpfile = fopen(tmpname, "w+t");
                        if(tmpfile)
                        {
                            expand_ctlfile(tmpfile, filename);
                            fclose(tmpfile);
                            strcpy(filename, tmpname);
                        }
                        break;
    }
    cur_filearea = 0;
    areafile = _fsopen(filename, read_mode, SH_DENYNO);
    if(!areafile)
    {
        sprintf(LOGSTR, "! Unable to open '%s' - (%s)", filename, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(FALSE);
    }

    if(index_size > 0)
    {
        indexfile = _fsopen(indexname, read_mode, SH_DENYNO);
        if(!indexfile)
        {
            sprintf(LOGSTR, "! Unable to open '%s' - (%s)", indexname, strerror(errno));
            Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
            fclose(areafile);
            return(FALSE);
        }
    }

    if(file_date == 0 || file_time == 0)
    {
        _dos_getftime(fileno(areafile), &file_date, &file_time);
    }
    return(TRUE);
}

/* Read the next file entry from 'areafile' and fill up the structure
   pointed to by 'areavar'. Return 0 if EOF, 1 if successful */
int BBSInfo::read_files(struct filearea *areavar)
{
    char str[101], tmpstr[101], *ptr, *ptr2, tmp;
    unsigned long offset;

    cur_filearea++;

    /* See if this is end of file */
    offset = ftell(areafile);
    fread(&tmp, sizeof(tmp), 1, areafile);
    if(feof(areafile))
    {
        return(FALSE);
    }
    else
    {
        fseek(areafile, offset, SEEK_SET);
    }

    areavar -> keycrc32 = 0;
    switch(Config_obj.amu_cfgvar.BBStype)
    {
            /* RemoteAccess 2.0 */
        case RA250:
        case RA2: fread(&ra20filesvar, rec_size, 1, areafile);
                  Amustr_obj.pascaltoc(areavar -> areaname, ra20filesvar.name, ra20filesvar.l1);
                  Amustr_obj.pascaltoc(areavar -> filepath, ra20filesvar.filepath, ra20filesvar.l2);
                  areavar -> security = ra20filesvar.listsecurity;
                  areavar -> attrib.password = FALSE;
		  areavar -> attrib.cdrom = FALSE;
                  if(ra20filesvar.l3)
                  {
                      areavar -> attrib.password = TRUE;
                  }
                  if(Utility_obj.bitset(ra20filesvar.attrib, BIT3))
                  {
                      areavar -> attrib.cdrom = TRUE;
                  }
                  areavar -> listtype = RA_FDB;
                  if(Config_obj.amu_cfgvar.BBStype == RA250)
                  {
                      areavar -> areanum = ra20filesvar.areanum;
                  }
                  break;


                     /* RemoteAccess 1.11 */
        case RA1: fread(&ra10filesvar, rec_size, 1, areafile);
                  Amustr_obj.pascaltoc(areavar -> areaname, ra10filesvar.name, ra10filesvar.l1);
                  Amustr_obj.pascaltoc(areavar -> filepath, ra10filesvar.filepath, ra10filesvar.l2);
                  sprintf(areavar -> listpath, "%sFILES.%d", Config_obj.amu_cfgvar.cdlistpath,
                          ftell(areafile) / rec_size);
                  areavar -> security = ra10filesvar.security;
                  areavar -> attrib.cdrom = FALSE;
                  areavar -> attrib.password = FALSE;
                  areavar -> listtype = FILESBBS;
                  break;

		 /* Telegard 3.02, 3.10*/
	case TG310:
	case TG3: fread(&t302filesvar, rec_size, 1, areafile);
                  Amustr_obj.pascaltoc(areavar -> areaname, t302filesvar.name, t302filesvar.l1);
                  Amustr_obj.pascaltoc(areavar -> filepath, t302filesvar.path, t302filesvar.l4);
                  Amustr_obj.pascaltoc(areavar -> listpath, t302filesvar.filepath, t302filesvar.l5);
                  Amustr_obj.pascaltoc(tmpstr, t302filesvar.filename, t302filesvar.l2);
                  strcat(areavar -> listpath, tmpstr);
                  areavar -> security = 65535;
                  areavar -> attrib.password = FALSE;
		  areavar -> attrib.cdrom = t302filesvar.fstatus.fbcdrom;
		  switch(Config_obj.amu_cfgvar.BBStype)
		  {
		      case TG310: areavar -> listtype = TG310_FDB;
				  break;
		      case TG3  : areavar -> listtype = TG_FDB;
				  break;
		  }
                  break;

                    /* SuperBBS 1.17 */
        case SBBS: fread(&s117filesvar, rec_size, 1, areafile);
                   s117filesvar.name[40] = NULL;
                   s117filesvar.directory[40] = NULL;
                   s117filesvar.listname[40] = NULL;
                   Amustr_obj.pascaltoc(areavar -> areaname, s117filesvar.name, s117filesvar.ln1);
                   Amustr_obj.pascaltoc(areavar -> filepath, s117filesvar.directory, s117filesvar.ln2);
                   Amustr_obj.pascaltoc(areavar -> listpath, s117filesvar.listname, s117filesvar.ln3);
                   areavar -> security = s117filesvar.security;
                   areavar -> attrib.cdrom = FALSE;
                   areavar -> attrib.password = FALSE;
                   areavar -> listtype = FILESBBS;
                   break;

                    /* ProBoard 2.15 */
        case PB2: fread(&pb21filesvar, rec_size, 1, areafile);
                  pb21filesvar.name[40] = NULL;
                  strcpy(areavar -> areaname, pb21filesvar.name);
                  strcpy(areavar -> filepath, pb21filesvar.filepath);
                  strcpy(areavar -> listpath, pb21filesvar.listpath);
                  areavar -> security = pb21filesvar.level;
                  areavar -> attrib.cdrom = FALSE;
                  if(pb21filesvar.type == 1)
                  {
                      areavar -> attrib.cdrom = TRUE;
                  }
                  areavar -> attrib.password = FALSE;
                  areavar -> listtype = FILESBBS;
                  break;

                    /* EzyCom 1.20 */
        case EZ : fread(&e120filesvar, rec_size, 1, areafile);
		  fseek(indexfile, index_size * (e120filesvar.AreaPath - 1), SEEK_SET);
		  fread(&e120filesxivar, index_size, 1, indexfile);
                  Amustr_obj.pascaltoc(areavar -> areaname, e120filesvar.Name, e120filesvar.l1);
                  Amustr_obj.pascaltoc(areavar -> filepath, e120filesxivar.FilePath, e120filesxivar.l1);
                  Amustr_obj.pascaltoc(areavar -> listpath, e120filesxivar.FilesBBS, e120filesxivar.l2);
                  areavar -> security = e120filesvar.ListSecurity.Security;
                  areavar -> attrib.cdrom = FALSE;
                  if(Utility_obj.bitset(e120filesxivar.Attribute, BIT0))
                  {
                      areavar -> attrib.cdrom = TRUE;
                  }
                  areavar -> attrib.password = FALSE;
                  if((int) e120filesxivar.Password[0] > 0)
                  {
                      areavar -> attrib.password = TRUE;
                  }
                  areavar -> listtype = EZY_FDB;
                  break;

                    /* QuickBBS 2.76 */
        case QBBS: fread(&q276filesvar, rec_size, 1, areafile);
                   q276filesvar.areaname[40] = NULL;
                   q276filesvar.filepath[40] = NULL;
                   q276filesvar.listpath[40] = NULL;
                   Amustr_obj.pascaltoc(areavar -> areaname, q276filesvar.areaname, q276filesvar.ln1);
                   Amustr_obj.pascaltoc(areavar -> filepath, q276filesvar.filepath, q276filesvar.ln2);
                   Amustr_obj.pascaltoc(areavar -> listpath, q276filesvar.listpath, q276filesvar.ln3);
                   areavar -> security = q276filesvar.searchsec.security;
                   areavar -> attrib.cdrom = FALSE;
                   areavar -> attrib.password = FALSE;
                   areavar -> listtype = FILESBBS;
                   break;

                    /* QuickBBS 2.10 - Classic or GoldBase */
        case QBBSG:
        case QBBSC: fread(&q280filesvar, rec_size, 1, areafile);
                    q280filesvar.areaname[40] = NULL;
                    q280filesvar.filepath[40] = NULL;
                    q280filesvar.listpath[40] = NULL;
                    Amustr_obj.pascaltoc(areavar -> areaname, q280filesvar.areaname, q280filesvar.ln1);
                    Amustr_obj.pascaltoc(areavar -> filepath, q280filesvar.filepath, q280filesvar.ln2);
                    Amustr_obj.pascaltoc(areavar -> listpath, q280filesvar.listpath, q280filesvar.ln3);
                    areavar -> security = q280filesvar.searchsec.security;
                    areavar -> attrib.cdrom = FALSE;
                    areavar -> attrib.password = FALSE;
                    areavar -> listtype = FILESBBS;
                    break;

        case CONCORD: fread(&concfilesvar, rec_size, 1, areafile);
                      concfilesvar.name[40] = NULL;
                      concfilesvar.downloadpath[40] = NULL;
                      concfilesvar.filesbbs[40] = NULL;
                      Amustr_obj.pascaltoc(areavar -> areaname, concfilesvar.name, concfilesvar.l1);
                      Amustr_obj.pascaltoc(areavar -> filepath, concfilesvar.downloadpath, concfilesvar.l3);
                      Amustr_obj.pascaltoc(areavar -> listpath, concfilesvar.filesbbs, concfilesvar.l6);
                      if(areavar -> listpath[0] == NULL)
                      {
                          sprintf(areavar -> listpath, "%sFILES.BBS", areavar -> filepath);
                      }

                      areavar -> security = concfilesvar.listsec.seclvl;
                      areavar -> attrib.cdrom = FALSE;
                      areavar -> attrib.password = FALSE;
                      if(concfilesvar.l2)
                      {
                          areavar -> attrib.password = TRUE;
                      }
                      if(Utility_obj.bitset(concfilesvar.attrib, BIT6))
                      {
                          areavar -> attrib.cdrom = TRUE;
                      }
                      areavar -> listtype = FILESBBS;
                      if(!Utility_obj.bitset(concfilesvar.attrib, BIT9))
                      {
                          Amustr_obj.pascaltoc(areavar -> listpath, concfilesvar.Basename, concfilesvar.l4);
                          areavar -> listtype = CONCORD_FDB;
                      }
                      break;

        case LORA: fread(&lorafilesvar, rec_size, 1, areafile);
                   lorafilesvar.file_name[40] = NULL;
                   lorafilesvar.filepath[39] = NULL;
                   lorafilesvar.filelist[40] = NULL;
                   strcpy(areavar -> areaname, lorafilesvar.file_name);
                   strcpy(areavar -> filepath, lorafilesvar.filepath);
                   strcpy(areavar -> listpath, lorafilesvar.filelist);
                   areavar -> security = lorafilesvar.file_priv;
                   areavar -> attrib.password = FALSE;
                   areavar -> attrib.cdrom = FALSE;
                   if(lorafilesvar.cdrom)
                   {
                       areavar -> attrib.cdrom = TRUE;
                   }
                   areavar -> listtype = FILESBBS;
                   break;

        case LORA3:fread(&l300filesvar, rec_size, 1, areafile);
                   l300filesvar.Display[40] = NULL;
                   l300filesvar.Download[39] = NULL;
                   l300filesvar.FileList[40] = NULL;
                   areavar -> keycrc32 = Crc_obj.zmodemcrc32(l300filesvar.Key);
                   strcpy(areavar -> areaname, l300filesvar.Display);
                   strcpy(areavar -> filepath, l300filesvar.Download);
                   strcpy(areavar -> listpath, l300filesvar.FileList);
                   strcpy(areavar -> lora3key, l300filesvar.Key);
                   areavar -> security = l300filesvar.Level;
                   areavar -> attrib.password = FALSE;
                   areavar -> attrib.cdrom = FALSE;
                   if(l300filesvar.CdRom)
                   {
                       areavar -> attrib.cdrom = TRUE;
                   }
                   areavar -> listtype = LORA_FDB;
                   if(l300filesvar.UseFilesBBS == TRUE)
                   {
                       areavar -> listtype = FILESBBS;
                   }
                   break;

        case MAXIMUS2 :
        case MAXIMUS3 : areavar -> listtype = FILESBBS;
                        fgets(str, sizeof(str)-2, areafile);
                        strcpy(tmpstr, str);
                        strupr(tmpstr);

                        /* Move to the beginning of the file area block */
                        while(!feof(areafile) && !strstr(tmpstr, "FILEAREA "))
                        {
                            fgets(str, sizeof(str)-2, areafile);
                            strcpy(tmpstr, str);
                            strupr(tmpstr);
                        }
                        if(feof(areafile))
                        {
                            return(FALSE);
                        }

/*
 FileArea BBS
         Type       CD
         ACS        Limited
         Desc       BBS Programs and Support
         Download   F:\BBS\
         Upload     E:\FILES\UNCHECK\
         Filelist   E:\FILES\CD\BBS.BBS
 End FileArea
 */
                        fgets(str, sizeof(str)-2, areafile);
                        strcpy(tmpstr, str);
                        strupr(tmpstr);
                        while(!feof(areafile) && !strstr(tmpstr, "END FILEAREA"))
                        {
                            Amustr_obj.strip_n(tmpstr);
                            Amustr_obj.strip_n(str);
                            Amustr_obj.trimlead(tmpstr);
                            Amustr_obj.trimlead(str);
                            ptr = strchr(tmpstr, '\t');
                            if(!ptr)
                            {
                                ptr = strchr(tmpstr, ' ');
                            }

                          /* if this is null, the line is blank */
                            if(ptr)
                            {
                                *ptr = NULL;
                            }
                            else
                            {
                                fgets(str, sizeof(str)-2, areafile);
                                strcpy(tmpstr, str);
                                strupr(tmpstr);
                                continue;
                            }

                            ptr = strchr(str, '\t');
                            if(!ptr)
                            {
                                ptr = strchr(str, ' ');
                            }
                            Amustr_obj.trimlead(ptr);
                            ptr2 = ptr;
                            ptr2 += 40;
                            *ptr2 = NULL;

                            /* 'tmpstr' is the uppercase version of the
                               line identifier.  'ptr' points to the
                               beginning of the actual text */
                            if(strstr(tmpstr, "TYPE"))
                            {
                                strupr(ptr);
                                if(strstr(ptr, "CD"))
                                {
                                    areavar -> attrib.cdrom = TRUE;
                                }
                                tmpstr[0] = NULL;
                            }

                            if(strstr(tmpstr, "ACS") && tmpstr[0])
                            {
                                strupr(ptr);
                                areavar -> security = get_security(ptr);
                                tmpstr[0] = NULL;
                            }

                            if(strstr(tmpstr, "DESC") && tmpstr[0])
                            {
                                strcpy(areavar -> areaname, ptr);
                                tmpstr[0] = NULL;
                            }

                            if(strstr(tmpstr, "DOWNLOAD") && tmpstr[0])
                            {
                                strcpy(areavar -> filepath, ptr);
                                tmpstr[0] = NULL;
                            }

                            if(strstr(tmpstr, "FILELIST") && tmpstr[0])
                            {
                                strcpy(areavar -> listpath, ptr);
                                tmpstr[0] = NULL;
                            }

                            fgets(str, sizeof(str)-2, areafile);
                            strcpy(tmpstr, str);
                            strupr(tmpstr);
                        }
                        break;
    }
    if(areavar -> areanum <= 0)
    {
        areavar -> areanum = cur_filearea;
    }

    Amustr_obj.strip_n(areavar -> areaname);
    Amustr_obj.trimend(areavar -> areaname);

    Amustr_obj.noslash(areavar -> filepath);
    strupr(areavar -> filepath);
    if(access(areavar -> filepath, 0) != 0)
    {
        strrev(areavar -> filepath);
        Amustr_obj.noslash(areavar -> filepath);
        strrev(Config_obj.amu_cfgvar.BBSsyspath);
        strcat(areavar -> filepath, Config_obj.amu_cfgvar.BBSsyspath);
        strrev(Config_obj.amu_cfgvar.BBSsyspath);
        strrev(areavar -> filepath);
    }
    Amustr_obj.slash(areavar -> filepath);
    return(TRUE);
}

int BBSInfo::open_msgs(void)
{
    char filename[MAX_FILESPEC], read_mode[3], tmpname[MAX_FILESPEC];
    FILE *tmpfile;

    msg_date = msg_time = rec_size = 0;
    strcpy(filename, Config_obj.amu_cfgvar.BBSsyspath);
    strcpy(read_mode, "rb");
    switch(Config_obj.amu_cfgvar.BBStype)
    {
        case RA250    :
        case RA2      : strcat(filename, "MESSAGES.RA");
                        rec_size = sizeof(ra20msgsvar);
			break;
	case TG310    :
        case TG3      : strcat(filename, "MAREAS.DAT");
                        rec_size = sizeof(t302msgsvar);
                        break;
        case RA1      : strcat(filename, "MESSAGES.RA");
                        rec_size = sizeof(ra10msgsvar);
                        break;
        case SBBS     : strcat(filename, "BOARDS.BBS");
                        rec_size = sizeof(s117msgsvar);
                        break;
        case QBBS     : strcat(filename, "MSGCFG.DAT");
                        rec_size = sizeof(q276msgsvar);
                        break;
        case QBBSC    :
        case QBBSG    : strcat(filename, "MSGCFG.DAT");
                        rec_size = sizeof(q280msgsvar);
                        break;
        case PB2      : strcat(filename, "MESSAGES.PB");
                        rec_size = sizeof(pb21msgsvar);
                        break;
        case EZ       : strcat(filename, "MESSAGES.EZY");
                        rec_size = sizeof(e120msgsvar);
                        break;
        case CONCORD  : strcat(filename, "MAREAS.DAT");

                        /* Attempt to open the Concord CONFIG.DAT and
                           grab the record size for an MAREAS.DAT record */
                        sprintf(tmpname, "%sCONFIG.DAT", Config_obj.amu_cfgvar.BBSsyspath);
                        tmpfile = _fsopen(tmpname, "rb", SH_DENYNO);
                        if(tmpfile)
                        {
                            fseek(tmpfile, MAREASIZE_OFFSET, SEEK_SET);
                            fread(&rec_size, 2, 1, tmpfile);
                            fclose(tmpfile);
                        }
                        else
                        {
                           /* Otherwise, use a record size that is
                              not taking into the consideration the 1000
                              bytes of "buffer" space in the AMU definitions
                              of these records */
                            rec_size = sizeof(concmsgsvar) - 1000;
                        }
                        break;

        case LORA     : strcat(filename, "SYSMSG.DAT");
                        rec_size = sizeof(loramsgsvar);
                        break;
        case LORA3    : strcat(filename, "MSG.DAT");
                        rec_size = sizeof(l300msgsvar);
                        break;
        case MAXIMUS2 :
        case MAXIMUS3 : strcat(filename, "MSGAREA.CTL");
                        rec_size = 0;
                        strcpy(read_mode, "rt");

                        /* Grab the file time & date */
                        areafile = fopen(filename, "rt");
                        if(areafile)
                        {
                            _dos_getftime(fileno(areafile), &msg_date, &msg_time);
                            fclose(areafile);
                        }

                        /* First we need to create the temporary control
                           file that will include all files marked with a
                           'Include' */
                        sprintf(tmpname, "%s%s", Config_obj.amu_cfgvar.workpath,
                                MAXIMUS_TMP);
                        tmpfile = fopen(tmpname, "w+t");
                        if(tmpfile)
                        {
                            expand_ctlfile(tmpfile, filename);
                            fclose(tmpfile);
                            strcpy(filename, tmpname);
                        }
                        break;
    }
    cur_msgarea = 0;
    areafile = _fsopen(filename, read_mode, SH_DENYNO);
    if(!areafile)
    {
        sprintf(LOGSTR, "! Unable to open '%s' - (%s)", filename, strerror(errno));
        Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
        return(FALSE);
    }

    if(msg_time == 0 || msg_date == 0)
    {
        _dos_getftime(fileno(areafile), &msg_date, &msg_time);
    }
    return(TRUE);
}

/* Read the next msg entry from 'areafile' and fill up the structure
   pointed to by 'areavar'. Return 0 if EOF, 1 if successful */
int BBSInfo::read_msgs(struct msgarea *areavar)
{
    char str[131], tmpstr[131], *ptr, *ptr2, tmp;
    unsigned long offset;

     cur_msgarea++;

    /* See if this is end of file */
    offset = ftell(areafile);
    fread(&tmp, sizeof(tmp), 1, areafile);
    if(feof(areafile))
    {
        return(FALSE);
    }
    else
    {
        fseek(areafile, offset, SEEK_SET);
    }

    areavar -> areatype = UNKNOWN_TYPE;

    switch(Config_obj.amu_cfgvar.BBStype)
    {
            /* RemoteAccess 2.0 */
        case RA250:
        case RA2: fread(&ra20msgsvar, rec_size, 1, areafile);
                  Amustr_obj.pascaltoc(areavar -> areaname, ra20msgsvar.name, ra20msgsvar.l1);
                  Amustr_obj.pascaltoc(areavar -> basepath, ra20msgsvar.jambase, ra20msgsvar.l3);
                  areavar -> security = ra20msgsvar.readsecurity;
                  if(Utility_obj.bitset(ra20msgsvar.attribute, BIT7))
                  {
                      areavar -> areatype = JAM_TYPE;
                  }
                  else
                  {
                      areavar -> areatype = HUDSON_TYPE;
                  }
                  if(Config_obj.amu_cfgvar.BBStype == RA250)
                  {
                      areavar -> areanum = ra20msgsvar.areanum;
                  }
                  break;

	case TG310:
	case TG3: fread(&t302msgsvar, rec_size, 1, areafile);
                  Amustr_obj.pascaltoc(areavar -> areaname, t302msgsvar.name, t302msgsvar.l1);
                  Amustr_obj.pascaltoc(areavar -> basepath, t302msgsvar.msgpath, t302msgsvar.l2);
                  Amustr_obj.pascaltoc(tmpstr, t302msgsvar.filename, t302msgsvar.l3);
                  strcat(areavar -> basepath, tmpstr);
                  areavar -> security = 65535;
                  switch(t302msgsvar.mbformat)
                  {
                      case TGJAM   : areavar -> areatype = JAM_TYPE;
                                     break;
                      case TGSQUISH: areavar -> areatype = SQUISH_TYPE;
                                     break;
                      default      : areavar ->areatype = UNKNOWN_TYPE;
                                     break;
                  }
                  break;


                     /* RemoteAccess 1.11 */
        case RA1: fread(&ra10msgsvar, rec_size, 1, areafile);
                  Amustr_obj.pascaltoc(areavar -> areaname, ra10msgsvar.name, ra10msgsvar.l1);
                  areavar -> security = ra10msgsvar.readseclvl;
                  areavar -> areatype = HUDSON_TYPE;
                  break;

                    /* SuperBBS 1.17 */
        case SBBS: fread(&s117msgsvar, rec_size, 1, areafile);
                   s117msgsvar.name[40] = NULL;
                   Amustr_obj.pascaltoc(areavar -> areaname, s117msgsvar.name, s117msgsvar.ln1);
                   areavar -> security = s117msgsvar.readseclvl;
                   areavar -> areatype = HUDSON_TYPE;
                   break;

                    /* ProBoard 2.15 */
        case PB2: fread(&pb21msgsvar, rec_size, 1, areafile);
                  pb21msgsvar.name[40] = NULL;
                  strcpy(areavar -> areaname, pb21msgsvar.name);
                  strcpy(areavar -> basepath, pb21msgsvar.path);
                  areavar -> security = pb21msgsvar.readLevel;
                  switch(pb21msgsvar.msgBaseType)
                  {
                      case MSGBASE_HUDSON: areavar -> areatype = HUDSON_TYPE;
                                           areavar -> areanum = pb21msgsvar.areaNum;
                                           if(pb21msgsvar.hudsonBase > 0)
                                           {
                                               areavar -> areanum = pb21msgsvar.hudsonBase;
                                           }
                                           break;
                      case MSGBASE_SQUISH: areavar -> areatype = SQUISH_TYPE;
                                           break;
                      case MSGBASE_SDM:    areavar -> areatype = MSG_TYPE;
                                           break;
                      case MSGBASE_JAM:    areavar -> areatype = JAM_TYPE;
                                           break;
                      default: areavar -> areatype = UNKNOWN_TYPE;
                               break;
                  }
                  break;

                    /* EzyCom 1.48 */
        case EZ : fread(&e120msgsvar, rec_size, 1, areafile);
                  Amustr_obj.pascaltoc(areavar -> areaname, e120msgsvar.Name, e120msgsvar.l1);
                  areavar -> security = e120msgsvar.ReadSecurity.Security;
                  areavar -> areatype = EZY_TYPE;
                  break;

                    /* QuickBBS 2.76 */
        case QBBS: fread(&q276msgsvar, rec_size, 1, areafile);
                   q276msgsvar.name[40] = NULL;
                   Amustr_obj.pascaltoc(areavar -> areaname, q276msgsvar.name, q276msgsvar.ln1);
                   areavar -> security = q276msgsvar.readsec.security;
                   areavar -> areatype = HUDSON_TYPE;
                   break;

                    /* QuickBBS 2.81 - Classic and GoldBase */
        case QBBSG:
        case QBBSC: fread(&q280msgsvar, rec_size, 1, areafile);
                    q280msgsvar.name[40] = NULL;
                    Amustr_obj.pascaltoc(areavar -> areaname, q280msgsvar.name, q280msgsvar.ln1);
                    areavar -> security = q280msgsvar.readsec.security;
                    if(Config_obj.amu_cfgvar.BBStype == QBBSG)
                    {
                        areavar -> areatype = GOLD_TYPE;
                    }
                    else
                    {
                        areavar -> areatype = HUDSON_TYPE;
                    }
                    break;

        case CONCORD: fread(&concmsgsvar, rec_size, 1, areafile);
                      concmsgsvar.name[40] = NULL;
                      Amustr_obj.pascaltoc(areavar -> areaname, concmsgsvar.name, concmsgsvar.l2);
                      Amustr_obj.pascaltoc(areavar -> basepath, concmsgsvar.pathname, concmsgsvar.l1);
                      areavar -> security = concmsgsvar.readsec.seclvl;
                      switch(concmsgsvar.format)
                      {
                          case MAREAFMT_HMB: areavar -> areatype = HUDSON_TYPE;
                                             if(concmsgsvar.ownboard > 0)
                                             {
                                                 areavar -> areanum = concmsgsvar.ownboard;
                                             }
                                             break;
                          case MAREAFMT_JAM: areavar -> areatype = JAM_TYPE;
                                             break;
                          case MAREAFMT_MSG: areavar -> areatype = MSG_TYPE;
                                             break;
                          case MAREAFMT_SQUISH: areavar -> areatype = SQUISH_TYPE;
                                                break;
                          default: areavar -> areatype = UNKNOWN_TYPE;
                                   break;
                      }
                      break;

        case LORA: fread(&loramsgsvar, rec_size, 1, areafile);
                   strcpy(areavar -> areaname, loramsgsvar.msg_name);
                   strcpy(areavar -> basepath, loramsgsvar.msg_path);
                   areavar -> security = loramsgsvar.msg_priv;
                   if(loramsgsvar.squish)
                   {
                       areavar -> areatype = SQUISH_TYPE;
                   }
                   else
                   {
                       areavar -> areatype = MSG_TYPE;
                   }
                   if(loramsgsvar.quick_board)
                   {
                       areavar -> areatype = HUDSON_TYPE;
                       areavar -> areanum = loramsgsvar.quick_board;
                   }
                   if(loramsgsvar.gold_board)
                   {
                       areavar -> areatype = GOLD_TYPE;
                       areavar -> areanum = loramsgsvar.gold_board;
                   }
                   break;

        case LORA3:fread(&l300msgsvar, rec_size, 1, areafile);
                   l300msgsvar.Display[40] = NULL;
                   strcpy(areavar -> areaname, l300msgsvar.Display);
                   strcpy(areavar -> basepath, l300msgsvar.Path);
                   areavar -> security = l300msgsvar.Level;
                   switch(l300msgsvar.Storage)
                   {
                       case ST_JAM     : areavar -> areatype = JAM_TYPE;
                                         break;
                       case ST_SQUISH  : areavar -> areatype = SQUISH_TYPE;
                                         break;
                       case ST_FIDO    : areavar -> areatype = MSG_TYPE;
                                         break;
                       case ST_HUDSON  : areavar -> areatype = HUDSON_TYPE;
                                         areavar -> areanum = l300msgsvar.Board;
                                         break;
                       case ST_GOLDBASE: areavar -> areatype = GOLD_TYPE;
                                         areavar -> areanum = l300msgsvar.Board;
                                         break;
                       default:          areavar -> areatype = UNKNOWN_TYPE;
                                         break;
                   }
                   break;


        case MAXIMUS2 :
        case MAXIMUS3 : fgets(str, sizeof(str)-2, areafile);
                        strcpy(tmpstr, str);
                        strupr(tmpstr);

                        /* Move to the beginning of the msg area block */
                        while(!feof(areafile) && !strstr(tmpstr, "MSGAREA "))
                        {
                            fgets(str, sizeof(str)-2, areafile);
                            strcpy(tmpstr, str);
                            strupr(tmpstr);
                        }
                        if(feof(areafile))
                        {
                            return(FALSE);
                        }

/*
MsgArea 1
        ACS        Transient
        Desc       Comments to the SysOp
        Style      Squish Local Pvt Attach
        Tag        SYSOP_MSGS
        Path       E:\JAM\J1\SYSOP_MS
        Renum Max  100
        Renum Days 7
End MsgArea
*/
                        fgets(str, sizeof(str)-2, areafile);
                        strcpy(tmpstr, str);
                        strupr(tmpstr);
                        while(!feof(areafile) && !strstr(tmpstr, "END MSGAREA"))
                        {
                            Amustr_obj.strip_n(tmpstr);
                            Amustr_obj.strip_n(str);
                            Amustr_obj.trimlead(tmpstr);
                            Amustr_obj.trimlead(str);
                            ptr = strchr(tmpstr, '\t');
                            if(!ptr)
                            {
                                ptr = strchr(tmpstr, ' ');
                            }

                          /* if this is null, the line is blank */
                            if(ptr)
                            {
                                *ptr = NULL;
                            }
                            else
                            {
                                fgets(str, sizeof(str)-2, areafile);
                                strcpy(tmpstr, str);
                                strupr(tmpstr);
                                continue;
                            }

                            ptr = strchr(str, '\t');
                            if(!ptr)
                            {
                                ptr = strchr(str, ' ');
                            }
                            Amustr_obj.trimlead(ptr);
                            ptr2 = ptr;
                            ptr2 += 40;
                            *ptr2 = NULL;

                            /* 'tmpstr' is the uppercase version of the
                               line identifier.  'ptr' points to the
                               beginning of the actual text */
                            if(strstr(tmpstr, "STYLE"))
                            {
                                strupr(ptr);
                                if(strstr(ptr, "SQUISH"))
                                {
                                    areavar -> areatype = SQUISH_TYPE;
                                }
                                if(strstr(ptr, "*.MSG"))
                                {
                                    areavar -> areatype = MSG_TYPE;
                                }
                                tmpstr[0] = NULL;
                            }

                            if(strstr(tmpstr, "ACS") && tmpstr[0])
                            {
                                strupr(ptr);
                                areavar -> security = get_security(ptr);
                                tmpstr[0] = NULL;
                            }

                            if(strstr(tmpstr, "DESC") && tmpstr[0])
                            {
                                strcpy(areavar -> areaname, ptr);
                                tmpstr[0] = NULL;
                            }

                            if(strstr(tmpstr, "PATH") && tmpstr[0])
                            {
                                strcpy(areavar -> basepath, ptr);
                                tmpstr[0] = NULL;
                            }

                            fgets(str, sizeof(str)-2, areafile);
                            strcpy(tmpstr, str);
                            strupr(tmpstr);
                        }
                        break;
    }

    areavar -> areaname[35] = NULL;
    Amustr_obj.strip_n(areavar -> areaname);
    Amustr_obj.trimend(areavar -> areaname);

    if(areavar -> areanum <= 0)
    {
        areavar -> areanum = cur_msgarea;
    }

    strupr(areavar -> basepath);
    Amustr_obj.noslash(areavar -> basepath);
    if(areavar -> areatype == SQUISH_TYPE)
    {
        strcat(areavar -> basepath, ".SQD");
    }
    if(areavar -> areatype == JAM_TYPE)
    {
        strcat(areavar -> basepath, ".JHR");
    }

    if(access(areavar -> basepath, 0) != 0)
    {
        strcpy(tmpstr, areavar -> basepath);

	strrev(areavar -> basepath);
        Amustr_obj.noslash(areavar -> basepath);
        strrev(Config_obj.amu_cfgvar.BBSsyspath);
        strcat(areavar -> basepath, Config_obj.amu_cfgvar.BBSsyspath);
	strrev(Config_obj.amu_cfgvar.BBSsyspath);
        strrev(areavar -> basepath);

        // If that didn't help, restore the original value for the basepath
	if(access(areavar -> basepath, 0) != 0)
        {
            strcpy(areavar -> basepath, tmpstr);
        }
    }

    if(areavar -> areatype == SQUISH_TYPE)
    {
        ptr = strstr(areavar -> basepath, ".SQD");
        if(ptr)
        {
            *ptr = NULL;
        }
    }
    if(areavar -> areatype == JAM_TYPE)
    {
        ptr = strstr(areavar -> basepath, ".JHR");
        if(ptr)
        {
            *ptr = NULL;
        }
    }
    if(areavar -> areatype == MSG_TYPE)
    {
        Amustr_obj.slash(areavar -> basepath);
    }

    return(TRUE);
}


/***********************************************************************/
/* Check to see if the BBS file areas have changed. */
int BBSInfo::bbsfiles_changed(void)
{
    int changed;

    changed = FALSE;
    if(open_files())
    {
        if(Config_obj.amu_hdrvar.files_time != file_time ||
           Config_obj.amu_hdrvar.files_date != file_date)
        {
            changed = TRUE;
        }
        close_files();
    }
    return(changed);
}

/***********************************************************************/
/* Check to see if the BBS message areas have changed. */
int BBSInfo::bbsmsgs_changed(void)
{
    int changed;

    changed = FALSE;
    if(open_msgs())
    {
        if(Config_obj.amu_hdrvar.msgs_time != msg_time ||
           Config_obj.amu_hdrvar.msgs_date != msg_date)
        {
            changed = TRUE;
        }
        close_msgs();
    }
    return(changed);
}

void BBSInfo::close_msgs(void)
{
    char fname[MAX_FILESPEC];

    fclose(areafile);
    if(Config_obj.amu_cfgvar.BBStype == MAXIMUS2 ||
       Config_obj.amu_cfgvar.BBStype == MAXIMUS3)
    {
        sprintf(fname, "%s%s", Config_obj.amu_cfgvar.workpath, MAXIMUS_TMP);
        remove(fname);
    }
}

void BBSInfo::close_files(void)
{
    char fname[MAX_FILESPEC];

    fclose(areafile);
    if(indexfile)
    {
        fclose(indexfile);
    }
    if(Config_obj.amu_cfgvar.BBStype == MAXIMUS2 ||
       Config_obj.amu_cfgvar.BBStype == MAXIMUS3)
    {
        sprintf(fname, "%s%s", Config_obj.amu_cfgvar.workpath, MAXIMUS_TMP);
        remove(fname);
    }
}


/* Opens and reads 'filename' into 'outfile', recursively calls itself
   if an 'Include' line is encountered */
void BBSInfo::expand_ctlfile(FILE *outfile, char *filename)
{
    FILE *infile;
    char str[151], str2[151], *ptr;

    infile = fopen(filename, "rt");
    if(infile)
    {
        fgets(str, sizeof(str)-2, infile);
        while(!feof(infile) && !ferror(infile))
        {
            strcpy(str2, str);
            strupr(str2);
            if(strstr(str2, "INCLUDE"))
            {
                ptr = strstr(str2, "INCLUDE");
                if(ptr)
                {
                    ptr = strchr(ptr, ' ');
                    if(ptr)
                    {
                        Amustr_obj.trimlead(ptr);
                        Amustr_obj.strip_n(str2);
                        expand_ctlfile(outfile, ptr);
                    }
                }
            }
            else
            {
                fprintf(outfile, "%s", str);
            }
            fgets(str, sizeof(str)-2, infile);
        }
        fclose(infile);
    }
}

/**********************************************************************/
// EOF - BBSINFO.CPP
