/* Archives Menu functions       */
/* Created 28 January 1996       */
/* Last updated 14 May 1996      */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>
#include <mem.h>
#include <conio.h>
#include <mem.h>
#include "menus.h"
#include "arcmenu.h"
#include "config.h"
#include "utility2.h"
#include "crc.h"
#include "amuidx.h"

/* external objects */
extern class Utility2 Utility2_obj;
extern class Config Config_obj;
extern class Crc Crc_obj;
extern class Menus Menus_obj;

/**************************************************************************/

int ArcMenu::menu(void)
{
    long crc;
    int i, index;
    class Menus Menu_obj;
    char str[31];

    index = 1;
    cvar.uses_blanks = TRUE;
    cvar.items = 14;
    cvar.width = 60;
    cvar.left = 10;
    cvar.top = 6;
    cvar.position = 2;
    cvar.high_num = 15;
    Config_obj.open_config(ARCHIVE_RECORD);
    do
    {
	Menu_obj.set_help(ARCHIVES_HELP);
	Menu_obj.help("Dated archives configuration; F3 Copy");
	if(index > Config_obj.num_archives)
	{
	    index = 1;
	}
	if(index < 1)
	{
	    index = Config_obj.num_archives;
	}
	Config_obj.read_record(ARCHIVE_RECORD, index);
	sprintf(str, "Archives - Record %d/%d", index, Config_obj.num_archives);
	if(Config_obj.archivesvar.deleted)
	{
	    strcat(str, " [Deleted]");
	}
	cvar.title = str;
	cvar.options = options();
	i = Menu_obj.dialog(&cvar, ENTER, 1);
	switch(i)
	{
	    case LEFT: index--;
		       break;
	    case RIGHT: index++;
			break;
	    case ENTER: cvar.position = 2;
			break;
	    case HOME: index = 1;
		       break;
	    case END: index = Config_obj.num_archives;
		      break;
	    case DEL: Utility2_obj.toggle(&Config_obj.archivesvar.deleted);
		      Config_obj.update_record(ARCHIVE_RECORD, index);
		      break;
	    case INS: Config_obj.add_record(ARCHIVE_RECORD, ADD_NEW_RECORD);
		      index = Config_obj.num_archives;
		      break;
	    case F1   : Menus_obj.online_help(ARCHIVES);
			break;
	    case F3: Config_obj.add_record(ARCHIVE_RECORD, COPY_CUR_RECORD);
		     index = Config_obj.num_archives;
		     break;
	    case ESC: Config_obj.close_config(ARCHIVE_RECORD);
		      return(i);
	}
	if(i == ENTER)
	{
	    crc = Crc_obj.struct_crc((char *) &Config_obj.archivesvar, sizeof(Config_obj.archivesvar));
	    strcpy(str, "Dated archives options");
	    cvar.title = str;
	    do
	    {
		Menu_obj.set_help(ARCHIVES_HELP);
		cvar.options = options();
		i = Menu_obj.display_menu(&cvar, 1);
		switch(i)
		{
		    case ENTER: action(cvar.position);
				break;
		    case F1   : Menus_obj.online_help(ARCHIVES);
				break;
		}
	    }while(i != ESC);
	    if(crc != Crc_obj.struct_crc((char *) &Config_obj.archivesvar, sizeof(Config_obj.archivesvar))  &&  Menu_obj.prompt(0))
	    {
		Config_obj.update_record(ARCHIVE_RECORD, index);
	    }
	    i = ENTER; // Restore the 'ENTER' value so we don't fall out of the loop early
	}
    }while(i != ESC);
    Config_obj.close_config(ARCHIVE_RECORD);
    return(i);
}

char *ArcMenu::options(void)
{
    char tmpstr[13];

    strcpy(optionsstr, "  ;");

    strcat(optionsstr, "Type          : ");
    switch(Config_obj.archivesvar.type)
    {
	case ARC_DATED      : strcat(optionsstr, "Normal;");
			      break;
	case ARC_JULIAN_REN : strcat(optionsstr, "Julian - Rename;");
			      break;
	case ARC_JULIAN_COMP: strcat(optionsstr, "Julian - Compress;");
			      break;
	case ARC_BYTES      : strcat(optionsstr, "Size;");
			      break;
	default: strcat(optionsstr, "Normal;");
		 Config_obj.archivesvar.type = ARC_DATED;
    }


    strcat(optionsstr, "Filename      : ");
    strcat(optionsstr, Config_obj.archivesvar.name);
    strcat(optionsstr, ";");

    strcat(optionsstr, "Path          : ");
    if(Config_obj.archivesvar.type == ARC_BYTES)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Config_obj.archivesvar.path);
	strcat(optionsstr, ";");
    }

    strcat(optionsstr, "First letters : ");
    if(Config_obj.archivesvar.type == ARC_BYTES)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Config_obj.archivesvar.ltrs);
	strcat(optionsstr, ";");
    }

    strcat(optionsstr, "Format        : ");
    if(Config_obj.archivesvar.type == ARC_BYTES)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Utility2_obj.arctype_str(Config_obj.archivesvar.arctype));
	strcat(optionsstr, ";");
    }

    strcat(optionsstr, "Date format   : ");
    if(Config_obj.archivesvar.type == ARC_JULIAN_REN ||
       Config_obj.archivesvar.type == ARC_BYTES)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Utility2_obj.datetype_str(Config_obj.archivesvar.date_format));
    }

    strcat(optionsstr, "Erase logfile : ");
    if(Config_obj.archivesvar.type == ARC_JULIAN_REN ||
       Config_obj.archivesvar.type == ARC_BYTES)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Utility2_obj.YN(Config_obj.archivesvar.erase));
    }

    strcat(optionsstr, "Monthly       : ");
    if(Config_obj.archivesvar.type == ARC_BYTES)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Utility2_obj.YN(Config_obj.archivesvar.monthly_arc));
    }

    strcat(optionsstr, " Erase Daily : ");
    if(Config_obj.archivesvar.type == ARC_BYTES)
    {
	strcat(optionsstr, "n/a;");
    }
    else
    {
	strcat(optionsstr, Utility2_obj.YN(Config_obj.archivesvar.erase_daily));
    }

    strcat(optionsstr, "Day           : ");
    switch(Config_obj.archivesvar.day)
    {
	case 0: strcat(optionsstr, "Sunday;");
		break;
	case 1: strcat(optionsstr, "Monday;");
		break;
	case 2: strcat(optionsstr, "Tuesday;");
		break;
	case 3: strcat(optionsstr, "Wednesday;");
		break;
	case 4: strcat(optionsstr, "Thursday;");
		break;
	case 5: strcat(optionsstr, "Friday;");
		break;
	case 6: strcat(optionsstr, "Saturday;");
		break;
	case 7: strcat(optionsstr, "Everyday;");
		break;
	default: strcat(optionsstr, "Everyday;");
		 Config_obj.archivesvar.day = 7;
		 break;
    }

    strcat(optionsstr, "Max Size (k)  : ");
    if(Config_obj.archivesvar.type == ARC_BYTES)
    {
	sprintf(tmpstr, "%d;", Config_obj.archivesvar.max_size);
	strcat(optionsstr, tmpstr);
    }
    else
    {
	strcat(optionsstr, "n/a;");
    }

    strcat(optionsstr, "Enabled       : ");
    strcat(optionsstr, Utility2_obj.YN(Config_obj.archivesvar.enabled));

    strcat(optionsstr, "  ;");
    return(optionsstr);
}

void ArcMenu::action(int position)
{
    char *tmpbuf, tmpstr[13];
    int offset;

    offset = 18;
    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    switch(position)
    {
	case 2: Menus_obj.get_archivestype(&Config_obj.archivesvar.type);
		break;
	case 3: Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.archivesvar.name, Menus_obj.getfield(Config_obj.archivesvar.name, cvar.left + offset, cvar.top + 3, 40));
		break;
	case 4: if(Config_obj.archivesvar.type == ARC_BYTES) break;
		Menus_obj.set_validtype(PATH);
		strcpy(Config_obj.archivesvar.path, Menus_obj.getfield(Config_obj.archivesvar.path, cvar.left + offset, cvar.top + 4, 40));
		break;
	case 5: if(Config_obj.archivesvar.type == ARC_BYTES) break;
		Menus_obj.set_validtype(FILENM);
		strcpy(Config_obj.archivesvar.ltrs, Menus_obj.getfield(Config_obj.archivesvar.ltrs, cvar.left + offset, cvar.top + 5, 2));
		break;
	case 6: if(Config_obj.archivesvar.type == ARC_BYTES) break;
		Menus_obj.arctype_toggle(&Config_obj.archivesvar.arctype);
		break;
	case 7: if(Config_obj.archivesvar.type != ARC_JULIAN_REN &&
		   Config_obj.archivesvar.type != ARC_BYTES)
		{
		    Menus_obj.get_datetype(&Config_obj.archivesvar.date_format);
		}
		break;
	case 8: if(Config_obj.archivesvar.type != ARC_JULIAN_REN &&
		   Config_obj.archivesvar.type != ARC_BYTES)
		{
		    Utility2_obj.toggle(&Config_obj.archivesvar.erase);
		}
		break;
	case 9: if(Config_obj.archivesvar.type == ARC_BYTES) break;
		Utility2_obj.toggle(&Config_obj.archivesvar.monthly_arc);
		break;
	case 10: if(Config_obj.archivesvar.type == ARC_BYTES) break;
		 Utility2_obj.toggle(&Config_obj.archivesvar.erase_daily);
		 break;
	case 11: Menus_obj.get_archivesweekday(&Config_obj.archivesvar.day);
		 break;
	case 12: if(Config_obj.archivesvar.type == ARC_BYTES)
		 {
		     Menus_obj.set_validtype(RANGE_3);
		     sprintf(tmpstr, "%d", Config_obj.archivesvar.max_size);
		     strcpy(tmpstr, Menus_obj.getfield(tmpstr, cvar.left + offset, cvar.top + 12, 5));
		     Config_obj.archivesvar.max_size = atoi(tmpstr);
		 }
		 break;
	case 13: Utility2_obj.toggle(&Config_obj.archivesvar.enabled);
		 break;
    }
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
}

/**********************************************************************/
/* EOF - ARCMENU.CPP */

