// Functions to create dated archives, Y2K
// Created 29 February 1996
// Revised 21 May 1998

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <share.h>
#include <string.h>
#include <time.h>
#include "config.h"
#include "archives.h"
#include "screen.h"

// external objects
extern class Config Config_obj;
extern class Screen Screen_obj;

/**************************************************************************/

// Constructor for the Archives class
Archives::Archives(void)
{
}

// Destructor for the Archives class
Archives::~Archives(void)
{
}

void Archives::archives(void)
{
    struct screeninfo s;
    char dailyfn[129], monthlyfn[129], fn[129], newname[129], *ptr, *ptr2;
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    int x, index;
    long y;
    FILE *infile, *outfile;
    char str[129];

    strcpy(s.curoption, "Processing 'Archives' records");

    sprintf(LOGSTR, "[ARCHIVES] Processing dated archive records");
    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
    Config_obj.open_config(ARCHIVE_RECORD);
    Config_obj.close_config(ARCHIVE_RECORD);

    for(index = 1; index <= Config_obj.num_archives; index++)
    {
	Config_obj.open_config(ARCHIVE_RECORD);
	if(!Config_obj.read_record(ARCHIVE_RECORD, index))
	{
	    sprintf(LOGSTR, "! [ARCHIVES] Unable to read record #%d", index);
	    Utility_obj.logentry(LOGSTR, LOG_MINIMAL);
	    Config_obj.close_config(ARCHIVE_RECORD);
	    continue;
	}
	Config_obj.close_config(ARCHIVE_RECORD);

	/* If this isn't the day defined, outta here */
	if((Today.getDayOfWeek() - 1 != Config_obj.archivesvar.day  &&
	   Config_obj.archivesvar.day != EVERYDAY) || !Config_obj.archivesvar.enabled)
	{
	    continue;
	}

	sprintf(s.curarea, "Record #%d - '%s'", index, Config_obj.archivesvar.name);
	Screen_obj.display(&s);
	sprintf(LOGSTR, "Processing archive entry #%d - '%s'", index, Config_obj.archivesvar.name);
	Utility_obj.logentry(LOGSTR, LOG_NORMAL);
	switch(Config_obj.archivesvar.type)
	{
	    case ARC_JULIAN_COMP:
	    case ARC_DATED: if(Config_obj.archivesvar.type == ARC_JULIAN_COMP)
			    {
				sprintf(newname, "-%03d", Today.getDayOfYear());
			    }
			    else
			    {
				strcpy(str, Today.getDateStr(Config_obj.archivesvar.date_format));
				newname[0] = str[0];
				newname[1] = str[1];
				newname[2] = str[3];
				newname[3] = str[4];
				newname[4] = str[6];
				newname[5] = str[7];
				newname[6] = NULL;
				if(!Config_obj.archivesvar.ltrs[0])
				{
				    ptr = newname;
				    ptr2 = fn;
				    *ptr2 = *ptr;
				    ptr++;
				    ptr2++;
                                    *ptr2 = *ptr;
                                    ptr2++;
                                    ptr++;
				    *ptr2 = '-';
				    ptr2++;
                                    *ptr2 = *ptr;
                                    ptr++;
				    ptr2++;
                                    *ptr2 = *ptr;
                                    ptr++;
                                    ptr2++;
                                    *ptr2 = '-';
                                    ptr2++;
                                    *ptr2 = *ptr;
                                    ptr++;
                                    ptr2++;
                                    *ptr2 = *ptr;
                                    ptr2++;
                                    *ptr2 = NULL;
                                    strcpy(newname, fn);
                                }
                            }
                            sprintf(dailyfn, "%s%s%s", Config_obj.archivesvar.path, Config_obj.archivesvar.ltrs,
				    Utility_obj.arcext(newname, Config_obj.archivesvar.arctype));
			    date_name(dailyfn);
			    if(Config_obj.archivesvar.name[0] != '@')
			    {
				x = Execute_obj.compress(dailyfn,
                                    Config_obj.archivesvar.name, Config_obj.archivesvar.arctype);
                                if(x == 0 && Config_obj.archivesvar.erase)
				{
                                    Utility_obj.remove_all(Config_obj.archivesvar.name);
                                }
                            }
                            else
                            {
                                 x = Execute_obj.compress_list(dailyfn,
                                     Config_obj.archivesvar.name, Config_obj.archivesvar.arctype);
                                 if( x == 0 && Config_obj.archivesvar.erase)
                                 {
                                     infile = _fsopen(&Config_obj.archivesvar.name[1], "rt", SH_DENYWR);
                                     if(infile)
                                     {
                                         fgets(str, sizeof(str)-2, infile);
                                         while(!feof(infile))
                                         {
                                             Amustr_obj.strip_n(str);
					     Utility_obj.remove_all(str);
					     fgets(str, sizeof(str)-2, infile);
					 }
                                         fclose(infile);
                                     }
				 }
                            }
                            if(x == 0 && Config_obj.archivesvar.monthly_arc)
                            {
				sprintf(newname, "-%02d%02d", Today.getMonth(), Today.getYear() % 100);
                                sprintf(monthlyfn, "%s%s%s", Config_obj.archivesvar.path, Config_obj.archivesvar.ltrs,
					Utility_obj.arcext(newname, Config_obj.archivesvar.arctype));
				x = Execute_obj.compress(monthlyfn, dailyfn, Config_obj.archivesvar.arctype);
				if(x == 0 && Config_obj.archivesvar.erase_daily)
				{
				    Utility_obj.remove_all(dailyfn);
				}
			    }
			    break;

	    case ARC_JULIAN_REN :if(Config_obj.archivesvar.name[0] != '@')
				 {
				     _splitpath(Config_obj.archivesvar.name, drive, dir, fname, ext);
				     sprintf(dailyfn, "%s%s.%03d", Config_obj.archivesvar.path, fname, Today.getDayOfYear());
				     Utility_obj.copyfile(Config_obj.archivesvar.name, dailyfn);
				     Utility_obj.remove_all(Config_obj.archivesvar.name);
				     if(Config_obj.archivesvar.monthly_arc)
				     {
					 sprintf(newname, "%s%s-%02d%02d", Config_obj.archivesvar.path,
						 Config_obj.archivesvar.ltrs, Today.getMonth(), Today.getYear() % 100);
                                         sprintf(monthlyfn, "%s", Utility_obj.arcext(newname, Config_obj.archivesvar.arctype));
                                         x = Execute_obj.compress(monthlyfn, dailyfn, Config_obj.archivesvar.arctype);
                                         if(x == 0 && Config_obj.archivesvar.erase_daily)
                                         {
                                             Utility_obj.remove_all(dailyfn);
                                         }
                                     }
                                 }
                                 else
                                 {
                                     infile = _fsopen(&Config_obj.archivesvar.name[1], "rt", SH_DENYWR);
                                     outfile = _fsopen("AMUTGT.TXT", "a+t", SH_DENYNO);
                                     if(infile && outfile)
                                     {
                                         fgets(str, sizeof(str)-2, infile);
					 while(!feof(infile))
					 {
                                             Amustr_obj.strip_n(str);
                                             _splitpath(str, drive, dir, fname, ext);
					     sprintf(fn, "%s%s%s.%03d", drive, dir, fname, Today.getDayOfYear());
					     fprintf(outfile, "%s\n", fn);
					     Utility_obj.copyfile(str, fn);
					     Utility_obj.remove_all(str);
					     fgets(str, sizeof(str)-2, infile);
					 }
					 fclose(infile);
					 fclose(outfile);
					 if(Config_obj.archivesvar.monthly_arc)
					 {
					     sprintf(newname, "%s%s-%03d", Config_obj.archivesvar.path,
						     Config_obj.archivesvar.ltrs, Today.getDayOfYear());
					     sprintf(monthlyfn, "%s", Utility_obj.arcext(newname, Config_obj.archivesvar.arctype));
					     x = Execute_obj.compress_list(monthlyfn, dailyfn, Config_obj.archivesvar.arctype);
					     if(x == 0 && Config_obj.archivesvar.erase)
					     {
						 infile = _fsopen("AMUTXT.TXT", "rt", SH_DENYNO);
						 if(infile)
						 {
						     fgets(str, sizeof(str)-2, infile);
                                                     while(!feof(infile))
                                                     {
							 Amustr_obj.strip_n(str);
                                                         Utility_obj.remove_all(str);
                                                         fgets(str, sizeof(str)-2, infile);
                                                     }
                                                     fclose(infile);
                                                 }
                                             }
                                         }
                                         remove("AMUTGT.TXT");
                                     }
                                 }
				 break;

            case ARC_BYTES: infile = _fsopen(Config_obj.archivesvar.name, "rt", SH_DENYWR);
                            if(infile)
                            {
                                y = filelength(fileno(infile)) - Config_obj.archivesvar.max_size * 1024;
                                if(y <= 0)
				{
				    fclose(infile);
                                }
                                else
				{
                                    outfile = _fsopen("AMUTGT.TXT", "a+t", SH_DENYNO);
                                    fseek(infile, y, SEEK_SET);
				    fgets(str, sizeof(str)-2, infile);
                                    fgets(str, sizeof(str)-2, infile);
                                    while(!feof(infile))
                                    {
                                        fprintf(outfile, "%s", str);
                                        fgets(str, sizeof(str)-2, infile);
                                    }
                                    fclose(outfile);
				    fclose(infile);
				    Utility_obj.copyfile("AMUTGT.TXT", Config_obj.archivesvar.name);
                                    remove("AMUTGT.TXT");
				}

				Config_obj.open_config(LOGFILE_RECORD);
				for(x = 0; x < Config_obj.num_logs; x++)
				{
				    Config_obj.read_record(LOGFILE_RECORD, x);
				    if(strcmp(Config_obj.logsvar.name, Config_obj.archivesvar.name) == 0)
				    {
					infile = fopen(Config_obj.logsvar.name, "rt");
					if(infile)
					{
					    while(fgets(str, sizeof(str), infile))
					    {
						if(str[0] != '\n')
						{
						    Amustr_obj.trimlead(str);
						    Amustr_obj.strip_n(str);
						    Config_obj.logsvar.crc = Crc_obj.crc32(str);
						    Config_obj.logsvar.offset = filelength(fileno(infile));
						    Config_obj.update_record(LOGFILE_RECORD, x);
						    break;
						}
					    }
					    fclose(infile);
					}
					break;
				    }
				}
				Config_obj.close_config(LOGFILE_RECORD);
			    }
			    break;
	}
    }
    Config_obj.close_config(ARCHIVE_RECORD);
}

/* Take 'fn' and convert it to a .ZI0 type extension if necessary */
void Archives::date_name(char *fn)
{
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
    char tmpext[_MAX_EXT];
    int x;

    if(access(fn, 0) == 0)
    {
	x = 0;
	do
	{
	    _splitpath(fn, drive, dir, fname, ext);
	    ext[3] = NULL;
	    sprintf(tmpext, "%s%d", ext, x);
	    sprintf(fn, "%s%s%s%s", drive, dir, fname, tmpext);
	    x++;
	}while(access(fn, 0) == 0 && x < 10);
    }
}

/*************************************************************************/
/* EOF- ARCHIVES.CPP */
