// Functions designed to handle strings for AMU's purposes, Y2K
// Created 23 November 1996
// Revised 09 January 1998

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "amustr.h"
#include "extern.h"

/* Pad a string (on the right) with spaces to the specified length */
void Amustr::pad(char *str, int length)
{
    if(length <= 0)
    {
	return;
    }

    while(strlen(str) < length)
    {
        strcat(str, " ");
    }
    str[length] = NULL;
}

/* Pad a string (on the left) with spaces to the specified length */
void Amustr::lpad(char *str, int length)
{
    if(length <= 0)
    {
        return;
    }

    strrev(str);
    while(strlen(str) < length)
    {
        strcat(str, " ");
    }
    str[length] = NULL;
    strrev(str);
}

/* Append a backslash to the end of the string */
void Amustr::slash(char *str)
{
    char *ptr;

    ptr = strchr(str, 0);
    if(ptr)
    {
        ptr--;
        if(*ptr != '\\')
        {
            ptr++;
            *ptr = '\\';
	    ptr++;
            *ptr = NULL;
        }
    }
}

/* Strip trailing backslash from the input line */
void Amustr::noslash(char *str)
{
    int i = 0;

    while(str[i])
      i++;
    if(str[i-1]  == '\\')
    {
       str[i-1] = NULL;
    }
}

void Amustr::trimlead(char *instring)
{
    int i;

    strrev(instring);
    i = strlen(instring) - 1;
    while(instring[i] == ' ' || instring[i] == '\t')
    {
        instring[i] = NULL;
        i--;
    }
    strrev(instring);
}

void Amustr::trimend(char *instring)
{
    int i;

    i = strlen(instring) - 1;
    while(instring[i] == ' ' || instring[i] == '\t')
    {
	instring[i] = NULL;
	i--;
    }
}

void Amustr::center(char *instring)
{
    int i;

    trimend(instring);
    trimlead(instring);
    i = strlen(instring);
    i = (78 - i) / 2;
    lpad(instring, i + strlen(instring));
    pad(instring, 78);
}

void Amustr::center_str(char *instring, int width)
{
    int i;

    width -= 2;
    trimend(instring);
    trimlead(instring);
    i = strlen(instring);
    i = (width - i) / 2;
    lpad(instring, i + strlen(instring));
    pad(instring, width);
}

void Amustr::center_40(char *instring)
{
    int i;

    trimend(instring);
    trimlead(instring);
    i = strlen(instring);
    i = (38 - i) / 2;
    lpad(instring, i + strlen(instring));
    pad(instring, 38);
}

void Amustr::ctopascal(char *cstring, char *pstring)
{
    char *ptr1, *ptr2;

    ptr1 = cstring;
    ptr2 = pstring;

    while(*ptr1)
    {
        *ptr2 = *ptr1;
	ptr1++;
        ptr2++;
    }
}

void Amustr::pascaltoc(char *cstring, char *pstring, int length)
{
    char *ptr1, *ptr2;
    int i;

    ptr1 = cstring;
    ptr2 = pstring;
    for(i = 0; i < length; i++)
    {
        *ptr1 = *ptr2;
        ptr1++;
        ptr2++;
    }
    *ptr1 = NULL;
}

/* Strip the \n and \r from strings */
void Amustr::strip_n(char *s)
{
    char *ptr;

    ptr = strchr(s, '\n');
    if(ptr)
    {
        *ptr = NULL;
    }
    ptr = strchr(s, '\r');
    if(ptr)
    {
        *ptr = NULL;
    }
}

/************************************************************************/
/* Return a number which has comma separaters */
char *Amustr::format_value(double x)
{
    static char str[25];
    char *ptr, *ptr2, tmpstr[35];
    int i;

    sprintf(tmpstr, "%.0lf", x);

    i = strlen(tmpstr);
    if(i > 3)
    {
	strrev(tmpstr);
	ptr = tmpstr;
	ptr2 = str;
	while(i > 3)
	{
	    *ptr2 = *ptr;
	    ptr++;
	    ptr2++;
	    *ptr2 = *ptr;
	    ptr++;
	    ptr2++;
	    *ptr2 = *ptr;
	    ptr++;
	    ptr2++;
	    *ptr2 = ',';
	    ptr2++;
	    i -= 3;
	}
	*ptr2 = NULL;
	strcat(str, ptr);
	ptr = strchr(str, 0);
	if(ptr)
	{
	    ptr--;
	    if(*ptr == ',')
	    {
		*ptr = NULL;
	    }
	}
	strrev(str);
    }
    else
    {
	sprintf(str, "%.0lf", x);
    }
    return(str);
}

/* Takes a string with a value, possibly formated with commas, and returns
   the number */
long Amustr::pack_value(char *str)
{
    char *ptr1, *ptr2, tmp[22];

    ptr1 = str;
    ptr2 = tmp;
    while(*ptr1)
    {
	if(isdigit(*ptr1))
	{
	    *ptr2 = *ptr1;
	    ptr2++;
	}
	ptr1++;
    }
    *ptr2 = NULL;
    return(atol(tmp));
}

/* Convert all spaces to underscores */
void Amustr::spaces_to_us(char *instring)
{
    char *ptr;

    ptr = instring;
    while(*ptr && ptr)
    {
	if(*ptr == ' ')
	{
	    *ptr = '_';
	}
	ptr++;
    }
}

/* Convert all underscores to spaces */
void Amustr::us_to_spaces(char *instring)
{
    char *ptr;

    ptr = instring;
    while(*ptr && ptr)
    {
	if(*ptr == '_')
	{
	    *ptr = ' ';
	}
	ptr++;
    }
}


/************************************************************************/
/* EOF - AMUSTR.CPP */
