/* AMUCFG.EXE main file           */
/* Created 12 September 1996      */
/* Revised 18 March 1998          */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <alloc.h>
#include <share.h>
#include <mem.h>
#include "amustr.h"
#include "execute.h"
#include "utility.h"
#include "utility2.h"
#include "menus.h"
#include "screen.h"
#include "config.h"
#include "bbsinfo.h"
#include "mainmenu.h"
#include "crc.h"
#include "listbox.h"

extern unsigned int _stklen = 1024 * 16;

/**********************************************************************/
class Utility Utility_obj;
class Utility2 Utility2_obj;
class Screen Screen_obj;
class BBSInfo BBSInfo_obj;
class MainMenu MainMenu_obj;
class Menus Menus_obj;
class Crc Crc_obj;
class Amustr Amustr_obj;
class ListBox ListBox_obj;
class AreasBox AreasBox_obj;
class Config Config_obj;
class Execute Execute_obj;

int read_msgarray(int begin);
int read_filearray(int begin);
void write_hlp(char *param, char *desc);
void export_cfg(void);
void _help(void);
void color(int back, int fore);
void startup(void);
void main_menu(void);
int check_bbsfiles(int force_import);
int check_bbsmsgs(int force_import);
unsigned long get_passwordcrc(void);

/* Global variables */
int use_mono = FALSE;
char curdir[MAX_FILESPEC];
listbox *filelistbox, *msglistbox;

/**********************************************************************/

void main(int argc, char *argv[])
{
    int i;
    unsigned long passwordcrc;
    char tmp[61], str[200];
    struct coordinates cvar;
    char drive[_MAX_DRIVE], dir[_MAX_DIR], fname[_MAX_FNAME], ext[_MAX_EXT];
#if defined (__AMU16__) || defined(__AMU2__)
    struct text_info ti;

    gettextinfo(&ti);
    if(ti.currmode == MONO)
    {
        use_mono = TRUE;
    }
#endif

    _splitpath(argv[0], drive, dir, fname, ext);
    sprintf(curdir, "%s%s", drive, dir);

    filelistbox = msglistbox = NULL;
    window(1, 1, 80, 25);
    clrscr();
    _setcursortype(_NOCURSOR);
    if(!Config_obj.open_config(CFG_RECORD))
    {
        textcolor(LIGHTRED);
        cprintf("%s not found.  Press SPACE to create, any other key to exit. ",
                CONFIG_AMU);
        i = getch();
        if(!isspace(i))
        {
            _setcursortype(_NORMALCURSOR);
            exit(NO_CONFIG);
        }

        textcolor(LIGHTGRAY);
        cprintf("\r\n\r\nCreating %s...", CONFIG_AMU);
        if(!Config_obj.create_config())
        {
            cprintf("Unable to create configuration!\r\n");
            exit(NO_CONFIG);
        }
    }

    if(argc > 1)
    {
        clrscr();
        textcolor(YELLOW);
        cprintf("AMU %s  Automated Maintenance Utility Setup  Help screen (Page 1/1)\n\r", VERSION);
        textcolor(CYAN);
        cprintf("Copyright (C) 1994-1999 David L. Hickey. All rights reserved\r\n\r\n");

        strcpy(tmp, argv[1]);
        strupr(tmp);
        if(strstr(tmp, "RESTORE"))
        {
            cprintf("Restoring default values to external utility configuration..");
            Config_obj.read_main_config();
            Config_obj.init_external();
            Config_obj.save_cfg(SAVE_ALL);
            cprintf("Done\r\n");
            _setcursortype(_NORMALCURSOR);
            return;
        }
/*
        if(strstr(tmp, "EXPORT"))
        {
            cprintf("Exporting configuration to CONFIG.TXT... ");
            Config_obj.read_main_config();
            export_cfg();
            cprintf("Done\r\n");
            _setcursortype(_NORMALCURSOR);
            Config_obj.close_config();
            return;
        }
*/
        if(strstr(tmp, "IMPORTFILES"))
        {
            cprintf("Importing BBS file area configuration... ");
            Config_obj.read_main_config();
            Config_obj.read_bbsfiles();
            Config_obj.close_config(CFG_RECORD);
            _setcursortype(_NORMALCURSOR);
            return;
        }
        if(strstr(tmp, "IMPORTMSGS"))
        {
            cprintf("Importing BBS message area configuration... ");
            Config_obj.read_main_config();
            Config_obj.read_bbsmsgs();
            Config_obj.close_config(CFG_RECORD);
            _setcursortype(_NORMALCURSOR);
            return;
        }
        if(strstr(tmp, "UPGRADE"))
        {
            cprintf("Upgrading configuration... ");
            Config_obj.upgrade_config();
            Config_obj.close_config(CFG_RECORD);
            _setcursortype(_NORMALCURSOR);
            return;
        }

        if(strstr(tmp, "?"))
        {
            _help();
            _setcursortype(_NORMALCURSOR);
            Config_obj.close_config(CFG_RECORD);
            return;
        }
        if(strstr(tmp, "MONO"))
        {
            use_mono = TRUE;
        }
    }

    main_menu();
    Config_obj.read_main_config();

    /* Check the password if one is defined */
    if(Config_obj.amu_cfgvar.passwordcrc != 0)
    {
        passwordcrc = get_passwordcrc();
        if(passwordcrc != Config_obj.amu_cfgvar.passwordcrc)
        {
            clrscr();
            gotoxy(33, 12);
            textcolor(LIGHTRED);
            cprintf("Access Denied");
            textcolor(LIGHTGRAY);
            gotoxy(1, 24);
            return;
        }
    }

    Utility2_obj.get_screen();
    strcpy(str, " ;Reading configuration, please wait...; ;");
    cvar.uses_blanks = FALSE;
    cvar.items = 3;
    cvar.width = 40;
    cvar.left = 20;
    cvar.top = 10;
    cvar.high_num = 0;
    cvar.position = 2;
    cvar.title = NULL;
    cvar.options = str;
    Menus_obj.dialog(&cvar, DEL, 1);

    if(!check_bbsfiles(FALSE))
    {
        read_filearray(1);
    }
    if(!check_bbsmsgs(FALSE))
    {
        read_msgarray(1);
    }
    Utility2_obj.put_screen();
    startup();
    Config_obj.close_config(CFG_RECORD);
}

void startup(void)
{
    MainMenu_obj.menu();
}

/* Help screen */
void _help(void)
{
    clrscr();
    textcolor(YELLOW);
    cprintf("AMU %s  Automated Maintenance Utility - Setup  Help screen (Page 1/1)\n\r", VERSION);
    textcolor(CYAN);
    cprintf("Copyright (C) 1994-1999 David L. Hickey. All rights reserved\r\n\r\n");

    textcolor(LIGHTGRAY);
    write_hlp("UPGRADE     ", "Upgrade the configuration");
    write_hlp("RESTORE     ", "Restore external program defaults");
/*  write_hlp("EXPORT      ", "Export configuration to CONFIG.TXT"); */
    write_hlp("IMPORTFILES ", "Import BBS file area configuration");
    write_hlp("IMPORTMSGS  ", "Import BBS message area configuration");
    write_hlp("MONO        ", "Run in monochrome mode");
}

/* Export configuration to a text file */
void export_cfg(void)
{
    FILE *outfile;

    outfile = fopen("CONFIG.TXT", "w+t");
    fprintf(outfile, "\t               Export of current AMU configuration\n\n\n");


    fprintf(outfile, "\n\nEnd of file - CONFIG.TXT");
    fclose(outfile);
}

void write_hlp(char *param, char *desc)
{
    textcolor(WHITE);
    cprintf("%s", param);
    textcolor(LIGHTGRAY);
    cprintf("%s\r\n", desc);
}

void main_menu(void)
{
    int i;
    char str[81];

    /* Fill the screen initially */
    gotoxy(1, 1);
    for(i = 0; i < 80; i++)
    {
      str[i] = '';
    }
    str[80] = NULL;
    color(BLACK, LIGHTGRAY);
    for(i = 0; i < 25; i++)
    {
        gotoxy(1, i+1);
        cprintf("%s", str);
    }

    color(LIGHTGRAY, BLUE);

    /* Line 1 of the header */
    gotoxy(1,1);
    setmem(str, 80, '');
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    cprintf("%s", str);

    /* Line 2 of the header */
    gotoxy(1,2);
    setmem(str, 80, ' ');
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    cprintf("%s", str);
    gotoxy(3, 2);
    cprintf("AMU Configuration %s   %s", VERSION, __DATE__);

    /* Line 3 of the header */
    gotoxy(1,3);
    setmem(str, 80, ' ');
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    cprintf("%s", str);
    gotoxy(3, 3);
    cprintf("Copyright (C) 1994-1999 David L. Hickey.  All rights reserved. F1 = Help");

    /* Line 4 of the header */
    gotoxy(1,4);
    setmem(str, 80, '');
    str[80] = NULL;
    str[0] = '';
    str[79] = '';
    cprintf("%s", str);

      /* Bottom line */
    gotoxy(1, 24);
    color(BLACK, BLUE);
    setmem(str, 80, '');
    str[80] = NULL;
    cprintf("%s", str);
    Utility2_obj.get_screen();
}

void color(int back, int fore)
{
    if(use_mono)
    {
        back = LIGHTGRAY;
        fore = BLACK;
    }
    textcolor(fore);
    textbackground(back);
}


/***********************************************************************/
/* Read AMU's internal file areas into a linked list */
int read_filearray(int begin)
{
    int x, end;
    listbox listboxitem;
    struct filearea saved_area;

    // Save a copy of whatever data is currently in Config_obj.filearea
    memcpy(&saved_area, &Config_obj.fileareavar, sizeof(saved_area));

    /* If an array already exists, get rid of it */
    if(filelistbox)
    {
        ListBox_obj.destroy_listbox(&filelistbox);
    }

    Config_obj.open_config(FILEAREA_RECORD);
    filelistbox = ListBox_obj.create_listbox();
    if(begin > Config_obj.num_filearea)
    {
        begin = 1;
    }
    end = begin + NUM_AREAS_TO_READ;
    if(end > Config_obj.num_filearea)
    {
        end = Config_obj.num_filearea;
    }
    for(x = begin; x <= end; x++)
    {
        Config_obj.read_record(FILEAREA_RECORD, x);
        strcpy(listboxitem.itemname, Config_obj.fileareavar.areaname);
        listboxitem.itemnum = x;
        ListBox_obj.additem(&listboxitem, &filelistbox);
    }
    Config_obj.close_config(FILEAREA_RECORD);

    // Restore the saved copy
    memcpy(&Config_obj.fileareavar, &saved_area, sizeof(saved_area));
    return(TRUE);
}

/***********************************************************************/
/* Read AMU's internal message areas into a linked list */
int read_msgarray(int begin)
{
    int x, end;
    class ListBox ListBox_obj;
    listbox listboxitem;
    struct msgarea saved_area;

    // Save a copy of whatever data is currently in Config_obj.msgarea
    memcpy(&saved_area, &Config_obj.msgareavar, sizeof(saved_area));

    /* If an array already exists, get rid of it */
    if(msglistbox)
    {
        ListBox_obj.destroy_listbox(&msglistbox);
    }

    Config_obj.open_config(MSGAREA_RECORD);
    msglistbox = ListBox_obj.create_listbox();
    if(begin > Config_obj.num_msgarea)
    {
        begin = 1;
    }
    end = begin + NUM_AREAS_TO_READ;
    if(end > Config_obj.num_msgarea)
    {
        end = Config_obj.num_msgarea;
    }
    for(x = begin; x <= end; x++)
    {
        Config_obj.read_record(MSGAREA_RECORD, x);
        strcpy(listboxitem.itemname, Config_obj.msgareavar.areaname);
        listboxitem.itemnum = x;
        ListBox_obj.additem(&listboxitem, &msglistbox);
    }
    Config_obj.close_config(MSGAREA_RECORD);

    // Restore the saved area
    memcpy(&Config_obj.msgareavar, &saved_area, sizeof(saved_area));
    return(TRUE);
}

/* Check to see if the BBS File area configuration has changed, and
   if it has re-import it.  If force_import is TRUE, re-import regardless */
int check_bbsfiles(int force_import)
{
    if((force_import == FALSE && BBSInfo_obj.bbsfiles_changed()) ||
       (force_import == TRUE))
    {
        if(Menus_obj.prompt(FILECFGCHANGED_PROMPT))
        {
            Menus_obj.help("Reading file area configuration... ");
            Config_obj.read_bbsfiles();
            read_filearray(1);
            return(TRUE);
        }
    }
    return(FALSE);
}

/* Check to see if the BBS Msg area configuration has changed, and
   if it has re-import it.  If force_import is TRUE, re-import regardless */
int check_bbsmsgs(int force_import)
{
    if((force_import == FALSE && BBSInfo_obj.bbsmsgs_changed()) ||
       (force_import == TRUE))
    {
        if(Menus_obj.prompt(MSGCFGCHANGED_PROMPT))
        {
            Menus_obj.help("Reading message area configuration... ");
            Config_obj.read_bbsmsgs();
            read_msgarray(1);
            return(TRUE);
        }
    }
    return(FALSE);
}

/* Get the password crc for an input password */
unsigned long get_passwordcrc(void)
{
    char *tmpbuf, str[40], password[21];
    struct coordinates cvar;

    cvar.uses_blanks = TRUE;
    cvar.items = 3;
    cvar.width = 28;
    cvar.left = 27;
    cvar.top = 11;
    cvar.position = 4;
    cvar.high_num = 0;
    cvar.title = NULL;
    strcpy(str, " ;Password: ; ;");

    tmpbuf = (char *) malloc(4000);
    gettext(1, 1, 80, 25, tmpbuf);
    cvar.options = str;
    Menus_obj.dialog(&cvar, DEL, 1);
    Menus_obj.set_validtype(SPACES_OK);
    password[0] = NULL;
    strcpy(password, Menus_obj.getfield(password, cvar.left + 12, cvar.top + 2, 15));
    puttext(1, 1, 80, 25, tmpbuf);
    free(tmpbuf);
    return(Crc_obj.crc32(password));
}

/************************************************************************/
/* EOF - AMUCFG.CPP */
