#=============================================================
#
#	AMU2.MAK - Makefile for project J:\amusrc\amu2.prj
#		Created on 02/01/99 at 18:50
#
#=============================================================

.AUTODEPEND

.PATH.obj = J:\COMPILED

#=============================================================
#		Translator Definitions
#=============================================================
CC = bcc +AMU2.CFG
TASM = tasm.exe
TLIB = tlib.exe
TLINK = tlink
RC = brcc.exe
RB = rc.exe
LIBPATH = J:\BCOS2\LIB
INCLUDEPATH = J:\BCOS2\INCLUDE


#=============================================================
#		Implicit Rules
#=============================================================
.c.obj:
  $(CC) -c {$< }

.cpp.obj:
  $(CC) -c {$< }

.asm.obj:
  $(TASM) -Mx $*.asm,$*.obj

.rc.res:
  $(RC) -r $*.rc

#=============================================================
#		List Macros
#=============================================================


EXE_DEPENDENCIES =  \
 tgfdb.obj \
 utility2.obj \
 screen.obj \
 bbsinfo.obj \
 crc.obj \
 dates.obj \
 execute.obj \
 utility.obj \
 amustr.obj \
 fileopts.obj \
 fileopt2.obj \
 archives.obj \
 maint.obj \
 logs.obj \
 msgs.obj \
 users.obj \
 sort.obj \
 config.obj \
 switch.obj \
 macros.obj \
 bulletin.obj \
 amu.obj

#=============================================================
#		Explicit Rules
#=============================================================
j:\compiled\amu2.exe: amu2.cfg $(EXE_DEPENDENCIES)
  $(TLINK) /s /Toe /ap /L$(LIBPATH) @&&|
J:\BCOS2\LIB\C02.OBJ+
j:\compiled\tgfdb.obj+
j:\compiled\utility2.obj+
j:\compiled\screen.obj+
j:\compiled\bbsinfo.obj+
j:\compiled\crc.obj+
j:\compiled\dates.obj+
j:\compiled\execute.obj+
j:\compiled\utility.obj+
j:\compiled\amustr.obj+
j:\compiled\fileopts.obj+
j:\compiled\fileopt2.obj+
j:\compiled\archives.obj+
j:\compiled\maint.obj+
j:\compiled\logs.obj+
j:\compiled\msgs.obj+
j:\compiled\users.obj+
j:\compiled\sort.obj+
j:\compiled\config.obj+
j:\compiled\switch.obj+
j:\compiled\macros.obj+
j:\compiled\bulletin.obj+
j:\compiled\amu.obj
j:\compiled\amu2,j:\compiled\amu2
J:\BCOS2\LIB\C2.LIB+
J:\BCOS2\LIB\OS2.LIB

|


#=============================================================
#		Individual File Dependencies
#=============================================================
TGFDB.obj: amu2.cfg TGFDB.CPP 

UTILITY2.obj: amu2.cfg UTILITY2.CPP 

SCREEN.obj: amu2.cfg SCREEN.CPP 

BBSINFO.obj: amu2.cfg BBSINFO.CPP 

CRC.obj: amu2.cfg CRC.CPP 

DATES.obj: amu2.cfg DATES.CPP 

EXECUTE.obj: amu2.cfg EXECUTE.CPP 

UTILITY.obj: amu2.cfg UTILITY.CPP 

AMUSTR.obj: amu2.cfg AMUSTR.CPP 

FILEOPTS.obj: amu2.cfg FILEOPTS.CPP 

FILEOPT2.obj: amu2.cfg FILEOPT2.CPP 

ARCHIVES.obj: amu2.cfg ARCHIVES.CPP 

MAINT.obj: amu2.cfg MAINT.CPP 

LOGS.obj: amu2.cfg LOGS.CPP 

MSGS.obj: amu2.cfg MSGS.CPP 

USERS.obj: amu2.cfg USERS.CPP 

SORT.obj: amu2.cfg SORT.CPP 

CONFIG.obj: amu2.cfg CONFIG.CPP 

SWITCH.obj: amu2.cfg SWITCH.CPP 

MACROS.obj: amu2.cfg MACROS.CPP 

BULLETIN.obj: amu2.cfg BULLETIN.CPP 

AMU.obj: amu2.cfg AMU.CPP 

#=============================================================
#		Compiler Configuration File
#=============================================================
amu2.cfg: amu2.mak
  copy &&|
-R
-L$(LIBPATH)
-I$(INCLUDEPATH)
-nJ:\COMPILED
-P
-H=J:\amusrc\amu2.CSM
-vi-
-d
-y
-v
-K
-w-obs
-wuse
| amu2.cfg


