/*
 *  XASSERT.H - Extended assert macro.
 *  Written 1995-1997 by Andrew Clarke and released to the public domain.
 */

#ifndef __XASSERT_H__
#define __XASSERT_H__

#ifdef __cplusplus
extern "C"
{
#endif

void xsetassert(int set);

#ifdef NDEBUG

#define xassert(x)  ((void) 0)

#else

int pxassertfail(char *expr, char *srce_fn, unsigned long srce_ln);

#define xassert(x)  ((void) ((x) || pxassertfail(#x, __FILE__, __LINE__)))

#endif

#ifdef __cplusplus
};
#endif

#endif
