/*
 std2ext - convert standard FILES.BBS to extended format.
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of the std2ext.

 std2ext is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 std2ext is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with std2ext; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#pragma warn -ofp
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys\stat.h>
#include <dir.h>
#include <time.h>
#include <ctype.h>

#define MAXLINE 513

#define isspec(c) strchr( "+*;.?", (c) )


	int
main( argc, argv )
	 int  argc;
	char *argv[];
{
	FILE *fin, *fout;
	char buf[MAXLINE], path[MAXPATH], s[MAXLINE], tmstr[15],
		 fname[MAXFILE+MAXEXT], *p;
	struct stat info;

	strlwr( *argv );

	/* check for enough command line arguments */
	if( 3 != --argc ){
		fprintf( stderr, "usage: %s <files.bbs> <filepath> <output>", *argv );
		exit( EXIT_FAILURE );
	}

	strlwr( *(argv+2) );

	/* open listing file */
	if( !(fin = fopen( *(argv+1), "r" )) ){
		fprintf( stderr, "%s: couldn't open '%s'", *argv, *(argv+1) );
		exit( EXIT_FAILURE );
	}

	/* create the output file */
	if( !(fout = fopen( *(argv+3), "w")) ){
		fprintf( stderr, "%s: couldn't create '%s'", *argv, *(argv+3) );
		fclose( fin );
		exit( EXIT_FAILURE );
	}

	/* read line by line and process */
	for( ;; ){

		if( !fgets( buf, MAXLINE, fin ) ) break;

		/* just a description, copy it verbatim */
		if( isspace(buf[0]) || isspec(buf[0]) ){
			fputs( buf, fout );
			continue;
		}

		/* check for file name */
		sscanf( buf, "%12s", fname );
		sprintf( path, "%s/%s", *(argv+2),  strlwr(fname) );
		if( -1 == stat(path, &info) ){
			fprintf( stderr, "%s: warning: '%s' not found, skipped.\n",
				*argv, path );
			fputs( buf, fout );
			continue;
		}

		/* we have the statistics, create the output string */
		strftime( tmstr, 9, "%m/%d/%y", localtime( &info.st_ctime ) );
		p = strchr( buf, ' ' );	*p = '\0';
		for( ++p; isspace(*p); ++p ) ;
		sprintf( s, "%-12s %8ld %s %s", buf, info.st_size, tmstr, p );
		fputs( s, fout );
	}

	/* cleanup */
	fclose( fin );
	fclose( fout );
	return 0;
}
