
STD2EXT							User's Manual					STD2EXT
						Last revision date: May 5, 1995


NAME
	std2ext - converts standard FILES.BBS to extended format

SYNOPSIS
	std2ext <files.bbs> <filepath> <outfile>

VERSION
	std2ext version 1.0

DESCRIPTION
	std2ext will process a normal FILES.BBS (consisting only of the
	filename and extension and its description) and convert it into
	the extended format which includes the size and date. It will
	try to preserve the formatting of the descriptions (See: BUGS).

OPTIONS
	files.bbs	full path and name of the FILES.BBS to process

	filepath	directory where the files listed in the FILES.BBS
				are stored. No trailing slashes.

	outfile		name of the file to create


EXAMPLES
	To convert the FILES.BBS in D:\LIST\LIST01 which contains file
	descriptions for the files in E:\FILES\LIB01, and place the result
	in D:\LIST\EXT01, use the command line:

	std2ext d:\list\list01\files.bbs e:\files\lib01 d:\list\ext01\files.bbs

FILES
	std2ext.exe

DIAGNOSTICS
	On error, returns 1. Otherwise returns 0.

ERRORS
	All errors are of the form std2ext: message.

	std2ext: usage ...
		Wrong number of command-line parameters. Must be three.

	std2ext: couldn't open 'file'
		Could not open the requested file (FILES.BBS).

	std2ext: couldn't create 'file'
		Could not create the output file. Check your access and if
		there's a directory with the same name.

	std2ext: warning 'file' not found. Skipped.
		A file from FILES.BBS was not found in the specified directory.
		The line is copied verbatim. If you get tons of those messages,
		chances are, your second parameter is wrong.

IDENTIFICATION
	Author: Branislav L. Slantchev
	Revision Number: 1.0
	Release Date: May 5, 1995
	Copyright (C) 1995 by Branislav L. Slantchev

LIMITS
	Disk space.

BUGS
	Not enough testing. Only a couple of satisfactory runs. As it
	stands now, the routines eat the whitespace in front of all
	descriptions. This shouldn't usually be a problem and avoids
	the ugly non-aligned columns that result otherwise. If you
	don't like this feature, just edit the source code. Sorry, no
	command-line switch to do that.

	ProBoard's extended listing characters are recognized with one
	notable exception: the '!'. The reason for that is simple: there
	are some files floating around whose name starts with a '!'. If
	you accept it, then you might skip those file.

LEGALITIES
	std2ext is Copyright 1995 by Branislav L. Slantchev.

	std2ext (all executables, source and documentation files) are
	copyrighted material of Branislav L. Slantchev.

	This program is free software. You can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation, version 2. This
	software is released under the terms of that license. Please
	read the included file COPYING for the full text.

	You should have received a copy of the GNU General Public License
	along with this program (file COPYING). If not, write to the Free
	Software Foundation, Inc., 675 Mass Ave, Campbridge, MA 02139, USA.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	Branislav L. Slantchev will not be liable for any special, incidental,
	consequential, indirect or similar damages due to loss of data or
	any other reason.

	If you find this program useful, drop me a post card at the mail
	address (see file SUPPORT). I will really appreciate that.


SEE ALSO
	PB-HOWTO.DOC	a nice How-to Guide to using ProBoard
