/*  */
/* Extract SUMmary from DOWNsort's ALLFileList    -    by Rob Hamerling  */
/*  */

parse arg all sum

if sum = '' | all = '' then
  do
    call beep 800, 200
    say ''
    say 'Syntax:  DOWNSUM  <ALLFileList> <summary>'
    say ''
    say '         <ALLFileList> - filespec of inputfile'
    say '         <summary>     - filespec of outputfile'
    say ''
    exit 1
  end

say "Extracting file area summary report from ALLFileList '"all"'"
if stream(all, 'C', 'query exist') = '' then
  do
    say " ALLFileList '"all"' could not be found"
    exit 1
  end
if stream(sum, 'C', 'query exist') <> '' then
  '@erase' sum '>nul'

do while lines(all) > 0              /* copy header */
  l = linein(all)
  if substr(l, 1, 5) = '' | substr(l, 1, 5) = '=====' then
    leave
  rx = lineout(sum, l)
end

do while lines(all) > 0              /* skip to summary */
  l = linein(all)
  if substr(l, 1, 1) = '' then
    leave
end

if lines(all) = 0 then               /* check if summary present */
  do
    say 'No summary found in' all
    exit 99
  end

do while lines(all) > 0              /* rest of file is summary */
  l = linein(all)
  rx = lineout(sum, l)
end

rc = stream(all, 'C', 'close')
rc = stream(sum, 'C', 'close')

exit
