@echo off
REM ACFiles Restore Batch File
REM
REM Restores files from Tape/CD-ROM with ACF_MOVE
REM
REM Parms:
REM
REM %1 - Path\File to restore
REM %2 - Path To Restore Into
REM %3 - Name of File
REM %4 - Path to File (No trailing \)
REM %5 - Drive Letter associated with this move (ex.  C)
REM
REM
REM D:\TAPE is the directory the files were in before being backed up onto
REM tape.
REM
REM Upon detection of this path, you may goto the label TAPE, which will
REM restore files individually or you may use the MASS_TAPE label, which
REM is setup to write a restore.lst, which may be detected in the pre-down
REM batch file for restoring the files all at once.
REM
REM Remember - it is up to you to do whatever you want with the file in
REM this batch file.  As long as you update the NEW.LST with the path
REM and filename of the file after all processing you'll be just fine.
REM
REM Because you write to the new.lst, you may skip the transfer of a file,
REM Convert them to some archive format, etc.  There is a LOT of flexibility
REM here.
REM
REM
REM The following checks first if the file needs to be restored off of tape
REM and then sees if the file is on a CD-ROM and needs to be copied to the
REM hard disk for efficiency.  If neither one, it'll simply go to the end
REM after writing to new.lst
REM

if %4 == Z:\TAPE goto MASS_TAPE

if %5 == Z goto CDROM

goto NORM

echo %1 >NEW.LST

goto end

REM CD-ROM Copy Over
REM This will copy the file from your CD ROM to the temporary restore
REM directory.  This particular one uses %2, which is the path you
REM specified in the ACF_MOVE.CTL.  Please note that it is mainly for
REM compatibility with the old ACF_MOVE.  You may copy it where you want
REM as long as you update new.lst appropriately.

:CDROM

REM Copy file from %1 to %2

echo Moving From CD-ROM

goto GO

:NORM

echo Moving normal file - Why?

:GO

if not exist %2\%3 copy %1 %2

echo %2\%3 >>new.lst

goto END

REM Tape Single Restore
REM This will restore each file one at a time from the Tape Drive
REM using the appropriate tape software.
REM
REM It is recommended, if your tape software allows, to use the
REM MASS_TAPE label, which will write to a restore.lst for
REM pre-down to restore all at once.
REM
REM This example is for the Mountain Tape Backup software.

:TAPE

echo Moving From Tape
echo Need To Restore %1 into %2

c:
cd\mtn_tape
if not exist %1 tape SRS %1

REM This CD\ returns the batch file back to where it was.  You MUST
REM return it to the location where you started ACFiles.  Here, we
REM assume you run from BBS\NODE?.
REM
REM Failure to have this properly done will result in the file NOT
REM being transferred as it will not update the correct new.lst

CD\BBS\NODE%NODE%

echo %1 >>new.lst

goto END

REM Mass Restore 
REM This will write filenames needing restoration to RESTORE.LST.
REM This relies on PRE-DOWN.BAT to be written such that if it
REM detects a RESTORE.LST it will attempt to restore the files
REM using RESTORE.LST.  The PRE-DOWN.BAT in this archive contains
REM such an example..

:MASS_TAPE

if not exist %1 echo %1 >>restore.lst
echo %1 >>new.lst

goto END

:END
