/*                    RemoteAccess 2.00 structures
                    Converted to C by Sterling Moses
                              June 1st 1993

                              SilverSoftware
                             FIDONET (1:301/9)
                               (505)268-8502

                  Updated due to the new release of 2.00.
                              August 20, 1993

		  Modified for personal use Clyde Sisler (1:132/193)
*/
#define byte unsigned char
#define word unsigned int


char *RAEnvr;

//#pragma pack (1)


typedef enum {Yes,No,Ask,Only}			     AskType;
typedef enum {Auto,Short,Long}                       VideoType;
typedef enum {LocalMail,NetMail,EchoMail}            MsgType;
typedef enum {Both,Private,Public,ROnly,NoReply}     MsgKindsType;
typedef enum {Ignore,Create,Kill}                    OrphanType;
typedef byte                                         FlagType[4];

typedef struct {
        byte    l1;
        char    Time[5];
        }TIME;

typedef struct {
        byte    l1;
        char    Date[8];
        }DATE;

typedef struct {
        byte    l1;
        char    LongDate[9];
        }LONGDATE;

typedef byte ByteArray32[32];

typedef struct{
        word    Zone;
        word    Net;
        word    Node;
        word    Point;
        }NETADDRESS;

typedef struct{                         /*  LIMITS.RA  */
        word    Security;
        word    Ltime;
        word    L300;
        word    L1200;
        word    L2400;
        word    L4800;
        word    L7200;
        word    L9600;
        word    L12000;
        word    L14400;
        word    L16800;
        word    L19200;
        word    L38400;
        word    Llocal;
        word    RatioNum;
        word    RatioK;
        int     PerMinCost[3];
        byte    FreeSpace[42];
        }LIMITS;


typedef struct{                                 /* LANGUAGE.RA */
        byte    l1;
        char    Name[20];
        byte    Attribute;
        byte    l2;
        char    DefName[60];
        byte    l3;
        char    MenuPath[60];
        byte    l4;
        char    TextPath[60];
        byte    l5;
        char    QuesPath[60];
        word    Security;
        FlagType Flags;
        FlagType NotFlagsMask;
        byte    FreeSpace[190];
        }LANGUAGE;

typedef struct {                        /*  MSGINFO.BBS  */
        word    lowmsg;
        word    highmsg;
        word    totalmsgs;
        word    totalonboard[200];
        }MSGINFO;

typedef struct {
        int     msgnum;
        byte    board;
        }MSGIDX;

typedef struct {
        byte    l1;
        char    string[35];
        }MSGTOIDX;

typedef struct {
        int     msgnum;
        word    prevreply;
        word    nextreply;
        word    timesread;
        word    startblock;
        word    numblocks;
        word    destnet;
        word    destnode;
        word    orignet;
        word    orignode;
        byte    destzone;
        byte    origzone;
        word    cost;
        byte    msgattr;
        byte    netattr;
        byte    board;
        TIME    posttime;
        DATE    postdate;
        MSGTOIDX         whoto;
        MSGTOIDX         whofrom;
        byte    l1;
        char    subject[72];
        }MSGHDR;

typedef struct {
        byte    l1;
        char    text[255];
        }MSGTXT;

typedef struct {
        MSGTOIDX        name;
        MSGTOIDX        handle;
        byte    line;
        word    baud;
        byte    l1;
        char    city[25];
        byte    status;
        byte    attribute;
        byte    l2;
        char    statdesc[10];
        byte    freespace[98];
        word    nocalls;
        }USERON;

/*
Status byte - 0 : Browsing (in a menu)
              1 : Uploading/downloading
              2 : Reading/posting messages
              3 : In a door/external utility
              4 : Chatting with sysop
              5 : Answering questionnaire
              6 : RTC
              7 : New user logon
            255 : User-defined - display StatDesc

Attribute   - Bit 0 : Hidden
                  1 : Wants chat
                  2 : Reserved for RANETMGR
                  3 : Do not disturb flag
                  6 : Ready (0=busy) }
*/

typedef struct {
        byte          line;
        MSGTOIDX      name;
        MSGTOIDX      Handle;
        byte          l1;
        char          city[25];
        word          baud;
        long int      times;
        TIME          logon;
        TIME          logoff;
        byte          attribute;    /* BIT 0 : Hidden */
        }LASTCALL;

FILE *FILES_HDR;				 // FDBxxxxx.HDR

typedef struct {
	byte		NameSize;
	char		Name[12];
        long int        size;
        long int        CRC32;
        byte            l2;
        char            uploader[35];
        long int        uploaddate;
        long int        filedate;
        long int        lastdl;
        word            timesdl;
	byte		Attrib1;
        byte            l3;
        char            password[15];
        struct {
                byte l1;
                char desc[15];
                }keyword[5];
        word            cost;
        long int        longdescptr;
        byte            freespace[20];
        }FILESHDR;

/*
Attrib - Bit 0 : Deleted
             1 : Unlisted
             2 : Free (don't adjust ratio) - Does NOT affect "Cost"
             3 : Not available (don't allow downloads)
             4 : Locked (no kill)
             5 : Missing/offline
             6 : No time restrictions - always allow DL
*/

typedef struct {
        byte l1;
        char string[12];
        long int uploaddate;
        long int keywordcrc[5];
        long int longdescptr;
        }FILESIDX;


typedef word LASTREAD[200];

typedef struct {
        long int namecrc32;
        long int handlecrc32;
        }USERSIDX;


typedef word COMBINED[200];

typedef struct {
        MSGTOIDX        name;
        byte            l1;
        char            location[25];
        byte            l2;
        char            organization[50];
        byte            l3;
        char            address1[50];
        byte            l4;
        char            address2[50];
        byte            l5;
        char            address3[50];
        byte            l6;
        char            handle[35];
        byte            l7;
        char            comment[80];
        long int        passwordcrc;
        byte            l8;
        char            dataphone[15];
        byte            l9;
        char            voicephone[15];
        TIME            lasttime;
        DATE            lastdate;
        byte            attribute;
/*
                      { Bit 0 : Deleted
                            1 : Clear screen
                            2 : More prompt
                            3 : ANSI
                            4 : No-kill
                            5 : Xfer priority
                            6 : Full screen msg editor
                            7 : Quiet mode }
*/
        byte            Attribute2;
/*
                      { Bit 0 : Hot-keys
                            1 : AVT/0
                            2 : Full screen message viewer
                            3 : Hidden from userlist
                            4 : Page priority
                            5 : No echomail in mailbox scan
                            6 : Guest account
                            7 : Post bill enabled }
*/
        FlagType        flags;
        long int        credit;
        long int        pending;
        word            msgsposted;
        word            security;
        long int        lastread;
        long int        nocalls;
        long int        uploads;
        long int        downloads;
        long int        uploadsk;
        long int        downloadsk;
        long int        todayk;
        int             elapsed;
        word            screenlength;
        byte            lastpwdchange;
        word            group;
        COMBINED        combinedinfo;
        DATE            firstdate;
        DATE            birthdate;
        DATE            subdate;
        byte            screenwidth;
        byte            language;
        byte            dateformat;
        byte            l10;
        char            forwardto[35];
        word            msgarea;
        word            filearea;
        char            defualtprot;
        word            filegroup;
        byte            lastdobcheck;
        byte            sex;
        long int        XIrecord;
        word            msggroup;
        byte            freespace[48];
        }USERS;

typedef struct {
        byte            freespace[200];
        }USERSXI;

typedef struct {
        long int        totalcalls;
        MSGTOIDX        lastcaller;
        byte            extraspace[128];
        }SYSINFO;

typedef struct {
        DATE            startdate;
        word            busyperhour[24];
        word            busyperday[7];
        }TIMELOG;

typedef struct {
        byte            typ;
        word            security;
        word            maxsec;
        FlagType        notflagsmask;
        FlagType        flags;
        word            timeleft;
        word            timeused;
        byte            age;
        byte            termattrib; /* BIT 0 : ANSI | BIT 1 : AVT */
        long int        minspeed;
        long int        maxspeed;
        long int        credit;
        long int        optioncost;
        long int        permincost;
        ByteArray32     node;
        ByteArray32     group;
        word            starttime[7];
        word            stoptime[7];
        byte            l1;
        char            display[135];
        byte            l2;
        char            hotkey[8];
        byte            l3;
        char            miscdata[135];
        byte            foreground;
        byte            background;
        byte            freespace[50];
        }MNU;

typedef struct {
        byte            status; // 0=Deleted 1=Enabled 2=Disabled
        TIME            starttime;
        byte            errorlevel;
        byte            days;
        byte            forced; // 0=False 1=True
        DATE            lastrun;
        }EVENT;

typedef EVENT EVENTARRAY[20];

FILE *MESSAGES_RA;				 // MESSAGES.RA

typedef struct {
        byte            unused[4];
	byte		NameSize;
	char		Name[40];
        MsgType         typ;
        MsgKindsType    msgkinds;                 // Attributes
        byte            attribute;
        // Bit 0 : Enable EchoInfo
        //     1 : Combined access
        //     2 : File attaches
        //     3 : Allow aliases
        //     4 : Use SoftCRs as characters
        //     5 : Force handle
        //     6 : Allow deletes
        //     7 : Is a JAM area
        byte            dayskill; // { Kill older thax 'X' days }
        byte            recvkill; // { Kill recv msgs for more than 'x' days }
        word            countkill;
        word            readsecurity;
        FlagType        readflags;
        FlagType        readnotflags;
        word            writesec;
        FlagType        writeflags;
        FlagType        writenotflags;
        word            sysopsec;
        FlagType        sysopflags;
        FlagType        sysopnotflags;
        byte            l2;
        char            originline[60];
        byte            akaaddress;
        byte            age;
        byte            l3;
	char		jambase[58];
//	char		jambase[60];
	word		Group;
	word		AltGroup[3];
        byte            attribute2;  // BIT 0 : Include all groups
        byte            freespace2[9];
        }MESSAGE;

FILE *FGROUP_RA;				 // FGROUPS.RA
FILE *MGROUP_RA;				 // MGROUPS.RA

typedef struct {
	word		AreaNum;
	byte		NameSize;
	char		Name[40];
	word		Security;
	FlagType	Flags;
	FlagType	NotFlags;
	byte		FreeSpace[100];
	}GROUP;

FILE *FILES_RA;					 // FILES.RA

typedef struct {
        byte            unused[4];
	byte		NameSize;
	char		Name[40];
	byte		Attrib1;

/*                          0 : Include in new files scan
                            1 : Include in upload dupe scan
                            2 : Permit long descriptions
                            3 : Area is on CD-ROM
                            4 : All files are FREE
                            5 : Allow DLs not in FDB
                            6 : Allow users to password uploads
                            7 : Scan uploads }
*/
	byte		FilePathSize;
	char		FilePath[40];
	word		KillsDaysDL;
	word		KillsDaysFD;
	byte		PasswordSize;
	char		Password[15];
	word		MoveArea;
	byte		Age;
	byte		ConvertExt;
	word		Group;
	byte		Attrib2;    // BIT 0 : Include in all groups
	word		DefCost;
	word		UploadArea;
	word		UploadSecurity;
	FlagType	UploadFlags;
	FlagType	UploadNotFlags;
	word		DownloadSecurity;
	FlagType	DownloadFlags;
	FlagType	DownloadNotflags;
	word		ListSecurity;
	FlagType	ListFlags;
	FlagType	ListNotFlags;
	word		AltGroup[3];
	byte		Device;
	byte		FreeSpace[13];
        }FILES;

typedef struct {
        byte            l1;
        char            name[8];
        byte            l2;
        char            parent[8];
        byte            l3;
        char            desc[70];
        byte            attrib;
/*                      Bit 0 : Private
                            1 : Unlisted
                            2 : Global
                            3 : Permanent
                            4 : Use handles
*/
        byte            l4;
        char            moderator[35];
        byte            l5;
        char            language[20];
        byte            l6;
        char            password[15];
        word            security;
        FlagType        flags;
        byte            numnodes;
        byte            active[250];
        byte            child[250];
        FlagType        notflagsmask;
        byte            freespace[96];
        }CONF;

typedef struct {
          byte          comport;
          byte          inittries;
          word         buffersize;
          word          modemdelay;
          long int      maxspeed;
          byte          sendbreak;
          byte          lockmodem;
          byte          answerphone;
          byte          offhook;
          byte          l1;
          char          initStr[70];
          byte          l2;
          char          initStr2[70];
          byte          l3;
          char          busyStr[70];
          byte          l4;
          char          initResp[40];
          byte          l5;
          char          busyResp[40];
          byte          l6;
          char          connect300[40];
          byte          l7;
          char          connect1200[40];
          byte       l8;
          char          connect2400[40];
          byte          l9;
          char          connect4800[40];
          byte          l10;
          char          connect7200[40];
          byte          l11;
          char          connect9600[40];
          byte          l12;
          char          connect12k[40];
          byte          l13;
          char          connect14k[40];
          byte          l14;
          char          connect16k[40];
          byte          l15;
          char          connect19k[40];
          byte          l16;
          char          connect38k[40];
          byte          l17;
          char          connectFax[40];
          byte          l18;
          char          ringStr[20];
          byte          l19;
          char          answerStr[20];
          byte          l20;
          char          errorfreestring[15];
          byte          freespace[300];
          }MODEM;

typedef struct {
        byte            l1;
        char            extension[3];
        byte            l2;
        char            unpackcmd[60];
        byte            l3;
        char            packcmd[60];
        }ARC;

FILE *CONFIG_RA;				 // CONFIG.RA

typedef struct {
        word            versionID;
        byte            xCommPort;
        long int        xBaud;
        byte            xInitTries;
        byte            l1;
        char            xinitStr[70];
        byte            l2;
        char            xbusyStr[70];
        byte            l3;
        char            xInitResp[40];
        byte            l4;
        char            xBusyResp[40];
        byte            l5;
        char            xConnect300[40];
        byte            l6;
        char            xConnect1200[40];
        byte            l7;
        char            xConnect2400[40];
        byte            l8;
        char            xConnect4800[40];
        byte            l9;
        char            xConnect9600[40];
        byte            l10;
        char            xConnect19k[40];
        byte            l11;
        char            xConnect38k[40];
        byte            xAnswerPhone;   // 1=TRUE 0=FALSE
        byte            l12;
        char            xRing[20];
        byte            l13;
        char            xAnswerStr[20];
        byte            xFlushBuffer;
        int             xModemDelay;

        word            minBaud;
        word            graphicsBaud;
        word            TransferBaud;
        TIME            SlowBaudTimeStart;
        TIME            SlowBaudTimeEnd;
        TIME            DownloadTimeStart;
        TIME            DownloadTimeEnd;

        TIME            PageStart[7];
        TIME            PageEnd[7];

        byte            l14;
        char            SeriNum[22];
        byte            l15;
        char            CustNum[22];
        byte            FreeSpace1[24];
        word            PwdExpiry;

        byte            l16;
        char            MenuPath[60];
        byte            l17;
        char            TextPath[60];
        byte            l18;
        char            AttachPath[60];
        byte            l19;
        char            NodelistPath[60];
        byte            l20;
        char            MsgBasePath[60];
        byte            l21;
        char            SysPath[60];
        byte            l22;
        char            ExternalEdCmd[60];

        NETADDRESS      address[10];
        byte            l23;
        char            SystemName[30];

        word            NewSecurity;
        word            NewCredit;
        FlagType        NewFlags;
        byte            l24;
        char            OriginLine[60];
        byte            l25;
        char            QuoteString[15];
        byte            l26;
        char            Sysop[35];
        byte            l27;
        char            LogFileName[60];

        byte            Fastlogon;                    // 0=False 1=True
        byte            AllowSysRem;                  //    "      "
        byte            MonoMode;                     //    "      "
        byte            StrictPwdChecking;            //    "      "
        byte            DirectWrite;                  //    "      "
        byte            SnowCheck;                    //    "      "

        int             CreditFactor;

        word            UserTimeOut;
        word            LogonTime;
        word            PasswordTries;
        word            MaxPage;
        word            PageLength;

        byte            CheckMultiLogon;       // 0=False  1=True
        byte            ExcludeSysop;          //    "        "
        byte            OneWordNames;          //    "        "

        AskType         CheckMail;

        byte            AskVoice;              //    "        "
        byte            AskData;               //    "        "
        byte            FullMailCheck;         //    "        "
        byte            FileShells;            //    "        "
        byte            FixUploadDates;        //    "        "
        byte            FreezeChat;            //    "        "

        AskType         ANSI;
        AskType         ClearScr;
        AskType         MorePrompt;
        byte            UploadMsgs;             //Boolean
        AskType         KillSent;

        word            CrashAskSec;            // Min sec# to ask 'Crash Mail?'
        FlagType        CrashAskFlags;
        word            CrashSec;           // Min sec# to always send crash mail.
        FlagType        CrashFlags;
        word            FAttachSec;             // Min sec# to ask 'File Attach?'
        FlagType        FAttachFlags;
        byte            NormFore;
        byte            NormBack;
        byte            StatFore;
        byte            StatBack;
        byte            HiBack;
        byte            HiFore;
        byte            WindFore;
        byte            WindBack;
        byte            ExitLocal;
        byte            Exit300;
        byte            Exit1200;
        byte            Exit2400;
        byte            Exit4800;
        byte            Exit9600;
        byte            Exit19k;
        byte            Exit38k;

        byte            MultiLine;      //Boolean
        byte            MinPwdLen;
        word            MinUpSpace;
        AskType         HotKeys;
        byte            BorderFore;
        byte            BorderBack;
        byte            BarFore;
        byte            BarBack;
        byte            LogStyle;
        byte            MultiTasker;
        byte            PwdBoard;
        word            xBufferSize;

        struct  {
                byte    l1;
                char string[60];
                }Fkeys[10];

        byte            WhyPage;                //Boolean
        byte            LeaveMsg;
        byte            ShowMissingFiles;       //Boolean
        byte            xLockModem;             //Boolean
        byte            FreeSpace2[10];
        byte            AllowNetMailReplies;    //Boolean
        byte            l28;
        char            LogonPrompt[40];
        AskType         CheckNewFiles;
        byte            l29;
        char            ReplyHeader[60];
        byte            BlankSecs;
        byte            ProtocolAttrib[6];
        byte            l30;
        char            xErrorFreeString[15];
        byte            xDefualtCombined[25];
        word            RenumThreshold;
        char            LeftBracket;
        char            RightBracket;
        byte            AskForHandle;           //Boolean
        byte            AskForBirthdate;        //Boolean

        word            GroupMailSec;

        byte            ConfirmMsgDeletes;      //Boolean

        byte            FreeSpace4[30];

        byte            l31;
        char            TempScanDir[60];
        AskType         ScanNow;
        byte            xUnknownArcAction;          //  Bit 0:Mark Deleted
        byte            xFailedUnpackAction;        //  Bit 1:Mark Unlisted
        byte            FailedScanAction;           //  Bit 2:Mark NotAvail

        word            xUnknownArcArea;
        word            xFailedUnpackArea;
        word            FailedScanArea;

        byte            l32;
        char            ScanCmd[60];
        byte            xDeductIfUnknown;       //Boolean

        byte            NewUserGroup;
        AskType         AVATAR;
        byte            BadPwdArea;
        byte            l33;
        char            Location[40];
        byte            DoAfterAction;  // 0=wait for CR, > 0 = wait for x seconds
        byte            l34;
        char            OldFileLine[40];
        byte            CRfore;
        byte            CRback;
        byte            l35;
        char            LangHdr[40];
        byte            xSendBreak;             //Boolean
        byte            l36;
        char            ListPath[60];
        AskType         FullMsgView;
        AskType         EMSI_Enable;
        byte            EMSI_NewUser;           //Boolean

        byte            l37;
        char            EchoChar[1];
        byte            l38;
        char            xConnect7200[40];
        byte            l39;
        char            xConnect12000[40];
        byte            l40;
        char            xConnect14400[40];
        byte            Exit7200;
        byte            Exit12000;
        byte            Exit14400;
        byte            l41;
        char            ChatCommand[60];
        AskType         ExtEd;
        byte            NewuserLang;
        byte            l42;
        char            LangPrompt[40];
        VideoType       VideoMode;
        byte            AutoDetectAnsi; //Boolean
        byte            xOffHook;                       //Boolean
        byte            NewuserDateFormat;
        byte            l43;
        char            KeyboardPwd[15];
        byte            CapLocation;            //Boolean

        byte            NewuserSub;
        byte            l44;
        char            PrinterName[4];
        byte            HilitePromptFore;
        byte            HilitePromptBack;

        byte            l45;
        char            xInitStr2[70];
        byte            AltJSwap;                       //Boolean
        byte            l46;

	char		SemPath[47];
//	char		SemPath[60];
        byte            AutoChatCapture;        //Boolean

	byte		FDBPathSize;
	char		FDBPath[60];
        byte            NewFileTag;             //Boolean
        byte            IgnoreDupeExt;          //Boolean
        byte            l48;
        char            TempCdFilePath[60];
        byte            TagFore;
        byte            TagBack;

        byte            l49;
        char            xConnect16k[40];
        byte            Exit16k;
        byte            FilePayback;

        byte            l50;
        char            FileLine[200];
        byte            l51;
        char            FileMissingLine[200];

        byte            NewUserULCredit;
        word            NewUserULCreditk;
        ARC             ArcInfo[10];

        struct {
                byte    l1;
                char    string[60];
                }RaMgrAltFKeys[5];

        byte            l52;
        char            ArcViewCmd[60];
        byte            l53;
        char            xConnectFax[40];
        byte            ExitFax;

        byte            UseXMS;         //Boolean
        byte            UseEMS;         //Boolean
        byte            CheckDOB;
        AskType         EchoCheck;
        word            ccSec;
        word            ReturnRecSec;

        byte            HonourNetReq;           //Boolean
        COMBINED        DefaultCombined;
        byte            AskForSex;      //Boolean
        byte            AskForAddress;      //Boolean
        AskType         DLdesc;
        byte            NewPhoneScan;           //Boolean
        byte            FutureExpansion[587];

        }CONFIG;

typedef struct {
        word            Baud;
        SYSINFO         SysInfo;
        TIMELOG         TimeLogInfo;
        USERS           UserInfo;
        EVENT           EventInfo;
        byte            NetMailEntered; //Boolean
        byte            EchoMailEntered;        //Boolean
        TIME            LoginTime;
        DATE            LoginDate;
        word            TimeLimit;
        long int        LoginSec;
        int             UserRecord;
        word            ReadThru;
        word            NumberPages;
        word            DownloadLimit;
        TIME            TimeOfCreation;
        long int        LogonPasswordCRC;
        byte            WantChat;                       //Boolean
        int             DeductedTime;

        struct {
                byte l1;
                char     stack[8];
                }MenuStack[50];

        byte            MenuStackPointer;
        USERSXI         UserXIinfo;
        byte            ErrorFreeConnect;       //Boolean
        byte            SysopNext;              //Boolean

// EMSI SESSION DATA

        byte            EMSI_Session;           //Boolean
        byte            l1;
        char            EMSI_Crtdef[40];
        byte            l2;
        char            EMSI_Protocols[40];
        byte            l3;
        char            EMSI_Capabilities[40];
        byte            l4;
        char            EMSI_Requests[40];
        byte            l5;
        char            EMSI_Software[40];

        byte            Hold_attr1;
        byte            Hold_attr2;
        byte            Hold_Len;

        byte            l6;
        char            PageReason[80];
        byte            StatusLine;

        byte            l7;
        char            LastCostMenu[8];
        word            MenuCostPerMin;
        byte            DoesAVT;       //BOOL
        byte            RIPmode;       //BOOL

        byte            ExtraSpace[86];

        }EXITINFO;

typedef struct {
        byte            l1;
        char            name[15];
        char            ActiveKey;
        byte            OpusTypeCtlFile;        //Boolean
        byte            BatchAvailable; //Boolean
        byte            Attribute;      // 0=Disabled, 1=Enabled, 2=Errorfree

        byte            l2;
        char            LogFileName[80];
        byte            l3;
        char            CtlFileName[80];
        byte            l4;
        char            DnCmdString[80];
        byte            l5;
        char            DnCtlString[80];
        byte            l6;
        char            UpCmdString[80];
        byte            l7;
        char            UpCtlString[80];
        byte            l8;
        char            UpLogKeyword[20];
        byte            l9;
        char            DnLogKeyword[20];
        byte            XferDescWordNum;
        byte            XferNameWordNum;
        }PROTOCOL;

//( * Complete Structure listings for RemoteAccess 2.00 Shareware * )
//#pragma pack ()


