;
;  Example of a ISAAC.CTL file
;
;  L I S T   S E T U P
;
;
;        NEWDAYS [14]
;
;               Just what it says, how old can files maximally
;               be to be listed as a new file (e.g. with a '*'
;               mark) and to be included in the newfiles list.
;
NewDays 14
;
;
;        MINLISTSEC [65535]
;
;               All area's with a list security equal or lower
;               will be listed, even if the download and upload
;               security are higer.
;
;               There is no checking on Group security levels or
;               on flags.
;
;
MinListSec 999
;
;
;        DATENOTATION [2]
;
;               Three different notations of the dates are
;               possible.
;
;               1  MM-DD-YY
;               2  DD-MM-YY
;               3  DD-Mon-YY
;
DateNotation 2
;
;
;        ALLFILESNAME [ALLFILES.LST]
;         NEWFILESNAME [NEWFILES.LST]
;
;               The filenames of the Allfiles and Newfiles list.
;               If no path is specified, the current directory
;               is used. If no name is specified or an invalid
;               name, the list is skipped.
;
AllFilesName INSANITY.ALL
NewFilesName INSANITY.NEW
;
;
;        DONUTSTRING [Donuts Only]
;
;               This is a bit tricky... If you have area's with
;               a list security LOWER than the Minimal List
;               Security, but a download security which is
;               HIGHER, a macro will diplay this string. Else
;               the macro will display mere spaces. Read in
;               ISAAC.DOC for a complete macro list.
;
;
DonutString Donuts Only
;
;
;        BracketChars
;
;               Two characters, the left and the right bracket
;               of the download counter.
;
BracketChars []
;
;
;
;  End of ISAAC.CTL example file
;
