@echo off
rem ******************************************************
rem *                                                    *
rem * BBS.BAT file for 3 Node BBS under DesQView.        *
rem * Nodes 1 & 2 run the Front Door Mailer to answer    *
rem * the phone. 3rd runs in LOCAL mode.                 *
rem * In this setup, all three nodes use IMail for       *
rem * echomail tossing and scanning and MBUtil for       *
rem * importing and exporting NETMail.                   *
rem *                                                    *
rem ******************************************************

rem ******************************************************
rem * The FIRST thing we must do is see if we are        *
rem * "reloading" BBS.BAT. This is done when we run the  *
rem * DOBBS.BAT that FrontDoor creates. It is done so    *
rem * we can get the TimeToNextEvent from FD and pass it *
rem * on to RA. This way, you don't have to duplicate    *
rem * your events in FD and RA. If this is a reload, we  *
rem * jump down and run RA since we now have everything  *
rem * set in the environment variables.                  *
rem ******************************************************

if .%1 == .reload goto loadra
cls

rem ******************************************************
rem * Check to see if we are trying to load this node a  *
rem * second time. This is a BIG NO NO! You can only run *
rem * each node once. This was added to prevent          *
rem * "FAT FINGERS".                                     *
rem ******************************************************

if not exist c:\ra\%node%load.txt goto ok2load
echo.
echo 
echo The system shows that Node %node% is already loaded!
echo.
echo If you KNOW that Node %node% is not loaded and is being
echo brought back up after a crash (closing down the DV window
echo without exiting FD correctly ie: ALT C Y), then you need
echo to go to your RA directory delete the %node%LOAD.TXT file
echo and create the %node%ISDOWN.TXT file. Then you can reload
echo this Node.
echo.
echo Press [ENTER] to close this Task down.
pause
goto endok3

rem ******************************************************
rem * it's OK 2 load this task, so let's do it...        *
rem * set port variable dependent on each node. this     *
rem * MUST the com port you are using for the task. it   *
rem * is used to handle the modem from this and other    *
rem * .BAT files. this is VERY important!                *
rem ******************************************************

:ok2load
if %node% == N1 set port=1
if %node% == N2 set port=2
if %node% == N3 set port=0
echo.
echo Selected Port is %port%.
echo.

rem ******************************************************
rem * set up variables for each node. *NOTE* FD must     *
rem * have a seperate system directory for each node.    *
rem * make sure you set IMail and MBUtil correctly.      *
rem ******************************************************

set fd=c:\fd\%node%
set fdovr=c:\fd
set fmovr=c:\fd
set fdopt=INTL
set ra=c:\ra
set raovr=c:\ra
set imail=c:\ra
set mbu=c:\ra\mbutil.ctl

rem ******************************************************
rem * check to see if we are running under DV. if we are *
rem * we load the DV ANSI driver and recapture the FOSSIL*
rem * driver interrupt. otherwise, we load (or try to)   *
rem * the FOSSIL driver. This was added so that we could *
rem * the BBS as a single line in an emergency.          *
rem * Notice that we load DESQview's DVANSI.COM even if  *
rem * we are NOT running under DV. this is because DVANSI*
rem * uses up to 2K less memory and you don't have to put*
rem * it in your CONFIG.SYS file.                        *
rem ******************************************************

echo.
echo Checking for DESQview.
dvactive
if errorlevel 1 goto dvstuff
echo.
echo DESQview NOT detected.
echo Loading ANSI driver and FOSSIL driver..
c:\dv\dvansi
bnu /f+ /m- /q
bnu /c
goto start

:dvstuff
echo.
echo DESQview Detected!
echo Loading ANSI driver and Recapturing the FOSSIL interrupt...
echo.
c:\dv\dvansi
bnu /c

rem ******************************************************
rem * All this mess loops back to here each time.        *
rem * make sure we are on the correct drive and go to    *
rem * the correct directory for each node. Then run the  *
rem * correct FD for each node. Each FD has a different  *
rem * setup and control files!                           *
rem * *NOTE* We are NOT running in Shell to Mailer mode! *
rem ******************************************************

rem ******************************************************
rem * make sure the lockout files are NOT there incase   *
rem * of a system error or failure! we also check for    *
rem * and delete any stray DOBBS.BAT files that might be *
rem * in this nodes directory. then we create the        *
rem * semaphore file that tells the other nodes that     *
rem * this one is loaded and running.                    *
rem ******************************************************

:start
echo.
echo Removing old %node% lockout files.
if exist c:\ra\%node%*.txt del c:\ra\%node%*.txt
if exist c:\ra\%node%\dobbs.bat del c:\ra\%node%\dobbs.bat
rem>c:\ra\%node%load.txt

rem ******************************************************
rem * everything is OK so lets get into the right node   *
rem * directory and start this puppy.                    *
rem ******************************************************

echo.
echo Node %node% is going back online!
c:
cd\ra\%node%

rem ******************************************************
rem * if we are node 3 goto local logon only!            *
rem ******************************************************

if %node% == N3 goto ralocal

rem ******************************************************
rem * load and run Frontdoor                             *
rem ******************************************************

c:\fd\fd.exe

rem ******************************************************
rem * check errorlevels from FD. if call is human, set   *
rem * correct baud rate before loading RA.               *
rem ******************************************************

if errorlevel 255 goto diffexit
if errorlevel 240 set baud=2400
if errorlevel 240 goto racall
if errorlevel 120 set baud=1200
if errorlevel 120 goto racall
if errorlevel 110 set baud=300
if errorlevel 110 goto racall
if errorlevel 101 goto outbound
if errorlevel 100 goto inbound
if errorlevel  40 goto ralocal
if errorlevel  33 goto nightly
if errorlevel  31 goto weekly
if errorlevel  10 goto endok
if errorlevel   1 goto enderror

rem ******************************************************
rem * this node has been told to exit with errorlevel    *
rem * 255. this is the errorlevel we use to shutdown the *
rem * FD nodes so we can process a new nodediff file.    *
rem ******************************************************

:diffexit
dtr com%port%: on
at com%port%: h1
echo.
echo Notifying other nodes that I'm DOWN....
rem>c:\ra\%node%down.txt
goto endok2

rem ******************************************************
rem * check to see if another node is tossing inbound    *
rem * mail. if so let the caller know and exit. otherwise*
rem * create utility lockout file for individual nodes   *
rem * as they come online for a human caller and load    *
rem * RA with environment variables set for each node.   *
rem ******************************************************

:racall
cls
echo.
echo We have a caller!
if exist c:\ra\N?toss.txt goto fdbusy
rem>c:\ra\%node%isup.txt

rem ******************************************************
rem * check for DOBBS.BAT created by FD. if it there,    *
rem * execute it so we can get the TimeToNextEvent.      *
rem ******************************************************

if not exist c:\ra\%node%\dobbs.bat goto loadra
dobbs.bat

:loadra
ra -%node% -C%port% -B%baud% -E20 %event%

rem ******************************************************
rem * check errorlevels after RA exit.                   *
rem ******************************************************

:afterra
echo.
echo Checking Remote Access Exit Errorlevels....
if errorlevel 20 goto update
if errorlevel 11 goto ldv
if errorlevel  5 goto outbound
if errorlevel  4 goto outbound
if errorlevel  3 goto outbound
if errorlevel  2 goto ralocal
if errorlevel  1 goto enderror
if errorlevel  0 goto endok

rem ******************************************************
rem * this section is mainly to show a type 15 exit and  *
rem * reloading procedure. this one uses errorlevel 11   *
rem * to exit RA and run. this sample runs L.D.V. which  *                               
rem * is LongDistanceVerifier. it has the user fill out a*
rem * form which is then mailed to them with a special   *
rem * password. the user, when they receive the form,    *
rem * calls back, reenters LDV and enters the special    *
rem * password. LDV then upgrades the user according to  *
rem * your specs.                                        *
rem ******************************************************

:ldv
echo.
echo Running Long Distance Verifier.
ldv
echo.
echo Notifying User of making sure to leave SysOp Feedback
echo so I can make sure I mail him his special LDV password.
echo.>com%port%:
echo.>com%port%:
echo Please leave me a message stating that you had to use LDV>com%port%:
echo so you could have access to this system. If you don't tell>com%port%:
echo me, it will take longer for you to get your letter.>com%port%:
echo.>com%port%:
echo This option isn't used very much and i don't check it>com%port%:
echo very often.>com%port%:
echo.>com%port%:
echo Thank you,>com%port%:
echo Sysop>com%port%:
dvcomand wait 50
goto restart

rem ******************************************************
rem * this section is where we come to reload RA after   *
rem * a type 15 exit. when we exit this time, we go back *                                   
rem * to AFTERRA so we can check the errorlevels from    *
rem * there. this is to avoid having to duplicate them in*
rem * this already monstrous .BAT file.                  *
rem ******************************************************

:restart 
echo.
echo Reloading RA after a type 15 exit...
c:
cd\ra\%node%
ra -R -G -E20 -%node% -C%port% -B%baud%
goto afterra

rem ******************************************************
rem * we have inbound mail! take node 1's phone off hook *
rem * and make sure node 2 is not online before tossing. *
rem * if node 2 IS online, create a mailwaiting file so  *
rem * the waiting mail can be processed as soon as node  *
rem * is finished. in this case, we will let node 2 run  *
rem * the tosser otherwise node 1 will always toss.      *
rem * this is so that node 1 can be ready to accept      *
rem * human callers as soon as possible.                 *
rem ******************************************************

:inbound
cls
echo.
echo We have inbound mail!
echo.
if exist c:\ra\N?toss.txt goto innodechk
if exist c:\ra\n3inchck.txt goto 3upin
if exist c:\ra\n2inchck.txt goto 2upin
if exist c:\ra\n1inchck.txt goto 1upin
if exist c:\ra\N3outchk.txt goto 3upin
if exist c:\ra\N1outchk.txt goto 2upin
if exist c:\ra\N2outchk.txt goto 1upin
if %node% == N1 goto downthisnode
if %node% == N2 goto downthisnode
if %node% == N3 goto 3upin

rem ******************************************************
rem * if we have just recieved a mail packet while we    *
rem * are already tossing one, we will wait till next    *
rem * time to toss it, so don't worry about it right now *
rem ******************************************************

:innodechk
echo.
echo Another node is already Tossing INBOUND mail.
echo Waiting till later...
if %node% == N1 goto start
if %node% == N2 goto start
if %node% == N3 del c:\ra\%node%*.txt
If %node% == N3 goto end

rem ******************************************************
rem * take node offhook                                  *
rem ******************************************************

:downthisnode
dtr com%port%: off
dtr com%port%: on
at com%port%: h1
if %node% == N1 goto 2upin
if %node% == N2 goto 1upin

rem ******************************************************
rem * check for node 1 and node 2 online                 *
rem * if so, create waiting mail file.                   *
rem ******************************************************

:3upin
if exist c:\ra\N1isup.txt goto 3upin1
if exist c:\ra\N2isup.txt goto 3upin1

rem ******************************************************
rem * otherwise toss the mail!                           *
rem ******************************************************

goto tossit

rem ******************************************************
rem * create mail waiting file and loop back to start    *
rem ******************************************************

:3upin1
rem > c:\ra\mail!.txt
if exist c:\ra\%node%*.txt del c:\ra\%node%*.txt
goto end

rem ******************************************************
rem * check for node 2 and node 3 online                 *
rem * if so, create waiting mail file.                   *
rem ******************************************************

:2upin
if exist c:\ra\N2isup.txt goto 2upin1
if exist c:\ra\N3isup.txt goto 2upin1

rem ******************************************************
rem * otherwise toss the mail!                           *
rem ******************************************************

goto tossit

rem ******************************************************
rem * create mail file and loop back to start            *
rem ******************************************************

:2upin1
rem > c:\ra\mail!.txt
goto start

rem ******************************************************
rem * check for node 1 and node 3 online                 *
rem * if so, create waiting mail file.                   *
rem ******************************************************

:1upin
if exist c:\ra\N1isup.txt goto 1upin1
if exist c:\ra\N3isup.txt goto 1upin1

rem ******************************************************
rem * otherwise toss the mail!                           *
rem ******************************************************

goto tossit

rem ******************************************************
rem * create mail file and loop back to start            *
rem ******************************************************

:1upin1
rem > c:\ra\mail!.txt
goto start

rem ******************************************************
rem * lock out other nodes from coming online during     *
rem * inbound mail processing.                           *
rem ******************************************************

:tossit
echo.
echo Locking out other nodes for the Tossing of INBOUND mail...
rem>c:\ra\%node%toss.txt
echo.
echo Making sure phone is OFF the hook...
dtr com%port%: off
dtr com%port%: on
at com%port%: h1
echo.
echo Looking to see what we got. Don'cha love christmas -=B-)

rem ******************************************************
rem * checking for new FIDO Snooze. if it's there,       *
rem * unarchive it into the FNEWS directory.             *
rem ******************************************************

c:
cd\fd\files\news
if not exist ..\fnews???.* goto nodelist
echo.
echo Found new FIDO Snooze. Unpacking it...
spaz -d ..\fnews*

rem ******************************************************
rem * check for new nodediff file. if it's found, then   *
rem * we process it.                                     *
rem *                                                    *
rem * this process looks complicated. actually it's not. *
rem * in this process, we have to take down any FD nodes *
rem * that might be up and running. we have to wait till *
rem * they are down before we can continue.              *
rem ******************************************************

:nodelist
cd\fd\nodelist
if exist c:\fd\files\nodediff.* goto fidodiff
goto unpackmail

:fidodiff
echo.
echo Found a new FIDOnet NodeDiff....

:nodechker
if %node% == N1 goto diffn1
if %node% == N2 goto diffn2
if %node% == N3 goto diffn3

:diffn1
rem>c:\fd\n2\fdexit.255
:1diffn1
if not exist c:\ra\n2down.txt goto n1wait
goto dofidodiffs
:n1wait
echo.
echo Waiting for Node N2 to go down...
dvcomand wait 50
goto 1diffn1
:diffn2
rem>c:\fd\n1\fdexit.255
:2diffn2
if not exist c:\ra\n1down.txt goto n2wait
goto dofidodiffs
:n2wait
echo.
echo Waiting for Node N1 to go down...
dvcomand wait 50
goto 2diffn2
:diffn3
rem>c:\fd\n1\fdexit.255
rem>c:\fd\n2\fdexit.255
:3diffn3
if not exist c:\ra\n1down.txt goto n3wait
if not exist c:\ra\n2down.txt goto n3wait
goto dofidodiffs
:n3wait
echo.
echo Waiting on Node(s) to go down for Diff processing...
dvcomand wait 50
goto 3diffn3

rem ******************************************************
rem * ok, the nodes are down. first thing is to save the *
rem * the new nodediff. then we del the nodelist from 2  *
rem * weeks ago from the save dir. copy last weeks       *
rem * nodelist into the save dir. i use SYSNL to merge   *
rem * the new nodediff with the new nodelist. it can     *
rem * perform this process in about 1 minute on a 386 16 *
rem * under DV with 1 or two tasks running. it will then *
rem * delete the old nodelist and the new nodediff's     *
rem * archive file when done. the .BAT file makes sure,  *
rem * though<<grin>>. then we delete the nodediff from 5 *
rem * weeks ago that we saved and .ZIP up the newly      *
rem * compiled nodelist into the diffs dir. this diff dir*
rem * is where i keep the nodelist and 5 weeks worth of  *
rem * nodediffs for other systems to download them from  *
rem * in case they mess up theirs or haven't updated     *
rem * their nodelist in a while. it's a service i like   *
rem * to provide. i know it has helped me out.           *
rem * last weeks nodelist is saved in the save dir so in *
rem * case there are any problems. you can then have a   *
rem * better starting point rather than having to d/l it *
rem * all again -=B-)                                    *
rem ******************************************************

:dofidodiffs
copy c:\fd\files\nodediff.* c:\files\diffs
daynbr /-14 /d5 del c:\fd\nodelist\save\nodelist.@###
daynbr /-7 /d5 copy c:\fd\nodelist\nodelist.@### c:\fd\nodelist\save
sysnl merge nodelist nodediff c
daynbr /-7 /d5 del c:\fd\nodelist\nodelist.@###
daynbr /-7 /d5 del c:\files\diffs\nodelist.@Z##
daynbr /-35 /d5 del c:\files\diffs\nodediff.@A##
daynbr /d5 pkzip c:\files\diffs\nodelist.@Z## nodelist.@###
goto compile

rem ******************************************************
rem * now we compile the nodelist for FD and RA. then we *
rem * go back up just in case we missed something. if    *
rem * there are no more nodediffs to process,            * 
rem * (ie: othernets) then we go from there on to do any *
rem * inbound mail packets.                              *
rem ******************************************************

:compile
c:
cd\fd\n1
fdnc /f
cd\ra\%node%
ranode
goto nodelist

rem ******************************************************
rem * now we check the inbound mail. first step, though, *
rem * is to bring back up any FD nodes that may be down. *
rem ******************************************************

:unpackmail
echo.
echo Checking to see if FD Node(s) are down...
if exist c:\ra\n?down.txt goto openfdnodes
goto nodesup

:openfdnodes
echo .
echo Bringing FD Node(s) back online...
if exist c:\fd\n1\fdexit.255 del c:\fd\n1\fdexit.255
if exist c:\fd\n2\fdexit.255 del c:\fd\n2\fdexit.255
if exist c:\ra\n1down.txt dvcomand open c:\dv\n1
if exist c:\ra\n2down.txt dvcomand open c:\dv\n2

rem ******************************************************
rem * do the tossing and kill the mail waiting flag file *
rem * also, notify the FD nodes to rescan their message  *
rem * image in memory.                                   *
rem ******************************************************

:nodesup
echo.
echo Tossing INBOUND mail...
echo.>>c:\logs\inbound.log
echo Node %node% tossed this mail bundle.>>c:\logs\inbound.log
c:
cd\ra\%node%
imail toss
mbutil import
mbutil link -clean
rem>c:\fd\n1\fdrescan.now
rem>c:\fd\n1\fmrescan.now
rem>c:\fd\n2\fdrescan.now
rem>c:\fd\n2\fmrescan.now
if exist c:\ra\mail!.txt    del c:\ra\mail!.txt
if exist c:\ra\N?toss.txt   del c:\ra\N?toss.txt
if exist c:\ra\%node%inchck.txt goto back2update
if exist c:\ra\%node%outchk.txt goto backfromtoss
if %node% == N3 goto N3exit
goto start

rem ******************************************************
rem * one of the nodes is coming online in local mode.   *
rem * make the nodeisup file to let the other one know   *
rem * what is going on and load RA with the node number  *
rem * in local mode.                                     *
rem ******************************************************

:ralocal
if %node% == N1 goto tosschk1l
if %node% == N2 goto tosschk2l
if %node% == N3 goto tosschk3l
:tosschk1l                   
if exist c:\ra\N2toss.txt goto fdbusyl
if exist c:\ra\N3toss.txt goto fdbusyl
:tosschk2l
if exist c:\ra\N1toss.txt goto fdbusyl
if exist c:\ra\N3toss.txt goto fdbusyl
:tosschk3l
if exist c:\ra\N1toss.txt goto fdbusyl
if exist c:\ra\N2toss.txt goto fdbusyl
echo.
echo Notifying other nodes that this node is online...
rem>c:\ra\%node%isup.txt
set oldport=%port%
set port=0
c:
cd\ra\%node%
ra -%node% -l -e20
set port=%oldport%
set oldport=

rem ******************************************************
rem * check errorlevels on local mode exit and execute.  *
rem ******************************************************

goto afterra

rem ******************************************************
rem * local fdbusy display                               *
rem ******************************************************

:fdbusyl
type c:\ra\fdbusy.txt
dvcomand wait 50
goto start

rem ******************************************************
rem * normal fdbusy display                              *
rem ******************************************************

:fdbusy
echo.
echo Notifying user of System Maintainence in progress.
echo.
type c:\ra\fdbusy.txt > com%port%:
dtr com%port%: off
dtr com%port%: on
at com%port%: h1
goto start

rem ******************************************************
rem * ok, now we can do the outbound stuff               *
rem * first check to see which node we are. then see if  *
rem * we have any inbound waiting to be tossed.          *
rem ******************************************************

:outbound
if %node% == N1 goto downnode
if %node% == N2 goto downnode
if %node% == N3 goto nodeupout

rem ******************************************************
rem * take node  offhook                                 *
rem ******************************************************

:downnode
dtr com%port%: off
dtr com%port%: on
at com%port%: h1
if %node% == N2 goto nodeupout
if %node% == N1 goto nodeupout

rem ******************************************************
rem * check to see if we have inbound waiting.           *
rem * if so, let's try to toss it before we scan         *
rem * outbound, otherwise, let's do the real thing.      *
rem ******************************************************

:nodeupout
echo.
echo Checking for waiting INBOUND mail...
if not exist c:\ra\mail!.txt goto jump
echo.
echo We have waiting INBOUND mail. Going to toss it now...
rem>c:\ra\%node%outchk.txt
goto inbound
:jump

rem ******************************************************
rem * we return here if we had to toss inbound before we *
rem * scan for outbound.                                 *
rem ******************************************************

:backfromtoss
echo.
echo Checking for another node online...
if exist c:\ra\%node%outchk.txt del c:\ra\%node%outchk.txt
if %node% == N1 goto 1echoloop
if %node% == N2 goto 2echoloop
if %node% == N3 goto 3echoloop
:1echoloop
if not exist c:\ra\N2isup.txt goto chk3
echo.
echo Node N2 is online. Waiting till later to scan OUTBOUND mail...
goto start
:2echoloop
if not exist c:\ra\N1isup.txt goto chk3
echo.
echo Node N1 is online. Waiting till later to scan OUTBOUND mail...
goto start
:3echoloop
if not exist c:\ra\N1isup.txt goto chk2
echo.
echo Node N1 is online. Waiting till later to scan OUTBOUND mail...
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
goto end
:chk2
if not exist c:\ra\N2isup.txt goto echook
echo.
echo Node N2 is online. Waiting till later to scan OUTBOUND mail...
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
goto end
:chk3
if not exist c:\ra\N3isup.txt goto echook
echo.
echo Node N3 is online. Waiting till later to scan OUTBOUND mail...
goto start

rem ******************************************************
rem * ok, now we are ready to scan for outbound mail.    *
rem * when done, notify both FD nodes to rescan their    *
rem * message base image in memory.                      *
rem ******************************************************

:echook
echo.
echo Scanning for OUTBOUND mail...
c:
cd\ra\%node%
if exist c:\ra\msgbase\echomail.bbs del c:\ra\msgbase\echomail.bbs
if exist c:\ra\msgbase\netmail.bbs del c:\ra\msgbase\netmail.bbs
mbutil export
imail scan
rem>c:\fd\n1\fdrescan.now
rem>c:\fd\n1\fmrescan.now
rem>c:\fd\n2\fdrescan.now
rem>c:\fd\n2\fmrescan.now

rem ******************************************************
rem * ok. now we try to update the bulletins and such.   *
rem * we first check to see if another node is up. if    *
rem * it is, then we let it handle everything when it    *
rem * exits.                                             *
rem ******************************************************

:update
echo.
echo Attempting to update user bulletins...
if %node% == N3 goto lookup
dtr com%port%: off
dtr com%port%: on
at com%port%: h1

rem ******************************************************
rem * first see if there is waiting inbound mail. if so, *
rem * let's handle it.                                   *
rem ******************************************************

:lookup
if not exist c:\ra\mail!.txt goto jump1
rem>%node%inchck.txt
goto inbound
:jump1

rem ******************************************************
rem * now, check to see if there is waiting outbound     *
rem * mail. if so, let's handle it.                      *
rem ******************************************************

:back2update
if exist c:\ra\msgs\echomail.bbs goto outbound
if exist c:\ra\msgs\netmail.bbs goto outbound

rem ******************************************************
rem * finally got all the mail taken care of. now it's   *
rem * time for the user bulletins...                     *
rem ******************************************************

if %node% == N1 goto check1
if %node% == N2 goto check2
if not exist c:\ra\N1isup.txt goto chck2
echo.
echo Node N1 is online. Waiting till later to update bulletins...
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
goto end
:check2
if not exist c:\ra\N1isup.txt goto chck3
echo.
echo Node N1 is online. Waiting till later to update bulletins...
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
goto start
:check1
if not exist c:\ra\N2isup.txt goto chck3
echo.
echo Node N2 is online. Waiting till later to update bulletins...
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
goto start
:chck2
if not exist c:\ra\N2isup.txt goto doupdate
echo.
echo Node N2 is online. Waiting till later to update bulletins...
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
goto end
:chck3
if not exist c:\ra\N3isup.txt goto doupdate
echo.
echo Node N3 is online. Waiting till later to update bulletins...
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
goto start

rem ******************************************************
rem * WHEW! We can finally update the bulletins...       *
rem ******************************************************

:doupdate
usa

rem ******************************************************
rem * if this task is Node 3, we can now exit and shut   *
rem * down this task.                                    *
rem ******************************************************

:n3exit
del c:\ra\%node%isup.txt
if %node% == N3 goto end
goto start

rem ******************************************************
rem * all nightly maintenence is done by node 1.         *
rem * make sure the other node is not doing anything     *
rem * first. if it is, then wait a minute and try again. *
rem ******************************************************

:nightly
dtr com%port%: off
dtr com%port%: on
at com%port%: h1
if exist c:\ra\N1isup.txt del c:\ra\N1isup.txt
if exist c:\ra\N2isup.txt goto wait
if exist c:\ra\N2toss.txt goto wait
if exist c:\ra\N3isup.txt goto wait
if exist c:\ra\N3toss.txt goto wait
echo.
echo Running Nightly Maintenance...
rem>c:\ra\N1toss.txt
call c:\ra\runmaint.bat
goto start

rem ******************************************************
rem * we come here to wait for the other node to go down *
rem ******************************************************

:wait
echo.
echo Waiting on another node so I can run nightly maintenance...
dvcomand wait 100
goto nightly

rem ******************************************************
rem * weekly maintenence is done by node 1.              *
rem ******************************************************

:weekly
if %node% == N1 dtr com%port%: on
if %node% == N1 at com%port%: h1
if %node% == N2 goto start
if exist c:\ra\N1isup.txt del c:\ra\N1isup.txt
if exist c:\ra\N2isup.txt goto wwait
if exist c:\ra\N2toss.txt goto wwait
if exist c:\ra\N3isup.txt goto wwait
if exist c:\ra\N3toss.txt goto wwait
echo.
echo Running Weekly Maintenance...
rem>c:\ra\N1toss.txt
imthings stat
goto start

rem ******************************************************
rem * we come here to wait for the other node to go down *
rem ******************************************************

:wwait
echo.
echo Waiting on another node so I can run weekly maintenance...
dvcomand wait 100
goto weekly

rem ******************************************************
rem * OOPS! we have some kind of error!                  *
rem ******************************************************

:enderror
cls
echo Node %node% is down with a FATAL error!
echo Attempting to reload and correct in 5 seconds..
dvcomand wait 50
bnu /c
goto start

rem ******************************************************
rem * normal exit from any node                          *
rem ******************************************************

:endok
cls
dtr com%port%: off
dtr com%port%: on
at com%port%: h1
:endok2
echo Node %node% has been exited normally. The phone is unuseable.

rem ******************************************************
rem * make sure we kill any existing lockout files       *
rem * if we are running this without DV, unload the      *
rem * FOSSIL driver.                                     *
rem ******************************************************

:end
if exist c:\ra\%node%isup.txt del c:\ra\%node%isup.txt
if exist c:\ra\%node%load.txt del c:\ra\%node%load.txt
rem>c:\ra\%node%down.txt
:endok3
dvactive
if errorlevel 1 exit
bnu /u
