UNIT TpzVideo;
(* Status window routines for Turbo Pascal Zmodem *)
(* (c)1988 by J.R.Louvau                          *)
INTERFACE
USES CRT,GRAPH,DOS;

PROCEDURE Z_OpenWindow(title: STRING);
(* Setup the area of the screen for transfer status window *)
PROCEDURE Z_CloseWindow;
(* Restore the original window *)
PROCEDURE Z_ShowName(filename: STRING);
(* Display the file name *)
PROCEDURE Z_ShowSize(l: LONGINT);
(* Display the file size in blocks and bytes *)
PROCEDURE Z_ShowCheck(is32: BOOLEAN);
(* Display CRC16 or CRC32 block checking *)
PROCEDURE Z_ShowTransferTime(fsize, zbaud: LONGINT);
(* Show estimated transfer time in minutes *)
PROCEDURE Z_Message(s: STRING);
(* Show miscelaneous messages *)
PROCEDURE Z_Frame(n: INTEGER);
(* Show current ZMODEM frame type *)
PROCEDURE Z_ShowLoc(l: LONGINT);
(* Show byte position of file in blocks and bytes *)
PROCEDURE Z_Errors(w: WORD);
(* Show total error count *)

IMPLEMENTATION

TYPE
    
    oldstuff = array[1..10] of string;

CONST
   x1: BYTE = 20;
   x2: BYTE = 59;
   y1: BYTE = 5;
   y2: BYTE = 17;
   fore: BYTE = LightGray;
   back: BYTE = Black;
   bfore: BYTE = Black;
   bback: BYTE = Green;

VAR
   vmode: BYTE absolute $0040:$0049;
   vcols: WORD absolute $0040:$004A;
   oldx, oldy, oldattr: BYTE;
   oldmin, oldmax, cols, rows, size, vseg, vofs: WORD;
   buffer: POINTER;
   old : oldstuff;
   i : integer;
   x : array[1..10] of integer;
   y : array[1..10] of integer;
   startclock, stopclock : real;
   h,m,s,s100 : word;

FUNCTION RtoS(r: REAL; width, decimals: WORD): STRING;
VAR
   s: STRING;
BEGIN
   {$I-}
   Str(r:width:decimals,s);
   {$I+}
   IF (IoResult <> 0) THEN
      s := ''
   ELSE
      WHILE (Length(s) > 0) AND (s[1] = ' ') DO
         Delete(s,1,1);
   RtoS := s
END;

FUNCTION ItoS(r: LONGINT; width: WORD): STRING;
VAR
   s: STRING;
BEGIN
   {$I-}
   Str(r:width,s);
   {$I+}
   IF (IoResult <> 0) THEN
      s := ''
   ELSE
      WHILE (Length(s) > 0) AND (s[1] = ' ') DO
         Delete(s,1,1);
   ItoS := s
END;


PROCEDURE Z_OpenWindow(title: STRING);

var
   movedown,
   moveleft : integer;

BEGIN
rectangle(0,0,320,230);
setviewport(5,5,319,229,TRUE);
clearviewport;
moveto(0,0);
settextstyle(3,0,2);
setcolor(15);
outtext('File name :');
x[1] := getx;
y[1] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('File size :');
x[2] := getx;
y[2] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Time Elapsed :');
x[4] := getx;
y[4] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Transfer time :');
x[5] := getx;
y[5] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Block check :');
x[3] := getx;
y[3] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Current BYTE :');
x[6] := getx;
y[6] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Current BLOCK :');
x[7] := getx;
y[7] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Error count :');
x[8] := getx;
y[8] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Last frame :');
x[9] := getx;
y[9] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
outtext('Last Message: ');
x[10] := getx;
y[10] := gety;
movedown := textheight('A');
moveleft := getx;
moverel(-moveleft,movedown);
for i := 1 to 10 do
    old[i] := '';
gettime(h,m,s,s100);
startclock := (h*60) + m + s/60 ;
END;

PROCEDURE Z_CloseWindow;

BEGIN
setviewport(0,0,getmaxx,getmaxy,TRUE);
clearviewport;
END;

PROCEDURE Z_ShowName(filename: STRING);
BEGIN
setcolor(0);
outtextxy(x[1],y[1],old[1]);
setcolor(10);
outtextxy(x[1],y[1],filename);
old[1] := filename;
END;

PROCEDURE Z_ShowSize(l: LONGINT);
BEGIN
setcolor(0);
outtextxy(x[2],y[2],old[2]);
old[2] := itos(l,14);
setcolor(10);
outtextxy(x[2],y[2],old[2]);
END;

PROCEDURE Z_ShowCheck(is32: BOOLEAN);
BEGIN
   setcolor(10);
   IF (is32) THEN
      outtextxy(x[3],y[3],'CRC32')
   ELSE
      outtextxy(x[3],y[3],'CRC16');
END;

PROCEDURE Z_ShowTransferTime(fsize, zbaud: LONGINT);
VAR
   bits: REAL;
BEGIN
   setcolor(0);
   outtextxy(x[5],y[5],old[5]);
   bits := fsize * 10.0;
   moveto(x[5],y[5]);
   IF (bits <> 0.0) THEN
      begin
      old[5] := RtoS(((bits / zbaud) / 60),10,2);
      setcolor(10);
      outtext(old[5]);
      outtext(' min.')
      end
   ELSE
       begin
       setcolor(10);
       outtext('0min.');
       end;
END;

PROCEDURE Z_Message(s: STRING);
BEGIN
   setcolor(0);
   outtextxy(x[10],y[10],old[10]);
   setcolor(10);
   outtextxy(x[10],y[10],s);
   old[10] := s;
END;

PROCEDURE Z_Frame(n: INTEGER);
var
   temp : integer;
   oldold : string;

BEGIN
   IF (n < -3) OR (n > 20) THEN
      n := 20;
   moveto(x[9],y[9]);
   temp := Lo(n);
   oldold := old[9];
   CASE temp OF
      -3 : old[9] := 'ZNOCARRIER';
      -2 : old[9] := 'ZTIMEOUT';
      -1 : old[9] := 'ZERROR';
      0  : old[9] := 'ZRQINIT';
      1  : old[9] := 'ZRINIT';
      2  : old[9] := 'ZSINIT';
      3  : old[9] := 'ZACK';
      4  : old[9] := 'ZFILE';
      5  : old[9] := 'ZSKIP';
      6  : old[9] := 'ZNAK';
      7  : old[9] := 'ZABORT';
      8  : old[9] := 'ZFIN';
      9  : old[9] := 'ZRPOS';
      10 : old[9] := 'ZDATA';
      11 : old[9] := 'ZEOF';
      12 : old[9] := 'ZFERR';
      13 : old[9] := 'ZCRC';
      14 : old[9] := 'ZCHALLENGE';
      15 : old[9] := 'ZCOMPL';
      16 : old[9] := 'ZCAN';
      17 : old[9] := 'ZFREECNT';
      18 : old[9] := 'ZCOMMAND';
      19 : old[9] := 'ZSTDERR';
      20 : old[9] := 'ZUNKNOWN';
   END;
   if old[9] <> oldold then
      begin
      setcolor(0);
      outtextxy(x[9],y[9],oldold);
      setcolor(12);
      outtextxy(x[9],y[9],old[9]);
      end;
END;

PROCEDURE Z_ShowLoc(l: LONGINT);
BEGIN
   setcolor(0);
   outtextxy(x[4],y[4],old[4]);
   gettime(h,m,s,s100);
   stopclock := (h*60) + m + s/60 ;
   old[4] := rtos(stopclock-startclock,2,2);
   setcolor(7);
   outtextxy(x[4],y[4],old[4]);
   setcolor(0);
   outtextxy(x[6],y[6],old[6]);
   old[6] := itos(l,14);
   setcolor(10);
   outtextxy(x[6],y[6],old[6]);
   IF (l MOD 1024 <> 0) THEN
      l := (l DIV 1024) + 1
   ELSE
      l := (l DIV 1024);
   setcolor(0);
   outtextxy(x[7],y[7],old[7]);
   old[7] := itos(l,14);
   setcolor(10);
   outtextxy(x[7],y[7],old[7]);
END;

PROCEDURE Z_Errors(w: WORD);
BEGIN
   setcolor(0);
   outtextxy(x[8],y[8],old[8]);
   old[8] := itos(w,14);
   setcolor(12);
   outtextxy(x[8],y[8],old[8]);
END;

END.