(*$R-,V-,S-,F+*)
PROGRAM FixBrack;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*    Program:  FixBrack                                                    *)
(*                                                                          *)
(*    Purpose:  Neatens output of Dave Baldwin's INLINE assembler for       *)
(*              Turbo Pascal so that the code is lined up properly.         *)
(*                                                                          *)
(*    Usage:    Compile and run in the usual way.  You will be prompted     *)
(*              for the input and output file names.                        *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

TYPE
   AnyStr           = STRING[255];
   NameStr          = STRING[40];
   Text_Buffer_Type = ARRAY[0..4095] OF CHAR;

VAR
   OldObjFile  : TEXT;
   OldObjName  : NameStr;
   OldObjBuf   : Text_Buffer_Type;
   NewObjFile  : TEXT;
   NewObjName  : NameStr;
   NewObjBuf   : Text_Buffer_Type;

(*--------------------------------------------------------------------------*)
(*                     Dupl -- Duplicate a character n times                *)
(*--------------------------------------------------------------------------*)

FUNCTION Dupl( Dup_char : Char; Dup_Count: INTEGER ) : AnyStr;

(*--------------------------------------------------------------------------*)
(*                                                                          *)
(*    Function: Dupl                                                        *)
(*                                                                          *)
(*    Purpose:  Duplicate a character n times                               *)
(*                                                                          *)
(*    Calling Sequence:                                                     *)
(*                                                                          *)
(*       Dup_String := Dupl( Dup_Char: Char; Dup_Count: INTEGER ): AnyStr;  *)
(*                                                                          *)
(*          Dup_Char   --- Character to be duplicated                       *)
(*          Dup_Count  --- Number of times to duplicate character           *)
(*          Dup_String --- Resultant duplicated string                      *)
(*                                                                          *)
(*          Note:  If Dup_Count <= 0, a null string is returned.            *)
(*                                                                          *)
(*    Calls:  None                                                          *)
(*                                                                          *)
(*                                                                          *)
(*    Remarks:                                                              *)
(*                                                                          *)
(*       This routine could be programmed directly in Turbo as:             *)
(*                                                                          *)
(*          VAR                                                             *)
(*             S    : AnyStr;                                               *)
(*                                                                          *)
(*          BEGIN                                                           *)
(*                                                                          *)
(*             FillChar( S[1], Dup_Count, Dup_Char );                       *)
(*             S[0] := CHR( Dup_Count );                                    *)
(*                                                                          *)
(*             Dupl := S;                                                   *)
(*                                                                          *)
(*          END;                                                            *)
(*                                                                          *)
(*--------------------------------------------------------------------------*)

BEGIN (* Dupl *)

INLINE(
  $8B/$4E/$06/           {         MOV       CX,[BP+6]  ; Pick up dup count}
  $C4/$7E/$0A/           {         LES       DI,[BP+10] ; Result address}
  $FC/                   {         CLD                  ; Set direction flag}
  $88/$C8/               {         MOV       AL,CL      ; Get result length}
  $AA/                   {         STOSB                ; Store result length}
  $8B/$46/$08/           {         MOV       AX,[BP+8]  ; Get char to duplicate
}
  $F2/$AA);              {         REP       STOSB      ; Perform duplication}

END   (* Dupl *);

PROCEDURE Process_Files;

VAR
   S       : AnyStr;
   L       : INTEGER;
   I       : INTEGER;
   MaxBrack: INTEGER;
BEGIN (* Process_Filess *)

   ASSIGN    ( OldObjFile, OldObjName );
   SetTextBuf( OldObjFile, OldObjBuf  );
   RESET     ( OldObjFile );

   ASSIGN    ( NewObjFile, NewObjName );
   SetTextBuf( NewObjFile, NewObjBuf  );
   REWRITE   ( NewObjFile );

   WRITELN('Modifying ',OldObjName);

   MaxBrack := 0;

   REPEAT

      READLN( OldObjFile, S );

      I := POS( '{' , S );

      IF ( I > MaxBrack ) THEN
         MaxBrack := I;
   UNTIL ( EOF( OldObjFile ) );

   RESET( OldObjFile );

   REPEAT

      READLN( OldObjFile, S );

      I := POS( '{' , S );

      IF ( I > MaxBrack ) THEN
         MaxBrack := I;

      IF ( I = 0 ) THEN
         WRITELN( NewObjFile , S )
      ELSE
         BEGIN
            L := LENGTH( S );
            WRITELN( NewObjFile, COPY( S, 1, I - 1 ),
                     DUPL( ' ' , MaxBrack - I ), COPY( S, I, L - I + 1 ) );
         END;

   UNTIL ( EOF( OldObjFile ) );

   CLOSE( OldObjFile );

   WRITELN;

   CLOSE( NewObjFile );

END   (* Process_Filess *);

PROCEDURE Get_File_Names;

BEGIN (* Get_File_Names *)

   IF ParamCount > 0 THEN
      OldObjName := ParamStr( 1 )
   ELSE
      BEGIN
         WRITE('File to read:  ');
         READLN( OldObjName );
      END;

   IF ParamCount > 1 THEN
      NewObjName := ParamStr( 2 )
   ELSE
      BEGIN
         WRITE('File to write: ');
         READLN( NewObjName );
      END;

END   (* Get_File_Names *);

BEGIN (* FixBrack *)

   Get_File_Names;

   Process_Files;

END   (* FixBrack *).

