TITLE   JMODEM_G.ASM

COMMENT *
	Created		20-NOV-1991		Richard B. Johnson

	With the increased emphasis upon data transfer speed, it has
	become necessary to move the interrupt service routines out
	of the 'C' code and into assembly where they belong. Many will
	remember that JMODEM was originally written in assembly language.

	With this modification, JMODEM can now operate at about 76,800
	baud with a 33 MHz '386 clone and can operate at 38,400 baud with
	a 12 MHz "True Blue" AT.
*
;

EOI	EQU	20H			; Non-specific end-of-interrupt
INT_CTL	EQU	20H			; Interrupt controller base address

_TEXT	SEGMENT  WORD PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME DS: DGROUP, SS: DGROUP
EXTRN	_write_ptr:WORD
EXTRN	_buff_limit:WORD
EXTRN	_hardware_port:WORD
EXTRN	_timer:WORD
EXTRN	_old_tim:DWORD
PUBLIC	_tim_int
PUBLIC	_com_int

_TEXT	SEGMENT WORD PUBLIC 'CODE'
	ASSUME	CS: _TEXT
;
;	Communications hardware interrupt. To make this code as fast as
;	possible, only the registers actually used are saved on the stack.
;	Also, no jumps that could force the prefetch buffer to be flushed
;	are used.
;
_com_int	PROC FAR
	PUSH	AX				; Save registers used
	PUSH	BX
	PUSH	DX
	PUSH	DS
	MOV	AX,DGROUP			; Get data group
	MOV	DS,AX				; Set up segment
	ASSUME  DS:DGROUP			; Tell Assembler
	MOV	DX,WORD PTR _hardware_port	; Get port in use
	IN	AL,DX				; Get byte
	MOV	BX,WORD PTR _write_ptr		; Get buffer pointer
	MOV	BYTE PTR [BX],AL		; Put byte in the buffer
	CMP	BX,WORD PTR _buff_limit		; Check the buffer end
	ADC	WORD PTR _write_ptr,0		; Bump if not end of buffer
	MOV	AL,EOI				; Get end-of interrupt
	OUT	INT_CTL,AL			; Reset the controller
	POP	DS				; Restore segments used
	POP	DX
	POP	BX
	POP	AX
	IRET
_com_int	ENDP
;
;	Hardware timer interrupt attached to INT 1CH. Its purpose is to
;	provide a fixed timout interval for error trapping without regard
;	for the CPU speed.
;
_tim_int	PROC	FAR
	PUSH	AX			; Save register used
	MOV	AL,EOI			; Get end-of interrupt
	OUT	INT_CTL,AL		; Reset the controller right now!
	STI				; Allow all interrupts now
	PUSH	DS			; Save segment
	MOV	AX,DGROUP		; Get data GROUP
	MOV	DS,AX			; Make addressable
	SUB	WORD PTR _timer,1	; Bump the timer
	ADC	WORD PTR _timer,0	; Adjust if it went below zero
	PUSHF				; Set up for IRET from routine
	CALL	DWORD PTR _old_tim	; Call old timer interrupt
	POP	DS			; Restore segment
	POP	AX			; Restore register used
	IRET
_tim_int	ENDP
;
_TEXT	ENDS
	END
