/*---------------------------------------------------------------------------*/
/*                The Opus Computer-Based Conversation System                */
/*           (c) Copyright 1987, Rick Huebner, All Rights Reserved           */
/*---------------------------------------------------------------------------*/
#define  WAZOO_SECTION
#include <sys\types.h>
#include <sys\stat.h>

#include "bbs.h"

/* Positions of transfer status line fields */
#define POS_X 7
#define LEN_X 21
#define ETA_X 31
#define MSG_X 45


long  TX_FileSize;
long  TX_StTime;
int   TX_OldETA;

long  RX_FileSize;
long  RX_StTime;
int   RX_OldETA;

byte *ResendingFrom  = "Resending from %ld";
byte *XFER_str       = " pos=        , len=    , ETA=     min.";
long total_bytes;


/*****************************************************************************/
/* Display start-of-transfer summary info                                    */
/*****************************************************************************/
void pascal xfer_summary(xfertype,ftype,fname,len,efficiency,y)
byte *xfertype, *ftype, *fname;
long *len;
int efficiency, y;
{
  if (y) gotoxy(1,y);
  cprintf("%s %s %s, %ldb, %d min.", xfertype, ftype, fname, *len,
   (caller_baud)? ((int)((*len * 10/caller_baud*100/efficiency+30)/60)): -1);
}



/*****************************************************************************/
/* Update any status line values which have changed                          */
/*****************************************************************************/
void pascal update_status(long *pos,
                          long *oldpos,
                          int   len,
                          int  *oldlen,
                          long  left,
                          int  *oldeta,
                          int   efficiency,
                          int   y)
/* long *pos, *oldpos, left; */
/* int  len, *oldlen, *oldeta, efficiency, y; */
{
  register int eta;

  if (*pos != *oldpos) {
    gotoxy(POS_X,y);
    cprintf("%8ld",*oldpos = *pos);
  }

  if (len != *oldlen) {
    gotoxy(LEN_X,y);
    cprintf("%4d",*oldlen = len);
  }

  eta = (caller_baud)? ((int)((left*10/caller_baud*100/efficiency+30)/60)): -1;
  if (eta != *oldeta) {
    gotoxy(ETA_X,y);
    cprintf("%4d",*oldeta = eta);
  }
}


/*****************************************************************************/
/* Compute and print throughput                                              */
/*****************************************************************************/
void pascal through(bytes,started,y)
long *bytes, *started;
int y;
{
  register int bps;
  long elapsed;

  total_bytes += *bytes;
  if (elapsed = time(NULL) - *started) {
    if (elapsed < 0) elapsed += (24L*60L*60L); /* Fix if started yesterday */
    if (elapsed && caller_baud) {
      bps = (int)((*bytes * 10+elapsed/2)/elapsed);
      if (y) gotoxy(MSG_X,y);
      cprintf("Throughput = %d bps (%d%%)", bps,
              (int)((bps*100L+caller_baud/2)/caller_baud));
      local_CEOL();
    }
  }
}

