         .xlist
         .MODEL   Small
         INCLUDE  CMACROS.INC
         .list


Public   JANUS_RawByte
Public   JANUS_GetCookedByte


         ;
         ;--- Declarations
         ;
         NOCARRIER         equ -4
         PKTEND            equ -3
         PKTSTRT           equ -2
         NODATA            equ -1

         PKTSTRTCHR        equ 'a'
         PKTENDCHR         equ 'b'

         DLE               equ 10H





         .DATA

         ;
         ;--- External data
         ;
EXTRN    JANUS_WaitFlag    : BYTE
EXTRN    JANUS_TimeoutSecs : WORD





         .CODE

         ;
         ;--- External routines
         ;
EXTRN    READBYTE          : NEAR   ; PL/M
EXTRN    CARRIER           : NEAR   ; PL/M
EXTRN    TIME_RELEASE      : NEAR   ; PL/M
EXTRN    _time             : NEAR   ; CDecl



         PAGE
         ;--------------------------------------------------------------------
         ;
         ; RECEIVE RAW BYTE
         ;
         ;--------------------------------------------------------------------
         JANUS_RawByte Proc Near

         ;
         ;--- Quick return of byte if it's already available
         ;
         call     READBYTE          ; Try to get a byte from FOSSIL
         or       ax, ax            ; Did we get one?
         jl       $AGAIN            ; Jump, if FOSSIL returned -1
         xor      ah, ah
         ret                        ; Return the byte read via FOSSIL


$AGAIN:  call     CARRIER           ; See if other end is still alive
         or       ax, ax            ; Are we connected?
         je       $QkDCD            ; Jump, if not

         cmp      BYTE PTR JANUS_WaitFlag, 0
         je       $QkDATA

         ;
         ;--- Install a failsafe timer
         ;
         push     bp                ; Setup stack space for a local variable
         mov      bp, sp
         sub      sp, 6

         MSW_Time equ (Word Ptr [bp-2])
         LSW_Time equ (Word Ptr [bp-4])

         xor      ax, ax            ; Get the current time
         push     ax
         call     _time
         add      sp, 2

         add      ax, JANUS_TimeoutSecs
         adc      dx, 0

         mov      LSW_Time, ax      ; Save the timeout value
         mov      MSW_Time, dx

         ;
         ;--- LOOP: Wait for byte
         ;
$TOP:    call     READBYTE          ; Ask for a byte from FOSSIL
         or       ax, ax            ; Did FOSSIL give us something?
         jl       $NXT              ; Jump if we don't have a value yet
         xor      ah, ah            ; Strip AH in case there's debris
$DONE:   mov      sp, bp            ; AX assumed to have return value
         pop      bp
         ret

$NXT:    call     CARRIER
         or       ax, ax
         je       $NoDCD            ; Jump, if we lost carrier

         call     TIME_RELEASE      ; Be kind to multitaskers

         xor      ax, ax            ; Check the time
         push     ax
         call     _time             ; Get UNIX-style timestamp (MsC routine)
         add      sp, 2             ; Time is a CDECL routine

         cmp      dx, MSW_Time
         jl       $TOP
         jne      $NOTHING
         cmp      ax, LSW_Time
         jbe      $TOP
                                    ; Fallthrough, if timed out

$NOTHING:mov      ax, NODATA
         jmp      $DONE

$NoDCD:  mov      ax, NOCARRIER
         jmp      $DONE

$QkDCD:  mov      ax, NOCARRIER
         ret

$QkDATA: mov      ax, NODATA
         ret


         JANUS_RawByte ENDP





         PAGE
         ;--------------------------------------------------------------------
         ;
         ; JANUS_GetCookedByte
         ;
         ; Receive cooked escaped byte translated to avoid various problems.
         ; Returns raw byte, BUFEMPTY, PKTSTRT, PKTEND, or NOCARRIER.
         ;
         ;--------------------------------------------------------------------
         JANUS_GetCookedByte Proc Near

         ;
         ;--- Grab a byte from FOSSIL
         ;
         call     JANUS_RawByte              ; <-- (strips AH unless flag)
         cmp      ax, DLE                    ; Is it too raw?
         je       $DLE                       ; Jump, if we need to process
         ret                                 ; Otherwise, return the value

         ;
         ;--- Process an escaped byte
         ;
$DLE:    push     di

         mov      al, JANUS_WaitFlag         ; Preserve original WaitFlag
         mov      di, ax                     ; Keep it in a safe place (AH=junk)
         mov      JANUS_WaitFlag, 1          ; Force Janus to wait for byte

         ;
         ;--- Get a second byte from FOSSIL
         ;
         call     JANUS_RawByte
         or       ax, ax                     ; If (Raw<0) it's a flag
         jl       $DLEdone                   ; Jump, if Raw is a flag

         ;
         ;--- Cook the byte
         ;
         xor      ax, 40H

         ;
         ;--- Check for special values
         ;
         cmp      al, PKTSTRTCHR
         je       $PktStrt

         cmp      al, PKTENDCHR
         je       $PktEnd

         ;
         ;--- Clean up our mess and return the DLE'd character
         ;
$DLEdone:mov      bx, di                     ; Restore WaitFlag
         mov      JANUS_WaitFlag, bl
         pop      di
         ret

         ;
         ;--- Setup return value for PACKET START
         ;
$PktStrt:mov      ax, PKTSTRT
         jmp      SHORT $DLEdone

         ;
         ;--- Setup return value for PACKET END
         ;
$PktEnd: mov      ax, PKTEND
         jmp      SHORT $DLEdone


         JANUS_GetCookedByte EndP



END
