
(*
 * COPYRIGHT 1992 SAMUEL H. SMITH
 * ALL RIGHTS RESERVED
 *
 * THIS DOCUMENT CONTAINS CONFIDENTIAL INFORMATION AND TRADE SECRETS
 * PROPRIETARY TO SAMUEL H. SMITH DBA THE TOOL SHOP.
 *
 *)


(*
 * Helpme - Help On Tap support unit
 *          Runtime support for data generated by PrepHelp program.
 *
 *)

unit Helpme;

interface
   uses Crt, DispEdit;

const
   maxsub = 7;
   maxkey = 200;
   keylen = 30;

{$i language.inc}

{$ifdef LANG_ENGLISH}
   helptopic = ' Help topic: ';
{$endif}
{$ifdef LANG_GERMAN}
   helptopic = ' Befehl: ';
{$endif}

type
   keyword_rec = record
      loc:           word;
      width,lines:   byte;
      id:            string[keylen];
   end;

   sublist_rec = array[1..maxsub] of byte;

   procedure display_help_screen(x,y:    integer;
                                 keyno:  byte;
                                 var     keytab;
                                 var     htext;
                                 extra:  integer);

   procedure help_on_tap(level:  integer;
                         x,y:    integer;
                         keyno:  byte;
                         var     keytab;
                         var     htext);


implementation

   procedure display_help_screen(x,y:    integer;
                                 keyno:  byte;
                                 var     keytab;
                                 var     htext;
                                 extra:  integer);
   var
      keywords:   array[1..maxkey] of keyword_rec absolute keytab;
      help_text:  array[1..maxint] of byte absolute htext;
      p:          integer;
      str:        ^string;

   begin
      with keywords[keyno] do
      begin
         window(1,1,80,25);
         setattr(prompt_attr (*border_attr*));

         while x+width+3 > 79 do
            dec(x);
         while y+lines+2 > 25 do
            dec(y);
         display_border(x,y,x+width+3,y+lines+1+extra,single_border);

         setattr(title_attr);
         gotoxy(x+(width-length(id)-13) div 2,y);
         write(helptopic+id+' ');

         window(x+1,y+1,x+width+2,y+lines+extra);
         setattr(prompt_attr);
         clrscr;

         p := loc+maxsub;
         while true do
         begin
            str := @help_text[p];
            if str^ = #0 then
               exit;
            if (p <> loc+maxsub) then
               writeln;
            disp(' '+str^);
            inc(p,length(str^)+1);
         end;
      end;
   end;


   procedure help_on_tap(level:  integer;
                         x,y:    integer;
                         keyno:  byte;
                         var     keytab;
                         var     htext);
   var
      keywords:   array[1..maxkey] of keyword_rec absolute keytab;
      help_text:  array[1..maxint] of byte absolute htext;
      disp:       ^display_image_rec;
   const
      ex:         char = '?';


      procedure process_subtopics;
      var
         subs: ^sublist_rec;
         fld:  integer;
         xx:   sublist_rec;
         escx: integer;

      begin
         writeln;
         with keywords[keyno] do
         begin
            setattr(input_attr);

            subs := @help_text[loc];
            for fld := 1 to maxsub do
            begin
               xx[fld] := wherex+1;
               if subs^[fld] > 0 then
               with keywords[subs^[fld]] do
               begin
                  gotoxy(wherex+1,wherey);
                  write(' '+id+' ');
               end;
            end;

            escx := wherex+1;
            fld := maxsub+2;
            ex := DOWN;
            if keyno <> 1 then
               edit_funkey(display,escx,wherey,'Index',F1,ex);

            repeat
               if (fld = maxsub+1) and (keyno <> 1) then
                  edit_funkey(edit,escx,wherey,'Index',F1,ex)
               else

               if fld = maxsub+2 then
                  edit_funkey(edit,escx+8,wherey,'ESC',ESC,ex)
               else

               if subs^[fld] > 0 then
                  with keywords[subs^[fld]] do
                  begin
                     edit_funkey(edit,xx[fld],wherey,
                        id,chr(fld+ord(CTRL_F1)),ex);
                     if (ex >= CTRL_F2) and (ex <= chr(maxsub+ord(CTRL_F1))) then
                        fld := ord(ex)-ord(CTRL_F1);
                  end;

               ex := upcase(ex);
               case ex of
                  RIGHT,' ':     ex := DOWN;
                  ^H,DEL,LEFT:   ex := UP;
               end;
               select_next_entry(edit,fld,maxsub+2,ex);

               if (ex >= CTRL_F2) and (ex <= chr(maxsub+ord(CTRL_F1))) then
                  if (subs^[fld] > 0) then
                  begin
                     help_on_tap(level+1,x+2,y+1,subs^[fld],keytab,htext);
                     if ex = ESC then
                        ex := '?';
                  end;

            until (ex = ESC) or (ex = F1);
         end;
      end;


   begin
      new(disp);
      save_display(disp^);

      repeat
         shadow_display;
         display_help_screen(x,y,keyno,keytab,htext,1);
         process_subtopics;

         if (ex = F1) and (level = 1) then
         begin
            keyno := 1;
            ex := '?';
         end;

         restore_display(disp^);
      until (ex = ESC) or (ex = F1);

      dispose(disp);
   end;

end.

