/* Dedis Library fr Door-Programme */
/* in C                             */
/* Detlef Plei, 12.6.95            */

#include <dos.h>
#include <fcntl.h>
#include <share.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "dptypes.h"
#include "door.h"

//static DOORSYS  doorsys;
static WORD     inport;
static BOOLEAN  windetected=FALSE;

/*-----------------06-12-95 03:06pm-----------------
 Windows
--------------------------------------------------*/

BOOLEAN winactive(void) {
  windetected=(getenv("winbootdir")!=NULL);
  return(windetected);
}
/*  asm {
    mov     ax,352Fh                ; We are about to clobber them
    int     21h                     ; DOS get vector for 2Fh
    mov     ax,es                   ; ES:BX = vector
    or      ax,bx                   ; So let's see if there is one
    jz      got_windows             ; Nope, so return the zero
; Int 2f will work. So let's do it.
    mov     ax, 1600h               ; test for Windows
    int     2fh                     ; Go do the test
    and     ax, 007fh               ; Mask off bit so 80 is same as 0
; Result is now zero if not windows and nonzero if windows. Good enough.
    mov     windetected,al
got_windows:
  }
} */

void winidle(void) {
  asm {
    mov     ax,1680h
    int     2fh
  }
}

/*-----------------06-12-95 03:06pm-----------------
 ASCII's / Dropfiles
--------------------------------------------------*/

BOOLEAN getline(WORD handle,char* buffer) {
  char c;
  WORD numread;

  do {
    _dos_read(handle,&c,1,&numread);
    if(numread!=1) {
      return(FALSE);
    }
    if(c==13) {
      *buffer=0;
      _dos_read(handle,&c,1,&numread);
      if(numread!=1) {
        return(FALSE);
      }
      return(TRUE);
    }
    *(buffer++)=c;
  } while(1);
}

/*-----------------06-12-95 03:07pm-----------------
 Fossil
--------------------------------------------------*/

WORD fos_setbaud(WORD port,WORD baud) {
  WORD code;

  switch(baud) {
    case 300:
      code=0x43;
      break;
    case 600:
      code=0x63;
      break;
    case 1200:
      code=0x83;
      break;
    case 2400:
      code=0xA3;
      break;
    case 4800:
      code=0xC3;
      break;
    case 9600:
      code=0xE3;
      break;
    case 14400:
    case 19200:
      code=0x03;
      break;
    case 38400:
      code=0x23;
      break;
  }
  asm {
    mov ax,code
    mov dx,port
    dec dx
    int 14h
  }
}

WORD fos_trans(WORD port,char c) {
  asm {
    mov ah,1
    mov al,c
    mov dx,port
    dec dx
    int 14h
  }
}

char fos_recv(WORD port) {
  asm {
    mov ah,2
    mov dx,port
    dec dx
    int 14h
  }
}

WORD fos_status(WORD port) {
  asm {
    mov ah,3
    mov dx,port
    dec dx
    int 14h
  }
}

WORD fos_init(WORD port) {
  asm {
    mov ah,4
    mov dx,port
    dec dx
    int 14h
  }
}

void fos_exit(WORD port) {
  asm {
    mov ah,5
    mov dx,port
    dec dx
    int 14h
  }
}

void fos_dtr(WORD port,BYTE dtr) {
  asm {
    mov ah,6
    mov al,dtr
    mov dx,port
    dec dx
    int 14h
  }
}

//    AH = 07h    Return timer tick parameters

void fos_flushout(WORD port) {
  asm {
    mov ah,8
    mov dx,port
    dec dx
    int 14h
  }
}

void fos_purgeout(WORD port) {
  asm {
    mov ah,9
    mov dx,port
    dec dx
    int 14h
  }
}

void fos_purgein(WORD port) {
  asm {
    mov ah,0ah
    mov dx,port
    dec dx
    int 14h
  }
}

WORD fos_transnowait(WORD port) {
  asm {
    mov ah,0bh
    mov dx,port
    dec dx
    int 14h
  }
}

WORD fos_peek(WORD port) {
  asm {
    mov ah,0ch
    mov dx,port
    dec dx
    int 14h
  }
}

WORD fos_kbdrec(void) {
  asm {
    mov ah,0dh
    int 14h
  }
}

WORD fos_kbdrecwait(void) {
  asm {
    mov ah,0eh
    int 14h
  }
}

fos_flow(WORD port,BOOLEAN xonxoff,BOOLEAN rtscts) {
  BYTE maske;

  maske=0xf0;
  if(xonxoff) maske|=8; // 9 wre receive und transmit
  if(rtscts)  maske|=2;
  asm {
    mov ah,0fh
    mov al,maske
    mov dx,port
    dec dx
    int 14h
  }
}

//    AH = 10h    Extended Control-C / Control-K checking and transmit on/off
//    AH = 11h    Set current cursor location.
//    AH = 12h    Read current cursor location.
//    AH = 13h    Single character ANSI write to screen.
//    AH = 14h    Enable or disable watchdog processing
//    AH = 15h    Write character to screen using BIOS support routines
//    AH = 16h    Insert or delete a function from the timer tick chain
//    AH = 17h    Reboot system
//|   AH = 18h    Read block (transfer from FOSSIL to user buffer)
//|   AH = 19h    Write block (transfer from user buffer to FOSSIL)
//|   AH = 1Ah    Break begin or end
//|   AH = 1Bh    Return information about the driver
//|   AH = 7Eh    Install an "external application" function
//|   AH = 7Fh    Remove an "external application" function


/*-----------------06-12-95 03:07pm-----------------
 Serial
--------------------------------------------------*/

BOOLEAN checkfosport(WORD port,WORD baud) {
  WORD x;

  if(fos_init(port)==0x1954) {
    fos_setbaud(port,baud);
    fos_flow(port,FALSE,TRUE); // XON/RTS
    return(TRUE);
  }
  return(FALSE);
}

void sendstring(WORD port,char* string) {
  char c;

  do {
    c=*string++;
    if(c) fos_trans(port,c);
    if(windetected) winidle();
  } while(c);
}

void print(char* string) {
  printf(string);
  if(inport) {
    sendstring(inport,string);
  }
}

void recvline(WORD port,char* buffer) {
  char c;
  time_t  startzeit,actzeit;

  time(&startzeit);
  time(&actzeit);
  do {
    while(((fos_status(port)&256)!=256)) {  // wenn kein Zeichen anliegt
      time(&actzeit);
      if(windetected) winidle();
      if(actzeit-startzeit>(time_t)1) break;
    }
    time(&actzeit);
    if(actzeit-startzeit>(time_t)1) break;
    c=fos_recv(port);
    if(c==13) {
      *buffer=0;
      break;
    }
    if(c==10) {
      *buffer=0;
      break;
    }
    *(buffer++)=c;
  } while(TRUE);
}

void sleep(time_t seconds) {
  time_t starttime,testtime;

  time(&starttime);
  testtime=starttime;
  while(testtime<(starttime+seconds)) {
    if(windetected) winidle();
    time(&testtime);
  }
}

WORD waitfor(WORD port,DWORD timeout,char* text,BOOLEAN show) {
  WORD   ergebnis,zaehler,slen;
  time_t startsecs,actsecs;
  char   buffer[80];
  char   c;
  char*  ptr;

  time(&startsecs);
  actsecs=startsecs;
  slen=strlen(text);
  buffer[slen]=0;
  ptr=buffer;
  ergebnis=0;
  while((actsecs-startsecs)<(time_t)timeout) {
    while(((fos_status(port)&1)!=1)) {  // wenn kein Zeichen anliegt
      if(windetected) winidle();
      if((fos_status(port)&128)!=128) break;
      time(&actsecs);
      if(actsecs-startsecs>(time_t)timeout) break;
    }
    if((fos_status(port)&128)!=128) break;
    if(actsecs-startsecs>(time_t)timeout) break;
    c=(fos_recv(port)&0x7f);
    if(show) printf("%c",c);
    if(ptr==buffer+slen) {
      ptr=buffer;
      for(zaehler=0;zaehler<slen;zaehler++) {
        *ptr=*(ptr+1);
        ptr++;
      }
      ptr--;
    }
    *ptr++=c;
    if(strcmp(buffer,text)==0) {
      ergebnis=1;
      break;
    }
  }
  return(ergebnis);
}
