#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <ctype.h>
#include <winsock.h>

BOOL getline(int handle,LPSTR buffer) {
  char c;

  do {
    if(read(handle,&c,1)!=1) return(FALSE);
    if(c==13) {
      *buffer=0;
      if(read(handle,&c,1)!=1) return(FALSE);
      return(TRUE);
    }
    *(buffer++)=c;
  } while(TRUE);
}

int main(int argc,char** argv) {
  char            buffer[200];
  char            buffer2[200];
  int             hFile;
  WSADATA         wsaData;
  SOCKET          hListenSocket;
  SOCKADDR_IN     sockAddr;
  unsigned short  portnumber;
  fd_set          readfds;
  SOCKET          ClientSocket;
  int             iAddrLength=sizeof(SOCKADDR_IN);

  printf("DummyFTP, Freeware, by Detlef Pleiss\r\n");
  if(argc<3) {
    printf("USAGE: dummyftp <path to message file> <port number in decimal>\r\n");
    return 0;
  }

  if((hFile=open(argv[1],O_BINARY+O_RDONLY))==-1) {
    wsprintf(buffer,"could not open %s for reading\r\n",(LPSTR)argv[1]);
    printf(buffer);
    return 0;
  } else {
    close(hFile);
  }

  if(WSAStartup(0x0101,&wsaData)) {
    printf("could not open Windows Sockets\r\n");
    return 0;
  }

  if((hListenSocket=socket(PF_INET,SOCK_STREAM,IPPROTO_TCP))==INVALID_SOCKET) {
    printf("could not create server socket\r\n");
    WSACleanup();
    return 0;
  }

  portnumber=atoi(argv[2]);

  sockAddr.sin_family     =AF_INET;
  sockAddr.sin_port       =htons(portnumber);
  sockAddr.sin_addr.s_addr=INADDR_ANY;
  if(bind(hListenSocket,(LPSOCKADDR)&sockAddr,sizeof(sockAddr))) {
    wsprintf(buffer,"could not bind server socket to port %d\r\n",portnumber);
    printf(buffer);
    closesocket(hListenSocket);
    WSACleanup();
    return 0;
  }

  if(listen(hListenSocket,5)) {
    printf("cannot listen on server socket\r\n");
    closesocket(hListenSocket);
    WSACleanup();
    return 0;
  }

  wsprintf(buffer,"DummyFTP now listening for connections on port %d\r\n",portnumber);
  printf(buffer);
  printf("Press <ctrl-c> to quit\r\n");

  while(TRUE) {
    FD_ZERO(&readfds);
    FD_SET(hListenSocket,&readfds);
    if(select(0,&readfds,NULL,NULL,NULL)>0) {
      if((ClientSocket=accept(hListenSocket,(LPSOCKADDR)&sockAddr,(LPINT)&iAddrLength))!=INVALID_SOCKET) {
        printf("incoming connection from ");
        printf(inet_ntoa(sockAddr.sin_addr));
        printf(" ... ");
        if((hFile=open(argv[1],O_BINARY+O_RDONLY))!=-1) {
          while(getline(hFile,buffer2)) {
            strcpy(buffer,"421-");
            strcat(buffer,buffer2);
            strcat(buffer,"\r\n");
            send(ClientSocket,buffer,strlen(buffer),0);
          }
          close(hFile);
          strcpy(buffer,"421 Service not available, closing control connection.\r\n");
          send(ClientSocket,buffer,strlen(buffer),0);
        }
        closesocket(ClientSocket);
        printf("closed\r\n");
      }
    }
  }
}
