/* DPFLT.C by Detlef Pleiss Dec-2-1997       */
/* Converting PowerBBS floating point values */
/* from and to IEEE floating point format    */
/* and from and to 32 bit integers           */
/* based on code published by Ronny Brodin   */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

/* Structures and routines to convert between MSB and IEEE floats. */

struct MS_B {
    unsigned long
        mant : 23,
        sign : 1,
        exp : 8;
};

struct MS_IEEE {
    unsigned long
        mant : 23,
        exp : 8,
        sign : 1;
};

float _export WINAPI DPFLT_PBBSTOSINGLE(float x) {
    float y;
    struct MS_IEEE *m=(struct MS_IEEE *)&y;
    struct MS_B *n=(struct MS_B *)&x;

    m->sign=n->sign;
    m->exp=n->exp;
    m->mant=n->mant;
    if(((char *)&y)[3]) ((char *)&y)[3]--;
    return(y);
}

float _export WINAPI DPFLT_SINGLETOPBBS(float x) {
  float y;
  struct MS_B *m=(struct MS_B *)&y;
  struct MS_IEEE *n=(struct MS_IEEE *)&x;

  if(((char *)&x)[3]) ((char *)&x)[3]++;
  m->sign=n->sign;
  m->exp=n->exp;
  m->mant=n->mant;
  return(y);
}

float _export WINAPI DPFLT_INTTOPBBS(long int myint) {
  return(DPFLT_SINGLETOPBBS(myint));
}

long int _export WINAPI DPFLT_PBBSTOINT(float myfloat) {
  return(DPFLT_PBBSTOSINGLE(myfloat));
}

#ifdef __NT__
int _export WINAPI LibMain(HANDLE hinstance,DWORD reason,LPVOID reserved) {
#else
int _export WINAPI LibMain(HANDLE hinstance,WORD wdataseg,WORD cbheapsize,LPSTR lpszcmdline) {
#endif
  return 1;
}
