/* USERS.H - Definition of the USERS file structure        */
/* Original code taken from from POWRDLL.H by Russell Frey */
/* Modified by Detlef Pleiss Dec-4-1997                    */
/* to reflect the latest status of the structure           */
/* added comments telling the offsets into the structure   */
/* this is only the structure of USERS records, other      */
/* structures that are defined in the original POWRDLL.H   */
/* are left out here                                       */

#pragma pack(1)         /* Assume byte packing throughout */

/****************************************************************************/
/* PowerBBS Development Add-On DLL                                          */
/* (c) 1994 by Russell E. Frey                                              */
/*                                                                          */
/* This source code may be freely distributed.                              */
/* You may create a 3rd party DLL add-on to PowerBBS, and                   */
/* distribute it ROYALTY FREE.                                              */
/*                                                                          */
/* You may even modify this code and distribute it, so long as you          */
/* note the modifications at the top of the code and keep ALL the           */
/* comments here at the top.                                                */
/*                                                                          */
/* Be sure to announce your product on our BBS: 516-822-7396 and/or         */
/* distribute shareware versions of your DLL on our BBS.  We will do        */
/* our best to help you distribute your product!                            */
/*                                                                          */
/* If you translate this code to a different language, please consider      */
/* making your translation FREEWARE and upload it to the BBS.  Be sure      */
/* to thoroughly debug your translation (you do not want to mess up         */
/* the users record or they will not be happy!)                             */
/*                                                                          */
/* This code can easily be translated to ANY language capable to make a DLL */
/* To run this DLL, in PowerBBS MENU SETUP at the CGM option place a D [For */
/* DLL!].  Then in the description of command put the NAME of the actual    */
/* DLL created.  For example this file: POWRDLL.DLL would be placed in      */
/* the description.                                                         */
/*                                                                          */
/* When a user now selects the command PowerBBS will dynamically load       */
/* POWRDLL.DLL.  It will execute VERY FAST.  This is an easy way to create  */
/* a 3rd party add-on as if it was written inside of PowerBBS!  The user    */
/* will notice NO SLOWDOWN!                                                 */
/*                                                                          */
/* PowerLang's RUN_DLL command may also be used to execute the DLL          */
/*                                                                          */
/* We welcome ALL your comments on the Power of PowerBBS's DLL              */
/* We also welcome any questions you might have, but due to time            */
/* constraints may not be able to help you in some cases (including         */
/* debugging your code, etc).                                               */
/*                                                                          */
/* Be aware that this product is provided AS IS.  We are not                */
/* liable for ANY problems this DLL may cause.                              */
/*                                                                          */
/****************************************************************************/


/*-----------------------------------------------------------------------------*/
/* User types to directly manipulate user information.                         */
/* NEVER MANIPULATE any information unless you are SURE of what you are doing! */
/*-----------------------------------------------------------------------------*/

/* Notes for 'C' DLL developers:                                             */
/* Define a couple of commonly used string sizes. Note that Pascal uses      */
/* two types of strings, one where all bytes in the string contains the      */
/* actual data, and one where the first byte is a length byte and the        */
/* following contains that number of characters. In the following            */
/* structures, where the second type of strings are used these are           */
/* declared in the 'C' struture as:                                          */
/*     unsigned char HelloLen[1];                                            */
/*     char Hello[30];                                                       */
/* The support function in the PowerDLL.C, LPSTR PascalToCString (), is used */
/* to extract this type of string. The pointer, PascalString, should point   */
/* to the length byte, HelloLen in above example. The Max parameter for this */
/* function indicates the maximum length of the buffer, supplied by the      */
/* caller, to prevent buffer overrun.                                        */

typedef char Packed2Chars[2];
typedef char Packed3Chars[3];
typedef char Packed4Chars[4];
typedef char Packed5Chars[5];
typedef char Packed6Chars[6];
typedef char Packed7Chars[7];
typedef char Packed8Chars[8];
typedef char Packed9Chars[9];
typedef char Packed10Chars[10];
typedef char Packed11Chars[11];
typedef char Packed12Chars[12];
typedef char Packed13Chars[13];
typedef char Packed14Chars[14];
typedef char Packed15Chars[15];
typedef char Packed16Chars[16];
typedef char Packed19Chars[19];
typedef char Packed20Chars[20];
typedef char Packed23Chars[23];
typedef char Packed24Chars[24];
typedef char Packed25Chars[25];
typedef char Packed30Chars[30];
typedef char Packed32Chars[32];
typedef char Packed35Chars[35];
typedef char Packed39Chars[39];
typedef char Packed40Chars[40];
typedef char Packed45Chars[45];
typedef char Packed78Chars[78];
typedef char Packed128Chars[128];

/* Specification of the PowerUser_Rec. variable which stores the current */
/* users information.                                                    */
/* \powrbbs\data\users                                                   */
typedef struct _tagPowrUserRecord {     /* Offset   Comment                            */
  Packed25Chars name;                   /* 0 - 24   Name                               */
  Packed20Chars Location;               /* 25       City/Location                      */
  Packed15Chars Computer;               /* 45       Computer Type                      */
  Packed14Chars Phone_Number;           /* 60       Phone Number Home                  */
  Packed10Chars Password;               /* 74       Password                           */
  Packed8Chars  Birthday;               /* 84       Date of birthday, MM/DD/YY         */
  Packed8Chars  First_Call;             /* 92       Date of first call, MM/DD/YY       */
  Packed8Chars  Last_File_Scan;         /* 100      Date of last file search, MM/DD/YY */
  Packed8Chars  Expiration_Date;        /* 108      Expiration Date, MM/DD/YY          */
  Packed8Chars  Last_Call;              /* 116      Date of last call, MM/DD/YY        */
  Packed5Chars  Last_Time;              /* 124      Time of last call, HH:MM           */
  short int     Calls;                  /* 129      Total number of calls              */
  short int     uploads;                /* 131      Total number of uploads            */
  short int     downloads;              /* 133      Total number of downloads          */
  short int     Time_On;                /* 135-136  Minutes used TODAY                 */
  float         Dummy_Today_Bytes;      /* 137      originally 8 bytes double          */
  float         Today_Bytes;            /*    -144  Bytes downloaded TODAY             */
  float         Dummy_Download_Bytes;   /* 145      originally 8 bytes double          */
  float         Download_Bytes;         /*    -152  Total bytes downloaded             */
  float         Dummy_Upload_Bytes;     /* 153-     originally 8 bytes double          */
  float         Upload_Bytes;           /*     160  Total bytes uploaded               */
  long int      uNum;                   /* 161-164                                     */
  unsigned short int Pics_For_Today;    /* 165-166                                     */
  char          Flags_Initialized;      /* 167      If set to #188 then initialized    */
  char          Flags[10];              /* 168                                         */
  char          JUNK[300];              /* 178                                         */
  char          PersonalSysopUse[156];
  short int     UpToFlist;
  char          UpdatedDate[9];
  char          StartDate[9];
  char          PersMegSpaceInit;       /* 654      set to 10                          */
  short int     PersMegSpace;           /* 655      Megs                               */
  long int      jc_Points;              /* 657                                         */
  short int     jc_Pmatch;
  char          jc_Pblaster;
  unsigned char jc_DPPP;                /*          244 if ever used DPPP              */
  char          jc_junk1;
  char          jc_junk2;
  short int     Allow_PersULDLDir;      /* 667      if = 23521 then TRUE               */
  char          PersULDlDir_len;        /* 669                                         */
  char          PersULDlDir[150];       /* 670                                         */
  char          HasSetWWWMsgs;          /* 671      if = 233                           */
  short int     SetWWWMsgsCount;
  unsigned short int HasINetAddress;    /*          21200 = on                         */
  char          INetAddress[100];
  char          CountPres;              /*          set to #133                        */
  long int      NumPreviews;
  char          ReservedPB;
  short int     ExtendedAddress;        /*          if = 23016                         */
  char          ExtendedState[30];
  char          LastConnectType;        /*          1: ANSI; 2: PA; 3: ASCII 4: DPPP   */
  long int      KDownload_Maximum;
  long int      PowerPlay_Points;
  Packed8Chars  LastPlayed;
  char          Initted_PowerPlay;
  unsigned char Qwk_Init;
  unsigned char QWK_Flag1,
                QWK_Flag2;
  unsigned short int QWK_Flag3,
                QWK_Flag4;
  unsigned char internaluse;
  unsigned short int waiting_messages;  /*          number of messages waiting         */
  unsigned char reservedb;
  long int      reservedl;
  unsigned char handle_new;
  unsigned char info_in_new_numbs;      /*          if<>200 then just junk in next fields */
  char          chat_use_handle;
  char          qwk_msg_use_handle;
  Packed14Chars data_phone;             /* 1000                                        */
  Packed14Chars business_number;        /* 1014                                        */
  Packed14Chars fax_number;             /* 1028                                        */
  unsigned char bchat_exit;             /* 1042     if=200 use string                  */
  char          chat_exit_len;          /* 1043     length of chat exit string         */
  char          chat_exit[60];          /* 1044                                        */
  unsigned char bchat_entry;            /* 1104     if=200 use string                  */
  char          chat_entry_len;         /* 1105     length of chat entry string        */
  char          chat_entry[60];         /* 1106                                        */
  unsigned char Access;                 /* 1166     Access Level                       */
  unsigned char Expiration_Access;      /* 1167     Expired Access Level               */
  unsigned char Screen_Lines;           /* 1168     Length of a page                   */
  unsigned char Safe_Total;             /* 1169     Time in Bank                       */
  unsigned char Options;                /* 1170     Option bits                        */
                                        /*          bit value 1=expert; 4=dead; 8=hasmail */
                                        /*          16=TRUE,64=TRUE then 32=TRUE[MALE];FALSE[FEMALE] */
  char          Xproto;                 /* 1171     Protocol                           */
  char          Monitor_Type;           /* 1172     Monitor (M)onocrome (C)olor (N)one */
  unsigned short int Messages_Left;     /* 1173     total messages left by user        */
  float         Dummy_downbytes_month;  /* 1175     originally 8 bytes double          */
  float         downbytes_month;        /*    -1182 total bytes downloaded/month       */
  unsigned char downbytesmonth;         /* 1183     in month (1-12)                    */
  unsigned short downbytes_month_max;   /* 1184     max downbytes/month                */
  Packed5Chars  truebps2;               /* 1186     true baud rate                     */
  unsigned char lang_num;               /* 1191     current language number            */
  unsigned char is_focused;             /* 1192     used internally                    */
  unsigned char powercomm_connect;      /* 1193     true if PowerComm connect          */
  unsigned char color_mode_connect;     /* 1194     true if PowerComm/color_mode connect */
  unsigned char last_forum_on2;         /* 1195     last forum joined                  */
  long int      credits;                /* 1196     amount of credits left             */
  char          anony_name_len;         /* 1200     Junk                               */
  char          anony_name2[15];        /* 1201     JUNK                               */
  char          script[37];             /* 1216     used for scripts                   */
  char          auto_forum_join_set;    /* 1253     = 10 means use auto forum join!    */
  short int     auto_forum_join;        /* 1254                                        */
  unsigned char set_up_int_msgs;        /* 1256     = 10 if use next two options!      */
  unsigned short max_internet_msgs_month; /* 1257                                      */
  unsigned short current_internet_msgs_month; /* 1259                                  */
  unsigned char the_internet_month;     /* 1261                                        */
  unsigned char allow_FTPmail;          /* 1262     allow if = 10                      */
  unsigned short dollars;               /* 1263                                        */
  unsigned char call_verified;          /* 1265                                        */
  char          anonymous_name[20];     /* 1266                                        */
  char          has_anonyname;          /* 1286     if true, set to 10                 */
  char          has_address;            /* 1287     if true, set to 10                 */
  char          last_menu_code;         /* 1288                                        */
  char          QWK_Net_User;           /* 1289     if true, set to 10                 */
  char          area_backnum[3];        /* 1290                                        */
  short int     last_forum_on;          /* 1293                                        */
  char          created_rec;            /* 1295     if true, set to 10                 */
  unsigned short int PowerUser_Ext_Num; /* 1296     pointer to USERS.2 record          */
  char          address[50];            /* 1298     address (location above)           */
  char          state[10];              /*          state                              */
  char          zip[10];                /*          zip                                */
  char          call_backnum[7];        /*          Called Number                      */
} POWRUSER_RECORD;  /* 1375 bytes per record */

typedef POWRUSER_RECORD far * LPPOWRUSER_RECORD;
