#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>

#define MYSUBKEY    "Software\\DPSoft\\CMPAL"
#define MYVALUENAME "PaccPath"

BOOL CheckRM(LPSTR lpszFileName) {
  DWORD dwHold;

  SetErrorMode(SEM_FAILCRITICALERRORS);
  dwHold=GetFileAttributes(lpszFileName);
  SetErrorMode(0);
  if(dwHold!=0xFFFFFFFF ) return(TRUE);
  return(FALSE);
}

void SearchForPacc(LPSTR lpszFileName) {
  DWORD dwDriveMask;
  char  lpszRootPathName[4]="?:\\";
  UINT  DriveType;

  dwDriveMask=GetLogicalDrives();
  for(lpszRootPathName[0]='a';lpszRootPathName[0]<='z';lpszRootPathName[0]++) {
    if(dwDriveMask&1) { // drive exists
      DriveType=GetDriveType(lpszRootPathName);
      // Unknown / No root dir / Removable / Fixed / Remote / CD-ROM / Ramdisk
      if(DriveType==0 ||
         DriveType==1 ||
         DriveType==DRIVE_REMOVABLE ||
         DriveType==DRIVE_REMOTE ||
         DriveType==DRIVE_CDROM) {      // if so, skip over it
      } else {                          // else, see wether PowerAccess is there
        strcpy(lpszFileName,lpszRootPathName);
        strcat(lpszFileName,"POWRACC\\POWRACC.EXE");
        if(CheckRM(lpszFileName)) {     // it is!
          break;
        } else {                        // or it's not ...
          lpszFileName[0]=0;
        }
      } // check that drive or not
    } // drive exists
    dwDriveMask>>=1;                    // ... then on to the next drive
  }
}

void main(void) {
  char  szFileName[MAX_PATH];
  DWORD valuelen=MAX_PATH;
  DWORD regType;
  HKEY  hkey;

  regType=RegOpenKey(HKEY_CURRENT_USER,MYSUBKEY,&hkey);  // did we find it before?
  if(regType==ERROR_SUCCESS) {
    if(RegQueryValueEx(hkey,MYVALUENAME,NULL,&regType,szFileName,&valuelen)==ERROR_SUCCESS) {
      if(regType!=REG_SZ) {             // might still be the wrong key type
        szFileName[0]=0;
      }
    } else {                            // key found, but not the value
      szFileName[0]=0;
    }
    RegCloseKey(hkey);
  } else {                              // nope, no key in the registry
    szFileName[0]=0;
  }

  if((szFileName[0]==0) || (!CheckRM(szFileName))) { // not found in the registry or PowerAccess is not really there
    SearchForPacc(szFileName);          // then do the search
  }

  if(szFileName[0]) {                   // in which way whatsoever, we found something ... somewhere ...
    if(RegCreateKey(HKEY_CURRENT_USER,MYSUBKEY,&hkey)==ERROR_SUCCESS) {  // next time try this first!
      RegSetValueEx(hkey,MYVALUENAME,NULL,REG_SZ,szFileName,strlen(szFileName)+1);
      RegCloseKey(hkey);
    }
    WinExec(szFileName,SW_SHOW);        // ... so let's launch it!
  }
}
