Program LogView;

Uses
 Windos,
 PCEKiTL,
 pkMISC,
 pkTIMER;

const
 version                    = '2.O.2'; {Version number}

 timeafterbeingbored : byte = 7;
 talktextlines              = 6;
 textstrings   : array [1..talktextlines] of string[79] =
 ('what are you waiting for? PcExpress v1.4? anyway I quess you want some info',
  'about this door...that''s too bad coz I have noting to say about it.',
  'Watch out for the next version of TheTag, version 1.25 which is guaranteed',
  'to make you fall off your chair...Greetz go to: Doc Holiday, Michael Feilen,',
  'Houlq, Morgoth and ofcourse the Creative Team crew, cu in the next CT release!',
  '- reset -');

type
 ConfigurationFile = Record
  colours    : array [1..2] of string[3];
  promptfile : string[80];
  password   : string[15];
 end;

 DataBase = Record
  page     : longint;
  position : longint;
 end;

var
 IOSave         : byte;
 cfg            : ConfigurationFile;
 timer          : eventtimer;
 log_f          : text;
 data_f         : file of database;
 data           : database;
 searchhits     : word;
 previouschoice : byte;
 viewtype       : byte;

 endreached     : boolean;
 currentsearch,
 currentpage    : word;

Procedure GetFileMode; Assembler;

ASM
        CLC
        CMP    ES:[DI].TTextRec.Mode, fmInput
        JE     @1
        MOV    [InOutRes], 104         { 'File not opened for reading' }
        XOR    AX, AX                  { Zero out function result }
        XOR    DX, DX
        STC
@1:
end;

Function TextFilePos(Var f : Text) : LongInt; Assembler;

ASM
        LES    DI, f
        CALL   GetFileMode
        JC     @1

        XOR    CX, CX                  { Get position of file pointer }
        XOR    DX, DX
        MOV    BX, ES:[DI].TTextRec.handle
        MOV    AX, 4201h
        INT    21h                     { offset := offset-BufEnd+BufPos }
        XOR    BX, BX
        SUB    AX, ES:[DI].TTextRec.BufEnd
        SBB    DX, BX
        ADD    AX, ES:[DI].TTextRec.BufPos
        ADC    DX, BX
@1:
end;

Procedure TextSeek(Var f : Text; n : LongInt); Assembler;

ASM
        LES    DI, f
        CALL   GetFileMode
        JC     @2

        MOV    CX, Word Ptr n+2        { Move file pointer }
        MOV    DX, Word Ptr n
        MOV    BX, ES:[DI].TTextRec.Handle
        MOV    AX, 4200h
        INT    21h
        JNC    @1                      { Carry flag = reading past EOF }
        MOV    [InOutRes], AX
        JMP    @2


        { Force read next time }
@1:     MOV    AX, ES:[DI].TTextRec.BufEnd
        MOV    ES:[DI].TTextRec.BufPos, AX
@2:
end;

function resetlogx : boolean;
var
 i : byte;

begin
 pkShareAssign(log_f,pkbbspath+'LOG'+pkintstr(pknode,0)+'.TXT',True,False);
 i:=0;
 repeat
  inc(i);
  {$I-} Reset(log_f); {$I+}
  IOSave:=IOResult;
 until (i > 20) or (IOSave=0);
 resetlogx:=(IOSave=0) and (I < 20);
end;

type
 getlogtype =
 (previouspage,
  nextpage,
  thispage,
  locatepage);

function getlogposition(event : getlogtype) : longint;
var
 i : byte;

begin
 pkShareFile(True,False);
 i:=0;
 repeat
  inc(i);
  {$I-} Reset(data_f); {$I+}
  IOSave:=IOResult;
 until (i > 20) or (IOSave=0);
 if IOSave <> 0 then begin
                      getlogposition:=-1;
                      exit;
                     end;

 if event in [previouspage,nextpage,thispage] then
 begin

  case event of
   previouspage : dec(currentpage);
   nextpage     : inc(currentpage);
   thispage     : ;
  end;

  if currentpage > 1 then seek(data_f,currentpage-1);
  read(data_f,data);
  endreached:=eof(data_f);
  close(data_f);
  currentsearch  := data.page;
  getlogposition := data.position;

 end
 else
 begin
  currentpage:=currentsearch-1;
  if currentsearch > 1 then seek(data_f,currentsearch-1);
  repeat
   inc(currentpage);
   read(data_f,data);
  until data.page=currentsearch;
  endreached:=eof(data_f);
  close(data_f);
  currentsearch  := data.page;
  getlogposition := data.position;
 end;

 getlogposition:=data.position;
end;

procedure drawlogo;
begin
 pkwriteln('@X02>-- __ ----------------------------------------------------------------- __ --<');
 pkwriteln('@X02|  _\/_            lOGVIEW v'+version+' bY @X0FmUGSHOT @X02of Creative Team           _\/_  |');
 pkwriteln('@X02`- \/\/ -------------------------------------------------------------- \/\/ -''');
end;

procedure displaymenu;
begin
 pkgotoxy(1,4);
 pkwrite(Esc+'[0J');
 pkwrite(cfg.colours[1]+'          your logfile   all logged users   search on username   exit'+Esc+'[0K');
end;

procedure readcfg;
var
 txt : text;
 str : string;
 i   : byte;
begin
 assign(txt,'LOGVIEW.CFG');
 i:=0;
 repeat
  inc(i);
  {$I-} Reset(txt); {$I+}
  IOSave:=IOResult;
 until (i > 20) or (IOSave=0);
 if i > 20 then
 begin
  pkwrite('|15 |07error reading the logview configuration file.');
  halt;
 end;

 i:=0;
 repeat
  readln(txt,str);
  if str[1] <> ';' then
  begin
   inc(i);
   case i of
    1..2 : cfg.colours[i] := str;
       3 : cfg.password   := str;
       4 : cfg.promptfile := str;
   end;
  end;
 until eof(txt);
 close(txt);
end;

procedure menu;
var
 ch       : char;
 choice   : byte;
 UserQuit : boolean;

procedure starttalking;
var
 currentline : byte;

function displayline : boolean;
var
 i           : byte;
 str         : string;

begin
 displayline := false;
 pkgotoxy(1,4);
 pkwrite(Esc+'[0K');
 str := pkpadcenter(textstrings[currentline],79,' ');
 for i:= 1 to length(str) do
 begin
  pkwrite(str[i]);
  delay(50);
  if i=length(str) then delay(400);
  if pkkeypressed then
  begin
   displayline:=true;
   ch:=pkreadkey;
   displaymenu;
   exit;
  end;
 end;
end;

var
 UserQuit : boolean;

begin
  repeat
   for currentline:=1 to talktextlines do
   begin
    userquit:=displayline;
    if userquit then break;
   end;
  until UserQuit;
end;

procedure choicexy(choice : byte; first : boolean);
begin
 if first then
  case choice of
   1 : pkgotoxy(10,4);
   2 : pkgotoxy(25,4);
   3 : pkgotoxy(44,4);
   4 : pkgotoxy(65,4);
  end
 else
  case choice of
   1 : pkgotoxy(23,4);
   2 : pkgotoxy(42,4);
   3 : pkgotoxy(63,4);
   4 : pkgotoxy(70,4);
  end
end;

procedure drawchoice(oldchoice,newchoice : byte);
begin
 choicexy(oldchoice,true);
 pkwrite(' ');
 choicexy(oldchoice,false);
 pkwrite(' ');

 pkwrite(cfg.colours[2]);

 choicexy(newchoice,true);
 pkwrite('>');
 choicexy(newchoice,false);
 pkwrite('<'+Esc+'[1D');
end;

function space2zero(str : string) : string;
begin
 while pos(' ',str) > 0 do str[pos(' ',str)]:='0';
 space2zero:=str;
end;

procedure clearscreen;
var
 i : byte;

begin
 for i:=1 to 13 do
 begin
  pkgotoxy(2,4+i);
  pkwrite(pkdup(' ',77));
 end;
end;

var
 moretocome    : boolean;

procedure displaylog(event : getlogtype);
var
 i             : byte;
 str           : string;
 logok         : boolean;

begin
 clearscreen;

 logok := resetlogx;
 textseek(log_f,getlogposition(event));

 pkgotoxy(15,19);
 pkwrite(cfg.colours[1]+space2zero(pkintstr(currentsearch,5)));

 i   := 1;
 str := '';

 readln(log_f,str);
 pkgotoxy(2,5);

 if str[1] = '-' then
  pkwrite(cfg.colours[1]+'Log starts on '+cfg.colours[2]+copy(str,31,8)+
          cfg.colours[1]+' at '+cfg.colours[2]+copy(str,42,8)+
          cfg.colours[1]+'.')
  else
  begin
   pkwrite(cfg.colours[2]+'Log continues:'+cfg.colours[1]);
   inc(i);
   pkgotoxy(2,4+i);
   pkwriteln(str);
  end;

 repeat
  inc(i);
  pkgotoxy(2,4+i);
  readln(log_f,str);
  if str[1] <> '-' then pkwriteln(str);
 until (i=13) or (str[1]='-') or (eof(log_f));

 if eof(log_f) then
 begin
  str[1]:='-';
  inc(i);
 end;

 pkgotoxy(22,20);
 pkwrite(pkrealstr((currentsearch/searchhits)*100,3,0));

 close(log_f);

 if (str[1]='-') then
 begin
  pkgotoxy(63,3+i);
  pkwrite(cfg.colours[1]+'--('+cfg.colours[2]+' end of log '+cfg.colours[1]+')'+Esc+'[1D');
  moretocome:=false;
 end
 else
 begin
  pkgotoxy(69,4+i);
  pkwrite(cfg.colours[1]+'--('+cfg.colours[2]+' more '+cfg.colours[1]+')'+Esc+'[1D');
  moretocome:=true;
 end;
end;

function jump2search : boolean;
var
 searchnum : string;

begin
 jump2search:=false;
 pksetxy;
 pkgotoxy(22,2);
 pkwrite(cfg.colours[2]+'enter searchhit number [1-'+pkintstr(searchhits,0)+'] '+cfg.colours[1]+pkdup(' ',11)+Esc+'[11D');
 pkreadnum(searchnum,5,true,'_');

 pkgotoxy(16,2);
 pkwrite('@X02    lOGVIEW v'+version+' bY @X0FmUGSHOT @X02of Creative Team           _\/_  |');
 pkresetxy;

 if pkescaped or (searchnum='') or (pkstrlong(searchnum) > searchhits)
  or (pkstrint(searchnum)=0) then exit;

 jump2search:=true;
 currentsearch:=pkstrint(searchnum);
 getlogposition(locatepage);
end;

procedure viewdatabase;
var
 userquit      : boolean;

begin
 userquit:=false;
 pkgotoxy(1,4);
 pkwrite(Esc+'[0J');
 pksendfile('LOGVIEW.PCB',false);

 currentsearch := 1;
 currentpage   := 1;

 pkgotoxy(15,19);
 pkwrite(space2zero(pkintstr(currentsearch,5)));

 pkgotoxy(22,19);
 pkwrite(space2zero(pkintstr(searchhits,5)));

 pkgotoxy(22,20);
 pkwrite(pkrealstr((currentsearch/searchhits)*100,3,0));

 pkgotoxy(15,21);
 case viewtype of
  1 : pkwrite('   your log');
  2 : pkwrite('  all users');
  3 : pkwrite('   specific');
 end;

 currentpage := 1;
 displaylog(thispage);

 repeat
  repeat
   ch:=pkreadkey;
  until ch in [CTRLJ,UArr,DArr,Esc];
  case ch of
   Esc   : userquit:=true;
   CtrlJ : if searchhits > 1 then if jump2search then displaylog(thispage);
   UArr  : if currentsearch > 1 then displaylog(previouspage);
   DArr  : if not endreached then displaylog(nextpage);
  end;
 until userquit;
end;

procedure builddatabase(searchstr : string);
var
 str         : string;
 lastpos     : longint;
 i           : byte;
 searchmatch : boolean;
 reread      : boolean;

procedure buildtotaldatabase;
begin
 pksharefile(false,false);
 assign(data_f,pkbbspath+'LOGVIEW'+pkintstr(pknode,0)+'.IDX');
 Rewrite(data_f);
 reread:=true;
 repeat
  if reread then
  begin
   lastpos := textfilepos(log_f);
   readln(log_f,str);
  end;
  if str[1] = '-' then
  begin
   inc(searchhits);
   reread:=false;
   data.page     := searchhits;
   data.position := lastpos;
   write(data_f,data);
   i:=0;
   repeat
    inc(i);
    lastpos := textfilepos(log_f);
    readln(log_f,str);
     if (i=13) and (not eof(log_f)) then
     begin
      data.page     := searchhits;
      data.position := lastpos;
      write(data_f,data);
      i:=0;
     end;
   until (str[1]='-') or (eof(log_f));
  end;
 until eof(log_f);
 close(log_f);
 close(data_f);
end;

procedure buildonname;
var
 logged_user : string[30];
 logfound    : boolean;
 pos2        : longint;

begin
 pksharefile(false,false);
 assign(data_f,pkbbspath+'LOGVIEW'+pkintstr(pknode,0)+'.IDX');
 Rewrite(data_f);
 reread:=true;
 repeat
  if reread then
  begin
   lastpos := textfilepos(log_f);
   readln(log_f,str);
  end;
  if str[1] = '-' then
  begin
   reread:=false;
   repeat
    pos2:=textfilepos(log_f);
    readln(log_f,str);

    logged_user := copy(str,37,length(str)-36);                   {0.2!!}
    logfound := pos(pkupper(searchstr),pkupper(logged_user)) > 0; {0.2!!}

   until (eof(log_f)) or (str[1]='-') or (logfound);
   if logfound then
   begin
    inc(searchhits);
    data.page     := searchhits;
    data.position := lastpos;
    write(data_f,data);
    i:=0;
    textseek(log_f,lastpos);
    readln(log_f,str);
   repeat
    inc(i);
    lastpos := textfilepos(log_f);
    readln(log_f,str);
     if (i=13) and (not eof(log_f)) then
     begin
      data.page     := searchhits;
      data.position := lastpos;
      write(data_f,data);
      i:=0;
     end;
   until (str[1]='-') or (eof(log_f));
  end else lastpos:=pos2;
 end;
 until eof(log_f);
 close(log_f);
 close(data_f);
end;

begin
 if not resetlogx then
 begin
  pkgotoxy(1,4);
  pkwriteln('|15 |07Unable to access the PcExpress log file, retry or contact sysop.');
  pkshowprompt(cfg.promptfile);
  displaymenu;
  drawchoice(previouschoice,choice);
  exit;
 end;

 currentsearch := 0;
 searchhits    := 0;
 currentpage   := 0;
 searchmatch   := false;

 if searchstr='total' then buildtotaldatabase
  else buildonname;

 if searchhits = 0 then
 begin
  pkgotoxy(1,4);
  pkwrite(Esc+'[0J');
  pksendfile('NOMATCH',false);
  pkgotoxy(45,12);
  pkreadkey;
 end else viewdatabase;
 displaymenu;
 drawchoice(previouschoice,choice);
end;

procedure getname;
var
 searchname : string;

begin
 pkgotoxy(12,2);
 pkwrite(cfg.colours[2]+'enter part of a username: '+cfg.colours[1]);

 pkreadln(searchname,30,true,false,'_');

 pkgotoxy(12,2);
 pkwrite('@X02        lOGVIEW v'+version+' bY @X0FmUGSHOT @X02of Creative Team           _\/_  |');

 if pkescaped or (searchname = '') then
  drawchoice(previouschoice,choice)
  else builddatabase(searchname);
end;

function passwordok : boolean;
var
 password : string;

begin
 passwordok := false;
 pkgotoxy(16,2);
 pkwrite(cfg.colours[2]+'enter the logview password : '+cfg.colours[1]+'_______________  '+Esc+'[17D');

 pkreadhide(password,15,true,false,'x','_');
 pkgotoxy(16,2);
 pkwrite('@X02    lOGVIEW v'+version+' bY @X0FmUGSHOT @X02of Creative Team           _\/_  |');
 drawchoice(previouschoice,choice);

 if pkescaped or (password='') then exit
  else passwordok := password = cfg.password;
end;

begin
 displaymenu;

 UserQuit  := False;
 previouschoice := 1;
 choice    := 1;
 drawchoice(1,1);

 repeat
  NewTimerSecs(Timer,timeafterbeingbored);
  repeat

   repeat
    if ElapsedTimeInsecs(Timer) >= timeafterbeingbored then
    begin
     starttalking;
     drawchoice(previouschoice,choice);
     NewTimerSecs(Timer,timeafterbeingbored);
    end;
   until pkkeypressed;

   ch:=pkreadkey;
   NewTimerSecs(Timer,timeafterbeingbored);
  until ch in [LArr,RArr,Enter,' '];
  case ch of
   LArr : if choice > 1 then
          begin
           previouschoice:=choice;
           dec(choice);
           drawchoice(previouschoice,choice);
          end;
   Rarr : if choice < 4 then
          begin
           previouschoice:=choice;
           inc(choice);
           drawchoice(previouschoice,choice);
          end;
  ' ',
  Enter : begin
            case choice of
             1 : begin
                  viewtype:=choice;
                  builddatabase(pkdrop.name);
                 end;
             2 : begin
                  viewtype:=choice;
                  if passwordok then builddatabase('total');
                 end;
             3 : begin
                  viewtype:=choice;
                  if passwordok then getname;
                 end;
             4 : UserQuit:=True;
            end;
           end;
  end;
 until UserQuit;
 pkgotoxy(1,4);
 pkwriteln(Esc+'[0K'+pkdup(' ',16)+'|03Thank you for using another Creative Team product.');
 pkerase(pkbbspath+'LOGVIEW'+pkintstr(pknode,0)+'.IDX');
end;

procedure initialize;
begin
 pkinit;
 pktraperrors:=false;
 pkabout:=' '+pkpadcenter('[^LOGVIEW^ Version '+version+', done by ^MugSHot^]',82,'')+' ';

 if not pkdropfile then
 begin
  pkansi:=true;
  drawlogo;
  pkwriteln('|15 |07no dropfile.');
  halt(1);
 end;

 pkclrscr;
 pkstatusbar(9);
 drawlogo;
 readcfg;

 if not pkexist(pkbbspath+'LOG'+pkintstr(pknode,0)+'.TXT') then
 begin
  pkwriteln('|15 |07there is no logfile.');
  pkshowprompt(cfg.promptfile);
  halt;
 end;

 menu;
end;

begin
 Initialize;
end.