{$I TTDEFINE.INC}
Unit pkDIRX;

{***********************************************************}
{*                     pkDIRX.PAS 1.15                     *}
{*   Freeware, but remains copyright to Creative Team and  *}
{*                    the author, MugSHot                  *}
{***********************************************************}
{-Allround PC-Express DIRX.TXT file handling.}

interface

uses pkMISC,
     pkAsync,
     TTRB,
     WinDos,
     Dos;

const pkdirxversion  = 'pkDIRX Evoluzione II';
      pkdirxvernumber= '1.15';
      pkdirxmaxlines = 60;

type pkDIRXRecPtr = ^pkDIRXRecord;
     pkDIRXRecord = record
      percentage  : real;
      dirxsize    : longint;
      filename    : string[12];
      fileext     : string[3];
      filesize    : LongInt;
      nukedesc    : string[10];
      exists,
      pay         : boolean;
      filedate    : string[8];
      file_id     : array[1..pkDirxMaxLines] of string;
      startpos,               {-starting position of the current file
                               only supported by pkdirxgetentry at this time}
      lastpos     : longint;  {-ending position of the current file and the
                               last position in a dirx file}
     end;

     ScanProc       = procedure(percentage : real);
     AbortProc      = procedure;
     ClearBuffproc  = procedure;
     WriteProc      = procedure(str : string);
     KeyPressedFunc = function : boolean;
     ReadKeyFunc    = function : char;

Function  TextFilePos(Var f : Text) : LongInt;

Procedure TextSeek(Var f : Text; n : LongInt);

function  pkDIRXPath(conference,area : byte) : string;

procedure pksetdirxclearinbuffer(newfunc : ClearBuffproc);

procedure pksetdirxkeypeek(newfunc : readkeyfunc);

procedure pksetdirxreadkeyfunc(newfunc : readkeyfunc);

procedure pksetdirxkeyfunc(newfunc : keypressedfunc);

procedure pksetdirxdetectkey(on : boolean);

function  pkdirxscanstate : boolean;

procedure pksetdirxwriteproc(newproc : writeproc);

procedure pksetdirxscan(on : boolean);

procedure pksetdirxscanrate(lines : byte);

procedure pksetdirxscanproc(newproc : scanproc);

procedure pksetdirxfilepos(NewFilePos : longint; var dirxrec : pkdirxrecptr;
                           doCheck : boolean);

function  pkdirxgetentry(conference, area : byte; var dirxrec : pkdirxrecptr;
                         first : boolean) : byte;

function  pkdirxreverse(conference, area : byte; var dirxrec : pkdirxrecptr;
                        first : boolean) : byte;

function  pkdirxstringscan(conference,area : byte; var dirxrec : pkdirxrecptr;
                           searchstr,hicol,lowcol : string; first : boolean) : byte;

function  pkdirxdayscan(conference,area : byte; var dirxrec : pkdirxrecptr;
                        dayz : word; first,speedsearch : boolean) : byte;

function  pkdirxfilescan(conference,area : byte; var dirxrec : pkdirxrecptr;
                         wildcard : string; first : boolean) : byte;

function  pkdirxdizlines(dirxrec: pkdirxrecptr) : byte;

var glAbortProc : AbortProc;

const copyright     = 'Portions Copyright (c) 1995-96 by Creative Team.';
      LF = #10;

type {$I pkstruct.130}

implementation

var dir         : text;
    reversedir  : backtext;
    gllastline,
    bbspath,str : string;
    IOSave,
    maxareas    : byte;
    pkconf      : conrec;
    glLastPos   : longInt;
    glBufPos    : longint;
    glFileSize  : longint;
    glNewChk    : boolean;
    glScanProc  : scanproc;
    glWriteProc : writeproc;
    glKeyPeek   : readkeyfunc;
    glReadKey   : readkeyfunc;
    glKeyFunc   : keypressedfunc;
    glClearInBuffer : clearbuffproc;
    glDoScan    : boolean;
    glDetectKey : boolean;
    glScanMax   : byte;
    glCounter   : byte;
    glScanCnt   : byte;
    glChkScan   : byte;
    glBackPos   : byte;
    AbortCount  : byte;
    ExitSave    : Pointer;
    BResult     : word;
    ch          : char;

   Function glAborted : boolean;
   begin
    glAborted:=False;
    inc(AbortCount);

    if AbortCount>=50 then
    begin
     AbortCount:=0;
     if glDetectKey and glKeyFunc and (glKeyPeek=#27) then glAborted:=True
     else if glKeyFunc then
     begin
     {* clear input buffers *}
      ASM CLI End;
       MemW[$40:$1A] := MemW[$40:$1C];
      ASM STI End;
      glClearInBuffer;
     end;
    end;
   end;

Procedure GetFileMode; Assembler;

ASM
        CLC
        CMP    ES:[DI].TTextRec.Mode, fmInput
        JE     @1
        MOV    [InOutRes], 104         { 'File not opened for reading' }
        XOR    AX, AX                  { Zero out function result }
        XOR    DX, DX
        STC
@1:
end;

Function TextFilePos(Var f : Text) : LongInt; Assembler;

ASM
        LES    DI, f
        CALL   GetFileMode
        JC     @1

        XOR    CX, CX                  { Get position of file pointer }
        XOR    DX, DX
        MOV    BX, ES:[DI].TTextRec.handle
        MOV    AX, 4201h
        INT    21h                     { offset := offset-BufEnd+BufPos }
        XOR    BX, BX
        SUB    AX, ES:[DI].TTextRec.BufEnd
        SBB    DX, BX
        ADD    AX, ES:[DI].TTextRec.BufPos
        ADC    DX, BX
@1:
end;

Procedure TextSeek(Var f : Text; n : LongInt); Assembler;

ASM
        LES    DI, f
        CALL   GetFileMode
        JC     @2

        MOV    CX, Word Ptr n+2        { Move file pointer }
        MOV    DX, Word Ptr n
        MOV    BX, ES:[DI].TTextRec.Handle
        MOV    AX, 4200h
        INT    21h
        JNC    @1                      { Carry flag = reading past EOF }
        MOV    [InOutRes], AX
        JMP    @2


        { Force read next time }
@1:     MOV    AX, ES:[DI].TTextRec.BufEnd
        MOV    ES:[DI].TTextRec.BufPos, AX
@2:
end;

procedure clearrec(var dirxrec : pkdirxrecptr);
var i : byte;
begin
  with dirxrec^ do
  begin
   filename    := '';
   fileext     := '';
   filesize    := 0;
   nukedesc    := '';
   exists      := false;
   pay         := false;
   filedate    := '';
   for i:=1 to pkdirxmaxlines do file_id[i]:='';
 end;
end;

procedure readconf(conference : byte);
var conf_f : File of conRec;
    i: byte;

begin
   pkShareFile(True,False);
   Assign(conf_f,bbspath+'CONFER.CFG');
    i := 0;
     repeat
      inc(i);
      {$I-} Reset(conf_f); {$I+}
      IOSave:=IOResult;
     until (i > 50) or (iosave = 0);
   if IOSave=0 then
    begin
     if conference > 1 then seek(conf_f,conference-1);
     read(conf_f,pkconf);
     close(conf_f);
    end;
end;

function getmaxareas(conference : byte) : byte;
var i : byte;
begin
 getmaxareas:=0;
 readconf(conference);
 if not pkconf.conffilearea then exit;
 i:=0;
 repeat
  if pkconf.conffiles[i+1] <> '' then inc(i);
 until (i=9) or (pkconf.conffiles[i+1]='');
 getmaxareas:=i;
end;

function  pkDIRXPath(conference,area : byte) : string;
begin
 pkDIRXPath:='';
 ReadConf(conference);

 if area <> 0 then
 begin
  if pkconf.cdrom[area] then
   pkDIRXPath:=pkconf.confpath
  else
   pkDIRXPath:=pkconf.conffiles[area];
 end
 else
  pkDIRXPath:=pkconf.conffiles[getmaxareas(conference)]+'HOLD\';
end;

function resetdir(conference,area : byte; var dirxrec : pkdirxrecptr) : byte;
{ return codes: 0 - Ok.
                1 - No DIRX.TXT file present.
                2 - Error while trying to reset DIRX.TXT file }

var i : byte;
begin
 resetdir:=1;

 if area=0 then if not pkexist(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT')
  or (pkfilesize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT')=0)
  then exit;

 if (area <> 0) and (not pkconf.cdrom[area]) then if not
  pkexist(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if (area <> 0) and (pkconf.cdrom[area]) then if not
  pkexist(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if area <> 0 then
 begin
  if pkconf.cdrom[area] then
   begin
    pkShareAssign(dir,pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT',True,False);
    glFileSize:=pkFileSize(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT');
    dirxrec^.dirxsize:=glfilesize;
   end
  else
  begin
   pkShareAssign(dir,pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT',True,False);
   glFileSize:=pkFileSize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT');
   dirxrec^.dirxsize:=glfilesize;
  end
 end
 else
 begin
  pkShareAssign(dir,pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT',True,False);
  glFileSize:=pkFileSize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT');
  dirxrec^.dirxsize:=glfilesize;
 end;


 i:=0;
 repeat
  inc(i);
  {$I-} Reset(dir); {$I+}
  IOSave:=IOResult;
 until (i > 20) or (IOSave=0);
 if i > 20 then begin resetdir:=2; exit end
 else resetdir:=0;
end;

function eod(str : string) : boolean;
{-End of description}
begin


end;

function resetreversedir(conference,area : byte; var dirxrec : pkdirxrecptr) : byte;
{ return codes: 0 - Ok.
                1 - No DIRX.TXT file present.
                2 - Error while trying to reset DIRX.TXT file }

begin
 resetreversedir:=1;

 if area=0 then if not pkexist(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT') or
  (pkfilesize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT')=0)
  then exit;

 if (area <> 0) and (not pkconf.cdrom[area]) then if not
  pkexist(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if (area <> 0) and (pkconf.cdrom[area]) then if not
  pkexist(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if area <> 0 then
 begin
  if pkconf.cdrom[area] then
   begin
    pkShareFile(True,False);
    AssignBack(reversedir,pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT');
    glFileSize:=pkFileSize(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT'); {v1.11}
    dirxrec^.dirxsize:=glfilesize;
   end
  else
   begin
    pkShareFile(True,False);
    AssignBack(reversedir,pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT');
    glFileSize:=pkFileSize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT');
    dirxrec^.dirxsize:=glfilesize;
   end
 end
 else
  begin
   pkShareFile(True,False);
   AssignBack(reversedir,pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT');
   glFileSize:=pkFileSize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT');
   dirxrec^.dirxsize:=glfilesize;
  end;

 ResetBack(reversedir,1024);

 if BResult <> 0 then begin resetreversedir:=2; exit end
 else resetreversedir:=0;
end;

function BoE(str : string) : boolean;
{-begin of entry.}
begin
 if str[1] in [' ','.','>','^'] then BoE:=False else BoE:=True;
end;

function EoE(str : string) : boolean;
{-end of entry.}
begin
 if str[1] in [' ','.','>','^'] then EoE:=false else EoE:=true; {v1.12}
end;

procedure chkscan(percentage : real);
begin
 inc(glCounter);
 if glCounter=glChkScan then
 begin
  glCounter:=0;
  glScanProc(percentage);
 end;
end;

procedure readentry(conference,area : byte; var dirxrec : pkdirxrecptr);
var tmp  : string;
    fstr : string[12];
    x    : integer;
    tmpsize : longint;

begin

 clearrec(dirxrec);
 fstr:=pkextractwords(1,1,str);

 if pos('.',str) > 0 then
 begin                                                {v1.11}
  x:=pos('.',str);                                    {v1.11}
  dirxrec^.filename := copy(str,1,x-1);               {v1.11}
  dirxrec^.fileext  := copy(str,x+1,length(fstr)-x);  {v1.11}
 end else                                             {v1.11}
 begin                                                {v1.11}
  dirxrec^.filename := pkextractwords(1,1,str);       {v1.11}
  dirxrec^.fileext  := '';                            {v1.11}
 end;                                                 {v1.11}
 x:=0;                                                {v1.11}

 if pkconf.CONFFreeDown then dirxrec^.pay:=false else
 begin
  if pkupper(pkextractwords(2,1,str))='F' then dirxrec^.pay:=false
  else dirxrec^.pay:=true;
 end;

 dirxrec^.filedate:=pkextractwords(3,1,str);

 if pkwordcnt(str) >= 4 then                          {v1.12}
  dirxrec^.nukedesc:=copy(str,                        {v1.12}
                         pos(dirxrec^.filedate,str)+  {v1.12}
                         length(dirxrec^.filedate)+1, {v1.12}
                         length(str));                {v1.12}

 if area=0 then
 begin
 tmpsize:=pkfilesize(pkconf.confFiles[maxareas]+'HOLD\'+pkextractwords(1,1,str));
 if tmpsize <> -1 then
  begin
   dirxrec^.exists:=true;
   dirxrec^.FileSize:=tmpsize;
  end else begin dirxrec^.exists:=false; dirxrec^.filesize:=0; end;
 end
 else
 begin
  tmpsize:=pkfilesize(pkconf.conffiles[area]+pkextractwords(1,1,str));
  if tmpsize <> -1 then
  begin
   dirxrec^.exists:=true;
   dirxrec^.filesize:=tmpsize;
  end
  else begin dirxrec^.exists:=false; dirxrec^.filesize:=0; end;
 end;

  x:=0;
  repeat
   glLastPos:=TextFilePos(dir);
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan((glLastPos/glFileSize)*100);

   if glAborted then
   begin
    ch:=glReadKey;
    glWriteProc('Scanning Aborted.');
    close(dir);
    glabortproc;
    halt;
   end;

   readln(dir,str);
   if (str[1] in [' ','>','^']) and (x < pkdirxmaxlines+1) then
   begin inc(x); dirxrec^.file_id[x]:=str; end;
  until eof(dir) or (EoE(str)) or (x >= pkdirxmaxlines);
  if x=0 then dirxrec^.file_id[1]:=' No description found.';

  dirxrec^.percentage :=(TextFilePos(dir)/glFileSize)*100;
end;

function pkdirxgetentry(conference, area : byte; var dirxrec : pkDIRXRecPtr;
                        first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

var i   : byte;
begin
 clearrec(dirxrec);
 pkdirxgetentry := 1;
 if (conference > 200) or (area > 9) then exit;

 maxareas:=getmaxareas(conference);
 if maxareas=0 then begin pkdirxgetentry:=2; exit; end;

 if first then
 begin
  glScanCnt:=0;
  glLastPos:=0;
  i:=resetdir(conference,area,dirxrec);
  if i <> 0 then begin pkdirxgetentry:=i+2; exit; end;
  repeat
   glLastPos:=TextFilePos(dir);
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan((glLastPos/glFileSize)*100);
   readln(dir,str);

   if boe(str) then
   begin
    dirxrec^.startpos:=glLastPos;
    readentry(conference,area,dirxrec);
    pkdirxgetentry:=0;
    close(dir);
    exit;
   end;

  until eof(dir);
  if eof(dir) then
   begin
    pkdirxgetentry:=5;
    close(dir);
    exit;
   end;
 end
 else
 begin
  i:=resetdir(conference,area,dirxrec);
  if i <> 0 then begin pkdirxgetentry:=i+2; exit; end;
  glLastPos:=dirxrec^.lastpos;
  TextSeek(dir,glLastPos);
  if eof(dir) then
   begin
    pkdirxgetentry:=5;
    close(dir);
    exit;
   end;
  repeat
   glLastPos:=TextFilePos(dir);
   dirxrec^.lastpos:=glLastPos;

   if glNewChk and (glLastpos <> 0) then
    begin readln(dir,str); glNewChk:=False; end;

   if glDoScan then ChkScan((glLastPos/glFileSize)*100);
   if not eof(dir) then readln(dir,str);

   if boe(str) then
   begin
    dirxrec^.startpos:=glLastPos;
    readentry(conference,area,dirxrec);
    pkdirxgetentry:=0;
    close(dir);
    exit;
   end;

  until eof(dir);
  if eof(dir) then begin pkdirxgetentry:=5; close(dir); exit; end;
 end;
end;

function pkdirxstringscan(conference,area : byte; var dirxrec : pkDIRXRecPtr;
                          searchstr,hicol,lowcol : string; first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

function chkstr : boolean;
var i     : word;
    index : byte;
    tmp   : string;
    fn    : string[12];

begin
 chkstr:=false;

 if dirxrec^.fileext='' then fn:=dirxrec^.filename {v1.13}
  else fn:=dirxrec^.filename+'.'+dirxrec^.fileext; {v1.13}

 if pos(pkupper(searchstr),pkupper(fn)) > 0 then   {v1.13}
  chkstr:=true;

 for i:=1 to pkdirxmaxlines do
 if pos(pkupper(searchstr),pkupper(dirxrec^.file_id[i])) <> 0 then
 begin
  index:=pos(pkupper(searchstr),pkupper(dirxrec^.file_id[i]));
  tmp:=hicol+pkupper(searchstr)+lowcol;

  delete(dirxrec^.file_id[i],index,length(searchstr));
  insert(tmp,dirxrec^.file_id[i],index);

  chkstr:=true;
 end;
end;

var i : byte;
begin
 i:=pkdirxgetentry(conference,area,dirxrec,first);
 if i <> 0 then begin pkdirxstringscan:=i; exit; end;
                          if chkstr then begin pkdirxstringscan:=0; exit; end;
 first:=false;

 repeat
  i:=pkdirxgetentry(conference,area,dirxrec,first);
  if i = 0 then if chkstr then begin pkdirxstringscan:=0; exit; end;
 until i <> 0;
 pkdirxstringscan:=i;
end;

function pkdirxfilescan(conference,area : byte; var dirxrec : pkdirxrecptr;
                        wildcard : string; first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

function chkfile : boolean;
var tmp : string[12];
begin

 if dirxrec^.fileext='' then tmp:=dirxrec^.filename
 else tmp:=dirxrec^.filename+'.'+dirxrec^.fileext;

{ if pos('.',wildcard) = 0 then tmp:=dirxrec^.filename;}

 chkfile:=pkwildcompare(pkupper(wildcard),pkupper(tmp));

end;

var i : byte;
begin
 i:=pkdirxgetentry(conference,area,dirxrec,first);
 if i <> 0 then begin pkdirxfilescan:=i; exit; end;

 if chkfile then begin pkdirxfilescan:=0; exit; end;
 first:=false;

 repeat
  i:=pkdirxgetentry(conference,area,dirxrec,first);
  if i = 0 then if chkfile then begin pkdirxfilescan:=0; exit; end;
 until i <> 0;
 pkdirxfilescan:=i;
end;

function pkdirxreverse(conference, area : byte; var dirxrec : pkdirxrecptr;
                        first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                        *}

type
  tmprec  = array[1..pkdirxMaxLines] of string;

var
  tmpline    : ^tmprec;
  tmpcounter : byte;
  x          : byte;

procedure readbackentry;
var i,x : byte;
    fstr: string;
    tmpsize : longint;
    BR : BackRec Absolute Reversedir;

begin

 i:=0;

 clearrec(dirxrec);
 fstr:=pkextractwords(1,1,str);

 if pos('.',str) > 0 then                            {v1.11}
 begin                                               {v1.11}
  x:=pos('.',str);                                   {v1.11}
  dirxrec^.filename := copy(str,1,x-1);              {v1.11}
  dirxrec^.fileext  := copy(str,x+1,length(fstr)-x); {v1.11}
 end else                                            {v1.11}
 begin                                               {v1.11}
  dirxrec^.filename := pkextractwords(1,1,str);      {v1.11}
  dirxrec^.fileext  := '';                           {v1.11}
 end;                                                {v1.11}
 x:=0;                                               {v1.11}

 if pkconf.CONFFreeDown then dirxrec^.pay:=false else
 begin
  if pkupper(pkextractwords(2,1,str))='F' then dirxrec^.pay:=false
  else dirxrec^.pay:=true;
 end;

 dirxrec^.filedate:=pkextractwords(3,1,str);

 if pkwordcnt(str) >= 4 then                          {v1.12}
  dirxrec^.nukedesc:=copy(str,                        {v1.12}
                         pos(dirxrec^.filedate,str)+  {v1.12}
                         length(dirxrec^.filedate)+1, {v1.12}
                         length(str));                {v1.12}

 if area=0 then
 begin
 tmpsize:=pkfilesize(pkconf.confFiles[maxareas]+'HOLD\'+pkextractwords(1,1,str));
 if tmpsize <> -1 then
  begin
   dirxrec^.exists:=true;
   dirxrec^.FileSize:=tmpsize;
  end else begin dirxrec^.exists:=false; dirxrec^.filesize:=0; end;
 end
 else
 begin
  tmpsize:=pkfilesize(pkconf.conffiles[area]+pkextractwords(1,1,str));
  if tmpsize <> -1 then
  begin
   dirxrec^.exists:=true;
   dirxrec^.filesize:=tmpsize;
  end
  else
  begin
   dirxrec^.exists:=false;
   dirxrec^.filesize:=0;
  end;
 end;

 if tmpcounter > 0 then
 begin
  for i:=tmpcounter downto 1 do
  begin inc(x); dirxrec^.file_id[x]:=tmpline^[i]; end;
 end
 else
  begin
   dirxrec^.file_id[1]:=' No description found.';
   dirxrec^.lastpos   := BackFilePos(reversedir)+BR.BPos;
  end;

end;

var i   : byte;
    BR : BackRec Absolute Reversedir;

begin

 GetMemCheck(tmpline,sizeof(tmprec));

 for i:=1 to pkdirxmaxlines do tmpline^[i]:='';
 tmpcounter:=0;

 pkdirxreverse:= 1;
 if (conference > 200) or (area > 9) then exit;

 maxareas:=getmaxareas(conference);
 if maxareas=0 then begin pkdirxreverse:=2; exit; end;

 clearrec(dirxrec);

 if first then
 begin
  glScanCnt:=0;
  glLastPos:=0;
  i:=resetreversedir(conference,area,dirxrec);
  if i <> 0 then begin
                  pkdirxreverse:=i+2;
                  FreeMemCheck(tmpline,sizeof(tmprec));
                  exit;
                 end;
  repeat
   glLastPos:=BackFilePos(reversedir)+BR.Bpos;
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan(100-((glLastPos/glFileSize)*100));

   if glAborted then
   begin
    ch:=glReadKey;
    glWriteProc('Scanning Aborted.');
    closeback(reversedir);
    FreeMemCheck(tmpline,sizeof(tmprec));
    glabortproc;
    halt;
   end;

   if glNewChk and (glLastpos <> dirxrec^.dirxsize)
    then begin readlnback(reversedir,str); glNewChk:=False; end;

   readlnback(reversedir,str);

   if str[1] in [' ','>','^'] then
   begin
    inc(tmpcounter);
    tmpline^[tmpcounter]:=str;
   end;

   if BoE(str) and (str <> '') then
   begin
    dirxrec^.percentage :=100-(((BackFilePos(reversedir)+br.BPos)/glFileSize)*100);
    readbackentry;
    closeback(reversedir);
    FreeMemCheck(tmpline,sizeof(tmprec));
    pkdirxreverse:=0;
    exit;
   end;

  until bof(reversedir);
  if bof(reversedir) then begin
                           pkdirxreverse:=5;
                           closeback(reversedir);
                           FreeMemCheck(tmpline,sizeof(tmprec));
                           exit;
                          end;
 end
 else
 begin
  i:=resetreversedir(conference,area,dirxrec);
  if i <> 0 then begin
                  pkdirxreverse:=i+2;
                  FreeMemCheck(tmpline,sizeof(tmprec));
                  exit;
                 end;

  glLastPos:=dirxrec^.lastpos;
  SeekBack(reversedir,glLastPos);

  if bof(reversedir) then begin
                           pkdirxreverse:=5;
                           closeback(reversedir);
                           FreeMemCheck(tmpline,sizeof(tmprec));
                           exit;
                          end else ReadlnBack(reversedir,str); {!}
  repeat
   glLastPos:=BackFilePos(reversedir)+BR.BPos;
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan(100-((glLastPos/glFileSize)*100));

   if glAborted then
   begin
    ch:=glReadKey;
    glWriteProc('Scanning Aborted.');
    closeback(reversedir);
    FreeMemCheck(tmpline,sizeof(tmprec));
    glabortproc;
    halt;
   end;

   if glNewChk and (glLastpos <> dirxrec^.dirxsize)
    then begin readlnback(reversedir,str); glNewChk:=False; end;

   readlnback(reversedir,str);

   if str[1] in [' ','>','^'] then {v1.12}
   begin
    inc(tmpcounter);
    tmpline^[tmpcounter]:=str;
   end;

  if BoE(str) and (str <> '') then
   begin
    dirxrec^.percentage :=100-(((BackFilePos(reversedir)+br.Bpos)/glFileSize)*100);
    if bof(reversedir) then dirxrec^.percentage:=100;
    readbackentry;
    pkdirxreverse:=0;
    closeback(reversedir);
    FreeMemCheck(tmpline,sizeof(tmprec));
    exit;
   end;

  until bof(reversedir);
  if bof(reversedir) then begin
                           pkdirxreverse:=5;
                           closeback(reversedir);
                           FreeMemCheck(tmpline,sizeof(tmprec));
                           exit;
                          end;
 end;
end;

function pkdirxdayscan(conference,area : byte; var dirxrec : pkdirxrecptr;
                       dayz : word; first,speedsearch : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

function chkdayz : boolean;
var  dte  : date;
     tme  : time;
     a,b  : datetimerec;
     days : word;
     secs : longint;
     year,month,day,dayofweek : word;

begin
 chkdayz:=false;

 GetDate(year,month,day,dayofweek);
 dte := DMYtoDate(day,month,year);
 tme := HMStoTime(0,0,0);
 a.d := dte;
 a.t := tme;

 dte := DMYtoDate(pkstrint(copy(dirxrec^.filedate,5,2)),
                  pkstrint(copy(dirxrec^.filedate,3,2)),
                  pkstrint('19'+copy(dirxrec^.filedate,1,2)));
 tme := HMStoTime(0,0,0);
 b.d := dte;
 b.t := tme;

 DateTimeDiff(a,b,days,secs);

 if days <= dayz then chkdayz:=true;

end;

var i : byte;
begin
 i:=pkdirxreverse(conference,area,dirxrec,first);
 if i <> 0 then begin pkdirxdayscan:=i; exit; end;

 if chkdayz then begin pkdirxdayscan:=0; exit; end
 else if speedsearch then begin pkdirxdayscan:=5; exit; end;
 first:=false;

 repeat
  i:=pkdirxreverse(conference,area,dirxrec,first);
  if i = 0 then if chkdayz then begin pkdirxdayscan:=0; exit; end
  else if speedsearch then begin pkdirxdayscan:=5; exit; end;
 until i <> 0;
 pkdirxdayscan:=i;
end;

procedure pksetdirxkeypeek(newfunc : readkeyfunc);
begin glKeyPeek:=NewFunc; end;

procedure pksetdirxreadkeyfunc(newfunc : readkeyfunc);
begin glReadKey:=NewFunc; end;

procedure pkSetDirXKeyFunc(NewFunc : KeyPressedFunc);
begin glKeyFunc:=NewFunc; end;

procedure pkSetDirXWriteProc(NewProc : WriteProc);
begin glWriteProc:=NewProc; end;

procedure pksetdirxdetectkey(on : boolean);
begin glDetectKey:=On; end;

procedure pksetdirxscan(on : boolean);
begin glDoScan:=On; end;

procedure pksetdirxscanproc(newproc : scanproc);
begin
 glScanProc:=NewProc;
end;

procedure pksetdirxscanrate(lines : byte);
begin glChkScan:=lines; end;

procedure pksetdirxfilepos(NewFilePos : longint; var dirxrec : pkdirxrecptr; doCheck : boolean);
begin dirxrec^.LastPos:=NewFilePos; glNewChk:=doCheck; end;

procedure dirxexitproc; far;
var BR : BackRec Absolute reversedir;
begin
 ExitProc:=ExitSave;
end;

function  pkdirxscanstate : boolean;
begin pkdirxscanstate := gldoscan; end;

function  pkdirxdizlines(dirxrec: pkdirxrecptr) : byte;          {v1.12}
var i : byte;                                                    {v1.12}
begin                                                            {v1.12}
 for i:=pkdirxmaxlines downto 1 do if dirxrec^.file_id[i] <> ''  {v1.12}
 then begin                                                      {v1.12}
       pkdirxdizlines:=i;                                        {v1.12}
       exit;                                                     {v1.12}
      end;                                                       {v1.12}
 pkdirxdizlines:=0;                                              {v1.12}
end;                                                             {v1.12}

procedure pksetdirxclearinbuffer(newfunc : clearbuffproc);
begin
 glClearInBuffer:=NewFunc;
end;

procedure DoNothingProc; far;
begin
end;

var stamp    : array[1..2] of string;
begin

 stamp[1]    := copyright;
 stamp[2]    := pkdirxversion;

 ExitSave    := ExitProc;
 ExitProc    := @DirxExitProc;

 glWriteProc := Nil;
 glKeyFunc   := Nil;
 glScanProc  := Nil;
 glClearInBuffer:= Nil;

 AbortCount  := 0;
 glAbortProc := DoNothingProc;
 glDoScan    := False;
 glDetectKey := False;
 glScanMax   := 0;
 glScanCnt   := 0;
 glCounter   := 0;
 glChkScan   := 30;
 glNewChk    := False; {v1.14}

 bbspath:=GetEnv('PCEXPRESS');
 if bbspath='' then begin
                     writeln;
                     writeln('-',pkdirxversion,':');
                     writeln('Abnormal program termination: PCEXPRESS variable not set.');
                     halt;
                    end;

 if bbspath[length(bbspath)] <> '\' then bbspath:=bbspath+'\';

 if not pkexist(bbspath+'CONFER.CFG') then begin
                                            writeln;
                                            writeln('-',pkdirxversion,':');
                                            writeln('Abnormal program termination: ',bbspath,'CONFER.CFG not found.');
                                            halt;
                                           end;
end.