Program Login_Matrix;

Uses
   pkDoor,pkPort,Misc,Door,Crt,Dos;

Var
   MainDir, PceDir                      : PathStr;
   Tries, TriesGlobal                   : Byte;
   sTries, sTriesGlobal                 : Byte;
   qf, cf                               : Text;
   Disconnect, LastInput                : String;
   q                                    : Integer;
   Node                                 : String[3];
   uf                                   : File of UserRecord;
   ur                                   : UserRecord;
   df                                   : File of DoorInfo;
   dr                                   : DoorInfo;
   Ansi                                 : Boolean;

Function RemoteAnsiDetected : Boolean;
Begin
  pkClearBuffers;
  pkWrite(#27+'[6n');
  Delay(2000);
  RemoteAnsiDetected:= pkReadKey in [#27,'0'..'9','[','H'];
End;

Procedure Lower_DTR(Irq : Byte);
Var regs:Registers;
Begin
  regs.dx:=Irq;  {com1=0;com2=1;com3=2;com4=3}
  regs.al:=$00;
  regs.ah:=$06;
  intr($14,regs);
  Exit;
End;

Procedure HangUp;
Var      b : Byte;
Begin
  {$I-}
  Close(qf);
  Close(cf);
  {$I+}
  q:=IOResult;
  FileMode:=2;
  If fExist(PceDir+'PCEDOOR.DA'+Node) then Begin
    Assign(df,PceDir+'PCEDOOR.DA'+Node);
    b:=0;
    Repeat
      {$I-}
      Reset(df);
      Read(df,dr);
      dr.name:='&"$"1462"aeat4asl';
      Seek(df,0);
      Write(df,dr);
      Close(df);
      {$I+}
      Inc(b);
    Until (IOResult=0) or (b>40);

  End;
  If dr.commPortIrq=0 then dr.commPortIrq:=1;
  Lower_Dtr(dr.commPortIrq-1);
  Halt;
End;

Procedure OutFile(fn : String; More : Boolean);
Begin
  pkSendFile(fn,More);
End;

Procedure ReadMainCfg;
Var b                 : Byte;
    d                 : String[3];
    IOR               : Integer;
Begin
  FileMode:=64;
  Assign(cf,MainDir+'Main.cfg');
  b:=0;
  Repeat
    {$I-}
    Reset(cf);
    {$I+}
    Inc(b);
    IOR:=IOResult;
  Until (b>40) or (IOR=0);
  If (IOR=0) then Begin
    tries:=3;
    triesGlobal:=12;
    {$I-}
    Repeat
      ReadLn(cf,d);
    Until d[1]<>';';
    tries:=StrInt(Trim(d));
    Repeat
      ReadLn(cf,d);
    Until d[1]<>';';
    triesGlobal:=StrInt(Trim(d));
    Close(cf);
    {$I+}
    If IOResult<>0 then Begin
      WriteLn;
      WriteLn(' Error reading ''MAIN.CFG''!');
      WriteLn;
    End;
  End;
End;

Function GetUserData(s : String) : Boolean;
Begin

  { in the next version :-) }

End;

Procedure GetInput(s : String);
Var  bad,unknow,pw   : String;
     b               : Byte;
     IOR             : Integer;
Begin
  ReadLn(qf,unknow);             { Read data for unknow btw. unkorrect input }
  ReadLn(qf,bad);                { Read data for reject btw. disconnect      }
  If q=1 then Disconnect:=bad;           { Disconnect = Display while HangUp }

  FileMode:=64;
  Assign(cf,MainDir+'SYSPW'+IntStr(q)+'.CFG');
  b:=0;
  Repeat
    {$I-}
    Reset(cf);
    {$I+}
    Inc(b);
  Until (b>40) or (IOR=0);
  ReadLn(cf,pw);
  Close(cf);
  pw:=Upper(pw);
  sTries:=0;
  Repeat
    LastInput:=Upper(EnterLine(s,79-Length(s)));
    pkLn;
    If LastInput<>Pw then Begin
      pkWriteLn(unknow);
      Inc(sTries);
      Inc(sTriesGlobal);
    End;
  Until (LastInput=Pw) or (sTries=Tries) or (sTriesGlobal=TriesGlobal) ;
  If LastInput<>Pw then Begin
    pkWriteLn(bad);
    pkLn;
    pkLn;
    If (q=1) or (sTriesGlobal>=TriesGlobal) then Begin
      pkWriteLn(Disconnect);
      HangUp;
    End;
    While not eof(qf) do ReadLn(qf,bad);
    q:=q-2;
    If q<0 then q:=0;
  End;

End;

Procedure Out(s : String);
Var       i,i2            : Byte;
          p               : Boolean;
          u               : String;
Begin
  p:=False;
  If Pos('@',s)<>0 then Begin
    u:=Upper(s);

    i:=Pos('@DISPLAYFILE@',u);                                { Display File }
    If i=1 then Begin
      i2:=Pos('%1',u);                           { replace %1 to <NodeNumber> }
      If i2<>0 then Begin
        Delete(s,i2,2);
        Insert(Node,s,i2)
      End;
      OutFile(Copy(s,i+13,255),True);
      p:=True;
    End;

    i:=Pos('@INPUT@',u);
    If i<>0 then Begin                   { Input and verify with SYSPWx.CFG }
        GetInput(Copy(s,1,i-1));
        p:=True;
    End;

    i:=Pos('@LASTINPUT@',u);
    If i<>0 then Begin                                  { Display Last Input }
      pkWriteLn(Copy(s,1,i-1)+LastInput);
      p:=True;
    End;

    i:=Pos('@USERNAME@',u);                      { Input Username and verify }
    If i<>0 then Begin                                       { with userbase }
      GetUserData(Copy(s,1,i-1));
    End;

    i:=Pos('@USERPASSWORD@',u);              { Input Userpassword and verify }
    If i<>0 then Begin                                       { with userbase }
      GetUserData(Copy(s,1,i-1));
    End;

    i:=Pos('@LOCATION@',u);                          { Display User-Location }
    If i<>0 then Begin
      pkWriteLn(Copy(s,1,i-1)+ur.Location);
    End;

    i:=Pos('@LASTDATE@',u);                       { Display Last Login-datae }
    If i<>0 then Begin
      pkWriteLn(Copy(s,1,i-1)+ur.LastDate);
    End;

  End;
  If not p then If s='' then pkLn else pkWriteLn(s);      { Output on Screen }

End;

Function Question(fn : String) : Boolean;
Var b,i                 : Byte;
    d                   : String;
    IOR                 : Integer;
Begin
  Question:=False;
  If fExist(MainDir+fn) then Begin
    FileMode:=64;
    Assign(qf,MainDir+fn);
    b:=0;
    Repeat
      {$I-}
      Reset(qf);
      {$I+}
      Inc(b);
      IOR:=IOResult;
    Until (b>40) or (IOR=0);

    If IOR=0 then Begin
      While not eof(qf) do Begin
        ReadLn(qf,d);
        Out(d);
      End;
      Close(qf);
      Question:=True;
    End;

  End;
End;


Begin
  DirectVideo:=False;
  pkClrScr;
  pkAbout:=Center(' Login Matrix ۲ v.1.0 (c) June ''96 by MuHaDiB of AylA-BBs',78,' ');
  pkStatusBar(9);
  pkLn;
  Node:=Trim(Copy(ParamStr(1),3,3));
  MainDir:=MDir(ParamStr(0));
  PceDir:=GEnv('PCEXPRESS');

  ReadMainCfg;                  { Read Main.Cfg }

  q:=0;
  {
  pkAnsi:=RemoteAnsiDetected;
  If pkAnsi then WriteLn('Ansi detected!') else WriteLn('Asci detected!');
  WriteLn;
  }
  Repeat
    Inc(q);
  Until not Question('SYSPW'+IntStr(q)+'.TXT');
  Halt;
End.
