Unit pkDIRX;

{***********************************************************}
{*                     pkDIRX.PAS 1.11                     *}
{*   Freeware, but remains copyright to Creative Team and  *}
{*                    the author, MugSHot                  *}
{***********************************************************}
{-Allround PC-Express DIRX.TXT file handling.}

interface

uses DOS,
     CRT,
     pkMISC,
     pkAsync;

const pkdirxversion  = 'pkDIRX Evoluzione II';
      pkdirxmaxlines = 60;

type pkDIRXRecPtr = ^pkDIRXRecord;
     pkDIRXRecord = record
      percentage  : real;
      dirxsize    : longint;
      filename    : string[12];
      fileext     : string[3];
      filesize    : LongInt;
      nukedesc    : string[10];
      exists,
      pay         : boolean;
      filedate    : string[8];
      file_id     : array[1..pkDirxMaxLines] of string;
      startpos,               {-starting position of the current file
                               only supported by pkdirxgetentry at this time}
      lastpos     : longint;  {-ending position of the current file and the
                               last position in a dirx file}
     end;

     ScanRecPtr   = ^ScanRecord;
     ScanRecord   = record
      Scanstr     : array[1..60] of string[80];
     end;

     AbortProc      = procedure;
     WriteProc      = procedure(str : string);
     KeyPressedFunc = function : boolean;
     ReadKeyFunc    = function : char;

Function  TextFilePos(Var f : Text) : LongInt;

Procedure TextSeek(Var f : Text; n : LongInt);

procedure pksetdirxkeypeek(newfunc : readkeyfunc);

procedure pksetdirxreadkeyfunc(newfunc : readkeyfunc);

procedure pksetdirxkeyfunc(newfunc : keypressedfunc);

procedure pksetdirxdetectkey(on : boolean);

function  pkdirxscanstate : boolean;

procedure pksetdirxwriteproc(newproc : writeproc);

procedure pksetdirxscan(on : boolean);

procedure pksetdirxscanrate(lines : byte);

procedure pksetdirxfilepos(NewFilePos : longint; var dirxrec : pkdirxrecptr;
                           doCheck : boolean);

procedure pkread_pkdirx_scan_animation(fn : pathstr);

function  pkdirxgetentry(conference, area : byte; var dirxrec : pkdirxrecptr;
                         first : boolean) : byte;

function  pkdirxreverse(conference, area : byte; var dirxrec : pkdirxrecptr;
                        first : boolean) : byte;

function  pkdirxstringscan(conference,area : byte; var dirxrec : pkdirxrecptr;
                           searchstr,hicol,lowcol : string; first : boolean) : byte;


function  pkdirxdayscan(conference,area : byte; var dirxrec : pkdirxrecptr;
                        dayz : word; first,speedsearch : boolean) : byte;

function  pkdirxfilescan(conference,area : byte; var dirxrec : pkdirxrecptr;
                         wildcard : string; first : boolean) : byte;

var glAbortProc : AbortProc;
implementation

const copyright     = 'Portions Copyright (c) 1995-96 by Creative Team.';
      LF = #10;

type {$I pkstruct.120}

     BufferArray = Array[1..65521] of Char;
     BackRec = Record
      Handle : Word;
      Mode : Word;
      RecSize : Word;
      Private : Array[1..26] of Byte;
      Fpos : LongInt;             {Current File position}
      BufP : ^BufferArray;        {Pointer to Text buffer}
      Bpos : Word;                {Current position Within buffer}
      Bcnt : Word;                {Count of Characters in buffer}
      Bsize : Word;               {Size of Text buffer, 0 if none}
      UserData : Array[15..16] of Byte; {Remaining UserData}
      Name : Array[0..79] of Char;
     end;

     BackText = File;

var dir         : text;
    reversedir  : backtext;
    bbspath,str : string;
    IOSave,
    maxareas    : byte;
    pkconf      : conrec;
    glLastPos   : longInt;
    glBufPos    : longint;
    glFileSize  : longint;
    glNewChk    : boolean;
    glWriteProc : writeproc;
    glKeyPeek   : readkeyfunc;
    glReadKey   : readkeyfunc;
    glKeyFunc   : keypressedfunc;
    glDoScan    : boolean;
    glDetectKey : boolean;
    glScanMax   : byte;
    glCounter   : byte;
    glScanCnt   : byte;
    glChkScan   : byte;
    glBackPos   : byte;
    ExitSave    : Pointer;
    Scan        : ScanRecPtr;
    BResult     : word;
    ch          : char;

  Procedure AssignBack(Var F : BackText; Fname : String);
    {-Assign a backwards File to a File Variable}
  begin
    glFileSize:=pkfilesize(fname);
    if BResult = 0 then begin
      Assign(File(F), Fname);
      BResult := IoResult;
    end;
  end;

  Procedure ResetBack(Var F : BackText; BufSize : Word);
    {-Reset a backwards File, allocating buffer}
  Var
    BR : BackRec Absolute F;
  begin
    if BResult = 0 then
      With BR do begin
        {Open File}
        Reset(File(F), 1);
        BResult := IoResult;
        if BResult <> 0 then
          Exit;

        {Seek to end}
        Fpos := FileSize(File(F));
        Seek(File(F), Fpos);
        BResult := IoResult;
        if BResult <> 0 then
          Exit;

        {Allocate buffer}
        if BufSize < 128 then
          BufSize := 128;
        if MaxAvail < BufSize then begin
          BResult := 203;
          Exit;
        end;
        GetMemCheck(BufP, BufSize);
        Bsize := BufSize;
        Bcnt := 0;
        Bpos := 0;
      end;
  end;

  Procedure SeekBack(Var F : BackText; Pos : Longint);
  Var
    BR : BackRec Absolute F;
  begin
    if BResult = 0 then
      With BR do begin
        {Open File}

        FPos:=Pos;
        BResult := IoResult;
        if BResult <> 0 then
          Exit;
      end;
  end;

  Function BackFilePos(Var F : BackText): Longint;
  Var
    BR : BackRec Absolute F;
  begin
    if BResult = 0 then
      With BR do begin
        BackFilePos:=Fpos;
        BResult := IoResult;
        if BResult <> 0 then
         Exit;
   end;
  end;

  Function BoF(Var F : BackText) : Boolean;
    {-Return True when F is at beginning of File}
  Var
    BR : BackRec Absolute F;
  begin
    With BR do
      BoF := (Fpos = 0) and (Bpos = 0);
  end;

  Function GetCh(Var F : BackText) : Char;
    {-Return next Character from end of File}
  Var
    BR : BackRec Absolute F;
    Bread : Word;
  begin
    With BR do begin
      if Bpos = 0 then
        {Buffer used up}
        if Fpos > 0 then begin
          {Unread File remains, first reposition File Pointer}
          Bread := Bsize;
          Dec(Fpos, Bread);
          if Fpos < 0 then begin
            {Reduce the number of Characters to read}
            Inc(Bread, Fpos);
            Fpos := 0;
          end;
          Seek(File(F), Fpos);
          BResult := IoResult;
          if BResult <> 0 then
            Exit;

          {Refill buffer}
          BlockRead(File(F), BufP^, Bread, Bcnt);
          BResult := IoResult;
          if BResult <> 0 then
            Exit;

          {Remove ^Z's from end of buffer}
          While (Bcnt > 0) and (BufP^[Bcnt] = ^Z) do
            Dec(Bcnt);
          Bpos := Bcnt;
          if Bpos = 0 then begin
            {At beginning of File}
            GetCh := LF;
            Exit;
          end;

        end else begin
          {At beginning of File}
          GetCh := LF;
          Exit;
        end;

      {Return next Character}
      GetCh := BufP^[Bpos];
      Dec(Bpos);
    end;
  end;

  Procedure ReadLnBack(Var F : BackText; Var S : String);
    {-Read next line from end of backwards File}
  Var
    Slen : Byte Absolute S;
    Tpos : Word;
    Tch : Char;
    T : String;
  begin
    Slen := 0;
    if (BResult = 0) and not BoF(F) then begin
      {Build String from end backwards}
      Tpos := 256;
      Repeat
        Tch := GetCh(F);
        if BResult <> 0 then
          Exit;
        if Tpos > 1 then begin
          Dec(Tpos);
          T[Tpos] := Tch;
        end;
        {Note that GetCh arranges to return LF at beginning of File}
      Until Tch = LF;
      {Transfer to result String}
      Slen := 255-Tpos;
      if Slen > 0 then
        Move(T[Tpos+1], S[1], Slen);
      {Skip over (presumed) CR}
      Tch := GetCh(F);
    end;
  end;

  Procedure CloseBack(Var F : BackText);
    {-Close backwards File, releasing buffer}
  Var
    BR : BackRec Absolute F;
  begin
    if BResult = 0 then
      With BR do begin
        glBufPos:=BPos;
        FreeMemCheck(BufP, Bsize);
        Close(File(F));
        BResult := IoResult;
        if BResult <> 0 then
          Exit;
       end;
  end;

  Function BackResult : Word;
    {-Return I/O status code from operation}
  begin
    BackResult := BResult;
    BResult := 0;
  end;

Procedure GetFileMode; Assembler;

ASM
        CLC
        CMP    ES:[DI].TextRec.Mode, fmInput
        JE     @1
        MOV    [InOutRes], 104         { 'File not opened for reading' }
        XOR    AX, AX                  { Zero out function result }
        XOR    DX, DX
        STC
@1:
end;

Function TextFilePos(Var f : Text) : LongInt; Assembler;

ASM
        LES    DI, f
        CALL   GetFileMode
        JC     @1

        XOR    CX, CX                  { Get position of file pointer }
        XOR    DX, DX
        MOV    BX, ES:[DI].TextRec.handle
        MOV    AX, 4201h
        INT    21h                     { offset := offset-BufEnd+BufPos }
        XOR    BX, BX
        SUB    AX, ES:[DI].TextRec.BufEnd
        SBB    DX, BX
        ADD    AX, ES:[DI].TextRec.BufPos
        ADC    DX, BX
@1:
end;

Procedure TextSeek(Var f : Text; n : LongInt); Assembler;

ASM
        LES    DI, f
        CALL   GetFileMode
        JC     @2

        MOV    CX, Word Ptr n+2        { Move file pointer }
        MOV    DX, Word Ptr n
        MOV    BX, ES:[DI].TextRec.Handle
        MOV    AX, 4200h
        INT    21h
        JNC    @1                      { Carry flag = reading past EOF }
        MOV    [InOutRes], AX
        JMP    @2


        { Force read next time }
@1:     MOV    AX, ES:[DI].TextRec.BufEnd
        MOV    ES:[DI].TextRec.BufPos, AX
@2:
end;

procedure readconf(conference : byte);
var conf_f : File of conRec;
    i: byte;

begin
   pkShareFile(True,False);
   Assign(conf_f,bbspath+'CONFER.CFG');
    i := 0;
     repeat
      inc(i);
      {$I-} Reset(conf_f); {$I+}
      IOSave:=IOResult;
     until (i > 50) or (iosave = 0);
   if IOSave=0 then
    begin
     if conference > 1 then seek(conf_f,conference-1);
     read(conf_f,pkconf);
     close(conf_f);
    end;
end;

function getmaxareas(conference : byte) : byte;
var i : byte;
begin
 getmaxareas:=0;
 readconf(conference);
 if not pkconf.conffilearea then exit;
 i:=0;
 repeat
  if pkconf.conffiles[i+1] <> '' then inc(i);
 until (i=9) or (pkconf.conffiles[i+1]='');
 getmaxareas:=i;
end;

function resetdir(conference,area : byte; var dirxrec : pkdirxrecptr) : byte;
{ return codes: 0 - Ok.
                1 - No DIRX.TXT file present.
                2 - Error while trying to reset DIRX.TXT file }

var i : byte;
begin
 resetdir:=1;

 if area=0 then if not pkexist(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT')
  or (pkfilesize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT')=0)
  then exit;

 if (area <> 0) and (not pkconf.cdrom[area]) then if not
  pkexist(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if (area <> 0) and (pkconf.cdrom[area]) then if not
  pkexist(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if area <> 0 then
 begin
  if pkconf.cdrom[area] then
   begin
    pkShareAssign(dir,pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT',True,False);
    glFileSize:=pkFileSize(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT');
    dirxrec^.dirxsize:=glfilesize;
   end
  else
  begin
   pkShareAssign(dir,pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT',True,False);
   glFileSize:=pkFileSize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT');
   dirxrec^.dirxsize:=glfilesize;
  end
 end
 else
 begin
  pkShareAssign(dir,pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT',True,False);
  glFileSize:=pkFileSize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT');
  dirxrec^.dirxsize:=glfilesize;
 end;

 i:=0;
 repeat
  inc(i);
  {$I-} Reset(dir); {$I+}
  IOSave:=IOResult;
 until (i > 20) or (IOSave=0);
 if i > 20 then begin resetdir:=2; exit end
 else resetdir:=0;
end;

function eod(str : string) : boolean;
{-End of description}
begin


end;

function resetreversedir(conference,area : byte; var dirxrec : pkdirxrecptr) : byte;
{ return codes: 0 - Ok.
                1 - No DIRX.TXT file present.
                2 - Error while trying to reset DIRX.TXT file }

begin
 resetreversedir:=1;

 if area=0 then if not pkexist(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT') or
  (pkfilesize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT')=0)
  then exit;

 if (area <> 0) and (not pkconf.cdrom[area]) then if not
  pkexist(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if (area <> 0) and (pkconf.cdrom[area]) then if not
  pkexist(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT') or
  (pkfilesize(pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT')=0)
  then exit;

 if area <> 0 then
 begin
  if pkconf.cdrom[area] then
   begin
    pkShareFile(True,False);
    AssignBack(reversedir,pkconf.confpath+'DIR'+pkintstr(area,0)+'.TXT');
    glFileSize:=pkFileSize(pkconf.confpath+'DIR'+pkintstr(conference,0)+pkintstr(area,0)+'.TXT');
    dirxrec^.dirxsize:=glfilesize;
   end
  else
   begin
    pkShareFile(True,False);
    AssignBack(reversedir,pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT');
    glFileSize:=pkFileSize(pkconf.conffiles[area]+'DIR'+pkintstr(area,0)+'.TXT');
    dirxrec^.dirxsize:=glfilesize;
   end
 end
 else
  begin
   pkShareFile(True,False);
   AssignBack(reversedir,pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT');
   glFileSize:=pkFileSize(pkconf.conffiles[maxareas]+'HOLD\DIR0.TXT');
   dirxrec^.dirxsize:=glfilesize;
  end;

 ResetBack(reversedir,1024);

 if BResult <> 0 then begin resetreversedir:=2; exit end
 else resetreversedir:=0;
end;

procedure clearrecord(var dirxrec : pkdirxrecord);
var i : word;
begin
  with dirxrec do
  begin
   filename := '';
   fileext  := '';
   filesize :=  0;
   exists   := false;
   pay      := false;
   filedate := '';
   for i:=1 to pkDirxMaxLines do file_id[i]  := '';
  end;
end;

procedure chkscan;
begin
 inc(glCounter);
 if glCounter=glChkScan then begin
                              glCounter:=0;
                              Inc(glScanCnt);
                              if glScanCnt > glScanMax then glScanCnt:=1;
                              glWriteProc(scan^.scanstr[glScanCnt]+Esc+'['+pkintstr(glBackPos,0)+'D');
                             end;
end;

function BoE(str : string) : boolean;
{-begin of entry.}
begin
 if (str[1] <> ' ') and (str[1] <> '.') and (str[1] <> '>') then boe := true
  else boe := false;
end;

function EoE(str : string) : boolean;
{-end of entry.}
begin
 if (str[1] <> ' ') and (str[1] <> '>') then EoE := true else EoE := false;
end;

procedure readentry(conference,area : byte; var dirxrec : pkdirxrecptr);
var tmp  : string;
    fstr : string[12];
    x    : integer;

begin

 clearrecord(dirxrec^);
 fstr:=pkextractwords(1,1,str);

 if pos('.',str) > 0 then
 begin                                                {v1.11}
  x:=pos('.',str);                                    {v1.11}
  dirxrec^.filename := copy(str,1,x-1);               {v1.11}
  dirxrec^.fileext  := copy(str,x+1,length(fstr)-x);  {v1.11}
 end else                                             {v1.11}
 begin                                                {v1.11}
  dirxrec^.filename := pkextractwords(1,1,str);       {v1.11}
  dirxrec^.fileext  := '';                            {v1.11}
 end;                                                 {v1.11}
 x:=0;                                                {v1.11}

 if pkconf.CONFFreeDown then dirxrec^.pay:=false else
 begin
  if pkupper(pkextractwords(2,1,str))='F' then dirxrec^.pay:=false
  else dirxrec^.pay:=true;
 end;

 dirxrec^.filedate:=pkextractwords(3,1,str);
 if pkwordcnt(str)=4 then dirxrec^.nukedesc:=pkextractwords(4,1,str);

  if area=0 then
  begin
   if pkexist(pkconf.confFiles[maxareas]+'HOLD\'+pkextractwords(1,1,str)) then
    begin
     dirxrec^.exists:=true;
     dirxrec^.FileSize:=pkFileSize(pkconf.confFiles[maxareas]+'HOLD\'+pkextractwords(1,1,str));
    end else begin dirxrec^.exists:=false; dirxrec^.filesize:=0; end;
  end
  else if pkexist(pkconf.conffiles[area]+pkextractwords(1,1,str)) then
  begin
   dirxrec^.exists:=true;
   dirxrec^.filesize:=pkfilesize(pkconf.conffiles[Area]+pkextractwords(1,1,str));
  end else begin dirxrec^.exists:=false; dirxrec^.filesize:=0; end;

  x:=0;
  repeat
   glLastPos:=TextFilePos(dir);
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan;

   if glDetectKey and glKeyFunc and (glKeyPeek=#27) then
   begin
    ch:=glReadKey;
    glWriteProc('Scanning Aborted.');
    close(dir);
    glabortproc;
    halt;
   end
   else if glDetectKey and glKeyFunc and (glKeyPeek<> #27) then glReadkey;

   readln(dir,str);
   if (str[1] in [' ','>']) and (x < pkdirxmaxlines+1) then
   begin inc(x); dirxrec^.file_id[x]:=str; end;
  until eof(dir) or (EoE(str)) or (x >= pkdirxmaxlines);
  if x=0 then dirxrec^.file_id[1]:=' No description found.';

  dirxrec^.percentage :=(TextFilePos(dir)/glFileSize)*100;
end;

procedure clearrec(var dirxrec : pkdirxrecptr);
var i : byte;
begin
  with dirxrec^ do
  begin
   percentage  := 0;
   dirxsize    := 0;
   filename    := '';
   fileext     := '';
   filesize    := 0;
   nukedesc    := '';
   exists      := false;
   pay         := false;
   filedate    := '';
   for i:=1 to pkdirxmaxlines do file_id[i]:='';
 end;
end;

function pkdirxgetentry(conference, area : byte; var dirxrec : pkDIRXRecPtr;
                        first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

var i   : byte;
begin
 pkdirxgetentry := 1;
 if (conference > 200) or (area > 9) then exit;

 maxareas:=getmaxareas(conference);
 if maxareas=0 then begin pkdirxgetentry:=2; exit; end;

 clearrec(dirxrec);

 if first then
 begin
  glScanCnt:=0;
  glLastPos:=0;
  i:=resetdir(conference,area,dirxrec);
  if i <> 0 then begin pkdirxgetentry:=i+2; exit; end;
  repeat
   glLastPos:=TextFilePos(dir);
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan;
   readln(dir,str);

   if boe(str) then
   begin
    dirxrec^.startpos:=glLastPos;
    readentry(conference,area,dirxrec);
    pkdirxgetentry:=0;
    close(dir);
    exit;
   end;

  until eof(dir);
  if eof(dir) then
   begin
    pkdirxgetentry:=5;
    close(dir);
    exit;
   end;
 end
 else
 begin
  i:=resetdir(conference,area,dirxrec);
  if i <> 0 then begin pkdirxgetentry:=i+2; exit; end;
  glLastPos:=dirxrec^.lastpos;
  TextSeek(dir,glLastPos);
  if eof(dir) then
   begin
    pkdirxgetentry:=5;
    close(dir);
    exit;
   end;
  repeat
   glLastPos:=TextFilePos(dir);
   dirxrec^.lastpos:=glLastPos;

   if glNewChk and (glLastpos <> 0) then
    begin readln(dir,str); glNewChk:=False; end;

   if glDoScan then ChkScan;
   if not eof(dir) then readln(dir,str);

   if boe(str) then
   begin
    dirxrec^.startpos:=glLastPos;
    readentry(conference,area,dirxrec);
    pkdirxgetentry:=0;
    close(dir);
    exit;
   end;

  until eof(dir);
  if eof(dir) then begin pkdirxgetentry:=5; close(dir); exit; end;
 end;
end;

function pkdirxstringscan(conference,area : byte; var dirxrec : pkDIRXRecPtr;
                          searchstr,hicol,lowcol : string; first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

function chkstr : boolean;
var i     : word;
    index : byte;
    tmp   : string;

begin
 chkstr:=false;

 if pos(pkupper(searchstr),pkupper(dirxrec^.filename)) <> 0 then
  chkstr:=true;

 for i:=1 to pkdirxmaxlines do
 if pos(pkupper(searchstr),pkupper(dirxrec^.file_id[i])) <> 0 then
 begin
  index:=pos(pkupper(searchstr),pkupper(dirxrec^.file_id[i]));
  tmp:=hicol+pkupper(searchstr)+lowcol;

  delete(dirxrec^.file_id[i],index,length(searchstr));
  insert(tmp,dirxrec^.file_id[i],index);

  chkstr:=true;
 end;
end;

var i : byte;
begin
 i:=pkdirxgetentry(conference,area,dirxrec,first);
 if i <> 0 then begin pkdirxstringscan:=i; exit; end;
                          if chkstr then begin pkdirxstringscan:=0; exit; end;
 first:=false;

 repeat
  i:=pkdirxgetentry(conference,area,dirxrec,first);
  if i = 0 then if chkstr then begin pkdirxstringscan:=0; exit; end;
 until i <> 0;
 pkdirxstringscan:=i;
end;

function pkdirxfilescan(conference,area : byte; var dirxrec : pkdirxrecptr;
                        wildcard : string; first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

function chkfile : boolean;
var tmp : string[12];
begin
 if dirxrec^.fileext='' then tmp:=dirxrec^.filename
 else tmp:=dirxrec^.filename+'.'+dirxrec^.fileext;

{ if pos('.',wildcard) = 0 then tmp:=dirxrec^.filename;}

 chkfile:=pkwildcompare(pkupper(wildcard),pkupper(tmp));
end;

var i : byte;
begin
 i:=pkdirxgetentry(conference,area,dirxrec,first);
 if i <> 0 then begin pkdirxfilescan:=i; exit; end;

 if chkfile then begin pkdirxfilescan:=0; exit; end;
 first:=false;

 repeat
  i:=pkdirxgetentry(conference,area,dirxrec,first);
  if i = 0 then if chkfile then begin pkdirxfilescan:=0; exit; end;
 until i <> 0;
 pkdirxfilescan:=i;
end;

function pkdirxreverse(conference, area : byte; var dirxrec : pkdirxrecptr;
                        first : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                        *}

var tmpline    : array [1..pkdirxMaxLines] of string[60];
    tmpcounter : byte;
    x          : byte;

procedure readbackentry;
var i,x : byte;
    fstr: string;

begin

 i:=0;

 clearrecord(dirxrec^);
 fstr:=pkextractwords(1,1,str);

 if pos('.',str) > 0 then                            {v1.11}
 begin                                               {v1.11}
  x:=pos('.',str);                                   {v1.11}
  dirxrec^.filename := copy(str,1,x-1);              {v1.11}
  dirxrec^.fileext  := copy(str,x+1,length(fstr)-x); {v1.11}
 end else                                            {v1.11}
 begin                                               {v1.11}
  dirxrec^.filename := pkextractwords(1,1,str);      {v1.11}
  dirxrec^.fileext  := '';                           {v1.11}
 end;                                                {v1.11}
 x:=0;                                               {v1.11}

 if pkconf.CONFFreeDown then dirxrec^.pay:=false else
 begin
  if pkupper(pkextractwords(2,1,str))='F' then dirxrec^.pay:=false
  else dirxrec^.pay:=true;
 end;

 dirxrec^.filedate:=pkextractwords(3,1,str);
 if pkwordcnt(str)=4 then dirxrec^.nukedesc:=pkextractwords(4,1,str);

  if area=0 then
  begin
   if pkexist(pkconf.confFiles[maxareas]+'HOLD\'+pkextractwords(1,1,str)) then
   begin
     dirxrec^.exists:=true;
     dirxrec^.FileSize:=pkFileSize(pkconf.confFiles[maxareas]+'HOLD\'+pkextractwords(1,1,str));
    end else begin dirxrec^.exists:=false; dirxrec^.filesize:=0; end;
  end
  else if pkexist(pkconf.conffiles[area]+pkextractwords(1,1,str)) then
  begin
   dirxrec^.exists:=true;
   dirxrec^.filesize:=pkfilesize(pkconf.conffiles[Area]+pkextractwords(1,1,str));
  end else begin dirxrec^.exists:=false; dirxrec^.filesize:=0; end;

 if tmpcounter > 0 then
 begin
  for i:=tmpcounter downto 1 do
  begin inc(x); dirxrec^.file_id[x]:=tmpline[i]; end;
 end
 else
  begin
   dirxrec^.file_id[1]:=' No description found.';
   dirxrec^.lastpos   :=BackFilePos(reversedir);
  end;

end;

var i   : byte;
    BR : BackRec Absolute Reversedir;

begin

 for i:=1 to pkdirxmaxlines do tmpline[i]:='';
 tmpcounter:=0;

 pkdirxreverse:= 1;
 if (conference > 200) or (area > 9) then exit;

 maxareas:=getmaxareas(conference);
 if maxareas=0 then begin pkdirxreverse:=2; exit; end;

 clearrec(dirxrec);

 if first then
 begin
  glScanCnt:=0;
  glLastPos:=0;
  i:=resetreversedir(conference,area,dirxrec);
  if i <> 0 then begin pkdirxreverse:=i+2; exit; end;
  repeat
   glLastPos:=BackFilePos(reversedir);
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan;

   if glDetectKey and glKeyFunc and (glKeyPeek=#27) then
   begin
    ch:=glReadKey;
    glWriteProc('Scanning Aborted.');
    closeback(reversedir);
    glabortproc;
    halt;
   end
   else if glDetectKey and glKeyFunc and (glKeyPeek<> #27) then glReadkey;

   if glNewChk and (glLastpos <> dirxrec^.dirxsize)
    then begin readlnback(reversedir,str); glNewChk:=False; end;

   if not bof(reversedir) then readlnback(reversedir,str);


   if str[1] in [' ','>'] then
   begin
    inc(tmpcounter);
    tmpline[tmpcounter]:=str;
   end;

   if BoE(str) and (str <> '') then
   begin
    dirxrec^.percentage :=100-(((BackFilePos(reversedir)+br.BPos)/glFileSize)*100);
    readbackentry;
    closeback(reversedir);
    pkdirxreverse:=0;
    exit;
   end;

  until bof(reversedir);
  if bof(reversedir) then begin
                           pkdirxreverse:=5;
                           closeback(reversedir);
                           exit;
                          end;
 end
 else
 begin
  i:=resetreversedir(conference,area,dirxrec);
  if i <> 0 then begin pkdirxreverse:=i+2; exit; end;

  glLastPos:=dirxrec^.lastpos;
  SeekBack(reversedir,glLastPos+glBufPos);
  if bof(reversedir) then begin
                           pkdirxreverse:=5;
                           closeback(reversedir);
                           exit;
                          end;
  repeat
   glLastPos:=BackFilePos(reversedir);
   dirxrec^.lastpos:=glLastPos;
   if glDoScan then ChkScan;

   if glDetectKey and glKeyFunc and (glKeyPeek=#27) then
   begin
    ch:=glReadKey;
    glWriteProc('Scanning Aborted.');
    closeback(reversedir);
    glabortproc;
    halt;
   end
   else if glDetectKey and glKeyFunc and (glKeyPeek<> #27) then glReadkey;

  if glNewChk and (glLastpos <> dirxrec^.dirxsize)
    then begin readlnback(reversedir,str); glNewChk:=False; end;
{!}
   readlnback(reversedir,str);

   if str[1] in [' ','>'] then
   begin
    inc(tmpcounter);
    tmpline[tmpcounter]:=str;
   end;

  if BoE(str) and (str <> '') then
   begin
    dirxrec^.percentage :=100-(((BackFilePos(reversedir)+br.Bpos)/glFileSize)*100);
    if bof(reversedir) then dirxrec^.percentage:=100;

    readbackentry;
    pkdirxreverse:=0;
    closeback(reversedir);
    exit;
   end;

  until bof(reversedir);
  if bof(reversedir) then begin
                           pkdirxreverse:=5;
                           closeback(reversedir);
                           exit;
                          end;
 end;
end;

function pkdirxdayscan(conference,area : byte; var dirxrec : pkdirxrecptr;
                       dayz : word; first,speedsearch : boolean) : byte;
{* return codes: 0 = Ok.
                 1 = Incorrect use of function.
                 2 = This conference has no areas.
                 3 = DIRX.TXT file not present.
                 4 = Error while trying to reset DIRX.TXT file.
                 5 = No entry found                                         *}

function chkdayz : boolean;
var  dte  : date;
     tme  : time;
     a,b  : datetimerec;
     days : word;
     secs : longint;
     year,month,day,dayofweek : word;

begin
 chkdayz:=false;

 GetDate(year,month,day,dayofweek);
 dte := DMYtoDate(day,month,year);
 tme := HMStoTime(0,0,0);
 a.d := dte;
 a.t := tme;

 dte := DMYtoDate(pkstrint(copy(dirxrec^.filedate,5,2)),
                  pkstrint(copy(dirxrec^.filedate,3,2)),
                  pkstrint('19'+copy(dirxrec^.filedate,1,2)));
 tme := HMStoTime(0,0,0);
 b.d := dte;
 b.t := tme;

 DateTimeDiff(a,b,days,secs);

 if days <= dayz then chkdayz:=true;

end;

var i : byte;
begin
 i:=pkdirxreverse(conference,area,dirxrec,first);
 if i <> 0 then begin pkdirxdayscan:=i; exit; end;

 if chkdayz then begin pkdirxdayscan:=0; exit; end
 else if speedsearch then begin pkdirxdayscan:=5; exit; end;
 first:=false;

 repeat
  i:=pkdirxreverse(conference,area,dirxrec,first);
  if i = 0 then if chkdayz then begin pkdirxdayscan:=0; exit; end
  else if speedsearch then begin pkdirxdayscan:=5; exit; end;
 until i <> 0;
 pkdirxdayscan:=i;
end;

procedure pksetdirxkeypeek(newfunc : readkeyfunc);
begin glKeyPeek:=NewFunc; end;

procedure pksetdirxreadkeyfunc(newfunc : readkeyfunc);
begin glReadKey:=NewFunc; end;

procedure pkSetDirXKeyFunc(NewFunc : KeyPressedFunc);
begin glKeyFunc:=NewFunc; end;

procedure pkSetDirXWriteProc(NewProc : WriteProc);
begin glWriteProc:=NewProc; end;

procedure pksetdirxdetectkey(on : boolean);
begin glDetectKey:=On; end;

procedure pksetdirxscan(on : boolean);
begin glDoScan:=On; end;

procedure pkread_pkdirx_scan_animation(fn : pathstr);
var txt : text;
      i : byte;

begin
 GetMemCheck(Scan,SizeOf(ScanRecord));
 for i:=1 to 60 do scan^.scanstr[i]:='';

 if not pkexist(fn) then exit;
 pkShareAssign(txt,fn,True,False);
 reset(txt);
 readln(txt,str);
 glBackPos:=pkstrint(str);
 glScanMax:=0;
 repeat
  Inc(glScanMax);
  readln(txt,scan^.scanstr[glscanmax]);
 until eof(txt) or (glScanMax=60);
 close(txt);
end;

procedure pksetdirxscanrate(lines : byte);
begin glChkScan:=lines; end;

procedure pksetdirxfilepos(NewFilePos : longint; var dirxrec : pkdirxrecptr; doCheck : boolean);
begin dirxrec^.LastPos:=NewFilePos; glNewChk:=doCheck; end;

procedure dirxexitproc; far;
var BR : BackRec Absolute reversedir;
begin
 ExitProc:=ExitSave;
 if Scan <> Nil then FreeMemCheck(Scan,SizeOf(ScanRecord));
end;

function  pkdirxscanstate : boolean;
begin pkdirxscanstate := gldoscan; end;

procedure DoNothingProc;
begin
end;

var stamp    : array[1..2] of string;
begin

 stamp[1]    := copyright;
 stamp[2]    := pkdirxversion;

 ExitSave    := ExitProc;
 ExitProc    := @DirxExitProc;

 glWriteProc := Nil;
 glKeyFunc   := Nil;

 glAbortProc := DoNothingProc;
 glDoScan    := False;
 glDetectKey := False;
 glScanMax   := 0;
 glScanCnt   := 0;
 glCounter   := 0;
 glChkScan   := 30;

 if MaxAvail < SizeOf(ScanRecord) then begin
                                        writeln;
                                        writeln('-',pkdirxversion,':');
                                        writeln('Abnormal program termination: PCEXPRESS variable not set.');
                                        halt;
                                       end;

 bbspath:=GetEnv('PCEXPRESS');
 if bbspath='' then begin
                     writeln;
                     writeln('-',pkdirxversion,':');
                     writeln('Abnormal program termination: PCEXPRESS variable not set.');
                     halt;
                    end;

 if bbspath[length(bbspath)] <> '\' then bbspath:=bbspath+'\';

 if not pkexist(bbspath+'CONFER.CFG') then begin
                                            writeln;
                                            writeln('-',pkdirxversion,':');
                                            writeln('Abnormal program termination: ',bbspath,'CONFER.CFG not found.');
                                            halt;
                                           end;
end.