UNIT manson;

interface

  uses crt, dos;

  procedure MNHELP (s: string);
  procedure MNRESETERR (s: string);
  procedure MNERASEERR (s: string);
  procedure MNCLOSEERR (s: string);
  procedure MNREWRITEERR (s: string);
  procedure MNPCEPRG (s1, s2: string);
  procedure MNSETFILETIME (s: string; l: longint);
  procedure MNRENAME (s1, s2: string);
  procedure MNERASE (s: string);

  function MNGETFILETIME (s: string): longint;
  function MNFILLUP (w: word): string;
  function MNCUTR (s: string): string;
  function MNEXISTS (s: string): boolean;

implementation

  procedure MNHELP (s: string);
    begin
      textcolor (4); writeln (s);
      textcolor (7); halt (1);
    end;

  procedure MNRESETERR (s: string);
    begin
      textcolor (4); writeln ('CAN''T OPEN FILE: ',s,' !');
      textcolor (7); halt (1);
    end;

  procedure MNERASEERR (s: string);
    begin
      textcolor (4); writeln ('CAN''T DELETE FILE: ',s,' !');
      textcolor (7); halt (1);
    end;

  procedure MNCLOSEERR (s: string);
    begin
      textcolor (4); writeln ('CAN''T CLOSE FILE: ',s,' !');
      textcolor (7); halt (1);
    end;

  procedure MNREWRITEERR (s: string);
    begin
      textcolor (4); writeln ('CAN''T CREATE FILE: ',s,' !');
      textcolor (7); halt (1);
    end;

  procedure MNPCEPRG (s1, s2: string);
    begin
      writeln;
      textcolor (11); write (s1);
      textcolor (3); writeln (' for PCE V',s2);
      textcolor (8); writeln ('by [-mANsON!]^dC!^iSDN');
      textcolor (7); writeln;
    end;

  procedure MNSETFILETIME (s: string; l: longint);
    var t: text;
    begin
      assign (t, s);
      {$I-} reset (t); {$I+}
      if ioresult <> 0 then mnreseterr(s);
      setftime (t, l);
      {$I-} close (t); {$I+}
      if ioresult <> 0 then mncloseerr(s);
    end;

  procedure MNRENAME (s1, s2: string);
    var f: file;
    begin
      assign (f, s1);
      {$I-} rename (f, s2); {$I+}
      if ioresult <> 0 then
        begin
          textcolor (4); writeln ('CAN''T RENAME FILE: ',s1,' !');
          textcolor (7); halt (1);
        end;
    end;

  procedure MNERASE (s: string);
    var f: file;
    begin
      assign (f, s);
      {$I-} erase (f); {$I+}
      if ioresult <> 0 then mneraseerr (s);
    end;

  function MNGETFILETIME (s: string): longint;
    var t: text;
        l: longint;
    begin
      assign (t, s);
      {$I-} reset (t); {$I+}
      if ioresult <> 0 then mnreseterr(s);
      getftime (t, l);
      {$I-} close (t); {$I+}
      if ioresult <> 0 then mncloseerr(s);
      mngetfiletime := l;
    end;

  function MNFILLUP (w: word): string;
    var s: string;
    begin
      str (w:0, s);
      if length (s) = 1 then s := '0' + s;
      mnfillup := s;
    end;

  function MNCUTR (s: string): string;
    var b : byte;
    begin
      b := 1;
      repeat
        if (copy (s, b, 1) = ' ') then
          begin
            delete (s, b, length (s) - b + 1);
            b := length (s) + 1;
          end
        else b := b + 1;
      until b = length (s) + 1;
      mncutr := s;
    end;

  function MNEXISTS (s: string): boolean;
    var f: file;
    begin
      assign (f, s);
      {$I-}
      reset (f);
      close (f);
      {$I+}
      mnexists := (ioresult = 0) and (s <> '');
    end;

end.