PROGRAM JoinConf;
USES    crt, pkMisc, pkdoor, pkport;
VAR     new_conf,max_page,lastx,lasty,command : integer;
        dizzy                                 : ARRAY[1..200] OF STRING[60];
        password                              : STRING;
{-----> The config variables <-----------------------------------------------}
        path,cur,cur2               : STRING;
        no_xs,no_cf                 : STRING[16];
        no_diz                      : STRING[60];
        cno_xs,cno_cf,c_conf,c_curs : STRING[3];
        c_nodiz,c_diz,c_cnum,c_page : STRING[3];
        c_cc1,c_cc2                 : STRING[3];
        anima,allansi,xstyle        : boolean;
        cursor,cursor2              : char;
        minbaud                     : longint;
        cdelay                      : integer;
{-----> special xstyle vars , not changable by user unless xstyle=ON <-------}
        bord_ch                     : char;
        c_pw,c_bord                 : STRING[3];

PROCEDURE load_default;
BEGIN
   path   :='.';
   no_xs  :='-aCCeSS  DeNieD-';
   no_cf  :='-No  CoNFeReNCe-';
   no_diz :='No DeSCRiPTioN aVaiLaBLe.!';
   cno_xs :='|12';
   cno_cf :='|14';
   c_conf :='|10';
   c_curs :='|13';
   anima  :=true;
   cursor :='>';
   cursor2:='<';
   minbaud:=9600;
   cur    :=')>)';
   cur2   :='(<(';
   cdelay :=100;
   allansi:=false;
   xstyle :=false;
   c_nodiz:='|09';
   c_diz  :='|11';
   c_cnum :='|15';
   c_page :='|12';
   c_cc1  :='|12';
   c_cc2  :='|15';

   c_bord :='|09';
   bord_ch:='';
   c_pw   :='|15';
END;

FUNCTION make_pipe(nummer:integer):string;
VAR      out_str:STRING[3];
         helpstr:STRING;
BEGIN
   IF nummer in [1..15] THEN {black not allowed}
   BEGIN
      out_str:='|';
      IF nummer<10 THEN out_str:=out_str+'0';
      str(nummer,helpstr);
      out_str:=out_str+helpstr;
   END
   ELSE
      out_str:='|00';
   make_pipe:=out_str;
END;

PROCEDURE check_cfg_line(c_line:STRING);
VAR       laststr,laststrip,key_word : STRING;
          lastint,f                  : integer;
          lastpipe                   : STRING[3];
BEGIN
   c_line:=pkstripleft(' ',c_line);
   IF (c_line[1]<>';') AND (c_line<>'') THEN
   BEGIN
      f:=0;
      REPEAT
         inc(f);
      UNTIL (c_line[f]='=') OR (f=length(c_line));
      IF (c_line[f]='=') AND (f>1) THEN
      BEGIN
         key_word :=pkupper( pkstripright( ' ',pkfirststr( (f-1),c_line) ) );
         laststr  :=pklaststr((length(c_line)-f),c_line);
         laststrip:=pkupper(pkstripboth(' ',laststr));
         lastint  :=pkstrint(laststr);
         lastpipe :=make_pipe(lastint);

         IF key_word='PATH'  THEN PATH:=laststrip;
         IF key_word='NOXS'  THEN NO_XS:=laststr;
         IF key_word='NOCF'  THEN NO_CF:=laststr;
         IF key_word='NODIZ' THEN no_diz:=laststr;
         IF (key_word='CNOXS' ) AND (lastpipe<>'|00') THEN cno_xs:=lastpipe;
         IF (key_word='CNOCF' ) AND (lastpipe<>'|00') THEN cno_cf:=lastpipe;
         IF (key_word='CCONF' ) AND (lastpipe<>'|00') THEN c_conf:=lastpipe;
         IF (key_word='CCURS' ) AND (lastpipe<>'|00') THEN c_curs:=lastpipe;
         IF (key_word='CDIZ'  ) AND (lastpipe<>'|00') THEN c_diz:=lastpipe;
         IF (key_word='CNODIZ') AND (lastpipe<>'|00') THEN c_nodiz:=lastpipe;
         IF (key_word='CCNUM' ) AND (lastpipe<>'|00') THEN c_cnum:=lastpipe;
         IF (key_word='CPAGE' ) AND (lastpipe<>'|00') THEN c_page:=lastpipe;
         IF (key_word='CCUR1' ) AND (lastpipe<>'|00') THEN c_cc1:=lastpipe;
         IF (key_word='CCUR2' ) AND (lastpipe<>'|00') THEN c_cc2:=lastpipe;
         IF (key_word='DELAY' ) AND (lastint>0) THEN cdelay:=lastint;
         IF key_word='MINBAUD'   THEN minbaud:=lastint;
         IF key_word='SEQUENCE'  THEN cur:=laststr;
         IF key_word='SEQUENCE2' THEN cur2:=laststr;
         IF (key_word='ANIM')    AND (laststrip='OFF') THEN anima:=false;
         IF (key_word='ALLANSI') AND (laststrip='ON' ) THEN allansi:=true;
         IF (key_word='XSTYLE')  AND (laststrip='ON' ) THEN xstyle:=true;
         IF (key_word='CURSOR') AND (length(c_line) > f) THEN
            cursor:=c_line[f+1];
         IF (key_word='CURSOR2') AND (length(c_line) > f) THEN
            cursor2:=c_line[f+1];
      END;
   END;
END;

PROCEDURE Konfiguration;
VAR       helper,helper2:integer;
          cfg   :text;
          get   :STRING;
BEGIN
   load_default;
   pkshareassign(cfg,'.\IFC_JOIN.CFG',true,false);
   reset(cfg);
   WHILE NOT eof(cfg) DO
   BEGIN
      readln(cfg,get);
      check_cfg_line(get);
   END;
   close(cfg);
   IF (pkdrop.buadrate<minbaud) AND (pkdrop.local=false) THEN anima:=false;

   IF xstyle=true THEN  {do /X-style}
   BEGIN
      c_bord:='|01';
      bord_ch:='-';
      c_diz:='|03';
      c_nodiz:='|03';
      anima:=false;
      c_curs:='|05';
      c_cc1:='|04';
      c_cc2:='|06';
      cno_xs:='|01';
      cno_cf:='|01';
      c_conf:='|07';
      c_cnum:='|07';
      c_page:='|04';
      c_pw  :='|07';
   END;

   FOR helper:=1 to 200 DO dizzy[helper]:='';
   pkshareassign(cfg,PATH+'\IFC_JOIN.DES',true,false);
   reset(cfg);
   WHILE NOT eof(cfg) DO
   BEGIN
        readln(cfg,get);
        IF get<>'' THEN
        BEGIN
            helper:=0;
            REPEAT
                  INC(helper);
            UNTIL (get[helper]=':') OR (helper=length(get));
            IF (get[helper]=':') AND (helper>1) THEN
            BEGIN
                 helper2:=pkstrint(pkfirststr((helper-1),get));
                 IF (helper2 IN [1..200]) AND
                    (pkdrop.confaccess[helper2]=true) THEN
                       dizzy[helper2]:=pklaststr(length(get)-helper,get);
            END;
        END;
   END;
   close(cfg);
END;

PROCEDURE Konferenz_einlesen(starter:integer);
VAR       i,c_num,side,y_start:integer;
BEGIN
   pkgotoxy(71,22);
   pkwrite(C_PAGE+pkintstr( (starter+1),2));
   side:=12;
   y_start:=15;
   FOR i:=1 TO 10 DO
   BEGIN
      IF i=6 THEN
      BEGIN
         side:=48;
         y_start:=10;
      END;
      c_num:=starter*10+i;
      pkreadconf(c_num);
      pkgotoxy(side,y_start+i);
      pkwrite(C_CNUM+pkintstr(c_num,3));
      pkgotoxy(side+6,y_start+i);
      IF pkdrop.confaccess[c_num]=true THEN
         pkwrite(C_CONF+pkpadleft(pkconf.confname,16,' ') )
      ELSE
         IF pkconf.confname<>'' THEN
              pkwrite(CNO_XS+pkpadleft(NO_XS,16,' ') )
         ELSE pkwrite(CNO_CF+pkpadleft(NO_CF,16,' ') );
   END;
END;

PROCEDURE hide_cursor;
BEGIN
   IF xstyle=true THEN pkgotoxy(1,1) ELSE pkgotoxy(1,10);
END;

PROCEDURE display_diz(seite,x,y:integer);
VAR       akt_conf:integer;
          helps:STRING;
BEGIN
   akt_conf:=(seite*10)+(y-15);
   IF x=46 THEN akt_conf:=akt_conf+5;
   pkgotoxy(6,22);
   IF dizzy[akt_conf]='' THEN
   BEGIN
      pkwrite(c_nodiz);
      helps:=no_diz;
   END
   ELSE
   BEGIN
      pkwrite(c_diz);
      helps:=dizzy[akt_conf];
   END;
   pkwrite(helps+C_BORD+' ]'+pkdup(bord_ch,(60-length(helps))));
   hide_cursor;
END;

PROCEDURE kill_old_cursor(xcurs,ycurs:integer);
BEGIN
   pkgotoxy(xcurs,ycurs);
   pkwrite(' ');
   pkgotoxy(xcurs+24,ycurs);
   pkwrite(' ');
END;

PROCEDURE Get_selection(VAR Selector:integer);
VAR       valid                           :boolean;
          input                           :char;
          a_counter,page,cursor_x,cursor_y:integer;
BEGIN
     valid:=false;
     page:=0;
     cursor_x:=10;
     cursor_y:=16;
     konferenz_einlesen(page);
     display_diz(page,cursor_x,cursor_y);
     a_counter:=0;
     REPEAT
        REPEAT
           IF anima=true THEN
           BEGIN
              WHILE pkkeypressed=false DO
              BEGIN
                  IF (a_counter MOD cdelay)=0 THEN
                  BEGIN
                     pkgotoxy(cursor_x,cursor_y);
                     pkwrite(C_CURS+cur[(a_counter DIV cdelay)+1]);
                     pkgotoxy(cursor_x+24,cursor_y);
                     pkwrite(C_CURS+cur2[(a_counter DIV cdelay)+1]);
                     hide_cursor;
                  END;
                  delay(1);{pkdelay?}
                  inc(a_counter);
                  IF a_counter=(length(cur))*cdelay THEN a_counter:=0;
              END;
           END
           ELSE
           BEGIN
              pkgotoxy(cursor_x,cursor_y);
              pkwrite(C_CURS+cursor);
              pkgotoxy(cursor_x+24,cursor_y);
              pkwrite(c_curs+cursor2);
              hide_cursor;
           END;
           input:=pkreadkey;
        UNTIL input IN [#27,'+','-',#205,#203,#208,#200,#207,#199,#13];
        CASE input OF
{page up}  '+'  : IF page<(max_page-1) THEN
                  BEGIN
                     inc(page);
                     konferenz_einlesen(page);
                     display_diz(page,cursor_x,cursor_y);
                  END;
{page down}'-'  : IF page>0 THEN
                  BEGIN
                     dec(page);
                     konferenz_einlesen(page);
                     display_diz(page,cursor_x,cursor_y);
                  END;
{home page}#199 : BEGIN
                     IF page>0 THEN
                     BEGIN
                        page:=0;
                        konferenz_einlesen(page);
                     END;
                     kill_old_cursor(cursor_x,cursor_y);
                     cursor_x:=10;cursor_y:=16;
                     display_diz(page,cursor_x,cursor_y);
                  END;
{last page}#207 : BEGIN
                     IF page<(max_page-1) THEN
                     BEGIN
                        page:=max_page-1;
                        konferenz_einlesen(page);
                     END;
                     kill_old_cursor(cursor_x,cursor_y);
                     cursor_x:=lastx;cursor_y:=lasty;
                     display_diz(page,cursor_x,cursor_y);
                  END;
{cr r}     #205 : BEGIN
                     IF cursor_x=10 THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=46;
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_y<20) AND (cursor_x=46) THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=10;inc(cursor_y);
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_y=20) AND (cursor_x=46) AND
                        (page<max_page-1) THEN
                     BEGIN
                        inc(page);
                        konferenz_einlesen(page);
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=10;cursor_y:=16;
                        display_diz(page,cursor_x,cursor_y);
                     END;
                  END;
{cr l}     #203 : BEGIN
                     IF cursor_x=46 THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=10;
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_y>16) AND (cursor_x=10) THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=46;dec(cursor_y);
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_x=10) AND (cursor_y=16) AND
                        (page>0) THEN
                     BEGIN
                          dec(page);
                          konferenz_einlesen(page);
                          kill_old_cursor(cursor_x,cursor_y);
                          cursor_x:=46;cursor_y:=20;
                          display_diz(page,cursor_x,cursor_y);
                     END;
                  END;
{cr d}     #208 : BEGIN
                     IF cursor_y<20 THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        inc(cursor_y);
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_y=20) AND (cursor_x=10) THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=46;cursor_y:=16;
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_y=20) AND (cursor_x=46) AND
                        (page<max_page-1) THEN
                     BEGIN
                        inc(page);
                        konferenz_einlesen(page);
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=10;cursor_y:=16;
                        display_diz(page,cursor_x,cursor_y);
                     END;
                  END;
{cr u}     #200 : BEGIN
                     IF cursor_y>16 THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        dec(cursor_y);
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_y=16) AND (cursor_x=46) THEN
                     BEGIN
                        kill_old_cursor(cursor_x,cursor_y);
                        cursor_x:=10;cursor_y:=20;
                        display_diz(page,cursor_x,cursor_y);
                     END
                     ELSE
                     IF (cursor_x=10) AND (cursor_y=16) AND
                        (page>0) THEN
                     BEGIN
                          dec(page);
                          konferenz_einlesen(page);
                          kill_old_cursor(cursor_x,cursor_y);
                          cursor_x:=46;cursor_y:=20;
                          display_diz(page,cursor_x,cursor_y);
                     END;
                  END;
{ret}      #13  : BEGIN
                     selector:=page*10+cursor_y-15;
                     IF cursor_x=46 THEN selector:=selector+5;
                     IF pkdrop.confaccess[selector]=true THEN
                     BEGIN
                        pkreadconf(selector);
                        IF pkconf.confpwd<>'' THEN
                        BEGIN
                           pkgotoxy(9,21);
                           pkwrite(C_PW+'Please enter the password for this conference : ');
                           pkreadln(password,15,true);
                           pkgotoxy(9,21);
                           pkwrite(pkdup(' ',63));
                           pkgotoxy(9,21);
                           IF password=pkconf.confpwd THEN
                           BEGIN
                              valid:=true;
                              pkwrite('ACCESS CLEARED .!');
                           END
                           ELSE
                              pkwrite('ACCESS DENIED ..!');
                           pkdelay(1500);
                           pkgotoxy(9,21);
                           pkwrite(pkdup(' ',17));
                        END
                        ELSE
                           valid:=true;
                     END;
                  END;
        END;
{esc}UNTIL (input=#27) OR (valid=true);
     IF input=#27 THEN selector:=-1;
END;

PROCEDURE Get_max_conf(VAR max_return:integer);
VAR       help1,help2:integer;
BEGIN
     help1:=201;
     REPEAT
          dec(help1);
     UNTIL (pkdrop.confaccess[help1]=true) OR (help1=1);
     max_return:=help1 DIV 10;
     help2:=help1 MOD 10; {help 2 = anzahl der confs auf der letzten seite}
     IF help2>0 THEN
     BEGIN
        inc(max_return);
        lasty:=15+help2;
        IF help2>5 THEN
        BEGIN
             lasty:=lasty-5;
             lastx:=46;
        END
        ELSE lastx:=10;
     END
     ELSE
     BEGIN
         lastx:=46;
         lasty:=20;
     END;
END;

PROCEDURE Zusatz_schreiben;
VAR xxx:STRING;
BEGIN
   pkreadconf(pkdrop.currentconf);
   pkgotoxy(2,14);
   str(pkdrop.currentconf,xxx);
   pkwrite(C_BORD+'[ '+C_CC1+xxx+c_cc2+':'+c_cc1+pkconf.confname+C_BORD+' ]');
   pkgotoxy(74,22);
   pkwrite(C_PAGE + pkintstr(max_page,2));
END;

BEGIN
{   pkansi:=false;  {just to test the ascii capability}
   konfiguration;
   IF pkdropfile=true THEN
   BEGIN
      pkclrscr;
      command:=pkstrint(pkextractwords(1,1,pkdrop.parameters));
                                          {returns 0 if no parameters}
      IF (command IN [1..200]) AND (pkdrop.confaccess[command]=true) THEN
      BEGIN
         pkreadconf(command);
         IF pkconf.confpwd<>'' THEN
         BEGIN
            pkgotoxy(1,1);
            pkwrite(C_PW+'Please enter the password for this conference : ');
            pkreadln(password,15,true);
            pkgotoxy(1,1);
            pkwrite(pkdup(' ',63));
            pkgotoxy(1,1);
            IF password=pkconf.confpwd THEN
            BEGIN
               new_conf:=command;
               pkwrite('ACCESS CLEARED .!');
            END
            ELSE
            BEGIN
               new_conf:=-1;
               pkwrite('ACCESS DENIED ..!');
            END;
            pkdelay(1500);
            pkgotoxy(1,1);
            pkwrite(pkdup(' ',17));
         END
         ELSE
            new_conf:=command;
      END
      ELSE
      BEGIN
         IF xstyle=false THEN
         BEGIN
            IF pkansi=true  THEN pkSendFile(path+'\IFC_JOIN.ANS',false) ELSE
                                 pkSendFile(path+'\IFC_JOIN.ASC',false);
         END
         ELSE
         BEGIN
            IF pkansi=true  THEN pkSendFile(path+'\IFC_JOIN.ANX',false) ELSE
                                 pkSendFile(path+'\IFC_JOIN.ASX',false);
         END;

         get_max_conf(max_page);
{         max_page:=20;{just for testing..}
         zusatz_schreiben;
         get_Selection(new_conf);
      END;
      pkclrscr;
      IF new_conf<>-1 THEN
      BEGIN
         IF (pkdrop.currentconf<>new_conf) OR (allansi=true) THEN
         BEGIN
            pkdrop.currentconf:=new_conf;
            pkdrop.lastconf:=new_conf;
            pkreadconf(new_conf);
            IF pkansi=true THEN pksendfile(pkconf.confpath+'BULLALL.ANS',false) ELSE
                                pksendfile(pkconf.confpath+'BULLALL.ASC',false);
         END;
      END;
   END
   ELSE
   BEGIN
      pkclrscr;
      pkwriteln('         Join Conference reports : ');
      pkwriteln('Error 1: No dropfile found for current node..!');
      pkwriteln('         You better inform your SysOp about this...');
   END;
END.
